/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.script;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.JwtUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.DummyLogChannel;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.ScriptOperationImplementation;
import com.nuix.automate.workflow.core.execution.script.DiscoverRestClient;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class WorkflowExecutionDiscoverRestClient
extends DiscoverRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowExecutionDiscoverRestClient.class);
    private final transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private WorkflowExecution workflowExecution;
    private ScriptOperationImplementation operation;

    public WorkflowExecutionDiscoverRestClient(WorkflowExecution workflowExecution, ScriptOperationImplementation operation) {
        super((LogChannel)new DummyLogChannel(), "WorkflowExecutionDiscoverRestClient");
        this.workflowExecution = workflowExecution;
        this.operation = operation;
        this.initializeUrl();
        this.initializeBearerToken();
        this.applyFingerprints();
    }

    private void applyFingerprints() {
        try {
            String certificateFingerprints = this.workflowExecution.getExecutionContext().evalParameters("{wfn_discover_whitelisted_cert_fingerprints}", this.operation);
            if (certificateFingerprints == null || certificateFingerprints.trim().equals("{wfn_discover_whitelisted_cert_fingerprints}")) {
                return;
            }
            HashSet fingerprints = new HashSet((Collection)SerializationUtils.fromJson((String)certificateFingerprints));
            if (fingerprints != null && fingerprints.size() >= 1) {
                this.setFingerprint((String)fingerprints.iterator().next());
            }
        }
        catch (ParameterException e) {
            LOGGER.error("Cannot set Relativity fingerprints from parameters");
        }
    }

    @Override
    protected String getCallUrl() throws IOException {
        if (this.baseUrl == null) {
            LOGGER.error("Discover URL is null");
            throw new IOException("Discover API URL is not defined. Run the Configure Nuix Discover Connection operation or call discoverRest.setBaseUrl(String s) before calling this method.");
        }
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        if (this.bearerToken == null) {
            LOGGER.error("Discover token is null");
            throw new IOException("Discover API bearer token is not defined. Run the Configure Nuix Discover Connection operation or call discoverRest.setBearerToken(String s) before calling this method.");
        }
        return this.baseUrl;
    }

    public void initializeUrl() {
        try {
            String hostname = this.workflowExecution.getExecutionContext().evalParametersIfSet("{wfn_discover_hostname}", this.operation).trim();
            this.bearerToken = this.workflowExecution.getExecutionContext().evalProtectedParameter("{wfn_discover_api_token_protected}").trim();
            Map claims = JwtUtils.getTokenClaimsNoVerify((String)this.bearerToken);
            this.baseUrl = claims.get("apiUrl").toString();
            if (!this.baseUrl.toLowerCase(Locale.ROOT).startsWith("http://" + hostname + "/") && !this.baseUrl.toLowerCase(Locale.ROOT).startsWith("https://" + hostname + "/")) {
                throw new IllegalStateException(this.iu.getFormattedString("DiscoverRestClient.Error.InvalidHostname", new Object[]{this.baseUrl, hostname}));
            }
        }
        catch (ParameterException e) {
            LOGGER.debug("Cannot evaluate parameter {wfn_discover_hostname}");
        }
    }

    public void initializeBearerToken() {
        try {
            this.bearerToken = this.workflowExecution.getExecutionContext().evalProtectedParameter("{wfn_discover_api_token_protected}").trim();
        }
        catch (ParameterException e) {
            LOGGER.debug("Cannot evaluate parameter {wfn_discover_api_token_protected}");
        }
    }
}

