/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.script;

import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiModel;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.genAi.openAi.DataElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WorkflowExecutionGenAiClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowExecutionGenAiClient.class);
    private final transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private GenAiHelper genAiHelper;
    private GenAiService genAiService;

    public WorkflowExecutionGenAiClient(GenAiService genAiService) {
        this.genAiService = genAiService;
        this.initialize();
    }

    private void initialize() {
        this.genAiHelper = new GenAiHelper(this.genAiService);
    }

    public String getServiceName() {
        return this.genAiHelper.getPrintableServiceName();
    }

    public String getModel() {
        return this.genAiHelper.getModel();
    }

    public String getResponseMessage(List<Map<String, String>> genAiChatRequestMessages) throws IOException, InterruptedException {
        GenAiResponse genAiResponse = this.getResponse(genAiChatRequestMessages);
        return genAiResponse.getMessage().getContent();
    }

    public List<GenAiModel> getAvailableModels() {
        if (this.genAiHelper == null) {
            throw new IllegalStateException("Cannot get available models because Gen AI client was not initialized");
        }
        return this.genAiHelper.getAvailableModels();
    }

    public void setModel(String model) throws GenAiException {
        this.genAiHelper = new GenAiHelper(this.genAiService, model);
    }

    public GenAiResponse getResponse(List<Map<String, String>> genAiChatRequestMessages) throws IOException, InterruptedException {
        if (this.genAiHelper == null) {
            throw new IllegalStateException("Cannot get chat completions because Gen AI client was not initialized");
        }
        ArrayList<GenAiMessage> messages = new ArrayList<GenAiMessage>();
        for (Map<String, String> message : genAiChatRequestMessages) {
            String role = message.get("role");
            String content = message.get("content");
            String imageBase64 = message.get("imageBase64");
            String imageMimeType = message.get("imageMimeType");
            if (imageBase64 == null) {
                messages.add(new GenAiMessage(role, content));
                continue;
            }
            if (imageMimeType == null) {
                imageMimeType = "image/png";
            }
            messages.add(new GenAiMessage(role, content, Collections.singletonList(new DataElement(imageMimeType, imageBase64))));
        }
        GenAiRequest request = new GenAiRequest(UidUtils.getRandom(), messages);
        return this.genAiHelper.getCompletions(request);
    }
}

