/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.OperationList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;

public class OperationListAdapter
implements JsonDeserializer<OperationList>,
JsonSerializer<OperationList> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OperationListAdapter.class);
    private static final String operationsPackage = "com.nuix.automate.workflow.core.execution.operations";

    public OperationList deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonElement jsonOperation = jsonArray.get(i);
            JsonObject jsonObject = jsonOperation.getAsJsonObject();
            String simpleClassName = jsonObject.get("@class").getAsString();
            try {
                Class<?> operationClass = Class.forName("com.nuix.automate.workflow.core.execution.operations." + simpleClassName);
                if (!Operation.class.isAssignableFrom(operationClass)) continue;
                Operation operation = (Operation)jsonDeserializationContext.deserialize(jsonOperation, operationClass);
                operations.add(operation);
                continue;
            }
            catch (ClassCastException | ClassNotFoundException e) {
                LOGGER.error("Error getting class for operation JSON, " + simpleClassName, (Throwable)e);
            }
        }
        return new OperationList((Collection<? extends Operation>)operations);
    }

    public JsonElement serialize(OperationList operations, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonArray jsonArray = new JsonArray();
        for (Operation operation : operations) {
            JsonElement jsonElement = jsonSerializationContext.serialize((Object)operation);
            jsonElement.getAsJsonObject().addProperty("@class", operation.getClass().getSimpleName());
            jsonElement.getAsJsonObject().addProperty("operationAlias", operation.getOperationAlias().toString());
            jsonArray.add(jsonElement);
        }
        return jsonArray;
    }
}

