/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.workflow;

import com.nuix.automate.utils.workflow.DatasetMetadata;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import nuix.Item;

public class DatasetUtils {
    public static DatasetMetadata getFileDataSet(Map<String, DatasetMetadata> datasetsMetadata, Item item) {
        DatasetMetadata dataSetMetadata = null;
        String datasetId = (String)item.getEvidenceMetadata().get("Data Set ID");
        if (datasetId != null) {
            dataSetMetadata = datasetsMetadata.get(datasetId);
        }
        return dataSetMetadata;
    }

    public static String getRelativePathForDatasetItem(Item datasetItem) {
        String[] pathNames = datasetItem.getPathNames().toArray(new String[0]);
        if (pathNames.length > 1) {
            return Paths.get(pathNames[1], Arrays.copyOfRange(pathNames, 2, pathNames.length)).normalize().toString();
        }
        return null;
    }

    public static String[] getRelativePathSplit(String relativePath) {
        Path path = Paths.get(relativePath, new String[0]).normalize();
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add(path.getFileName().toString());
        Path parentPath = path;
        while ((parentPath = parentPath.getParent()) != null && parentPath.getFileName() != null) {
            fileNames.add(parentPath.getFileName().toString());
        }
        Collections.reverse(fileNames);
        return fileNames.toArray(new String[0]);
    }
}

