/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.workflow;

import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Workflow;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class ImmutableWorkflow
extends Workflow {
    public ImmutableWorkflow(Workflow workflow) {
        super.setName(workflow.getName());
        super.setIcon(workflow.getIcon());
        super.setOperations(workflow.getOperations());
        super.setDescription(workflow.getDescription());
        super.setUsage(workflow.getUsage());
        super.setPrerequisites(workflow.getPrerequisites());
        super.setExplicitExecutionMode(workflow.getExplicitExecutionMode());
        super.setProducerName(workflow.getProducerName());
        super.setProducerVersion(workflow.getProducerVersion());
        super.setLastModifiedEpoch(workflow.getLastModifiedEpoch());
    }

    @Override
    public Workflow toWorkflow() {
        Workflow workflow = new Workflow();
        workflow.setName(this.getName());
        workflow.setIcon(this.getIcon());
        workflow.setOperations(super.getOperations());
        workflow.setDescription(this.getDescription());
        workflow.setUsage(this.getUsage());
        workflow.setPrerequisites(super.getPrerequisites());
        workflow.setExplicitExecutionMode(this.getExplicitExecutionMode());
        workflow.setProducerName(this.getProducerName());
        workflow.setProducerVersion(this.getProducerVersion());
        workflow.setLastModifiedEpoch(this.getLastModifiedEpoch());
        return workflow;
    }

    public void useReadOnlyOperations(Consumer<List<Operation>> consumer) {
        this.useReadOnlyOperations((List<Operation> operations) -> {
            consumer.accept((List<Operation>)operations);
            return null;
        });
    }

    public <T> T useReadOnlyOperations(Function<List<Operation>, T> func) {
        List<Operation> operations = super.getOperations();
        T result = func.apply(operations);
        return result;
    }

    @Override
    public void setModified() {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public void setSaved() {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public void setDescription(String description) {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public void setLastModifiedEpoch(Long lastModifiedEpoch) {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public void setProducerName(String producerName) {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public void setProducerVersion(String producerVersion) {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public void setUsage(String usage) {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public void setIcon(String icon) {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public List<String> getPrerequisites() {
        return Collections.unmodifiableList(super.getPrerequisites());
    }

    @Override
    public void setPrerequisites(List<String> prerequisites) {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public List<Operation> getOperations() {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public void setOperations(List<Operation> operations) {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }

    @Override
    public void setExplicitExecutionMode(ExecutionMode explicitExecutionMode) {
        throw new UnsupportedOperationException("Workflow is immutable and cannot be modified");
    }
}

