/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.workflow;

import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.Set;
import org.joda.time.DateTimeZone;

public class OperationExecutionState {
    private Operation operation;
    private ExecutionState executionState;
    private Long startDateTime;
    private Long finishedDateTime;
    private Set<String> warningsMessages;
    private String errorMessage;
    private String originalState;

    public OperationExecutionState() {
    }

    public OperationExecutionState(Operation operation) {
        this.operation = operation;
        this.executionState = operation.executionState;
        if (operation.startDateTime != null) {
            this.startDateTime = operation.startDateTime.withZone(DateTimeZone.UTC).getMillis();
        }
        if (operation.finishedDateTime != null) {
            this.finishedDateTime = operation.finishedDateTime.withZone(DateTimeZone.UTC).getMillis();
        }
        this.warningsMessages = operation.getWarningMessages();
        this.errorMessage = operation.getErrorMessage();
        this.originalState = operation.getOriginalState();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }

    public Long getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(Long startDateTime) {
        this.startDateTime = startDateTime;
    }

    public Long getFinishedDateTime() {
        return this.finishedDateTime;
    }

    public void setFinishedDateTime(Long finishedDateTime) {
        this.finishedDateTime = finishedDateTime;
    }

    public Set<String> getWarningsMessages() {
        return this.warningsMessages;
    }

    public void setWarningsMessages(Set<String> warningsMessages) {
        this.warningsMessages = warningsMessages;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getOriginalState() {
        return this.originalState;
    }

    public void setOriginalState(String originalState) {
        this.originalState = originalState;
    }
}

