/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.workflow;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import com.nuix.automate.utils.models.api.job.JobRequiredProfile;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.security.IdEncryptor;
import com.nuix.automate.utils.security.LegacyIdEncryptor;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.ParameterValueMatchBy;
import com.nuix.automate.utils.workflow.ScriptLanguage;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.utils.workflow.WorkflowFileFormat;
import com.nuix.automate.workflow.core.execution.operations.AddEvidenceOperation;
import com.nuix.automate.workflow.core.execution.operations.AddToProductionSetOperation;
import com.nuix.automate.workflow.core.execution.operations.CloseNuixOperation;
import com.nuix.automate.workflow.core.execution.operations.ConfigurationOperation;
import com.nuix.automate.workflow.core.execution.operations.ConfigureDiscoverConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.ConfigureNuixOperation;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperation;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperationImplementation;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.DetectAndAssignCustodiansOperation;
import com.nuix.automate.workflow.core.execution.operations.ExportItemsOperation;
import com.nuix.automate.workflow.core.execution.operations.GenerateDuplicateFieldsOperation;
import com.nuix.automate.workflow.core.execution.operations.GeneratePrintedImagesOperation;
import com.nuix.automate.workflow.core.execution.operations.GraphConfigureConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.LegalExportOperation;
import com.nuix.automate.workflow.core.execution.operations.ListRelativityDocumentsOperation;
import com.nuix.automate.workflow.core.execution.operations.LogOperation;
import com.nuix.automate.workflow.core.execution.operations.MatchItemsOperation;
import com.nuix.automate.workflow.core.execution.operations.MetadataExportOperation;
import com.nuix.automate.workflow.core.execution.operations.MetadataToSqlOperation;
import com.nuix.automate.workflow.core.execution.operations.NotifyOperation;
import com.nuix.automate.workflow.core.execution.operations.OcrOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityMetadataOverlayOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.operations.ScriptFileOperation;
import com.nuix.automate.workflow.core.execution.operations.ScriptOperation;
import com.nuix.automate.workflow.core.execution.operations.UseCaseOperation;
import com.nuix.automate.workflow.core.execution.operations.UseDiscoverCaseOperation;
import com.nuix.automate.workflow.core.execution.options.addevidence.SourceScope;
import com.nuix.automate.workflow.core.execution.options.configuration.NuixSettingsType;
import com.nuix.automate.workflow.core.execution.options.configuration.ParallelProcessingSettingsSource;
import com.nuix.automate.workflow.core.execution.options.configuration.PasswordSettingsType;
import com.nuix.automate.workflow.core.execution.options.matchitems.MatchScope;
import com.nuix.automate.workflow.core.execution.options.script.ScriptType;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.execution.workflow.ImmutableWorkflow;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowRenderer;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowStub;
import com.nuix.automate.workflow.core.utils.general.ScriptUtils;
import com.nuix.automate.workflow.core.utils.general.SerializerFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.NotImplementedException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Workflow
implements Serializable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Workflow.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private static final String OPAQUE_KEY = "abc69e38-02ec-46eb-8481-dfbb61630b5b";
    private String name;
    private Long lastModifiedEpoch;
    private String producerName;
    private String producerVersion;
    private String description;
    private String usage;
    private String icon;
    private List<String> prerequisites;
    private List<Operation> operations;
    private ExecutionMode explicitExecutionMode;
    private transient boolean workflowModifiedSinceLastSave = true;

    public Workflow() {
        this.operations = new ArrayList<Operation>();
        this.prerequisites = new ArrayList<String>();
        this.explicitExecutionMode = ExecutionMode.AUTODETECT;
    }

    public Workflow(String name) {
        this.setName(name);
        this.setOperations(new ArrayList<Operation>());
        this.setPrerequisites(new ArrayList<String>());
        this.setExplicitExecutionMode(ExecutionMode.AUTODETECT);
    }

    public static Workflow fromXml(String xml) throws IOException {
        return Workflow.fromXml(xml, DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
    }

    public static Workflow fromFile(String filename) throws IOException {
        String xml = FileUtils.readFileWithAutodetectEncoding((File)new File(filename));
        return Workflow.fromXml(xml, new File(filename).lastModified());
    }

    public static Workflow fromXml(String xml, long lastModified) throws IOException {
        Workflow workflow;
        block14: {
            String decryptedWorkflow;
            IdEncryptor encryptor;
            block13: {
                workflow = null;
                try {
                    encryptor = new IdEncryptor(OPAQUE_KEY);
                    decryptedWorkflow = encryptor.decrypt(xml);
                    workflow = (Workflow)SerializerFactory.getSerializer().deserialize(decryptedWorkflow);
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block13;
                    LOGGER.debug("Cannot deserialize workflow as Opaque");
                }
            }
            if (workflow == null) {
                try {
                    encryptor = new LegacyIdEncryptor(OPAQUE_KEY);
                    decryptedWorkflow = encryptor.decrypt(xml);
                    workflow = (Workflow)SerializerFactory.getSerializer().deserialize(decryptedWorkflow);
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block14;
                    LOGGER.debug("Cannot deserialize workflow as Legacy Opaque");
                }
            }
        }
        if (workflow == null) {
            try {
                workflow = (Workflow)SerializerFactory.getSerializer().deserialize(xml);
            }
            catch (Exception e) {
                WorkflowStub workflowStub;
                try {
                    workflowStub = WorkflowStub.fromXml(xml);
                }
                catch (Exception ex) {
                    throw e;
                }
                LOGGER.error("Cannot open workflow", (Throwable)e);
                throw new IOException(iu.getFormattedString("WorkflowDesigner.Dialog.WorkflowNotCompatibleWithThisVersion", new Object[]{workflowStub.getProducerName(), workflowStub.getProducerVersion()}));
            }
        }
        for (Operation o : workflow.getOperations()) {
            o.normalize();
        }
        if (workflow.getLastModifiedEpoch() == null) {
            workflow.setLastModifiedEpoch(lastModified);
        }
        if (workflow.getExplicitExecutionMode() == null) {
            workflow.setExplicitExecutionMode(ExecutionMode.AUTODETECT);
        }
        return workflow;
    }

    public boolean getWorkflowModifiedSinceLastSave() {
        if (this.workflowModifiedSinceLastSave) {
            this.setLastModifiedEpoch(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
            return true;
        }
        for (Operation o : this.getOperations()) {
            if (!o.modifiedSinceWorkflowSaved) continue;
            this.setLastModifiedEpoch(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
            return true;
        }
        return false;
    }

    public void setModified() {
        this.workflowModifiedSinceLastSave = true;
    }

    public void setSaved() {
        this.workflowModifiedSinceLastSave = false;
        for (Operation o : this.getOperations()) {
            o.modifiedSinceWorkflowSaved = false;
        }
    }

    boolean hasWarnings() {
        for (Operation operation : this.getOperations()) {
            if (!operation.getEncounteredWarnings()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSoftErrors() {
        for (Operation operation : this.getOperations()) {
            if (!operation.getEncounteredSoftError()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder representation = new StringBuilder("Workflow:\t" + this.getName() + "\n");
        for (Operation operation : this.getOperations()) {
            representation.append(operation.toString()).append("\n");
        }
        return representation.toString();
    }

    public void saveToFile(String filename, WorkflowFileFormat workflowFileFormat) throws IOException {
        LOGGER.info("Saving workflow to " + filename);
        this.setLastModifiedEpoch(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        for (Operation o : this.getOperations()) {
            if (!(o instanceof ConfigureParametersOperationImplementation)) continue;
            ((ConfigureParametersOperationImplementation)o).protectSensitiveParameters();
        }
        switch (workflowFileFormat) {
            case XML: {
                SerializerFactory.getSerializer().serialize(this.toWorkflow(), new File(filename));
                break;
            }
            case OPAQUE: {
                String serializedWorkflow = this.toXml();
                IdEncryptor encryptor = new IdEncryptor(OPAQUE_KEY);
                String encryptedWorkflow = encryptor.encrypt(serializedWorkflow);
                FileUtils.writeToFile((String)encryptedWorkflow, (Path)Paths.get(filename, new String[0]));
                break;
            }
            default: {
                throw new NotImplementedException("Workspace file format " + String.valueOf(workflowFileFormat) + " not supported");
            }
        }
        for (Operation o : this.getOperations()) {
            if (!(o instanceof ConfigureParametersOperationImplementation)) continue;
            ((ConfigureParametersOperationImplementation)o).unProtectSensitiveParameters();
        }
    }

    public void saveToFile(String filename) throws IOException {
        this.saveToFile(filename, WorkflowFileFormat.XML);
    }

    public void saveReportToFile(String filename) throws IOException {
        LOGGER.info("Saving workflow report to " + filename);
        FileUtils.writeToFile((String)WorkflowRenderer.getWorkflowHtmlReport(new ImmutableWorkflow(this), DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis(), false), (Path)Paths.get(filename, new String[0]));
    }

    public Workflow toWorkflow() {
        return this;
    }

    public String toXml() throws IOException {
        return SerializerFactory.getSerializer().serialize(this.toWorkflow());
    }

    public double getPercentageComplete(boolean enablePercentageComplete) {
        double percentageComplete = 0.0;
        if (this.getOperations() != null) {
            double totalWeight = 0.0;
            double completedWeight = 0.0;
            for (Operation operation : this.getOperations()) {
                double operationProgressWeight = 1.0;
                if (enablePercentageComplete) {
                    operationProgressWeight = operation.progressWeight;
                }
                if (!operation.disabled) {
                    totalWeight += operationProgressWeight;
                }
                if (operation.executionState == ExecutionState.FINISHED) {
                    completedWeight += operationProgressWeight;
                }
                if (operation.executionState != ExecutionState.RUNNING && operation.executionState != ExecutionState.PAUSING && operation.executionState != ExecutionState.PAUSED && operation.executionState != ExecutionState.STOPPING && operation.executionState != ExecutionState.STOPPED && operation.executionState != ExecutionState.ERROR) continue;
                completedWeight += operationProgressWeight * operation.getNormalizedPercentageComplete();
            }
            percentageComplete = 100.0 * completedWeight / totalWeight;
        }
        return percentageComplete;
    }

    public ExecutionMode getExecutionMode() {
        if (this.getExplicitExecutionMode() != null && this.getExplicitExecutionMode() != ExecutionMode.AUTODETECT) {
            return this.getExplicitExecutionMode();
        }
        HashSet<Feature> features = new HashSet<Feature>();
        if (this.operations != null) {
            for (Operation operation : this.operations) {
                if (operation.disabled) continue;
                Set<Feature> operationFeatures = operation.getRequiredFeatures();
                features.addAll(operationFeatures);
            }
        }
        ExecutionMode executionMode = features.contains((Object)Feature.NUIX_WORKSTATION) ? ExecutionMode.WORKFLOW_NUIX : (features.contains((Object)Feature.NUIX) ? ExecutionMode.AUTOMATE_NUIX : ExecutionMode.AUTOMATE_NATIVE);
        return executionMode;
    }

    private ConfigureParametersOperation insertConfigurationOperation(StringBuilder htmlLog, List<String> plainTextLog) {
        ConfigureParametersOperation configureParametersOperation = new ConfigureParametersOperation();
        configureParametersOperation.staticParameters = new ArrayList<StaticParameter>();
        configureParametersOperation.userParameters = new ArrayList<StaticParameter>();
        this.getOperations().add(1, configureParametersOperation);
        htmlLog.append("<div><b>#2 " + configureParametersOperation.getOperationName() + "</b>: ");
        htmlLog.append("<li>" + iu.getString("WorkflowNormalization.AddedOperation") + "</li>");
        htmlLog.append("</div></br></br>");
        plainTextLog.add(" #2 " + configureParametersOperation.getOperationName() + ": " + iu.getString("WorkflowNormalization.AddedOperation"));
        return configureParametersOperation;
    }

    private LogOperation insertNormalizationLogOperation(StringBuilder htmlLog, List<String> plainTextLog) {
        LogOperation logOperation = new LogOperation();
        logOperation.notes = iu.getString("WorkflowNormalization.ScriptOperationLog");
        this.getOperations().add(0, logOperation);
        htmlLog.append("<div><b>#1 " + logOperation.getOperationName() + "</b>: ");
        htmlLog.append("<li>" + iu.getString("WorkflowNormalization.NotesInsert") + "</li>");
        htmlLog.append("</div></br></br>");
        plainTextLog.add(" #1 " + logOperation.getOperationName() + ": " + iu.getString("WorkflowNormalization.NotesInsert"));
        return logOperation;
    }

    private ScriptOperation getWarningScriptOperation(StringBuilder htmlLog, List<String> plainTextLog, int index) {
        ScriptOperation scriptOperation = new ScriptOperation();
        scriptOperation.notes = iu.getFormattedString("WorkflowNormalization.ScriptWarning", (Object)"workflowExecution.goToOperation(n)");
        scriptOperation.useScriptFile = false;
        scriptOperation.scriptType = ScriptType.PYTHON;
        scriptOperation.scriptCode = "workflowExecution.addWarning(\"" + iu.getFormattedString("WorkflowNormalization.ScriptWarning", (Object)"workflowExecution.goToOperation(n)") + "\")";
        this.getOperations().add(2, scriptOperation);
        htmlLog.append("<div><b>#3 " + scriptOperation.getOperationName() + "</b>: ");
        htmlLog.append("<li>" + iu.getString("WorkflowNormalization.ScriptWarningInsert") + "</li>");
        htmlLog.append("</div></br></br>");
        plainTextLog.add(" #3 " + scriptOperation.getOperationName() + ": " + iu.getString("WorkflowNormalization.ScriptWarningInsert"));
        return scriptOperation;
    }

    public boolean normalize(StringBuilder normalizationHtmlLog, Set<String> messageLines) {
        AtomicBoolean normalizationPerformed = new AtomicBoolean(false);
        String version = new Version(Workflow.class.getPackage().getImplementationVersion()).toString();
        messageLines.add(iu.getFormattedString("WorkflowNormalization.Message1", (Object)version));
        ArrayList<String> normalizationPlainTextLog = new ArrayList<String>();
        ConfigureParametersOperation configureParametersOperation = null;
        LogOperation logOperation = null;
        StaticParameter addEvidenceSource = null;
        StaticParameter addEvidenceName = null;
        StaticParameter useCaseLocation = null;
        ArrayList<Operation> originalOperations = new ArrayList<Operation>();
        originalOperations.addAll(this.getOperations());
        int lastConfigureParametersOperation = -1;
        int lastConfigureNuixOperation = -1;
        int lastDisabledConfigureParametersOperation = -1;
        int lastDisabledConfigureNuixOperation = -1;
        int insertedOperationsCount = 0;
        for (int i = 0; i < originalOperations.size(); ++i) {
            Operation operation = (Operation)originalOperations.get(i);
            MultiConsumer addNormalizationLog = args -> {
                int _i = (Integer)args[0];
                int operationsCount = (Integer)args[1];
                String line = (String)args[2];
                normalizationPerformed.set(true);
                if (args.length > 3 && Boolean.TRUE.equals(args[3])) {
                    messageLines.add("\n\n" + line);
                }
                String operationLabel = "#" + (_i + 1 + operationsCount) + " " + operation.getOperationName();
                normalizationHtmlLog.append("<div><b>").append(operationLabel).append("</b>: ").append("<li>").append(line).append("</li>").append("</div></br></br>");
                normalizationPlainTextLog.add(" " + operationLabel + ": " + line);
            };
            if (operation instanceof ConfigurationOperation) {
                ConfigureNuixOperation configureNuix;
                ConfigureParametersOperation configureParameters;
                boolean normalizeParameters;
                ConfigurationOperation configurationOperation = (ConfigurationOperation)operation;
                if (logOperation == null) {
                    normalizationPerformed.set(true);
                    logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                    ++insertedOperationsCount;
                }
                this.getOperations().remove(i + insertedOperationsCount);
                normalizationHtmlLog.append("<div><b>#" + (i + 1 + insertedOperationsCount) + " " + configurationOperation.getOperationName() + "</b>: ");
                normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.RemovedConfiguration") + "</li>");
                normalizationHtmlLog.append("</div></br></br>");
                normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + configurationOperation.getOperationName() + ": " + iu.getString("WorkflowNormalization.RemovedConfiguration"));
                --insertedOperationsCount;
                if (configurationOperation.placeholders != null && configurationOperation.placeholders.size() > 0) {
                    if (configurationOperation.parameters == null) {
                        configurationOperation.parameters = new ArrayList<StaticParameter>();
                    }
                    for (Object[] p : configurationOperation.placeholders) {
                        String placeholderName = (String)p[0];
                        String placeholderValue = (String)p[1];
                        configurationOperation.parameters.add(new StaticParameter(placeholderName, placeholderValue));
                    }
                    configurationOperation.placeholders = null;
                }
                boolean normalizeNuixSettings = configurationOperation.useConfigurationProfile || configurationOperation.useProcessingProfile || configurationOperation.parallelProcessingSettingsSource == ParallelProcessingSettingsSource.WORKFLOW || configurationOperation.requireFilesInExecutionProfile || configurationOperation.passwordSettingsType != null && configurationOperation.passwordSettingsType != PasswordSettingsType.NONE || configurationOperation.keyStoreFilePath != null && !configurationOperation.keyStoreFilePath.trim().equals("") || configurationOperation.nuixSettingsType == NuixSettingsType.FROM_FILE;
                boolean bl = normalizeParameters = configurationOperation.parameters != null && configurationOperation.parameters.size() > 0;
                if (normalizeNuixSettings || normalizeParameters) {
                    messageLines.add("\n\n" + iu.getString("WorkflowNormalization.ConfigurationNormalization"));
                }
                if (!configurationOperation.disabled) {
                    boolean configureNuixCondition;
                    boolean configureParametersCondition = i + insertedOperationsCount == lastConfigureParametersOperation || i + insertedOperationsCount == lastConfigureNuixOperation && i - 1 + insertedOperationsCount == lastConfigureParametersOperation;
                    boolean bl2 = configureNuixCondition = i + insertedOperationsCount == lastConfigureNuixOperation;
                    if (!configureParametersCondition && normalizeParameters) {
                        configureParameters = new ConfigureParametersOperation();
                        configureParameters.staticParameters = new ArrayList<StaticParameter>();
                        configureParameters.userParameters = new ArrayList<StaticParameter>();
                        this.getOperations().add(i + 1 + insertedOperationsCount, configureParameters);
                        normalizationHtmlLog.append("<div><b>#" + (i + 1 + ++insertedOperationsCount) + " " + configureParameters.getOperationName() + "</b>: ");
                        normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.AddedOperation") + "</li>");
                        normalizationHtmlLog.append("</div></br></br>");
                        normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + configureParameters.getOperationName() + ": " + iu.getString("WorkflowNormalization.AddedOperation"));
                        lastConfigureParametersOperation = i + insertedOperationsCount;
                        if (configureParametersOperation == null) {
                            configureParametersOperation = configureParameters;
                        }
                    }
                    if (!configureNuixCondition && normalizeNuixSettings) {
                        configureNuix = new ConfigureNuixOperation();
                        this.getOperations().add(i + 1 + insertedOperationsCount, configureNuix);
                        normalizationHtmlLog.append("<div><b>#" + (i + 1 + ++insertedOperationsCount) + " " + configureNuix.getOperationName() + "</b>: ");
                        normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.ConfigureNuixInsert") + "</li>");
                        normalizationHtmlLog.append("</div></br></br>");
                        normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + configureNuix.getOperationName() + ": " + iu.getString("WorkflowNormalization.ConfigureNuixInsert"));
                        lastConfigureNuixOperation = i + insertedOperationsCount;
                    }
                } else {
                    boolean configureNuixDisabledCondition;
                    boolean configureParametersDisabledCondition = i + insertedOperationsCount == lastDisabledConfigureParametersOperation || i + insertedOperationsCount == lastDisabledConfigureNuixOperation && i - 1 + insertedOperationsCount == lastDisabledConfigureParametersOperation;
                    boolean bl3 = configureNuixDisabledCondition = i + insertedOperationsCount == lastDisabledConfigureNuixOperation;
                    if (!configureParametersDisabledCondition && normalizeParameters) {
                        configureParameters = new ConfigureParametersOperation();
                        configureParameters.staticParameters = new ArrayList<StaticParameter>();
                        configureParameters.userParameters = new ArrayList<StaticParameter>();
                        configureParameters.disabled = true;
                        this.getOperations().add(i + 1 + insertedOperationsCount, configureParameters);
                        normalizationHtmlLog.append("<div><b>#" + (i + 1 + ++insertedOperationsCount) + " " + configureParameters.getOperationName() + "</b>: ");
                        normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.AddedOperation") + "</li>");
                        normalizationHtmlLog.append("</div></br></br>");
                        normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + configureParameters.getOperationName() + ": " + iu.getString("WorkflowNormalization.AddedOperation"));
                        lastDisabledConfigureParametersOperation = i + insertedOperationsCount;
                    }
                    if (!configureNuixDisabledCondition && normalizeNuixSettings) {
                        configureNuix = new ConfigureNuixOperation();
                        configureNuix.disabled = true;
                        this.getOperations().add(i + 1 + insertedOperationsCount, configureNuix);
                        normalizationHtmlLog.append("<div><b>#" + (i + 1 + ++insertedOperationsCount) + " " + configureNuix.getOperationName() + "</b>: ");
                        normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.ConfigureNuixInsert") + "</li>");
                        normalizationHtmlLog.append("</div></br></br>");
                        normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + configureNuix.getOperationName() + ": " + iu.getString("WorkflowNormalization.ConfigureNuixInsert"));
                        lastDisabledConfigureNuixOperation = i + insertedOperationsCount;
                    }
                }
                if (normalizeParameters) {
                    ConfigureParametersOperation configureParameters2 = null;
                    configureParameters2 = !configurationOperation.disabled ? (ConfigureParametersOperation)this.getOperations().get(lastConfigureParametersOperation) : (ConfigureParametersOperation)this.getOperations().get(lastDisabledConfigureParametersOperation);
                    configureParameters2.notes = configureParameters2.notes != null && !configureParameters2.notes.trim().equals("") ? configureParameters2.notes + "\n" + configurationOperation.notes : configurationOperation.notes;
                    if (configurationOperation.promptAtExecution) {
                        configureParameters2.userParameters.addAll(configurationOperation.parameters);
                        if (this.migrateRegexDropdowns(configureParameters2.userParameters)) {
                            addNormalizationLog.accept(i, insertedOperationsCount, iu.getString("WorkflowNormalization.ParameterRegexDropdown"));
                        }
                    } else {
                        configureParameters2.staticParameters.addAll(configurationOperation.parameters);
                    }
                }
                if (normalizeNuixSettings) {
                    ConfigureNuixOperation configureNuix2 = null;
                    configureNuix2 = !configurationOperation.disabled ? (ConfigureNuixOperation)this.getOperations().get(lastConfigureNuixOperation) : (ConfigureNuixOperation)this.getOperations().get(lastDisabledConfigureNuixOperation);
                    configureNuix2.notes = configureNuix2.notes != null && !configureNuix2.notes.trim().equals("") ? configureNuix2.notes + "\n" + configurationOperation.notes : configurationOperation.notes;
                    if (configurationOperation.nuixSettingsType == NuixSettingsType.FROM_FILE) {
                        configurationOperation.useConfigurationProfile = true;
                    }
                    if (configurationOperation.useConfigurationProfile && configurationOperation.profileFilePath != null && !configurationOperation.profileFilePath.trim().equals("")) {
                        configureNuix2.useConfigurationProfile = true;
                        configureNuix2.profileFilePath = configurationOperation.profileFilePath;
                    }
                    if (configurationOperation.useProcessingProfile && configurationOperation.processingProfileName != null && !configurationOperation.processingProfileName.trim().equals("")) {
                        configureNuix2.useProcessingProfile = true;
                        configureNuix2.processingProfileName = configurationOperation.processingProfileName;
                    }
                    if (configurationOperation.parallelProcessingSettingsSource != null && configurationOperation.parallelProcessingSettingsSource != ParallelProcessingSettingsSource.PROFILE) {
                        configureNuix2.parallelProcessingSettingsSource = configurationOperation.parallelProcessingSettingsSource;
                        configureNuix2.workflowLocalWorkersCount = configurationOperation.workflowLocalWorkersCount;
                        configureNuix2.workflowLocalWorkersMemoryMb = configurationOperation.workflowLocalWorkersMemoryMb;
                        configureNuix2.workflowBrokerWorkersCount = configurationOperation.workflowBrokerWorkersCount;
                        if (configurationOperation.workflowBrokerIp != null && !configurationOperation.workflowBrokerIp.trim().equals("")) {
                            configureNuix2.workflowBrokerIp = configurationOperation.workflowBrokerIp;
                        }
                        configureNuix2.workflowBrokerPort = configurationOperation.workflowBrokerPort;
                        configureNuix2.requireFilesInExecutionProfile = configurationOperation.requireFilesInExecutionProfile;
                    }
                    if (configurationOperation.requireFilesInExecutionProfile) {
                        configureNuix2.requireFilesInExecutionProfile = true;
                    }
                    if (configurationOperation.passwordSettingsType != null && configurationOperation.passwordSettingsType != PasswordSettingsType.NONE) {
                        if (configurationOperation.passwordSettingsType == PasswordSettingsType.PASSWORD_LIST) {
                            ArrayList<Object[]> passwordList = new ArrayList<Object[]>();
                            if (configureNuix2.passwordSettingsType == PasswordSettingsType.PASSWORD_LIST && configureNuix2.passwordList != null && configureNuix2.passwordList.size() > 0) {
                                passwordList.addAll(configureNuix2.passwordList);
                            }
                            if (configurationOperation.passwordList != null && configurationOperation.passwordList.size() > 0) {
                                passwordList.addAll(configurationOperation.passwordList);
                            }
                            configureNuix2.passwordList = passwordList;
                        }
                        if (configurationOperation.passwordFilePath != null && !configurationOperation.passwordFilePath.trim().equals("")) {
                            configureNuix2.passwordFilePath = configurationOperation.passwordFilePath;
                        }
                        configureNuix2.passwordSettingsType = configurationOperation.passwordSettingsType;
                    }
                    if (configurationOperation.keyStoreFilePath != null && !configurationOperation.keyStoreFilePath.trim().equals("")) {
                        configureNuix2.keyStoreFilePath = configurationOperation.keyStoreFilePath;
                    }
                }
            }
            if (operation instanceof AddEvidenceOperation && !operation.disabled) {
                AddEvidenceOperation addEvidenceOperation = (AddEvidenceOperation)operation;
                if (!addEvidenceOperation.predefined) {
                    if (logOperation == null) {
                        normalizationPerformed.set(true);
                        logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    if (configureParametersOperation == null) {
                        normalizationPerformed.set(true);
                        messageLines.add("\n\n" + iu.getString("WorkflowNormalization.InterractivePromptsNormalized"));
                        configureParametersOperation = this.insertConfigurationOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    addEvidenceOperation.predefined = true;
                    normalizationHtmlLog.append("<div><b>#" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + "</b>: ");
                    normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.ChangedToPredefined") + "</li>");
                    normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + ": " + iu.getString("WorkflowNormalization.ChangedToPredefined"));
                    if ((addEvidenceOperation.sourceScope.equals((Object)SourceScope.PATH_ITEM) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.PATH_CONTENTS) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.LOADFILE) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.PATH_CONTENTS_AS_SEPARATE_EVIDENCE) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.EVIDENCE_LISTING) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.DATASET)) && (addEvidenceOperation.source == null || addEvidenceOperation.source.length() == 0)) {
                        normalizationHtmlLog.append("<li>" + iu.getFormattedString("WorkflowNormalization.PathMessage", (Object)"{add_evidence_source}") + "</li>");
                        normalizationPlainTextLog.add("\t" + iu.getFormattedString("WorkflowNormalization.PathMessage", (Object)"{add_evidence_source}"));
                        addEvidenceOperation.source = "{add_evidence_source}";
                        if (addEvidenceSource == null) {
                            addEvidenceSource = new StaticParameter();
                            addEvidenceSource.setName("{add_evidence_source}");
                            addEvidenceSource.setFriendlyName(iu.getString("WorkflowNormalization.PathFriendlyName"));
                            addEvidenceSource.setDescription(iu.getString("WorkflowNormalization.PathDescription"));
                            addEvidenceSource.setRegex(".+");
                            configureParametersOperation.userParameters.add(addEvidenceSource);
                        }
                    }
                    if ((addEvidenceOperation.sourceScope.equals((Object)SourceScope.PATH_ITEM) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.PATH_CONTENTS) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.LOADFILE) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.PATH_CONTENTS_AS_SEPARATE_EVIDENCE) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.MICROSOFT_GRAPH) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.SHAREPOINT) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.EXCHANGE) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.ENTERPRISE_VAULT) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.S3) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.SQL_SERVER) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.ORACLE) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.DOCUMENTUM) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.DROPBOX) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.SSH) || addEvidenceOperation.sourceScope.equals((Object)SourceScope.HISTORICAL_TWITTER)) && (addEvidenceOperation.evidenceName == null || addEvidenceOperation.evidenceName.length() == 0)) {
                        normalizationHtmlLog.append("<li>" + iu.getFormattedString("WorkflowNormalization.EvidenceMessage", (Object)"{add_evidence_name}") + "</li>");
                        normalizationPlainTextLog.add("\t" + iu.getFormattedString("WorkflowNormalization.EvidenceMessage", (Object)"{add_evidence_name}"));
                        addEvidenceOperation.evidenceName = "{add_evidence_name}";
                        if (addEvidenceName == null) {
                            addEvidenceName = new StaticParameter();
                            addEvidenceName.setName("{add_evidence_name}");
                            addEvidenceName.setValue("Evidence 1");
                            addEvidenceName.setFriendlyName(iu.getString("WorkflowNormalization.EvidenceFriendlyName"));
                            addEvidenceName.setDescription(iu.getString("WorkflowNormalization.EvidenceDescription"));
                            addEvidenceName.setRegex(".+");
                            configureParametersOperation.userParameters.add(addEvidenceName);
                        }
                    }
                    normalizationHtmlLog.append("</div></br></br>");
                }
            }
            if (operation instanceof UseCaseOperation) {
                UseCaseOperation useCaseOperation = (UseCaseOperation)operation;
                if (!useCaseOperation.predefined) {
                    if (logOperation == null) {
                        normalizationPerformed.set(true);
                        logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    if (configureParametersOperation == null) {
                        normalizationPerformed.set(true);
                        messageLines.add("\n\n" + iu.getString("WorkflowNormalization.InterractivePromptsNormalized"));
                        configureParametersOperation = this.insertConfigurationOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    useCaseOperation.predefined = true;
                    normalizationHtmlLog.append("<div><b>#" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + "</b>: ");
                    normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.ChangedToPredefined") + "</li>");
                    normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + ": " + iu.getString("WorkflowNormalization.ChangedToPredefined"));
                    if (useCaseOperation.caseLocation == null || useCaseOperation.caseLocation.length() == 0) {
                        normalizationHtmlLog.append("<li>" + iu.getFormattedString("WorkflowNormalization.CaseLocationMessage", (Object)"{use_case_location}") + "</li>");
                        normalizationPlainTextLog.add("\t" + iu.getFormattedString("WorkflowNormalization.CaseLocationMessage", (Object)"{use_case_location}"));
                        useCaseOperation.caseLocation = "{use_case_location}";
                        if (useCaseLocation == null) {
                            useCaseLocation = new StaticParameter();
                            useCaseLocation.setName("{use_case_location}");
                            useCaseLocation.setFriendlyName(iu.getString("WorkflowNormalization.CaseLocationFriendlyName"));
                            useCaseLocation.setDescription(iu.getString("WorkflowNormalization.CaseLocationDescription"));
                            useCaseLocation.setRegex(".+");
                            configureParametersOperation.userParameters.add(useCaseLocation);
                        }
                    }
                    normalizationHtmlLog.append("</div></br></br>");
                }
            }
            if (operation instanceof DetectAndAssignCustodiansOperation) {
                DetectAndAssignCustodiansOperation detectAndAssignCustodiansOperation = (DetectAndAssignCustodiansOperation)operation;
                if (detectAndAssignCustodiansOperation.interactiveAssignment) {
                    if (logOperation == null) {
                        logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    normalizationPerformed.set(true);
                    messageLines.add("\n\n" + iu.getString("WorkflowNormalization.InterractivePromptsNormalized"));
                    detectAndAssignCustodiansOperation.interactiveAssignment = false;
                    normalizationHtmlLog.append("<div><b>#" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + "</b>: ");
                    normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.DisabledManualInteractiveAssignment") + "</li>");
                    normalizationHtmlLog.append("</div></br></br>");
                    normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + ": " + iu.getString("WorkflowNormalization.DisabledManualInteractiveAssignment"));
                }
            }
            if (operation instanceof AddToProductionSetOperation) {
                AddToProductionSetOperation addToProductionSetOperation = (AddToProductionSetOperation)operation;
                if (addToProductionSetOperation.promptForNumberingAtExecution) {
                    if (logOperation == null) {
                        logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    normalizationPerformed.set(true);
                    messageLines.add("\n\n" + iu.getString("WorkflowNormalization.InterractivePromptsNormalized"));
                    addToProductionSetOperation.promptForNumberingAtExecution = false;
                    normalizationHtmlLog.append("<div><b>#" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + "</b>: ");
                    normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.DisabledPromptForNumberingAtExecution") + "</li>");
                    normalizationHtmlLog.append("</div></br></br>");
                    normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + ": " + iu.getString("WorkflowNormalization.DisabledPromptForNumberingAtExecution"));
                }
            }
            if (operation instanceof CloseNuixOperation && !operation.disabled) {
                CloseNuixOperation closeNuixOperation = (CloseNuixOperation)operation;
                if (!closeNuixOperation.disabled) {
                    if (logOperation == null) {
                        logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    normalizationPerformed.set(true);
                    closeNuixOperation.disabled = true;
                    normalizationHtmlLog.append("<div><b>#" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + "</b>: ");
                    normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.DisabledOperation") + "</li>");
                    normalizationHtmlLog.append("</div></br></br>");
                    normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + ": " + iu.getString("WorkflowNormalization.DisabledOperation"));
                }
            }
            if (operation instanceof NotifyOperation) {
                NotifyOperation notifyOperation = (NotifyOperation)operation;
                if (notifyOperation.interactive) {
                    if (logOperation == null) {
                        logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    normalizationPerformed.set(true);
                    messageLines.add("\n\n" + iu.getString("WorkflowNormalization.InterractivePromptsNormalized"));
                    notifyOperation.interactive = false;
                    normalizationHtmlLog.append("<div><b>#" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + "</b>: ");
                    normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.DisabledInteractiveNotification") + "</li>");
                    normalizationHtmlLog.append("</div></br></br>");
                    normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + ": " + iu.getString("WorkflowNormalization.DisabledInteractiveNotification"));
                }
            }
            if (operation instanceof ConfigureRelativityConnectionOperation) {
                ConfigureRelativityConnectionOperation workspaceOperation = (ConfigureRelativityConnectionOperation)operation;
                if (workspaceOperation.workspaceIdentifier != null || workspaceOperation.workspaceName != null) {
                    if (logOperation == null) {
                        logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    RelativitySetWorkspaceOperation configureWorkspaceOperation = new RelativitySetWorkspaceOperation();
                    configureWorkspaceOperation.workspaceIdentifierType = workspaceOperation.workspaceIdentifierType;
                    configureWorkspaceOperation.folderPath = workspaceOperation.folderPath;
                    configureWorkspaceOperation.createPathIfNotExists = workspaceOperation.createPathIfNotExists;
                    configureWorkspaceOperation.workspaceIdentifier = workspaceOperation.workspaceIdentifier;
                    configureWorkspaceOperation.disabled = workspaceOperation.disabled;
                    workspaceOperation.workspaceName = null;
                    workspaceOperation.workspaceIdentifier = null;
                    workspaceOperation.workspaceIdentifierType = null;
                    workspaceOperation.folderPath = null;
                    workspaceOperation.createPathIfNotExists = null;
                    this.getOperations().add(i + 1 + insertedOperationsCount, configureWorkspaceOperation);
                    normalizationHtmlLog.append("<div><b>#" + (i + 1 + ++insertedOperationsCount) + " " + configureWorkspaceOperation.getOperationName() + "</b>: ");
                    normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.SetRelativityWorkspaceInsert") + "</li>");
                    normalizationHtmlLog.append("</div></br></br>");
                    normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + ": " + iu.getString("WorkflowNormalization.SetRelativityWorkspaceInsert"));
                    normalizationPerformed.set(true);
                    messageLines.add("\n\n" + iu.getString("WorkflowNormalization.RelativityNormalization"));
                }
            }
            if (operation instanceof ConfigureDiscoverConnectionOperation) {
                ConfigureDiscoverConnectionOperation configureDiscoverConnectionOperation = (ConfigureDiscoverConnectionOperation)operation;
                if (configureDiscoverConnectionOperation.connectApiUrl != null) {
                    configureDiscoverConnectionOperation.connectApiUrl = null;
                    try {
                        configureDiscoverConnectionOperation.hostname = FormattingUtils.getHostnameFromUrl((String)configureDiscoverConnectionOperation.connectApiUrl);
                    }
                    catch (URISyntaxException e) {
                        LOGGER.error("Cannot parse hostname from URL " + configureDiscoverConnectionOperation.connectApiUrl, (Throwable)e);
                        configureDiscoverConnectionOperation.hostname = configureDiscoverConnectionOperation.connectApiUrl;
                    }
                }
            }
            if (operation instanceof UseDiscoverCaseOperation) {
                UseDiscoverCaseOperation useDiscoverCaseOperation = (UseDiscoverCaseOperation)operation;
                if (useDiscoverCaseOperation.discoverServiceId != null || useDiscoverCaseOperation.connectApiUrl != null && useDiscoverCaseOperation.apiToken != null) {
                    if (logOperation == null) {
                        logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    ConfigureDiscoverConnectionOperation configureDiscoverConnectionOperation = new ConfigureDiscoverConnectionOperation();
                    configureDiscoverConnectionOperation.disabled = useDiscoverCaseOperation.disabled;
                    configureDiscoverConnectionOperation.useDiscoverService = useDiscoverCaseOperation.useDiscoverService;
                    configureDiscoverConnectionOperation.discoverServiceId = useDiscoverCaseOperation.discoverServiceId;
                    try {
                        configureDiscoverConnectionOperation.hostname = FormattingUtils.getHostnameFromUrl((String)useDiscoverCaseOperation.connectApiUrl);
                    }
                    catch (URISyntaxException e) {
                        LOGGER.error("Cannot parse hostname from URL " + useDiscoverCaseOperation.connectApiUrl, (Throwable)e);
                        configureDiscoverConnectionOperation.hostname = useDiscoverCaseOperation.connectApiUrl;
                    }
                    configureDiscoverConnectionOperation.apiToken = useDiscoverCaseOperation.apiToken;
                    useDiscoverCaseOperation.discoverServiceId = null;
                    useDiscoverCaseOperation.apiToken = null;
                    useDiscoverCaseOperation.connectApiUrl = null;
                    this.getOperations().add(i + insertedOperationsCount, configureDiscoverConnectionOperation);
                    normalizationHtmlLog.append("<div><b>#" + (i + ++insertedOperationsCount) + " " + configureDiscoverConnectionOperation.getOperationName() + "</b>: ");
                    normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.ConfigureDiscoverConnectionInsert") + "</li>");
                    normalizationHtmlLog.append("</div></br></br>");
                    normalizationPlainTextLog.add(" #" + (i + insertedOperationsCount) + " " + operation.getOperationName() + ": " + iu.getString("WorkflowNormalization.ConfigureDiscoverConnectionInsert"));
                    normalizationPerformed.set(true);
                    messageLines.add("\n\n" + iu.getString("WorkflowNormalization.DiscoverNormalization"));
                }
            }
            if (operation instanceof ListRelativityDocumentsOperation) {
                ListRelativityDocumentsOperation listRelativityDocumentsOperation = (ListRelativityDocumentsOperation)operation;
                if (Boolean.TRUE.equals(listRelativityDocumentsOperation.tagMatches)) {
                    if (logOperation == null) {
                        logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    MatchItemsOperation matchItemsOperation = new MatchItemsOperation();
                    matchItemsOperation.matchItemsByGUID = false;
                    matchItemsOperation.matchItemsByMD5 = false;
                    matchItemsOperation.matchItemsByDocID = true;
                    matchItemsOperation.scope = listRelativityDocumentsOperation.scope;
                    boolean resetExportLocation = false;
                    if (!listRelativityDocumentsOperation.exportMatches.booleanValue()) {
                        listRelativityDocumentsOperation.exportMatches = true;
                        listRelativityDocumentsOperation.exportLocation = "{case_folder}/Temp/DocumentsInRelativity.txt";
                        resetExportLocation = true;
                    }
                    matchItemsOperation.sourceTextFile = listRelativityDocumentsOperation.exportLocation;
                    matchItemsOperation.tag = listRelativityDocumentsOperation.tag;
                    matchItemsOperation.tagScope = MatchScope.MATCHES;
                    matchItemsOperation.disabled = listRelativityDocumentsOperation.disabled;
                    matchItemsOperation.notes = listRelativityDocumentsOperation.notes;
                    this.getOperations().add(i + 1 + insertedOperationsCount, matchItemsOperation);
                    ++insertedOperationsCount;
                    if (resetExportLocation) {
                        normalizationHtmlLog.append("<div><b>#" + (i + insertedOperationsCount) + " " + listRelativityDocumentsOperation.getOperationName() + "</b>: ");
                        normalizationHtmlLog.append("<li>" + iu.getFormattedString("WorkflowNormalization.SetExportLocation", (Object)listRelativityDocumentsOperation.exportLocation) + "</li>");
                        normalizationHtmlLog.append("</div></br></br>");
                    }
                    normalizationHtmlLog.append("<div><b>#" + (i + 1 + insertedOperationsCount) + " " + matchItemsOperation.getOperationName() + "</b>: ");
                    normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.MatchItemsInsert") + "</li>");
                    normalizationHtmlLog.append("</div></br></br>");
                    if (resetExportLocation) {
                        normalizationPlainTextLog.add(" #" + (i + insertedOperationsCount) + " " + operation.getOperationName() + ": " + iu.getFormattedString("WorkflowNormalization.SetExportLocation", (Object)listRelativityDocumentsOperation.exportLocation));
                    }
                    normalizationPlainTextLog.add(" #" + (i + 1 + insertedOperationsCount) + " " + operation.getOperationName() + ": " + iu.getString("WorkflowNormalization.MatchItemsInsert"));
                    normalizationPerformed.set(true);
                    messageLines.add("\n\n" + iu.getString("WorkflowNormalization.ListRelativityDocumentsNormalization"));
                    listRelativityDocumentsOperation.tagMatches = null;
                    listRelativityDocumentsOperation.tag = null;
                    listRelativityDocumentsOperation.exportMatches = null;
                }
            }
            if (operation instanceof ConfigureParametersOperation) {
                ConfigureParametersOperation o = (ConfigureParametersOperation)operation;
                boolean parameterNormalizationPerformed = false;
                boolean normalizedRegexDropdowns = false;
                for (StaticParameter parameter : o.userParameters) {
                    this.migrateParameterSettings((com.nuix.automate.utils.workflow.Parameter)parameter);
                    if (this.migrateRegexDropdown((com.nuix.automate.utils.workflow.Parameter)parameter)) {
                        normalizedRegexDropdowns = true;
                    }
                    LinkedHashSet<String> allowedValues = new LinkedHashSet<String>();
                    if (parameter.getAllowedValues() == null) continue;
                    for (String allowedVal : parameter.getAllowedValues()) {
                        ScriptLanguage scriptLanguage = ScriptUtils.getScriptLanguage(allowedVal.toLowerCase());
                        if (scriptLanguage != null) {
                            String scriptPath = allowedVal.split(":", 2)[1];
                            parameterNormalizationPerformed = true;
                            if (logOperation == null) {
                                logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                                ++insertedOperationsCount;
                            }
                            parameter.setParameterType(ParameterType.SCRIPTED);
                            parameter.setUseLibraryFile(false);
                            parameter.setScriptLanguage(scriptLanguage);
                            try {
                                parameter.setScriptCode(FileUtils.readFileWithAutodetectEncoding((File)new File(scriptPath)));
                            }
                            catch (Exception e) {
                                parameter.setScriptCode("");
                                parameter.setDescription(parameter.getDescription() + "\nFailed to retrieve script code from " + scriptPath);
                            }
                            parameter.setValue("");
                            continue;
                        }
                        allowedValues.add(allowedVal);
                    }
                    parameter.setAllowedValues(allowedValues);
                }
                if (parameterNormalizationPerformed) {
                    if (logOperation == null) {
                        logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    addNormalizationLog.accept(i, insertedOperationsCount, iu.getString("WorkflowNormalization.ConvertedToScriptedParameter"));
                }
                if (normalizedRegexDropdowns) {
                    if (logOperation == null) {
                        logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                        ++insertedOperationsCount;
                    }
                    addNormalizationLog.accept(i, insertedOperationsCount, iu.getString("WorkflowNormalization.ParameterRegexDropdown"));
                }
            }
            if (!(operation instanceof ScriptOperation)) continue;
            boolean scriptNormalizationPerformed = false;
            ScriptOperation o = (ScriptOperation)operation;
            ArrayList<String> methodLines = new ArrayList<String>();
            if (!o.useScriptFile) {
                String[] lines = o.scriptCode.split("\n");
                for (int j = 0; j < lines.length; ++j) {
                    String line = lines[j];
                    if (!line.trim().matches("(workflowExecution|workflow_execution)\\.goToOperation\\s*\\(\\s*\\d+\\s*\\)")) continue;
                    scriptNormalizationPerformed = true;
                    methodLines.add(String.valueOf(j));
                }
            }
            if (insertedOperationsCount == 0) {
                scriptNormalizationPerformed = false;
            }
            if (!scriptNormalizationPerformed) continue;
            if (logOperation == null) {
                logOperation = this.insertNormalizationLogOperation(normalizationHtmlLog, normalizationPlainTextLog);
                ++insertedOperationsCount;
            }
            ScriptOperation scriptOperation = new ScriptOperation();
            scriptOperation.notes = iu.getString("WorkflowNormalization.ScriptWarningSimple");
            scriptOperation.useScriptFile = false;
            scriptOperation.scriptType = ScriptType.PYTHON;
            scriptOperation.scriptCode = "workflowExecution.logWarning(\"" + iu.getNumeralFormattedString("WorkflowNormalization.ScriptWarning", (long)methodLines.size(), new Object[]{"workflowExecution.goToOperation(n)", String.join((CharSequence)", ", methodLines)}) + "\")\n";
            this.getOperations().add(i + insertedOperationsCount, scriptOperation);
            normalizationHtmlLog.append("<div><b>#" + (i + ++insertedOperationsCount) + " " + scriptOperation.getOperationName() + "</b>: ");
            normalizationHtmlLog.append("<li>" + iu.getString("WorkflowNormalization.ScriptWarningInsert") + "</li>");
            normalizationHtmlLog.append("</div></br></br>");
            normalizationPlainTextLog.add(" #" + (i + insertedOperationsCount) + " " + operation.getOperationName() + ": " + iu.getString("WorkflowNormalization.ScriptWarningInsert"));
            normalizationPerformed.set(true);
            messageLines.add("\n\n" + iu.getFormattedString("WorkflowNormalization.WarningScriptAdded", (Object)"workflowExecution.goToOperation(n)"));
        }
        if (normalizationPerformed.get()) {
            LOGGER.info(String.join((CharSequence)"", messageLines));
            StringBuilder notes = new StringBuilder();
            notes.append(String.join((CharSequence)"", messageLines).replace("\n", " ").replace("  ", " ")).append("\n");
            for (String line : normalizationPlainTextLog) {
                notes.append(line.replace("\"", " ")).append("\n");
                LOGGER.info(line);
            }
            logOperation.logRecords = notes.toString();
        }
        return normalizationPerformed.get();
    }

    private boolean migrateParameterSettings(com.nuix.automate.utils.workflow.Parameter parameter) {
        boolean migrated = false;
        if (parameter.getAllowedValuesMatchBy() == null) {
            parameter.setAllowedValuesMatchBy(ParameterValueMatchBy.SYSTEM_OR_USER_PRINTABLE_VALUE);
            migrated = true;
        }
        if (parameter.getParameterType() == ParameterType.MICROSOFT_USER_SERVICE) {
            parameter.setParameterType(ParameterType.PURVIEW_SERVICE);
            migrated = true;
        }
        return migrated;
    }

    private boolean migrateRegexDropdowns(List<StaticParameter> parameters) {
        boolean migrated = false;
        for (StaticParameter parameter : parameters) {
            this.migrateParameterSettings((com.nuix.automate.utils.workflow.Parameter)parameter);
            if (!this.migrateRegexDropdown((com.nuix.automate.utils.workflow.Parameter)parameter)) continue;
            migrated = true;
        }
        return migrated;
    }

    private boolean migrateRegexDropdown(com.nuix.automate.utils.workflow.Parameter parameter) {
        String[] potentialValues;
        Object regex = parameter.getRegex();
        if (regex == null || ((String)regex).trim().isEmpty()) {
            return false;
        }
        if (((String)regex).endsWith("|")) {
            regex = (String)regex + " ";
        }
        if ((potentialValues = ((String)regex).split("\\|")).length < 2) {
            return false;
        }
        HashSet<Character> regexSpecialChars = new HashSet<Character>(Arrays.asList(Character.valueOf('.'), Character.valueOf('+'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('^'), Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'), Character.valueOf('\\')));
        HashSet<String> allowedValues = new HashSet<String>();
        for (String value : potentialValues) {
            StringBuilder allowedValue = new StringBuilder();
            char[] chars = value.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (regexSpecialChars.contains(Character.valueOf(c))) {
                    if (c == '\\') {
                        if (!regexSpecialChars.contains(Character.valueOf(c = chars[++i]))) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                allowedValue.append(c);
            }
            allowedValues.add(allowedValue.toString());
        }
        if (parameter.getAllowedValues() == null) {
            parameter.setAllowedValues(new HashSet());
        }
        parameter.getAllowedValues().addAll(allowedValues);
        parameter.setRegex("");
        return true;
    }

    public List<Parameter> getUserParameters() throws ParameterException {
        ArrayList<Parameter> userConfigurationParameters = new ArrayList<Parameter>();
        HashMap<String, StaticParameter> staticParameters = new HashMap<String, StaticParameter>();
        StringBuilder errorMessage = new StringBuilder();
        for (Operation op : this.operations) {
            if (op.disabled || !(op instanceof ConfigureParametersOperation)) continue;
            ConfigureParametersOperation configureParametersOperation = (ConfigureParametersOperation)op;
            if (configureParametersOperation.userParameters == null || configureParametersOperation.userParameters.size() <= 0) continue;
            for (StaticParameter staticParameter : configureParametersOperation.userParameters) {
                Parameter configurationParameter = new Parameter((com.nuix.automate.utils.workflow.Parameter)staticParameter);
                userConfigurationParameters.add(configurationParameter);
                StaticParameter previousParameter = (StaticParameter)staticParameters.get(staticParameter.getName());
                if (previousParameter == null) continue;
                if (previousParameter.getRegex() != null && staticParameter.getRegex() != null && !previousParameter.getRegex().equals(staticParameter.getRegex())) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append("\n");
                    }
                    errorMessage.append(iu.getFormattedString("JobResource.InconsistentValidationRegexps", (Object)staticParameter.getName()));
                }
                staticParameters.put(staticParameter.getName(), staticParameter);
            }
        }
        if (errorMessage.length() > 0) {
            throw new ParameterException(errorMessage.toString());
        }
        return userConfigurationParameters;
    }

    public List<Parameter> getStaticParameters() throws ParameterException {
        ArrayList<Parameter> staticConfigurationParameters = new ArrayList<Parameter>();
        HashMap<String, StaticParameter> staticParameters = new HashMap<String, StaticParameter>();
        StringBuilder errorMessage = new StringBuilder();
        for (Operation op : this.operations) {
            if (op.disabled || !(op instanceof ConfigureParametersOperation)) continue;
            ConfigureParametersOperation configureParametersOperation = (ConfigureParametersOperation)op;
            if (configureParametersOperation.staticParameters == null || configureParametersOperation.staticParameters.size() <= 0) continue;
            for (StaticParameter staticParameter : configureParametersOperation.staticParameters) {
                Parameter configurationParameter = new Parameter((com.nuix.automate.utils.workflow.Parameter)staticParameter);
                staticConfigurationParameters.add(configurationParameter);
                StaticParameter previousParameter = (StaticParameter)staticParameters.get(staticParameter.getName());
                if (previousParameter == null) continue;
                if (previousParameter.getRegex() != null && staticParameter.getRegex() != null && !previousParameter.getRegex().equals(staticParameter.getRegex())) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append("\n");
                    }
                    errorMessage.append(iu.getFormattedString("JobResource.InconsistentValidationRegexps", (Object)staticParameter.getName()));
                }
                staticParameters.put(staticParameter.getName(), staticParameter);
            }
        }
        if (errorMessage.length() > 0) {
            throw new ParameterException(errorMessage.toString());
        }
        return staticConfigurationParameters;
    }

    public boolean workflowRequiresFilesInExecutionProfile() {
        for (Operation op : this.operations) {
            if (op.disabled || !(op instanceof ConfigureNuixOperation)) continue;
            ConfigureNuixOperation configureNuixOperation = (ConfigureNuixOperation)op;
            if (!configureNuixOperation.requireFilesInExecutionProfile) continue;
            return true;
        }
        return false;
    }

    public List<JobRequiredProfile> getRequiredNuixProfiles() {
        ArrayList<JobRequiredProfile> requiredNuixProfiles = new ArrayList<JobRequiredProfile>();
        if (this.workflowRequiresFilesInExecutionProfile()) {
            for (Operation op : this.operations) {
                JobRequiredProfile profile;
                Operation specializedOperation;
                if (op.disabled) continue;
                if (op instanceof ConfigureNuixOperation) {
                    specializedOperation = (ConfigureNuixOperation)op;
                    if (specializedOperation.useProcessingProfile) {
                        profile = new JobRequiredProfile(specializedOperation.processingProfileName, LibraryNuixFileType.PROCESSING_PROFILE);
                        requiredNuixProfiles.add(profile);
                    }
                }
                if (op instanceof AddEvidenceOperation) {
                    specializedOperation = (AddEvidenceOperation)op;
                    if (((AddEvidenceOperation)specializedOperation).metadataImportProfile != null && ((AddEvidenceOperation)specializedOperation).metadataImportProfile.trim().length() > 0) {
                        profile = new JobRequiredProfile(((AddEvidenceOperation)specializedOperation).metadataImportProfile, LibraryNuixFileType.METADATA_IMPORT_PROFILE);
                        requiredNuixProfiles.add(profile);
                    }
                }
                if (op instanceof GraphConfigureConnectionOperation) {
                    specializedOperation = (GraphConfigureConnectionOperation)op;
                    if (((GraphConfigureConnectionOperation)specializedOperation).playbookFile != null && ((GraphConfigureConnectionOperation)specializedOperation).playbookFile.trim().length() > 0) {
                        profile = new JobRequiredProfile(((GraphConfigureConnectionOperation)specializedOperation).playbookFile, LibraryNuixFileType.PLAYBOOK);
                        requiredNuixProfiles.add(profile);
                    }
                }
                if (op instanceof OcrOperation) {
                    specializedOperation = (OcrOperation)op;
                    if (((OcrOperation)specializedOperation).useOcrProfile) {
                        profile = new JobRequiredProfile(((OcrOperation)specializedOperation).ocrProfileName, LibraryNuixFileType.OCR_PROFILE);
                        requiredNuixProfiles.add(profile);
                    }
                }
                if (op instanceof GenerateDuplicateFieldsOperation) {
                    specializedOperation = (GenerateDuplicateFieldsOperation)op;
                    profile = new JobRequiredProfile(((GenerateDuplicateFieldsOperation)specializedOperation).fieldMetadataProfileName, LibraryNuixFileType.OCR_PROFILE);
                    requiredNuixProfiles.add(profile);
                }
                if (op instanceof GeneratePrintedImagesOperation) {
                    specializedOperation = (GeneratePrintedImagesOperation)op;
                    profile = new JobRequiredProfile(((GeneratePrintedImagesOperation)specializedOperation).imagingProfile, LibraryNuixFileType.METADATA_PROFILE);
                    requiredNuixProfiles.add(profile);
                }
                if (op instanceof RelativityMetadataOverlayOperation) {
                    specializedOperation = (RelativityMetadataOverlayOperation)op;
                    profile = new JobRequiredProfile(((RelativityMetadataOverlayOperation)specializedOperation).metadataProfile, LibraryNuixFileType.METADATA_PROFILE);
                    requiredNuixProfiles.add(profile);
                }
                if (op instanceof LegalExportOperation) {
                    JobRequiredProfile profile2;
                    specializedOperation = (LegalExportOperation)op;
                    profile = new JobRequiredProfile(((LegalExportOperation)specializedOperation).metadataProfile, LibraryNuixFileType.METADATA_PROFILE);
                    requiredNuixProfiles.add(profile);
                    if (((LegalExportOperation)specializedOperation).productionProfile != null && ((LegalExportOperation)specializedOperation).productionProfile.trim().length() > 0) {
                        profile2 = new JobRequiredProfile(((LegalExportOperation)specializedOperation).productionProfile, LibraryNuixFileType.PRODUCTION_PROFILE);
                        requiredNuixProfiles.add(profile2);
                    }
                    if (((LegalExportOperation)specializedOperation).imagingProfile != null && ((LegalExportOperation)specializedOperation).imagingProfile.trim().length() > 0) {
                        profile2 = new JobRequiredProfile(((LegalExportOperation)specializedOperation).imagingProfile, LibraryNuixFileType.IMAGING_PROFILE);
                        requiredNuixProfiles.add(profile2);
                    }
                }
                if (op instanceof ExportItemsOperation) {
                    specializedOperation = (ExportItemsOperation)op;
                    profile = new JobRequiredProfile(((ExportItemsOperation)specializedOperation).metadataProfile, LibraryNuixFileType.METADATA_PROFILE);
                    requiredNuixProfiles.add(profile);
                }
                if (op instanceof MetadataExportOperation) {
                    specializedOperation = (MetadataExportOperation)op;
                    profile = new JobRequiredProfile(((MetadataExportOperation)specializedOperation).metadataProfile, LibraryNuixFileType.METADATA_PROFILE);
                    requiredNuixProfiles.add(profile);
                }
                if (!(op instanceof MetadataToSqlOperation)) continue;
                specializedOperation = (MetadataToSqlOperation)op;
                profile = new JobRequiredProfile(((MetadataToSqlOperation)specializedOperation).metadataProfile, LibraryNuixFileType.METADATA_PROFILE);
                requiredNuixProfiles.add(profile);
            }
        }
        return requiredNuixProfiles;
    }

    public void clearSensitiveValues() {
        for (Operation operation : this.operations) {
            String value;
            if (operation.getOriginalState() != null) {
                operation.setOriginalState(null);
            }
            if (!(operation instanceof ConfigureParametersOperation)) continue;
            ConfigureParametersOperation configureParametersOperation = (ConfigureParametersOperation)operation;
            for (StaticParameter parameter : configureParametersOperation.staticParameters) {
                if (!parameter.isEffectiveTypeMaskedOrProtected() || (value = parameter.getProtectedValue()) == null || value.length() <= 0) continue;
                parameter.setValue(null);
            }
            for (StaticParameter parameter : configureParametersOperation.userParameters) {
                if (!parameter.isEffectiveTypeMaskedOrProtected() || (value = parameter.getProtectedValue()) == null || value.length() <= 0) continue;
                parameter.setValue(null);
            }
        }
    }

    public boolean cleanupScriptedParameters() {
        boolean parametersModified = false;
        for (Operation operation : this.operations) {
            if (!(operation instanceof ConfigureParametersOperation)) continue;
            ConfigureParametersOperation configureParameters = (ConfigureParametersOperation)operation;
            if (configureParameters.userParameters == null || configureParameters.userParameters.size() <= 0) continue;
            for (StaticParameter parameter : configureParameters.userParameters) {
                boolean clearSelectedLibraryFile;
                boolean clearScriptCode = parameter.getParameterType() != ParameterType.SCRIPTED || parameter.isUseLibraryFile();
                boolean bl = clearSelectedLibraryFile = parameter.getParameterType() != ParameterType.SCRIPTED || !parameter.isUseLibraryFile();
                if (clearScriptCode && parameter.getScriptCode() != null && !parameter.getScriptCode().equals("")) {
                    parameter.setScriptCode("");
                    parametersModified = true;
                }
                if (!clearSelectedLibraryFile || parameter.getLibraryFileId() == null || parameter.getLibraryFileId().equals("")) continue;
                parameter.setLibraryFileId("");
                parametersModified = true;
            }
        }
        return parametersModified;
    }

    public void setOperationsHaveScriptFiles() {
        for (Operation operation : this.getOperations()) {
            if (!(operation instanceof ScriptFileOperation)) continue;
            ScriptFileOperation scriptOp = (ScriptFileOperation)((Object)operation);
            scriptOp.setOperationHasScriptFiles();
        }
    }

    public boolean getOperationsHaveScriptFiles() {
        for (Operation operation : this.getOperations()) {
            ScriptFileOperation scriptOp;
            if (!(operation instanceof ScriptFileOperation) || !(scriptOp = (ScriptFileOperation)((Object)operation)).getOperationHasScriptFiles().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getLastModifiedEpoch() {
        return this.lastModifiedEpoch;
    }

    public void setLastModifiedEpoch(Long lastModifiedEpoch) {
        this.lastModifiedEpoch = lastModifiedEpoch;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public String getProducerVersion() {
        return this.producerVersion;
    }

    public void setProducerVersion(String producerVersion) {
        this.producerVersion = producerVersion;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<String> getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(List<String> prerequisites) {
        this.prerequisites = prerequisites;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }

    public ExecutionMode getExplicitExecutionMode() {
        return this.explicitExecutionMode;
    }

    public void setExplicitExecutionMode(ExecutionMode explicitExecutionMode) {
        this.explicitExecutionMode = explicitExecutionMode;
    }

    private static interface MultiConsumer {
        public void accept(Object ... var1);
    }
}

