/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.workflow;

import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.exceptions.UserTriggeredScriptErrorException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.TimerTask;
import com.nuix.automate.utils.general.ZipUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenceValidationException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.ProfileTypeNuix;
import com.nuix.automate.utils.security.Encryptor;
import com.nuix.automate.utils.ui.Icons;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.LinkLog;
import com.nuix.automate.utils.workflow.LogLevel;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.SourceParameter;
import com.nuix.automate.utils.workflow.SourceParameterSourceType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.utils.workflow.WorkflowFileFormat;
import com.nuix.automate.workflow.core.execution.events.ScriptWorkflowExecutionListener;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperation;
import com.nuix.automate.workflow.core.execution.operations.NativeOcrItemsOperationImplementation;
import com.nuix.automate.workflow.core.execution.operations.OcrOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.OperationEvent;
import com.nuix.automate.workflow.core.execution.operations.OperationListener;
import com.nuix.automate.workflow.core.execution.operations.UseCaseOperation;
import com.nuix.automate.workflow.core.execution.script.WorkflowExecutionAutomateRestClient;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.execution.workflow.OperationExecutionState;
import com.nuix.automate.workflow.core.execution.workflow.UserCancelledException;
import com.nuix.automate.workflow.core.execution.workflow.Workflow;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecutionEvent;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecutionListener;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecutionState;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.general.ReflectionUtils;
import com.nuix.automate.workflow.core.utils.general.SerializerFactory;
import com.nuix.automate.workflow.core.utils.ocr.TesseractOcrUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import nuix.CaseFactory;
import nuix.profile.Profile;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class WorkflowExecution
implements TimerTask.Callback {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowExecution.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private Workflow workflow;
    private String workflowFilename;
    private ExecutionContext executionContext;
    private int workflowExecutionPosition = -1;
    private int operationsExecutionCount = 0;
    private int nextWorkflowExecutionPosition = -1;
    private Timer workflowExecutionTimer;
    private TimerTask timerTask;
    private ExecutionState executionState;
    private Semaphore operationStatusRefreshLock;
    private AtomicInteger activeEvents = new AtomicInteger(0);
    private Set<String> logFiles;
    private Set<String> caseFolders;
    private List<WorkflowExecutionListener> workflowExecutionListeners;
    private StringBuilder logStringBuilder = new StringBuilder();
    private String executionTime;
    private RuntimeMXBean runtimeMXBean;
    private long upTime;
    private long gcTime;
    private long uiGcSkip;
    private boolean lowJvmMemory;
    private boolean lowSystemMemory;
    private int refreshMs = 500;
    private boolean isResuming = false;
    private boolean caseOpenedBeforePausing;
    private Set<String> caseFoldersBeforePausing;
    private ScriptWorkflowExecutionListener scriptWorkflowExecutionListener;
    private boolean encounteredErrors;
    private ExecutionState lastEventState = null;
    private long startEpoch;
    private Map<ProfileTypeNuix, Set<String>> nuixProfiles;
    private Set<Profile> nuixProfileObjects;
    private JFrame uiFrame;
    private String logFileNameTemplate;

    public WorkflowExecution(ExecutionContext executionContext) {
        this.logFiles = new HashSet<String>();
        this.caseFolders = new HashSet<String>();
        this.executionState = ExecutionState.NOT_STARTED;
        this.executionContext = executionContext;
        this.executionContext.workflowExecution = this;
        this.workflowExecutionListeners = new ArrayList<WorkflowExecutionListener>();
        this.runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    }

    public WorkflowExecution() {
        this(new ExecutionContext(null, null, null, null, null, false, null));
    }

    public Set<String> getCaseFolders() {
        return this.caseFolders;
    }

    public void setUiFrame(JFrame uiWindow) {
        this.uiFrame = uiWindow;
    }

    public void setNextWorkflowExecutionPosition(int id) {
        this.nextWorkflowExecutionPosition = id;
    }

    public int getWorkflowExecutionPosition() {
        return this.workflowExecutionPosition;
    }

    public void closeUi() {
        this.uiFrame.dispose();
    }

    public void forceFinishedState() {
        LOGGER.info("Sleeping for 1s ...");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOGGER.info("Cannot sleep");
        }
        this.call();
        this.workflowExecutionTimer.cancel();
        this.closeCaseOpenedByWorkflow();
        this.executionState = ExecutionState.FINISHED;
    }

    public double getPercentageComplete() {
        if (this.workflow != null && this.executionContext != null && this.executionContext.licenceInfo != null) {
            boolean enablePercentageComplete = this.executionContext.licenceInfo.getModuleLicensed(ModuleType.NEO_MANAGEMENT);
            return this.workflow.getPercentageComplete(enablePercentageComplete);
        }
        return 0.0;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.executionContext.workflowExecution = this;
    }

    public String getWorkflowFilename() {
        if (this.workflowFilename == null) {
            try {
                String name = "Unnamed workflow";
                if (this.workflow.getName() != null) {
                    name = this.workflow.getName();
                }
                File tempWorkflowFile = FileUtils.createTempFile((String)(name + " "), (String)".rfn");
                this.workflow.saveToFile(tempWorkflowFile.getAbsolutePath(), WorkflowFileFormat.XML);
                tempWorkflowFile.deleteOnExit();
                this.workflowFilename = tempWorkflowFile.getAbsolutePath();
            }
            catch (IOException e) {
                LOGGER.warn("Cannot make backup copy of workflow", (Throwable)e);
            }
        }
        return this.workflowFilename;
    }

    public void addWorkflowExecutionListener(WorkflowExecutionListener workflowExecutionListener) {
        this.workflowExecutionListeners.add(workflowExecutionListener);
    }

    public void removeWorkflowExecutionListener(WorkflowExecutionListener workflowExecutionListener) {
        this.workflowExecutionListeners.remove(workflowExecutionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWorkflowBeforeInitializedEvent() {
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.beforeWorkflowExecutionInitialized(workflowExecutionEvent);
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWorkflowAfterInitializedEvent() {
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.workflowExecutionInitialized(workflowExecutionEvent);
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWorkflowStatusChangedEvent(ExecutionState executionState) {
        if (executionState.equals((Object)this.lastEventState)) {
            return;
        }
        this.lastEventState = executionState;
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.workflowExecutionStateChanged(workflowExecutionEvent, executionState);
                }
                catch (ConcurrentModificationException ex) {
                    LOGGER.error("Error sending notification", (Throwable)ex);
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWorkflowExecutionProgressEvent(int operationPosition) {
        this.activeEvents.incrementAndGet();
        try {
            if (this.workflow == null) {
                LOGGER.warn("Skipping notification for operation at position " + operationPosition + " because workflow is null");
                return;
            }
            if (this.workflow.getOperations() == null) {
                LOGGER.warn("Skipping notification for operation at position " + operationPosition + " because workflow operations is null");
                return;
            }
            if (this.workflow.getOperations().size() <= operationPosition || operationPosition < 0) {
                LOGGER.warn("Skipping notification for operation at position " + operationPosition + " because workflow only has " + this.workflow.getOperations().size() + " operations");
                return;
            }
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.workflowExecutionProgress(workflowExecutionEvent, operationPosition);
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWorkflowExecutionPrerequisitesError(String errorTitle, String errorMessage, String detailedErrorMessage, Exception exception) {
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.workflowExecutionPrerequisiteError(workflowExecutionEvent, errorTitle, errorMessage, detailedErrorMessage, exception);
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWorkflowExecutionLog(String logMessage, LogLevel logLevel) {
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.workflowExecutionLog(workflowExecutionEvent, logMessage, logLevel);
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBeforeOperationStart(Operation operation) {
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.beforeOperationStart(workflowExecutionEvent, operation);
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAfterOperationFinish(Operation operation, boolean operationIsLast) {
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.afterOperationFinish(workflowExecutionEvent, operation, operationIsLast);
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
            try {
                operation.cleanUp();
            }
            catch (Exception e) {
                LOGGER.error("Cannot perform operation clean-up", (Throwable)e);
            }
            if (operation.executionState == ExecutionState.STOPPED) {
                this.fireAfterOperationError(operation);
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAfterOperationSkipped(Operation operation) {
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.afterOperationSkipped(workflowExecutionEvent, operation);
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOnOperationWarning(Operation operation, String message) {
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.onOperationWarning(workflowExecutionEvent, operation, message);
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAfterOperationError(Operation operation) {
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.afterOperationError(workflowExecutionEvent, operation);
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireOnConfigurationPrompt(Operation operation) throws UserCancelledException {
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.onConfigurationPrompt(workflowExecutionEvent, operation);
                }
                catch (UserCancelledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireOnUseCasePrompt(Operation operation) throws UserCancelledException {
        this.activeEvents.incrementAndGet();
        try {
            WorkflowExecutionEvent workflowExecutionEvent = new WorkflowExecutionEvent(this);
            ArrayList<WorkflowExecutionListener> listeners = new ArrayList<WorkflowExecutionListener>();
            listeners.addAll(this.workflowExecutionListeners);
            for (WorkflowExecutionListener workflowExecutionListener : listeners) {
                try {
                    workflowExecutionListener.onUseCasePrompt(workflowExecutionEvent, this.executionContext, operation);
                }
                catch (UserCancelledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.error("Error sending notification", (Throwable)e);
                }
            }
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    void preInitPausedWorkflow() {
        this.executionContext.initializeDynamicParameters();
        this.executionContext.initializeBuiltInParameters();
    }

    void initPausedWorkflow() {
        this.activeEvents.incrementAndGet();
        try {
            this.executionState = ExecutionState.PAUSED;
            this.fireWorkflowBeforeInitializedEvent();
            this.fireWorkflowAfterInitializedEvent();
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    void initNotStartedWorkflow() {
        this.workflowExecutionPosition = -1;
        this.activeEvents.incrementAndGet();
        try {
            this.executionState = ExecutionState.NOT_STARTED;
            this.logStringBuilder = new StringBuilder();
            this.executionContext.initializeDynamicParameters();
            this.executionContext.initializeBuiltInParameters();
            this.fireWorkflowBeforeInitializedEvent();
            this.fireWorkflowAfterInitializedEvent();
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    public void setNewWorkflow() {
        LOGGER.info("New Workflow");
        this.setNewWorkflow(this.iu.getString("WorkflowExecution.Workflow.UntitledName"));
    }

    void setNewWorkflow(String workflowName) {
        LOGGER.info("New Workflow with name " + workflowName);
        this.workflow = new Workflow(workflowName);
        this.workflowFilename = null;
        this.initNotStartedWorkflow();
    }

    public void openWorkflow(File f) throws IOException {
        this.readWorkflowFromFile(f.getAbsolutePath());
        this.initNotStartedWorkflow();
    }

    public void openWorkflowSavedSate(File f) throws IOException {
        LOGGER.info("Opening workflow from " + f.getAbsolutePath());
        String workflowSavedStateXml = FileUtils.readFileWithAutodetectEncoding((File)f);
        this.openWorkflowSavedSate(workflowSavedStateXml);
    }

    public void openWorkflowSavedSate(String xml) throws IOException {
        this.preInitPausedWorkflow();
        this.readWorkflowSavedStateFromXml(xml);
        this.initPausedWorkflow();
    }

    public void openWorkflow(byte[] decodedData) throws IOException {
        ByteArrayInputStream inputStream;
        String header = new String(Arrays.copyOfRange(decodedData, 0, 4), StandardCharsets.UTF_8);
        if (header.startsWith("PK\u0003\u0004")) {
            List filesContents = ZipUtils.unzipFileData((byte[])decodedData, (String)".rfn");
            if (filesContents.size() == 0) {
                throw new IOException(this.iu.getString("Zip.Error.NoWorkflow"));
            }
            if (filesContents.size() > 1) {
                throw new IOException(this.iu.getString("Zip.Error.MoreThanOneWorkflow"));
            }
            inputStream = new ByteArrayInputStream(((String)filesContents.get(0)).getBytes(StandardCharsets.UTF_8));
        } else {
            inputStream = new ByteArrayInputStream(decodedData);
        }
        String xml = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        this.readWorkflowFromXml(xml);
        this.initNotStartedWorkflow();
    }

    public void openWorkflow(String data) throws IOException {
        byte[] decodedData;
        try {
            decodedData = Base64.getDecoder().decode(data);
        }
        catch (Exception e) {
            LOGGER.debug("Data is not base64 encoded");
            decodedData = data.getBytes(StandardCharsets.UTF_8);
        }
        this.openWorkflow(decodedData);
    }

    public boolean normalizeWorkflow() {
        StringBuilder normalizationHtmlLog = new StringBuilder();
        LinkedHashSet<String> messageLines = new LinkedHashSet<String>();
        return this.workflow.normalize(normalizationHtmlLog, messageLines);
    }

    public int getOperationPosition(Operation o) {
        for (int i = 0; i < this.workflow.getOperations().size(); ++i) {
            if (o != this.workflow.getOperations().get(i)) continue;
            return i;
        }
        return -1;
    }

    public void openWorkflow(Workflow workflow) {
        LOGGER.info("Open workflow from existing workflow " + workflow.getName());
        this.workflow = workflow;
        this.initNotStartedWorkflow();
    }

    public Boolean isWorkflowRunning() {
        return this.executionState != ExecutionState.NOT_STARTED && this.executionState != ExecutionState.STOPPED && this.executionState != ExecutionState.PAUSED && this.executionState != ExecutionState.FINISHED && this.executionState != ExecutionState.ERROR;
    }

    public String getWorkflowXml() throws IOException {
        return this.workflow.toXml();
    }

    private void readWorkflowFromXml(String xml) throws IOException {
        Workflow openedWorkflow;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Opening workflow from XML");
        }
        this.workflow = openedWorkflow = Workflow.fromXml(xml);
        this.workflowFilename = null;
    }

    private void decryptSavedStateParameters(WorkflowExecutionState workflowExecutionState) throws IOException {
        String parameterValue;
        Encryptor encryptor = Encryptor.getUserInstance();
        for (StaticParameter parameter : workflowExecutionState.getExecutionCustomParameters()) {
            if (parameter.isEffectiveTypeMaskedOrProtected()) {
                if (parameter.getProtectedValue().equals(Parameter.MASKED_VALUE)) continue;
                try {
                    parameterValue = encryptor.decrypt(parameter.getProtectedValue());
                    parameter.setValue(parameterValue);
                }
                catch (IOException e) {
                    this.logWarning(this.iu.getFormattedString("WorkflowExecution.Exception.CannotDecryptExecutionParameter", (Object)parameter.getFriendlyNameAndName()));
                    LOGGER.error("Cannot decrypt execution custom parameter " + parameter.getFriendlyNameAndName(), (Throwable)e);
                }
            }
            this.executionContext.getExecutionCustomParameters().put((Parameter)parameter);
        }
        for (StaticParameter parameter : workflowExecutionState.getExecutionBuiltInparameters()) {
            if (parameter.isEffectiveTypeMaskedOrProtected()) {
                if (parameter.getProtectedValue().equals(Parameter.MASKED_VALUE)) continue;
                try {
                    parameterValue = encryptor.decrypt(parameter.getProtectedValue());
                    parameter.setValue(parameterValue);
                }
                catch (IOException e) {
                    this.logWarning(this.iu.getFormattedString("WorkflowExecution.Exception.CannotDecryptBuiltInParameter", (Object)parameter.getFriendlyNameAndName()));
                    LOGGER.error("Cannot decrypt execution built-in parameter " + parameter.getFriendlyNameAndName(), (Throwable)e);
                }
            }
            this.executionContext.getExecutionBuiltInParameters().put((Parameter)parameter);
        }
        for (Operation operation : this.workflow.getOperations()) {
            if (!(operation instanceof ConfigureParametersOperation)) continue;
            ConfigureParametersOperation configureParametersOperation = (ConfigureParametersOperation)operation;
            for (StaticParameter parameter : configureParametersOperation.staticParameters) {
                try {
                    if (parameter.getProtectedValue().equals(Parameter.MASKED_VALUE) || !parameter.isEffectiveTypeMaskedOrProtected()) continue;
                    parameter.setValue(encryptor.decrypt(parameter.getProtectedValue()));
                }
                catch (IOException e) {
                    this.logWarning(this.iu.getFormattedString("WorkflowExecution.Exception.CannotDecryptParameter", (Object)parameter.getFriendlyNameAndName()));
                    LOGGER.error("Cannot decrypt configuration parameter " + parameter.getFriendlyNameAndName(), (Throwable)e);
                }
            }
            for (StaticParameter parameter : configureParametersOperation.userParameters) {
                try {
                    if (parameter.getProtectedValue().equals(Parameter.MASKED_VALUE) || !parameter.isEffectiveTypeMaskedOrProtected()) continue;
                    parameter.setValue(encryptor.decrypt(parameter.getProtectedValue()));
                }
                catch (IOException e) {
                    this.logWarning(this.iu.getFormattedString("WorkflowExecution.Exception.CannotDecryptParameter", (Object)parameter.getFriendlyNameAndName()));
                    LOGGER.error("Cannot decrypt configuration parameter " + parameter.getFriendlyNameAndName(), (Throwable)e);
                }
            }
            String originalState = configureParametersOperation.getOriginalState();
            if (originalState == null) continue;
            try {
                ConfigureParametersOperation originalStateOperation = (ConfigureParametersOperation)SerializerFactory.getSerializer().deserialize(originalState);
                for (StaticParameter parameter : originalStateOperation.staticParameters) {
                    try {
                        if (parameter.getProtectedValue().equals(Parameter.MASKED_VALUE) || !parameter.isEffectiveTypeMaskedOrProtected()) continue;
                        parameter.setValue(encryptor.decrypt(parameter.getProtectedValue()));
                    }
                    catch (IOException e) {
                        this.logWarning(this.iu.getFormattedString("WorkflowExecution.Exception.CannotDecryptSavedStateParameter", (Object)parameter.getFriendlyNameAndName()));
                        LOGGER.error("Cannot decrypt original parameter " + parameter.getFriendlyNameAndName(), (Throwable)e);
                    }
                }
                for (StaticParameter parameter : originalStateOperation.userParameters) {
                    try {
                        if (parameter.getProtectedValue().equals(Parameter.MASKED_VALUE) || !parameter.isEffectiveTypeMaskedOrProtected()) continue;
                        parameter.setValue(encryptor.decrypt(parameter.getProtectedValue()));
                    }
                    catch (IOException e) {
                        this.logWarning(this.iu.getFormattedString("WorkflowExecution.Exception.CannotDecryptSavedStateParameter", (Object)parameter.getFriendlyNameAndName()));
                        LOGGER.error("Cannot decrypt original parameter " + parameter.getFriendlyNameAndName(), (Throwable)e);
                    }
                }
                originalState = SerializerFactory.getSerializer().serialize(originalStateOperation);
                operation.setOriginalState(originalState);
            }
            catch (IOException e) {
                LOGGER.error("Cannot serialize original state", (Throwable)e);
            }
        }
    }

    private void readWorkflowSavedStateFromXml(String xml) throws IOException {
        WorkflowExecutionState workflowExecutionState = (WorkflowExecutionState)SerializerFactory.getSerializer().deserialize(xml);
        this.startEpoch = workflowExecutionState.getStartEpoch();
        this.workflowFilename = null;
        this.workflow = new Workflow(this.workflowFilename);
        this.workflow.setName(workflowExecutionState.getWorkflowName());
        this.executionContext.workflowParallelSettings = workflowExecutionState.workflowParallelSettings;
        this.executionContext.workflowLocalWorkersCount = workflowExecutionState.workflowLocalWorkersCount;
        this.executionContext.workflowLocalWorkersMemoryMb = workflowExecutionState.workflowLocalWorkersMemoryMb;
        this.executionContext.workflowLocalWorkersTempFolder = workflowExecutionState.workflowLocalWorkersTempFolder;
        this.executionContext.workflowBrokerWorkersCount = workflowExecutionState.workflowBrokerWorkersCount;
        this.executionContext.workflowBrokerIp = workflowExecutionState.workflowBrokerIp;
        this.executionContext.workflowBrokerPort = workflowExecutionState.workflowBrokerPort;
        for (OperationExecutionState operationExecutionState : workflowExecutionState.getOperationExecutionStates()) {
            Operation operation = operationExecutionState.getOperation();
            operation.setExecutionContext(this.executionContext);
            operation.setErrorMessage(operationExecutionState.getErrorMessage());
            operation.setOriginalState(operationExecutionState.getOriginalState());
            for (String warningMessage : operationExecutionState.getWarningsMessages()) {
                operation.addWarning(warningMessage);
            }
            operation.executionState = operationExecutionState.getExecutionState();
            if (operationExecutionState.getStartDateTime() != null) {
                operation.startDateTime = new DateTime((Object)operationExecutionState.getStartDateTime());
            }
            if (operationExecutionState.getFinishedDateTime() != null) {
                operation.finishedDateTime = new DateTime((Object)operationExecutionState.getFinishedDateTime());
            }
            this.workflow.getOperations().add(operation);
        }
        this.logStringBuilder = new StringBuilder(workflowExecutionState.getExecutionLog());
        this.workflowExecutionPosition = workflowExecutionState.getExecutionPosition();
        this.decryptSavedStateParameters(workflowExecutionState);
        this.caseOpenedBeforePausing = workflowExecutionState.getCaseOpened();
        this.caseFoldersBeforePausing = workflowExecutionState.getCaseFolders();
    }

    public void saveToTemporaryFile(String name) throws IOException {
        File tempWorkflowFile = FileUtils.createTempFile((String)(name + "-"), (String)".rfn");
        this.workflow.saveToFile(tempWorkflowFile.getAbsolutePath(), WorkflowFileFormat.XML);
        tempWorkflowFile.deleteOnExit();
        this.workflowFilename = tempWorkflowFile.getAbsolutePath();
    }

    private void readWorkflowFromFile(String filename) throws IOException {
        LOGGER.info("Opening workflow from " + filename);
        File file = new File(filename);
        Workflow openedWorkflow = Workflow.fromFile(filename);
        openedWorkflow.setName(file.getName().replace(".rfn", ""));
        this.workflowFilename = file.getAbsolutePath();
        this.workflow = openedWorkflow;
    }

    public void prepareForRerun() {
        this.logStringBuilder = new StringBuilder();
        this.logFiles = new HashSet<String>();
        this.caseFolders = new HashSet<String>();
        this.executionState = ExecutionState.NOT_STARTED;
        this.executionContext.workflowExecution = this;
        this.operationsExecutionCount = 0;
    }

    public void prepareForResume() {
        this.logFiles = new HashSet<String>();
        this.caseFolders = new HashSet<String>();
    }

    public void trackWorkBeingPerformedInCase(String caseFolder) {
        if (!this.caseFolders.contains(caseFolder)) {
            this.caseFolders.add(caseFolder);
            if (this.logFileNameTemplate != null) {
                this.logFileNameTemplate = FormattingUtils.sanitizeFilename((String)this.logFileNameTemplate);
                Path baseLogsFolder = Paths.get(caseFolder, new String[0]).resolve("Stores").resolve("Workflow");
                try {
                    Path logPath = FileUtils.safeResolve((Path)baseLogsFolder, (String)this.logFileNameTemplate);
                    this.addNewLogFile(logPath.toString());
                }
                catch (FileTraversalException e) {
                    LOGGER.error("Cannot write workflow log file", (Throwable)e);
                }
            }
        }
    }

    public void removeLogFileInFolder(String folder) {
        TreeSet<String> filesToRemove = new TreeSet<String>();
        for (String logFile : this.logFiles) {
            if (!logFile.startsWith(folder)) continue;
            filesToRemove.add(logFile);
        }
        this.logFiles.removeAll(filesToRemove);
    }

    private void addNewLogFile(String logFile) {
        try {
            LOGGER.info("Logging progress to " + logFile);
            Path logFilePath = Paths.get(logFile, new String[0]);
            Path logFileParent = logFilePath.getParent();
            if (!Files.exists(logFileParent, new LinkOption[0])) {
                Files.createDirectories(logFileParent, new FileAttribute[0]);
            }
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(logFile, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
                bufferedWriter.write(this.logStringBuilder.toString());
            }
            this.logFiles.add(logFile);
        }
        catch (IOException e) {
            LOGGER.warn("Error writing cached log to log file.", (Throwable)e);
        }
    }

    private void logNewLine() {
        this.log("");
    }

    public void log(String s) {
        this.log(s, LogLevel.EXECUTION);
    }

    public void logInfo(String s) {
        this.log(s, LogLevel.INFO);
    }

    public void addLink(LinkLog linkLog) {
        this.log(SerializationUtils.toJson((Object)linkLog), LogLevel.LINK);
    }

    private void logWarning(String s) {
        this.log(s, LogLevel.WARNING);
    }

    private void logError(String s) {
        this.encounteredErrors = true;
        this.log(s, LogLevel.ERROR);
    }

    public void log(String message, LogLevel logLevel) {
        this.log(message, logLevel, true);
    }

    public void log(String message, LogLevel logLevel, boolean triggerWorkflowErrorOnErrorLog) {
        if (message == null) {
            LOGGER.error("Received null error message");
            return;
        }
        if (message.length() > 0) {
            LOGGER.info(message);
        }
        if ((LogLevel.WARNING == logLevel || LogLevel.TRANSIENT_WARNING_TRIGGERED == logLevel) && this.workflowExecutionPosition >= 0 && this.workflowExecutionPosition < this.workflow.getOperations().size()) {
            Operation operation = this.workflow.getOperations().get(this.workflowExecutionPosition);
            this.fireOnOperationWarning(operation, message);
        }
        this.fireWorkflowExecutionLog(message, logLevel);
        for (String logFile : this.logFiles) {
            if (logFile == null) continue;
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(logFile, new String[0]), StandardOpenOption.APPEND), StandardCharsets.UTF_8));){
                if (logLevel == LogLevel.WARNING || logLevel == LogLevel.TRANSIENT_WARNING_TRIGGERED) {
                    bufferedWriter.write(this.iu.getString("WorkflowExecution.Output.Warning"));
                }
                if (logLevel == LogLevel.TRANSIENT_WARNING_RESOLVED) {
                    bufferedWriter.write(this.iu.getString("WorkflowExecution.Output.Resolved"));
                }
                if (logLevel == LogLevel.ERROR || logLevel == LogLevel.NON_CRITICAL_ERROR) {
                    bufferedWriter.write(this.iu.getString("WorkflowExecution.Output.Error"));
                }
                if (logLevel == LogLevel.SOFT_ERROR) {
                    bufferedWriter.write(this.iu.getString("WorkflowExecution.Output.SoftError"));
                }
                if (logLevel == LogLevel.LINK) {
                    try {
                        LinkLog linkLog = (LinkLog)SerializationUtils.fromJson((String)message, LinkLog.class);
                        bufferedWriter.write(linkLog.toString());
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot deserialize link log", (Throwable)e);
                    }
                } else {
                    bufferedWriter.write(message.replace("\n", "\r\n").replace("\r\r\n", "\r\n"));
                }
                bufferedWriter.write("\r\n");
            }
            catch (IOException e) {
                LOGGER.warn("Error writing message to log file.", (Throwable)e);
            }
        }
        if (logLevel == LogLevel.WARNING || logLevel == LogLevel.TRANSIENT_WARNING_TRIGGERED) {
            this.logStringBuilder.append(this.iu.getString("WorkflowExecution.Output.Warning"));
        }
        if (logLevel == LogLevel.TRANSIENT_WARNING_RESOLVED) {
            this.logStringBuilder.append(this.iu.getString("WorkflowExecution.Output.Resolved"));
        }
        if (logLevel == LogLevel.ERROR || logLevel == LogLevel.NON_CRITICAL_ERROR) {
            this.logStringBuilder.append(this.iu.getString("WorkflowExecution.Output.Error"));
        }
        if (logLevel == LogLevel.SOFT_ERROR) {
            this.logStringBuilder.append(this.iu.getString("WorkflowExecution.Output.SoftError"));
        }
        if (logLevel == LogLevel.LINK) {
            try {
                LinkLog linkLog = (LinkLog)SerializationUtils.fromJson((String)message, LinkLog.class);
                this.logStringBuilder.append(linkLog.toString());
            }
            catch (Exception e) {
                LOGGER.error("Cannot deserialize link log", (Throwable)e);
            }
        } else {
            this.logStringBuilder.append(message.replace("\n", "\r\n").replace("\r\r\n", "\r\n"));
        }
        this.logStringBuilder.append("\r\n");
        if (triggerWorkflowErrorOnErrorLog && logLevel == LogLevel.ERROR) {
            Operation currentOperation = null;
            if (this.workflow != null && this.workflow.getOperations() != null && this.workflow.getOperations().size() > this.workflowExecutionPosition && this.workflowExecutionPosition >= 0) {
                currentOperation = this.workflow.getOperations().get(this.workflowExecutionPosition);
            }
            this.handleWorkflowExecutionException(new Exception(message), currentOperation, false);
        }
    }

    public boolean closeCaseOpenedByWorkflow() {
        if (this.executionContext.nuixCase != null && this.executionContext.nuixCase != this.executionContext.workstationCase) {
            try {
                LOGGER.info("Closing Nuix case");
                this.executionContext.closeNuixCase();
                this.executionContext.nuixCase = null;
                return true;
            }
            catch (Throwable e) {
                LOGGER.warn("Cannot close Nuix case", e);
            }
        }
        this.executionContext.nuixCase = null;
        this.executionContext.workflowExecution.checkMemoryUsage("Closed case");
        return false;
    }

    public String getExecutionLog() {
        return this.logStringBuilder.toString();
    }

    public StringBuilder getLogStringBuilder() {
        return this.logStringBuilder;
    }

    public void runWorkflow() {
        this.runWorkflow(false);
    }

    public List<String> getUnattendedSubmitPrerequisites() {
        ArrayList<String> result = new ArrayList<String>();
        this.log(this.iu.getString("WorkflowExecution.Log.VerifyingPrerequisites"));
        boolean prerequisitesSatisfied = true;
        boolean haveCase = false;
        long operationId = 1L;
        for (Operation operation : this.workflow.getOperations()) {
            if (operation.disabled) {
                LOGGER.info("Skipping prerequisites check for disabled operation " + operationId + " " + operation.getOperationName());
                ++operationId;
                continue;
            }
            if (operation instanceof UseCaseOperation) {
                haveCase = true;
            }
            operation.setExecutionContext(this.executionContext);
            Operation.PrerequisitesActivity prerequisitesActivity = Operation.PrerequisitesActivity.SUBMIT_UNATTENDED;
            List<String> prerequisites = operation.getPrerequisites(prerequisitesActivity);
            if (prerequisites != null && prerequisites.size() > 0) {
                prerequisitesSatisfied = false;
                for (String prerequisite : prerequisites) {
                    String unsatisfiedPrerequisite = this.iu.getFormattedString("WorkflowExecution.Log.UnsatisfiedPrerequisite", new Object[]{operationId, operation.getOperationName(), prerequisite});
                    result.add(unsatisfiedPrerequisite);
                    this.log(unsatisfiedPrerequisite);
                }
            }
            if (operation.getRequiresCase() && !haveCase) {
                String unsatisfiedPrerequisite = this.iu.getFormattedString("WorkflowExecution.Log.UseCaseMustBePresent", new Object[]{operationId, operation.getOperationName()});
                result.add(unsatisfiedPrerequisite);
                this.log(unsatisfiedPrerequisite);
                haveCase = true;
            }
            ++operationId;
        }
        return result;
    }

    public void runWorkflow(boolean unattended) {
        this.runWorkflow(unattended, false);
    }

    public void updateDisabledOperation(int id, boolean disabled) throws Exception {
        Operation operation = this.workflow.getOperations().get(id);
        if (this.workflow.getExecutionMode() == ExecutionMode.AUTOMATE_NATIVE && !disabled && operation.getRequiredFeatures().contains((Object)Feature.NUIX)) {
            throw new Exception(this.iu.getFormattedString("ScriptOperation.Error.UnableToEnableOperation", (Object)operation.getOperationName()));
        }
        if (operation.getClass().getName().endsWith("Implementation")) {
            operation.disabled = disabled;
        } else {
            try {
                XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
                xstream.ignoreUnknownElements();
                xstream.allowTypesByWildcard(new String[]{"com.nuix.automate.**"});
                String xmlText = xstream.toXML((Object)operation);
                xmlText = xmlText.replace(operation.getClass().getName(), operation.getClass().getName() + "Implementation");
                Object operationImplementation = xstream.fromXML(xmlText);
                Operation implementation = (Operation)operationImplementation;
                implementation.disabled = disabled;
                this.workflow.getOperations().set(id, implementation);
            }
            catch (ConversionException | CannotResolveClassException e) {
                this.logWarning("Cannot cast operation #" + (id + 1) + " " + operation.getOperationName() + " to implementation, " + e.getClass().getName());
                LOGGER.error("Cannot cast to implementation", e);
            }
        }
    }

    private void testSchedulerConnectivity(WorkflowExecutionAutomateRestClient restAutomate) throws IOException {
        Response response = restAutomate.get("/api/v1/services/runId");
        response.raise_for_status();
        response = restAutomate.get("/api/v1/services");
        response.raise_for_status();
        try {
            Collection services = (Collection)response.json();
            if (!services.contains(SchedulerComponent.SCHEDULER.name())) {
                throw new IOException("Server does not have the Scheduler role");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void convertOperationsToImplementations() {
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
        xstream.ignoreUnknownElements();
        xstream.allowTypesByWildcard(new String[]{"com.nuix.automate.**"});
        for (int i = 0; i < this.workflow.getOperations().size(); ++i) {
            Operation operation = this.workflow.getOperations().get(i);
            if (operation.disabled) continue;
            try {
                String xmlText = xstream.toXML((Object)operation);
                if (operation.getClass().getName().endsWith("Implementation")) continue;
                xmlText = xmlText.replace(operation.getClass().getName(), operation.getClass().getName() + "Implementation");
                Object operationImplementation = xstream.fromXML(xmlText);
                Operation implementation = (Operation)operationImplementation;
                this.workflow.getOperations().set(i, implementation);
                continue;
            }
            catch (ConversionException | CannotResolveClassException e) {
                this.logWarning("Cannot cast operation #" + (i + 1) + " " + operation.getOperationName() + " to implementation, " + e.getClass().getName());
                LOGGER.error("Cannot cast to implementation", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWorkflow(boolean unattended, boolean quickRun) {
        this.convertOperationsToImplementations();
        this.encounteredErrors = false;
        if (this.scriptWorkflowExecutionListener != null) {
            this.removeWorkflowExecutionListener(this.scriptWorkflowExecutionListener);
            this.scriptWorkflowExecutionListener = null;
        }
        this.lowJvmMemory = false;
        this.lowSystemMemory = false;
        if (this.executionState == ExecutionState.STOPPED || this.executionState == ExecutionState.FINISHED || this.executionState == ExecutionState.ERROR) {
            LOGGER.error("Asked to run workflow when workflow is in state " + String.valueOf(this.executionState));
            return;
        }
        this.activeEvents.incrementAndGet();
        try {
            block67: {
                this.executionState = ExecutionState.RUNNING;
                this.startEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                boolean bl = this.isResuming = this.workflowExecutionPosition > 0;
                if (this.isResuming) {
                    Operation currentOperation = this.workflow.getOperations().get(this.workflowExecutionPosition);
                    if (currentOperation.executionState == ExecutionState.PAUSED) {
                        currentOperation.executionState = ExecutionState.NOT_STARTED;
                        --this.workflowExecutionPosition;
                    }
                    this.prepareForResume();
                    this.logNewLine();
                    this.log(this.iu.getString("WorkflowExecution.Log.VerifyingResumePrerequisites"));
                } else {
                    this.log(this.iu.getString("WorkflowExecution.Log.VerifyingPrerequisites"));
                }
                StringBuilder workflowUnsatisfiedPrerequisiteHtml = new StringBuilder();
                workflowUnsatisfiedPrerequisiteHtml.append("<h2>" + this.iu.getString("WorkflowExecution.Log.UnsatisfiedPrerequisites") + "</h2><hr/>");
                boolean prerequisitesSatisfied = true;
                int operationId = 1;
                for (Operation operation : this.workflow.getOperations()) {
                    List<String> prerequisites;
                    OcrOperation ocrOperation;
                    Object ocrErrorMessage;
                    operation.setExecutionContext(this.executionContext);
                    if (operation.disabled) {
                        LOGGER.info("Skipping prerequisites check for disabled operation " + operationId + " " + operation.getOperationName());
                        ++operationId;
                        continue;
                    }
                    if (operationId <= this.workflowExecutionPosition + 1) {
                        LOGGER.info("Skipping prerequisites check for previously executed operation " + operationId + " " + operation.getOperationName());
                        ++operationId;
                        continue;
                    }
                    Operation.PrerequisitesActivity prerequisitesActivity = unattended ? Operation.PrerequisitesActivity.RUN_UNATTENDED : Operation.PrerequisitesActivity.RUN_INTERACTIVE;
                    if (operation instanceof OcrOperation && !operation.disabled && (ocrErrorMessage = (ocrOperation = (OcrOperation)operation).getNuixOcrErrorMessage()) != null) {
                        NativeOcrItemsOperationImplementation nativeOcrItemsOperation = new NativeOcrItemsOperationImplementation();
                        nativeOcrItemsOperation.scope = ocrOperation.scope;
                        try (TesseractOcrUtils ocrUtils = new TesseractOcrUtils(this.executionContext, nativeOcrItemsOperation, Paths.get(System.getProperty("java.io.tmpdir"), "ocrtemp"));){
                            this.workflow.getOperations().set(operationId - 1, nativeOcrItemsOperation);
                            operation = nativeOcrItemsOperation;
                            operation.setExecutionContext(this.executionContext);
                            operation.addWarning(this.iu.getFormattedString("NativeOcrItemsOperation.Log.MissingNuixOcr", ocrErrorMessage));
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot initialize Native OCR engine", (Throwable)e);
                        }
                    }
                    if ((prerequisites = operation.getPrerequisites(prerequisitesActivity)) != null && prerequisites.size() > 0) {
                        if (prerequisitesSatisfied) {
                            this.logError(this.iu.getString("WorkflowExecution.Error.PrerequisitesNotSatisfied"));
                            prerequisitesSatisfied = false;
                        }
                        ocrErrorMessage = prerequisites.iterator();
                        while (ocrErrorMessage.hasNext()) {
                            String prerequisite = (String)ocrErrorMessage.next();
                            workflowUnsatisfiedPrerequisiteHtml.append("<div><b>#" + operationId + " " + operation.getOperationName() + "</b>: " + prerequisite + "</div></br></br>");
                        }
                        operation.setErrorMessage(String.join((CharSequence)", ", prerequisites));
                        this.logError(operation.getOperationName() + ": " + String.join((CharSequence)" ", prerequisites));
                    }
                    ++operationId;
                }
                if (!prerequisitesSatisfied) {
                    this.logNewLine();
                    this.fireWorkflowExecutionPrerequisitesError(this.iu.getString("WorkflowExecution.Error.CannotRunWorkflow"), this.iu.getString("WorkflowExecution.Error.PrerequisitesNotSatisfied"), workflowUnsatisfiedPrerequisiteHtml.toString(), null);
                    return;
                }
                this.log(this.iu.getString("WorkflowExecution.Log.PrerequisitesSatisfied"));
                WorkflowExecutionAutomateRestClient restRampiva = new WorkflowExecutionAutomateRestClient(this.executionContext.workflowExecution, null);
                String schedulerUrl = restRampiva.getUrl();
                try {
                    this.testSchedulerConnectivity(restRampiva);
                    this.log(this.iu.getFormattedString("WorkflowExecution.Log.SchedulerConnectivitySuccess", (Object)schedulerUrl));
                    System.setProperty("workflow.scheduler.connected", "true");
                }
                catch (Exception e) {
                    LOGGER.error("Cannot connect to Scheduler", (Throwable)e);
                    if (schedulerUrl == null) break block67;
                    this.logWarning(this.iu.getFormattedString("WorkflowExecution.Log.SchedulerConnectivityFailed", new Object[]{schedulerUrl, FormattingUtils.getExceptionPrintableMessage((Exception)e)}));
                    System.setProperty("workflow.scheduler.connected", "false");
                }
            }
            this.executionTime = FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            this.logFileNameTemplate = this.executionTime + "-" + this.workflow.getName() + ".log";
            this.operationStatusRefreshLock = new Semaphore(1);
            this.logNewLine();
            if (this.isResuming) {
                this.log(this.iu.getFormattedString("WorkflowExecution.Log.ResumingWorkflowExecution", new Object[]{this.workflow.getName(), FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC))}));
            } else {
                this.log(this.iu.getFormattedString("WorkflowExecution.Log.StartingWorkflowExecution", new Object[]{this.workflow.getName(), FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC))}));
            }
            if (this.isResuming) {
                if (this.caseOpenedBeforePausing) {
                    String timeZoneId;
                    block68: {
                        String lastCaseFolder = this.executionContext.getExecutionBuiltInParameters().get("{last_case_folder}").getProtectedValue();
                        LOGGER.info("Opening previous case from folder: " + lastCaseFolder);
                        String lastCaseGuid = this.executionContext.getExecutionBuiltInParameters().get("{last_case_guid}").getProtectedValue();
                        LOGGER.info("Expected GUID: " + lastCaseGuid);
                        CaseFactory caseFactory = this.executionContext.nuixUtilities.getCaseFactory();
                        File directory = new File(lastCaseFolder);
                        this.executionContext.nuixCase = caseFactory.open(directory);
                        timeZoneId = null;
                        String timezoneIdParameter = "{case_timezone_id}";
                        String evaluatedTimezoneIdParameter = this.executionContext.evalParameters(timezoneIdParameter, null);
                        if (!timezoneIdParameter.equals(evaluatedTimezoneIdParameter)) {
                            if (evaluatedTimezoneIdParameter.length() > 0) {
                                try {
                                    DateTimeZone dateTimeZone = DateTimeZone.forID((String)evaluatedTimezoneIdParameter);
                                    timeZoneId = dateTimeZone.getID();
                                    LOGGER.info("Parsed specified timezone " + FormattingUtils.timeZoneToDisplayName((DateTimeZone)dateTimeZone) + " from ID " + timezoneIdParameter);
                                }
                                catch (Exception e) {
                                    LOGGER.error("Cannot set timezone " + evaluatedTimezoneIdParameter, (Throwable)e);
                                }
                            } else {
                                timeZoneId = "";
                            }
                        }
                        String caseGuid = this.executionContext.nuixCase.getGuid();
                        LOGGER.info("Opened GUID: " + caseGuid);
                        if (caseGuid.equals(lastCaseGuid)) break block68;
                        this.executionContext.closeNuixCase();
                        this.executionContext.nuixCase = null;
                        this.logNewLine();
                        this.logError(this.iu.getFormattedString("WorkflowExecution.Error.CannotOpenPreviousNuixCase", new Object[]{lastCaseFolder, lastCaseGuid, caseGuid}));
                        this.fireWorkflowExecutionPrerequisitesError(this.iu.getString("WorkflowExecution.Error.CannotResumeWorkflow"), this.iu.getString("WorkflowExecution.Error.CannotOpenPreviousNuixCaseMessage"), this.iu.getFormattedString("WorkflowExecution.Error.DifferentCaseDetected", new Object[]{lastCaseFolder, lastCaseGuid, caseGuid}), null);
                        return;
                    }
                    try {
                        this.trackWorkBeingPerformedInCase(this.executionContext.nuixCase.getLocation().getAbsolutePath());
                        this.log(this.iu.getFormattedString("WorkflowExecution.Log.CaseWasOpened", (Object)this.executionContext.nuixCase.getName()));
                        if (timeZoneId != null && timeZoneId.length() > 0) {
                            this.executionContext.nuixCase.setInvestigationTimeZone(timeZoneId);
                            this.log(this.iu.getFormattedString("UseCaseOperation.Log.Timezone", (Object)FormattingUtils.timeZoneToDisplayName((DateTimeZone)DateTimeZone.forID((String)timeZoneId))));
                        }
                    }
                    catch (ParameterException | IOException e) {
                        LOGGER.info("Cannot open case", e);
                        this.logNewLine();
                        this.logError(this.iu.getFormattedString("WorkflowExecution.Error.CannotOpenNuixCasePreviouslyUsed", (Object)e.getLocalizedMessage()));
                        this.fireWorkflowExecutionPrerequisitesError(this.iu.getString("WorkflowExecution.Error.CannotResumeWorkflow"), this.iu.getString("WorkflowExecution.Error.CannotOpenPreviousNuixCaseMessage"), e.getLocalizedMessage(), (Exception)e);
                        this.activeEvents.decrementAndGet();
                        return;
                    }
                }
                if (this.caseFoldersBeforePausing != null) {
                    for (String caseFolder : this.caseFoldersBeforePausing) {
                        this.trackWorkBeingPerformedInCase(caseFolder);
                    }
                }
            }
            try {
                this.log(this.iu.getFormattedString("WorkflowExecution.Log.ServerAddress", (Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (UnknownHostException e) {
                LOGGER.warn("Cannot get server name.", (Throwable)e);
            }
            this.log(this.iu.getFormattedString("WorkflowExecution.Log.AutomateVersion", (Object)this.executionContext.getVersion()));
            if (!this.executionContext.nuixVersion.isNull()) {
                this.log(this.iu.getFormattedString("WorkflowExecution.Log.NuixVersion", (Object)this.executionContext.nuixVersion));
            }
            if (this.workflowFilename != null) {
                this.log(this.iu.getFormattedString("WorkflowExecution.Log.WorkflowLocation", (Object)this.workflowFilename));
            }
            ArrayList<String> sourceParameterErrors = new ArrayList<String>();
            for (Parameter parameter : this.executionContext.getSessionConfigParameters().getParameters()) {
                String translationKey = "Job";
                if (parameter.getSource() != null) {
                    switch (parameter.getSource()) {
                        case JOB_SUBMISSION: {
                            translationKey = "Job";
                            break;
                        }
                        case FILE: {
                            translationKey = "File";
                            break;
                        }
                        case EXECUTION_PROFILE: {
                            translationKey = "ExecutionProfile";
                            break;
                        }
                        case DEFAULT_THIRD_PARTY_SERVICE: {
                            translationKey = "DefaultThirdPartyService";
                        }
                    }
                }
                try {
                    if (parameter instanceof SourceParameter) {
                        List messages = ((SourceParameter)parameter).getMessages();
                        SourceParameterSourceType type = ((SourceParameter)parameter).getSourceType();
                        if (this.executionContext.checkIfBuiltInParameter(parameter.getName())) {
                            sourceParameterErrors.add(this.iu.getFormattedString("WorkflowExecution.Error.SourceParameterError", new Object[]{parameter.getFriendlyNameAndName(), type.toString()}));
                            continue;
                        }
                        if (messages != null) {
                            for (String message : messages) {
                                this.log(message);
                            }
                        }
                        this.log(this.iu.getFormattedString("WorkflowExecution.Log.SourceParameter", new Object[]{type.toString(), parameter.getFriendlyNameAndName(), parameter.getMaskedValue()}));
                        continue;
                    }
                    if (parameter.getUserDisplayableValue() != null) {
                        this.log(this.iu.getFormattedString("WorkflowExecution.Log." + translationKey + "Parameter", (Object)parameter.getFriendlyNameAndName()) + ": " + parameter.getUserDisplayableValue() + " (" + parameter.getMaskedValue() + ")");
                        continue;
                    }
                    if (ParameterType.FILE_CONTENTS.equals((Object)parameter.getParameterType())) {
                        String[] splits = parameter.getMaskedValue().split(":");
                        if (splits.length != 2) {
                            throw new ParameterException("Invalid contents");
                        }
                        String filename = splits[0];
                        long dataSize = splits[1].length();
                        this.log(this.iu.getFormattedString("WorkflowExecution.Log." + translationKey + "Parameter", (Object)parameter.getFriendlyNameAndName()) + ": " + filename + " (" + FormattingUtils.sizeToDisplaySize((long)dataSize) + ")");
                        continue;
                    }
                    this.log(this.iu.getFormattedString("WorkflowExecution.Log." + translationKey + "Parameter", (Object)parameter.getFriendlyNameAndName()) + ": " + parameter.getMaskedValue());
                }
                catch (ParameterException e) {
                    this.logError(this.iu.getFormattedString("WorkflowExecution.Log." + translationKey + "Parameter", new Object[]{parameter.getFriendlyNameAndName(), e.getLocalizedMessage()}));
                }
            }
            if (sourceParameterErrors.size() > 0) {
                this.logError(String.join((CharSequence)", ", sourceParameterErrors));
                return;
            }
            this.timerTask = new TimerTask((TimerTask.Callback)this);
            this.workflowExecutionTimer = new Timer();
            this.fireWorkflowStatusChangedEvent(this.executionState);
            this.fireWorkflowExecutionProgressEvent(0);
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
        this.workflowExecutionTimer.scheduleAtFixedRate((java.util.TimerTask)this.timerTask, 0L, (long)this.refreshMs);
    }

    private void setWorkflowExecutionPosition(int workflowExecutionPosition) {
        this.workflowExecutionPosition = workflowExecutionPosition;
    }

    private void handleWorkflowExecutionException(Throwable e, Operation currentOperation) {
        this.handleWorkflowExecutionException(e, currentOperation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWorkflowExecutionException(Throwable e, Operation currentOperation, boolean logError) {
        this.activeEvents.incrementAndGet();
        boolean currentOperationSoftFail = currentOperation != null && Boolean.TRUE.equals(currentOperation.softFail);
        boolean currentOperationSuppressWarnings = currentOperation != null && currentOperation.areWarningsSuppressed();
        try {
            if (!currentOperationSoftFail) {
                this.executionState = ExecutionState.ERROR;
            }
            if (currentOperation != null) {
                if (e != null) {
                    LOGGER.warn("Handling workflow exception for operation " + currentOperation.getOperationName(), e);
                } else {
                    LOGGER.warn("Handling workflow error for operation " + currentOperation.getOperationName());
                }
            } else if (e != null) {
                LOGGER.warn("Handling workflow exception", e);
            } else {
                LOGGER.warn("Handling workflow error");
            }
            String operationErrorMessage = null;
            if (currentOperation != null) {
                operationErrorMessage = currentOperation.getErrorMessage();
            }
            if (!(e == null || currentOperation != null && e instanceof UserTriggeredScriptErrorException)) {
                operationErrorMessage = ExceptionUtils.getExceptionPrintableMessage((Throwable)e);
            }
            if (operationErrorMessage == null) {
                operationErrorMessage = "Unknown error";
            }
            if (logError) {
                if (currentOperationSoftFail) {
                    if (currentOperationSuppressWarnings) {
                        operationErrorMessage = this.iu.getFormattedString("WorkflowExecution.Error.SuppressedError", (Object)operationErrorMessage);
                        this.log(operationErrorMessage, LogLevel.EXECUTION, false);
                    } else {
                        this.log(operationErrorMessage, LogLevel.SOFT_ERROR, false);
                    }
                } else {
                    this.log(operationErrorMessage, LogLevel.NON_CRITICAL_ERROR, false);
                }
            }
            if (currentOperation != null) {
                String workflowErrorMessage = this.iu.getFormattedString("WorkflowExecution.Error.ExecutionHalted", (Object)this.workflow.getOperations().get(this.workflowExecutionPosition).toString());
                currentOperation.setErrorMessage(operationErrorMessage, currentOperationSoftFail);
                if (!currentOperationSoftFail) {
                    this.log(workflowErrorMessage, LogLevel.ERROR, false);
                }
                currentOperation.setFinishedDateTime();
            }
            if (!currentOperationSoftFail) {
                if (this.workflowExecutionTimer != null) {
                    this.workflowExecutionTimer.cancel();
                }
                this.closeCaseOpenedByWorkflow();
            }
            this.fireWorkflowStatusChangedEvent(this.executionState);
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    public String saveState(boolean encryptParameters) {
        try {
            WorkflowExecutionState workflowExecutionState = new WorkflowExecutionState(this, encryptParameters);
            String serialization = SerializerFactory.getSerializer().serialize(workflowExecutionState);
            if (encryptParameters) {
                this.decryptSavedStateParameters(workflowExecutionState);
            }
            return serialization;
        }
        catch (IOException e) {
            LOGGER.error("Cannot save state", (Throwable)e);
            return null;
        }
    }

    public String saveState() {
        try {
            WorkflowExecutionState workflowExecutionState = new WorkflowExecutionState(this);
            String serialization = SerializerFactory.getSerializer().serialize(workflowExecutionState);
            this.decryptSavedStateParameters(workflowExecutionState);
            return serialization;
        }
        catch (IOException e) {
            LOGGER.error("Cannot save state", (Throwable)e);
            return null;
        }
    }

    public void pauseWorkflow() {
        block10: {
            try {
                LOGGER.info("Pausing workflow, waiting for lock");
                this.operationStatusRefreshLock.acquire();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Thread interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
            try {
                if (this.executionState == ExecutionState.NOT_STARTED || this.executionState == ExecutionState.PENDING) {
                    this.triggerExecutionPaused();
                    break block10;
                }
                if (this.executionState == ExecutionState.RUNNING) {
                    LOGGER.info("Setting Paused state");
                    this.activeEvents.incrementAndGet();
                    try {
                        this.executionState = ExecutionState.PAUSING;
                        int pauseOperation = this.workflowExecutionPosition;
                        if (pauseOperation < 0) {
                            pauseOperation = 0;
                        }
                        this.workflow.getOperations().get(pauseOperation).pause();
                        this.fireWorkflowStatusChangedEvent(this.executionState);
                        break block10;
                    }
                    finally {
                        this.activeEvents.decrementAndGet();
                    }
                }
                LOGGER.error("Cannot pause workflow because it is not running");
            }
            catch (Exception e) {
                LOGGER.error("Error while pausing workflow", (Throwable)e);
            }
        }
        this.operationStatusRefreshLock.release();
    }

    public void resumeWorkflow() {
        Operation currentOperation = this.workflow.getOperations().get(this.workflowExecutionPosition);
        if (this.executionState == ExecutionState.PAUSED || this.executionState == ExecutionState.PAUSING) {
            this.activeEvents.incrementAndGet();
            try {
                LOGGER.info("Workflow resume requested on " + FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)));
                this.executionState = ExecutionState.RUNNING;
                try {
                    currentOperation.resume();
                }
                catch (UserCancelledException e) {
                    this.logNewLine();
                    this.logWarning(this.iu.getFormattedString("WorkflowExecution.Warning.ExecutionCancelled", new Object[]{this.workflowExecutionPosition + 1, this.workflow.getOperations().size(), this.workflow.getOperations().get(this.workflowExecutionPosition).toString()}));
                    LOGGER.error("Execution error", (Throwable)e);
                    currentOperation.trackStopped();
                    this.workflowExecutionTimer.cancel();
                    this.closeCaseOpenedByWorkflow();
                    this.fireWorkflowStatusChangedEvent(this.executionState);
                }
                catch (Throwable e) {
                    this.handleWorkflowExecutionException(e, currentOperation);
                }
                this.log(this.iu.getFormattedString("WorkflowExecution.Log.OperationResumedOn", new Object[]{this.workflowExecutionPosition + 1, this.workflow.getOperations().size(), currentOperation.toString(), FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC))}));
                this.fireWorkflowStatusChangedEvent(this.executionState);
            }
            finally {
                this.activeEvents.decrementAndGet();
            }
        }
        LOGGER.error("Cannot pause workflow because it is not paused");
    }

    public void stopWorkflow() {
        try {
            LOGGER.info("Stopping workflow, waiting for lock");
            this.operationStatusRefreshLock.acquire();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
        try {
            this.activeEvents.incrementAndGet();
            try {
                LOGGER.info("Stopping");
                this.executionState = ExecutionState.STOPPING;
                int stopOperation = this.workflowExecutionPosition;
                if (stopOperation < 0) {
                    LOGGER.warn("Cannot stop workflow because it had not yet started, sending stop command to first operation");
                    stopOperation = 0;
                    this.executionState = ExecutionState.STOPPED;
                }
                this.workflow.getOperations().get(stopOperation).stop();
                this.fireWorkflowStatusChangedEvent(this.executionState);
            }
            finally {
                this.activeEvents.decrementAndGet();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while stopping workflow", (Throwable)e);
        }
        this.operationStatusRefreshLock.release();
    }

    public void skipOperation(int operationPosition) {
        try {
            LOGGER.info("Skipping operation #" + (operationPosition + 1) + ", waiting for lock");
            this.operationStatusRefreshLock.acquire();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
        try {
            this.activeEvents.incrementAndGet();
            try {
                LOGGER.info("Skipping operation");
                this.executionState = ExecutionState.STOPPING;
                if (this.workflowExecutionPosition != operationPosition) {
                    LOGGER.warn("Cannot skip operation because it is not currently running");
                }
                Operation operation = this.workflow.getOperations().get(operationPosition);
                if (!operation.skippable) {
                    LOGGER.warn("Cannot skip operation because it is not skippable");
                } else {
                    this.workflow.getOperations().get(operationPosition).skip();
                    this.fireWorkflowStatusChangedEvent(this.executionState);
                }
            }
            finally {
                this.activeEvents.decrementAndGet();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while skipping operation", (Throwable)e);
        }
        this.operationStatusRefreshLock.release();
    }

    public void abortWorkflow() {
        this.activeEvents.incrementAndGet();
        try {
            try {
                LOGGER.info("Aborting workflow, waiting for lock");
                this.operationStatusRefreshLock.acquire();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Thread interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
                this.activeEvents.decrementAndGet();
                return;
            }
            try {
                this.activeEvents.incrementAndGet();
                try {
                    LOGGER.info("Aborting");
                    this.executionState = ExecutionState.STOPPING;
                    int stopOperation = this.workflowExecutionPosition;
                    if (stopOperation < 0) {
                        LOGGER.warn("Cannot abort workflow because it had not yet started, sending abort command to first operation");
                        stopOperation = 0;
                        this.executionState = ExecutionState.STOPPED;
                    }
                    this.workflow.getOperations().get(stopOperation).abort();
                    this.fireWorkflowStatusChangedEvent(this.executionState);
                }
                finally {
                    this.activeEvents.decrementAndGet();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while aborting workflow", (Throwable)e);
            }
            this.operationStatusRefreshLock.release();
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    public boolean getCaseOpenedBeforePausing() {
        return this.caseOpenedBeforePausing;
    }

    private void checkAndRegisterExecutionScript() {
        if (this.scriptWorkflowExecutionListener == null) {
            String workflowExecutionParameterName;
            String executionScriptFileName = workflowExecutionParameterName = "{job_side_script_file}";
            try {
                executionScriptFileName = this.executionContext.evalParameters(workflowExecutionParameterName, null);
            }
            catch (ParameterException e) {
                LOGGER.error("Unexpected error", (Throwable)e);
            }
            if (executionScriptFileName.equals(workflowExecutionParameterName)) {
                executionScriptFileName = workflowExecutionParameterName = "{wfn_execution_script_file}";
                try {
                    executionScriptFileName = this.executionContext.evalParameters(workflowExecutionParameterName, null);
                }
                catch (ParameterException e) {
                    LOGGER.error("Unexpected error", (Throwable)e);
                }
            }
            if (!executionScriptFileName.equals(workflowExecutionParameterName)) {
                boolean featureLicensed = false;
                try {
                    this.executionContext.assertModuleLicensed(ModuleType.AUTOMATE_JSS_API);
                    featureLicensed = true;
                }
                catch (LicenceValidationException licenceValidationException) {
                    // empty catch block
                }
                if (featureLicensed) {
                    this.executionContext.workflowExecution.log(this.iu.getFormattedString("WorkflowExecution.Log.SettingWorkflowExecutionCallback", (Object)executionScriptFileName), LogLevel.EXECUTION);
                    this.scriptWorkflowExecutionListener = new ScriptWorkflowExecutionListener(executionScriptFileName, this.executionContext);
                    this.addWorkflowExecutionListener(this.scriptWorkflowExecutionListener);
                } else {
                    this.logError(this.iu.getString("AutomateLicenseResource.restrictedFeatureJSS"));
                }
            }
        }
    }

    private void triggerExecutionPaused() {
        this.activeEvents.incrementAndGet();
        try {
            this.executionState = ExecutionState.PAUSED;
            if (this.workflowExecutionTimer != null) {
                this.workflowExecutionTimer.cancel();
            }
            this.log(this.iu.getFormattedString("WorkflowExecution.Log.WorkflowExecutionPausedOn", (Object)FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC))));
            this.caseOpenedBeforePausing = this.executionContext.nuixCase != null;
            this.closeCaseOpenedByWorkflow();
            this.fireWorkflowStatusChangedEvent(this.executionState);
        }
        finally {
            this.activeEvents.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNextAction() {
        if (this.isWorkflowRunning().booleanValue()) {
            if (this.executionState == ExecutionState.PAUSING && this.workflowExecutionPosition != this.workflow.getOperations().size() - 1) {
                this.triggerExecutionPaused();
                return;
            }
            this.lowJvmMemory = false;
            ++this.workflowExecutionPosition;
            if (this.workflowExecutionPosition >= this.workflow.getOperations().size()) {
                this.logNewLine();
                boolean warningsEncountered = this.workflow.hasWarnings();
                boolean softErrorsEncountered = this.workflow.hasSoftErrors();
                String dateString = FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
                if (softErrorsEncountered) {
                    this.log(this.iu.getFormattedString("WorkflowExecution.Log.ExecutionFinishedWithSoftErrors", (Object)dateString));
                } else if (warningsEncountered) {
                    this.log(this.iu.getFormattedString("WorkflowExecution.Log.ExecutionFinishedWithWarnings", (Object)dateString));
                } else {
                    this.log(this.iu.getFormattedString("WorkflowExecution.Log.ExecutionFinishedOn", (Object)dateString));
                }
                this.activeEvents.incrementAndGet();
                try {
                    this.executionState = ExecutionState.FINISHED;
                    this.workflowExecutionTimer.cancel();
                    this.closeCaseOpenedByWorkflow();
                    this.fireWorkflowStatusChangedEvent(this.executionState);
                }
                finally {
                    this.activeEvents.getAndDecrement();
                }
            } else {
                Operation currentOperation = this.workflow.getOperations().get(this.workflowExecutionPosition);
                this.fireWorkflowExecutionProgressEvent(this.workflowExecutionPosition);
                this.workflow.getOperations().get((int)this.workflowExecutionPosition).executionState = ExecutionState.NOT_STARTED;
                if (this.executionContext != null) {
                    currentOperation.overwriteOperationFields(this.executionContext.getSessionConfigParameters());
                    currentOperation.overwriteOperationFields(this.executionContext.getExecutionCustomParameters());
                }
                if (currentOperation.disabled) {
                    this.logNewLine();
                    this.log(this.iu.getFormattedString("WorkflowExecution.Log.SkippingDisabledOperation", new Object[]{this.workflowExecutionPosition + 1, this.workflow.getOperations().size(), this.workflow.getOperations().get(this.workflowExecutionPosition).toString(), FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC))}));
                    this.startNextAction();
                } else {
                    try {
                        this.logNewLine();
                        LinkedHashSet<String> previousWarningMessages = currentOperation.getWarningMessages();
                        String originalState = currentOperation.getOriginalState();
                        if (originalState != null) {
                            Operation operation = (Operation)SerializerFactory.getSerializer().deserialize(originalState);
                            operation = ReflectionUtils.getOperationImplementation(operation);
                            this.workflow.getOperations().set(this.workflowExecutionPosition, operation);
                            currentOperation = operation;
                            currentOperation.setOriginalState(originalState);
                        } else {
                            originalState = SerializerFactory.getSerializer().serialize(currentOperation);
                            currentOperation.setOriginalState(originalState);
                        }
                        if (previousWarningMessages != null) {
                            currentOperation.setInitialWarnings(previousWarningMessages);
                        }
                        this.log(this.iu.getFormattedString("WorkflowExecution.Log.StartingOperation", new Object[]{this.workflowExecutionPosition + 1, this.workflow.getOperations().size(), this.workflow.getOperations().get(this.workflowExecutionPosition).toString(), FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC))}));
                        if (currentOperation.notes != null && currentOperation.notes.trim().length() > 0) {
                            this.log(this.iu.getFormattedString("WorkflowExecution.Log.CurrentOperationNotes", (Object)currentOperation.notes.trim()));
                        }
                        if (this.executionState == ExecutionState.PAUSING) {
                            this.workflow.getOperations().get(this.workflowExecutionPosition).pause();
                        } else if (this.executionState == ExecutionState.STOPPING) {
                            this.workflow.getOperations().get(this.workflowExecutionPosition).stop();
                        }
                        this.updateOperationProgressStatus(currentOperation);
                        currentOperation.addOperationListener(new OperationListener(){

                            @Override
                            public void operationExecutionLogging(OperationEvent operationEvent, String warningMessage, LogLevel logLevel) {
                                WorkflowExecution.this.log(warningMessage, logLevel);
                            }

                            @Override
                            public void executionFinished() {
                                WorkflowExecution.this.call();
                            }
                        });
                        ++this.operationsExecutionCount;
                        currentOperation.beforeStart(this.executionContext, this.workflowExecutionPosition + 1, this.operationsExecutionCount);
                        this.fireBeforeOperationStart(currentOperation);
                        currentOperation.start(this.executionContext, this.workflowExecutionPosition + 1, this.operationsExecutionCount);
                    }
                    catch (UserCancelledException e) {
                        this.logNewLine();
                        this.logWarning(this.iu.getFormattedString("WorkflowExecution.Warning.ExecutionCancelled", new Object[]{this.workflowExecutionPosition + 1, this.workflow.getOperations().size(), this.workflow.getOperations().get(this.workflowExecutionPosition).toString()}));
                        LOGGER.error("Execution error", (Throwable)e);
                        currentOperation.executionState = ExecutionState.STOPPED;
                        this.activeEvents.incrementAndGet();
                        try {
                            this.executionState = ExecutionState.STOPPED;
                            this.workflowExecutionTimer.cancel();
                            this.closeCaseOpenedByWorkflow();
                            this.fireWorkflowStatusChangedEvent(this.executionState);
                        }
                        finally {
                            this.activeEvents.decrementAndGet();
                        }
                    }
                    catch (Throwable e) {
                        this.logError(this.iu.getFormattedString("WorkflowExecution.Error.CannotStartOperation", (Object)e.getLocalizedMessage()));
                        LOGGER.error("Cannot start operation.", e);
                    }
                }
            }
        } else {
            LOGGER.warn("startNextAction() called when workflow was not running");
        }
    }

    private void logOperationProcessingSpeed(Operation operation) {
        String processingSpeed = operation.getPrintableProcessingSpeed();
        if (processingSpeed != null) {
            this.log(this.iu.getFormattedString("WorkflowExecution.Log.ProcessingSpeed", (Object)processingSpeed));
        }
    }

    private void updateOperationProgressStatus(Operation operation) {
        this.fireWorkflowExecutionProgressEvent(this.workflowExecutionPosition);
    }

    private void checkMemoryUsage() {
        this.checkMemoryUsage(null);
    }

    public void checkMemoryUsage(String message) {
        block23: {
            if (message != null) {
                this.uiGcSkip = 0L;
            } else {
                ++this.uiGcSkip;
                if (this.uiGcSkip < 120L) {
                    return;
                }
            }
            try {
                Operation currentOperation = this.workflow.getOperations().get(this.workflowExecutionPosition);
                LOGGER.info("Stats trigger: " + (message == null ? "Timer" : message) + "\t" + currentOperation.getOperationName() + ": " + currentOperation.getPrintableStatus());
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block23;
                LOGGER.debug("Cannot get operation printable percentage complete", (Throwable)e);
            }
        }
        this.uiGcSkip = 0L;
        long currentUpTime = this.runtimeMXBean.getUptime();
        long currentGcTime = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            currentGcTime += garbageCollectorMXBean.getCollectionTime();
        }
        long deltaUpTime = currentUpTime - this.upTime;
        long deltaGcTime = currentGcTime - this.gcTime;
        double percentageGc = (double)deltaGcTime / (double)deltaUpTime;
        PeriodFormatter periodFormatter = new PeriodFormatterBuilder().printZeroNever().appendHours().appendSuffix("h").appendSeparator(" ").printZeroNever().appendMinutes().appendSuffix("m").appendSeparator(" ").printZeroAlways().appendSeconds().appendSuffix("s").toFormatter();
        double systemLoad = 0.0;
        LOGGER.info(String.format(Locale.ROOT, "JVM GC time: %s, Total GC time: %s, GC percentage: %.2f%%, Max memory: %s, Total memory: %s, Free memory %s", periodFormatter.print((ReadablePeriod)new Period(deltaGcTime)), periodFormatter.print((ReadablePeriod)new Period(currentGcTime)), 100.0 * percentageGc, FormattingUtils.sizeToDisplaySize((long)Runtime.getRuntime().maxMemory()), FormattingUtils.sizeToDisplaySize((long)Runtime.getRuntime().totalMemory()), FormattingUtils.sizeToDisplaySize((long)Runtime.getRuntime().freeMemory())));
        try {
            long physicalMemorySize = -1L;
            long freePhysicalMemory = -1L;
            long freeSwapSize = -1L;
            long commitedVirtualMemorySize = -1L;
            double processCpuLoad = -1.0;
            double systemCpuLoad = -1.0;
            long processCpuTime = -1L;
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            int processorsCount = operatingSystemMXBean.getAvailableProcessors();
            for (Method method : operatingSystemMXBean.getClass().getDeclaredMethods()) {
                try {
                    method.setAccessible(true);
                    if (!method.getName().startsWith("get") || !Modifier.isPublic(method.getModifiers())) continue;
                    Object value = 0;
                    try {
                        value = method.invoke((Object)operatingSystemMXBean, new Object[0]);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected error", (Throwable)e);
                    }
                    if (method.getName().equals("getTotalPhysicalMemorySize")) {
                        physicalMemorySize = (Long)value;
                    }
                    if (method.getName().equals("getFreePhysicalMemorySize")) {
                        freePhysicalMemory = (Long)value;
                    }
                    if (method.getName().equals("getFreeSwapSpaceSize")) {
                        freeSwapSize = (Long)value;
                    }
                    if (method.getName().equals("getCommittedVirtualMemorySize")) {
                        commitedVirtualMemorySize = (Long)value;
                    }
                    if (method.getName().equals("getProcessCpuLoad")) {
                        processCpuLoad = (Double)value;
                    }
                    if (method.getName().equals("getProcessCpuTime")) {
                        processCpuTime = (Long)value / 1000L / 1000L / 1000L;
                    }
                    if (!method.getName().equals("getSystemCpuLoad")) continue;
                    systemCpuLoad = (Double)value;
                }
                catch (Exception e) {
                    LOGGER.debug("Cannot get operatingSystemMXBean value");
                }
            }
            if (physicalMemorySize > 0L) {
                LOGGER.info(String.format(Locale.ROOT, "OS Physical memory: %s, Free Physical Memory: %s, Free Swap Size: %s, Committed Virtual Memory: %s", FormattingUtils.sizeToDisplaySize((long)physicalMemorySize), FormattingUtils.sizeToDisplaySize((long)freePhysicalMemory), FormattingUtils.sizeToDisplaySize((long)freeSwapSize), FormattingUtils.sizeToDisplaySize((long)commitedVirtualMemorySize)));
                if (freePhysicalMemory < 100000L && !this.lowSystemMemory) {
                    this.logWarning(this.iu.getString("WorkflowExecution.Warning.LowSystemMemory"));
                    this.lowSystemMemory = true;
                }
            }
            if (processCpuLoad > 0.0) {
                LOGGER.info(String.format(Locale.ROOT, "OS System CPU Load: %s, Processors: %d, Process CPU Load: %s, Process CPU Time: %d", FormattingUtils.getLocalizedPercentage((double)systemCpuLoad), processorsCount, FormattingUtils.getLocalizedPercentage((double)processCpuLoad), processCpuTime));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.upTime != 0L && deltaUpTime > 60000L && percentageGc > 0.9 && !this.lowJvmMemory) {
            this.logWarning(this.iu.getString("WorkflowExecution.Warning.LowJVMMemory"));
            this.lowJvmMemory = true;
        }
        this.upTime = currentUpTime;
        this.gcTime = currentGcTime;
    }

    public void call() {
        block19: {
            Thread.currentThread().setName("Automate - WorkflowExecution");
            try {
                boolean lockAcquired = this.operationStatusRefreshLock.tryAcquire(this.refreshMs, TimeUnit.MILLISECONDS);
                if (!lockAcquired) {
                    return;
                }
            }
            catch (InterruptedException e) {
                return;
            }
            this.checkMemoryUsage();
            try {
                if (this.workflowExecutionPosition < 0) {
                    this.startNextAction();
                    break block19;
                }
                if (this.workflowExecutionPosition >= this.workflow.getOperations().size()) break block19;
                Operation currentOperation = this.workflow.getOperations().get(this.workflowExecutionPosition);
                this.fireWorkflowExecutionProgressEvent(this.workflowExecutionPosition);
                if (currentOperation.executionState == ExecutionState.NOT_STARTED) {
                    this.isResuming = false;
                    this.executionState = ExecutionState.RUNNING;
                    this.startNextAction();
                    break block19;
                }
                if (currentOperation.executionState == ExecutionState.ERROR) {
                    this.updateOperationProgressStatus(currentOperation);
                    if (currentOperation.getSkipRequested()) {
                        currentOperation.executionState = ExecutionState.STOPPED;
                        this.executionState = ExecutionState.RUNNING;
                        this.fireAfterOperationSkipped(currentOperation);
                    } else {
                        this.handleWorkflowExecutionException(currentOperation.getException(), currentOperation);
                        this.fireAfterOperationError(currentOperation);
                    }
                    break block19;
                }
                if (currentOperation.executionState == ExecutionState.FINISHED || currentOperation.executionState == ExecutionState.STOPPED && currentOperation.getSkipRequested() || currentOperation.executionState == ExecutionState.SOFT_ERROR) {
                    if (currentOperation.getSkipRequested() || currentOperation.executionState == ExecutionState.SOFT_ERROR) {
                        this.executionState = ExecutionState.RUNNING;
                    }
                    this.checkAndRegisterExecutionScript();
                    if (!this.isResuming && this.executionState != ExecutionState.PAUSED) {
                        currentOperation.setFinishedDateTime();
                        this.fireAfterOperationFinish(currentOperation, this.workflowExecutionPosition == this.workflow.getOperations().size() - 1);
                        this.logOperationProcessingSpeed(currentOperation);
                        this.log(this.iu.getFormattedString("WorkflowExecution.Log.OperationCompletedOn", new Object[]{this.workflowExecutionPosition + 1, this.workflow.getOperations().size(), currentOperation.toString(), FormattingUtils.dateTimeToLocalString((DateTime)currentOperation.finishedDateTime)}));
                        this.updateOperationProgressStatus(currentOperation);
                        if (this.nextWorkflowExecutionPosition > 0) {
                            this.log(this.iu.getFormattedString("WorkflowExecution.Log.JumpingToOperation", (Object)this.nextWorkflowExecutionPosition));
                            this.workflowExecutionPosition = this.nextWorkflowExecutionPosition - 2;
                            this.nextWorkflowExecutionPosition = 0;
                        }
                    }
                    this.isResuming = false;
                    this.startNextAction();
                    break block19;
                }
                this.updateOperationProgressStatus(currentOperation);
                if (currentOperation.executionState != ExecutionState.STOPPED) break block19;
                if (this.executionState == ExecutionState.STOPPING) {
                    this.logNewLine();
                    this.log(this.iu.getFormattedString("WorkflowExecution.Warning.ExecutionStopped", (Object)FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC))));
                    this.activeEvents.incrementAndGet();
                    try {
                        this.executionState = ExecutionState.STOPPED;
                        this.workflowExecutionTimer.cancel();
                        this.closeCaseOpenedByWorkflow();
                        this.fireWorkflowStatusChangedEvent(this.executionState);
                    }
                    finally {
                        this.activeEvents.decrementAndGet();
                    }
                }
                if (currentOperation.finishedDateTime == null) {
                    currentOperation.setFinishedDateTime();
                }
                this.fireAfterOperationError(currentOperation);
            }
            catch (Throwable e) {
                LOGGER.error("Execution exception", e);
                this.logError(e.getLocalizedMessage());
                this.workflowExecutionTimer.cancel();
                this.closeCaseOpenedByWorkflow();
                this.fireWorkflowStatusChangedEvent(this.executionState);
            }
        }
        this.operationStatusRefreshLock.release();
    }

    public String getWorkflowStatusHtml() {
        Object result = "<table class=\"workflow-status\">\n";
        result = (String)result + "   <tr>\n";
        result = (String)result + "       <th class=\"workflow-status-index\">" + this.iu.getString("WorkflowExecution.Status.HashTagColumn") + "</th>\n";
        result = (String)result + "       <th class=\"workflow-status-icon\"></th>\n";
        result = (String)result + "       <th class=\"workflow-status-operation\">" + this.iu.getString("WorkflowExecution.Status.OperationColumn") + "</th>\n";
        result = (String)result + "       <th class=\"workflow-status-notes\">" + this.iu.getString("WorkflowExecution.Status.NotesColumn") + "</th>\n";
        result = (String)result + "       <th class=\"workflow-status-text\">" + this.iu.getString("WorkflowExecution.Status.StatusColumn") + "</th>\n";
        result = (String)result + "   </tr>";
        int operationId = 0;
        if (this.workflow != null && this.workflow.getOperations() != null) {
            for (Operation operation : this.workflow.getOperations()) {
                result = (String)result + "   <tr>\n";
                result = (String)result + "       <td>" + ++operationId + "</td>\n";
                result = (String)result + "       <td><img height=\"20\" width=\"20\" class=\"workflow-operation-icon\" src=\"" + Icons.getInstance().getIconUrl(operation.getIconType()) + "\"></td>\n";
                result = (String)result + "       <td>" + operation.getOperationName() + "</td>\n";
                Object warningMessage = "";
                if (operation.getEncounteredWarnings()) {
                    LinkedHashSet<String> warningsList = operation.getWarningMessages();
                    StringBuilder message = new StringBuilder();
                    for (String warning : warningsList) {
                        message.append(this.iu.getString("WorkflowExecution.Output.Warning")).append(" ").append(warning).append("<br/>");
                    }
                    warningMessage = (String)warningMessage + "<br /><br />" + String.valueOf(message);
                }
                if (operation.getErrorMessage() != null && operation.getErrorMessage().length() > 0) {
                    warningMessage = operation.executionState == ExecutionState.SOFT_ERROR ? (String)warningMessage + "<br /><br />" + this.iu.getString("WorkflowExecution.Output.SoftError") + " " + operation.getErrorMessage() : (String)warningMessage + "<br /><br />" + this.iu.getString("WorkflowExecution.Output.Error") + " " + operation.getErrorMessage();
                }
                result = (String)result + "       <td>" + operation.notes + (String)warningMessage + "</td>\n";
                if (operation.executionState == ExecutionState.RUNNING || operation.executionState == ExecutionState.STOPPING || operation.executionState == ExecutionState.PAUSED || operation.executionState == ExecutionState.PAUSING) {
                    result = (String)result + "       <td class=\"workflow-status-inprogress\">";
                    result = (String)result + operation.getPrintableStatus() + "</td>\n";
                } else if (operation.executionState == ExecutionState.FINISHED || operation.executionState == ExecutionState.STOPPED || operation.executionState == ExecutionState.ERROR || operation.executionState == ExecutionState.SOFT_ERROR) {
                    result = operation.getEncounteredWarnings() || operation.getErrorMessage() != null && operation.getErrorMessage().length() > 0 ? (String)result + "        <td class=\"workflow-status-complete-with-warnings\"><b>" : (String)result + "        <td class=\"workflow-status-complete\"><b>";
                    result = (String)result + operation.getPrintableStatus() + "</b></td>\n";
                } else {
                    result = (String)result + "       <td>";
                    result = (String)result + operation.getPrintableStatus() + "</td>\n";
                }
                result = (String)result + "   </tr>\n";
            }
        }
        result = (String)result + "</table>\n";
        return result;
    }

    public String getWorkflowStatusText() {
        StringBuilder result = new StringBuilder();
        String header = this.iu.getString("WorkflowExecution.Status.HashTag") + "\t" + this.iu.getString("WorkflowExecution.Status.Operation") + "\t" + this.iu.getString("WorkflowExecution.Status.Notes") + "\t" + this.iu.getString("WorkflowExecution.Status.Status");
        result.append(header).append("\n");
        int operationPosition = 0;
        if (this.workflow != null && this.workflow.getOperations() != null) {
            for (Operation operation : this.workflow.getOperations()) {
                result.append(++operationPosition).append("\t");
                result.append(operation.getOperationName()).append("\t");
                result.append(operation.notes.trim().replace("\n", " ")).append("\t");
                result.append(operation.getPrintableStatus()).append("\n");
            }
        }
        return result.toString();
    }

    public boolean getHasWarnings() {
        return this.workflow.hasWarnings();
    }

    public boolean getHasSoftErrors() {
        return this.workflow.hasSoftErrors();
    }

    public boolean getHasErrors() {
        return this.encounteredErrors || this.executionState == ExecutionState.ERROR;
    }

    public void setNuixProfiles(Map<ProfileTypeNuix, Set<String>> profiles) {
        this.nuixProfiles = profiles;
    }

    public Set<String> getNuixProfiles(ProfileTypeNuix type) {
        if (this.nuixProfiles == null) {
            return new HashSet<String>();
        }
        Set<String> result = this.nuixProfiles.get(type);
        if (result == null) {
            return new HashSet<String>();
        }
        return result;
    }

    public int getActiveEventsCount() {
        return this.activeEvents.get();
    }

    public long getStartEpoch() {
        return this.startEpoch;
    }
}

