/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.workflow;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.SensitiveField;
import com.nuix.automate.utils.ui.IconType;
import com.nuix.automate.utils.ui.Icons;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.PrintableOption;
import com.nuix.automate.utils.workflow.PrintableOptionStyle;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.configuration.ParameterListType;
import com.nuix.automate.workflow.core.execution.workflow.ImmutableWorkflow;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class WorkflowRenderer {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowRenderer.class);
    private static InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private static Pattern parameterPattern = Pattern.compile("(\\{.*?})");
    public static final String WORKFLOW_REPORT_STYLE = "<style>\nbody{\n  font-family: -apple-system,BlinkMacSystemFont,\"Segoe UI\",Roboto,Oxygen,Ubuntu,\"Fira Sans\",\"Droid Sans\",\"Helvetica Neue\",sans-serif;\n  font-size: .9rem;\n}\ntable.operations {\n    border-collapse: collapse;\n    margin-top: 10px;\n}\ntable.operations th {\n  background-color: #fafafa;\n}\ndiv.report-date{\n  margin-top: -10px;\n  margin-bottom: 10px;\n}\nth.operation {\n  width:1px;  \n}\nth.index {\n  width:16px;\n}\n.operations td, .operations th {\n    border: 1px solid #dddddd;\n    text-align: left;\n    padding: 8px;\n}\n.details td, .details th {\n    text-align: left;\n}\nimg.operation-icon {\n  width: 2rem;\n}\n\ntable.operation-name td {\n    border-collapse: collapse;\n    border: 0px;\n    padding: 0px;\n    margin: 0px;\n}\ntable.settings {\n    border-collapse: collapse;\n    margin-top: 5px;\n}\n.settings td {\n    border: 0px solid #dddddd;\n    text-align: left;\n    padding: 5px;\n}\n.settings td.multiline {\n    border-left:  1px solid #dddddd;\n}\n.parameter{\n    color: #005696;\n}\n.operations tr.operation-disabled {\n  background-color: #cccccc;\n}\n.operations tr.operation-disabled table td > table {\n  color: #a0a0a0;\n}\n.operations tr.operation-softFail {\n  background-color: #F4ECCC;\n}\n.operations tr.operation-suppressWarnings {\n}\nul {\n  margin: 0px\n}\nli:not(:last-child) {\n    margin-bottom: 10px;\n}\nli li {\n    margin-bottom: 0px;\n    margin-top: 5px;\n}\nins {\n    text-decoration: none;\n    background-color: #d4fcbc;\n}\ndel {\n    text-decoration: line-through;\n    background-color: #fbb6c2;\n    color: #555;\n}\nimg.logo{\n  height: 2.5rem;\n  vertical-align: bottom;\n}\nh1 {\n    font-weight: 400;\n    margin-bottom: 0px;\n    margin-top: 0px;\n}\nh2 {\n    font-weight: 400;\n    margin-bottom: 2px;\n    margin-top: 8px;\n}\ntable.title td{\n  vertical-align: baseline;\n}\ntd.logo{\n  padding-right: 5px;\n}\n.separator-parameter {\n  width: 100%;\n  min-width: 100%;\n}\n.separator-parameter:not(:first-child) {\n  margin-top: 1.5rem;\n}\n.separator-parameter .separator {\n  display: flex;\n  align-items: center;\n  text-align: center;\n  margin-bottom: 0.875rem;\n}\n.separator-parameter .separator:before, .separator-parameter .separator:after {\n  content: \"\";\n  flex: 1;\n  border-bottom: 1px solid hsl(0deg, 0%, 71%);\n}\n.separator-parameter .separator:not(:empty)::before {\n  margin-right: 0.25em;\n}\n.separator-parameter .separator:not(:empty)::after {\n  margin-left: 0.25em;\n}\n.separator-parameter .separator:last-child {\n  margin-bottom: 1.375rem;\n}\n.separator-parameter-description {\n  margin-bottom: 0.875rem;\n}\n.scripted-parameter {\n  border-left:  1px solid #dddddd;\n}\n</style>\n";
    public static final String SCRIPT_COMPARE_HTML = "!function(){var e,n,t,r,i,f,_,a,o,s,u,h,l,c,d,b,p;o=function(e){return\">\"===e},s=function(e){return\"<\"===e},h=function(e){return/^\\s+$/.test(e)},u=function(e){return/^\\s*<[^>]+>\\s*$/.test(e)},l=function(e){return!u(e)},e=function(){return function(e,n,t){this.start_in_before=e,this.start_in_after=n,this.length=t,this.end_in_before=this.start_in_before+this.length-1,this.end_in_after=this.start_in_after+this.length-1}}(),a=function(e){var n,t,r,i,f,_;for(f=\"char\",t=\"\",_=[],r=0,i=e.length;r<i;r++)switch(n=e[r],f){case\"tag\":o(n)?(t+=\">\",_.push(t),t=\"\",f=h(n)?\"whitespace\":\"char\"):t+=n;break;case\"char\":s(n)?(t&&_.push(t),t=\"<\",f=\"tag\"):/\\s/.test(n)?(t&&_.push(t),t=n,f=\"whitespace\"):/[\\w\\#@]+/i.test(n)?t+=n:(t&&_.push(t),t=n);break;case\"whitespace\":s(n)?(t&&_.push(t),t=\"<\",f=\"tag\"):h(n)?t+=n:(t&&_.push(t),t=n,f=\"char\");break;default:throw new Error(\"Unknown mode \"+f)}return t&&_.push(t),_},f=function(n,t,r,i,f,_,a){var o,s,u,h,l,c,d,b,p,g,w,v,k,m,y;for(s=i,o=_,u=0,w={},c=h=m=i,y=f;m<=y?h<y:h>y;c=m<=y?++h:--h){for(k={},d=0,b=(p=r[n[c]]).length;d<b;d++)if(!((l=p[d])<_)){if(l>=a)break;null==w[l-1]&&(w[l-1]=0),v=w[l-1]+1,k[l]=v,v>u&&(s=c-v+1,o=l-v+1,u=v)}w=k}return 0!==u&&(g=new e(s,o,u)),g},d=function(e,n,t,r,i,_,a,o){var s;return null!=(s=f(e,0,t,r,i,_,a))&&(r<s.start_in_before&&_<s.start_in_after&&d(e,n,t,r,s.start_in_before,_,s.start_in_after,o),o.push(s),s.end_in_before<=i&&s.end_in_after<=a&&d(e,n,t,s.end_in_before+1,i,s.end_in_after+1,a,o)),o},r=function(e){var n,t,r,i,f,_;if(null==e.find_these)throw new Error(\"params must have find_these key\");if(null==e.in_these)throw new Error(\"params must have in_these key\");for(r={},n=0,i=(f=e.find_these).length;n<i;n++)for(r[_=f[n]]=[],t=e.in_these.indexOf(_);-1!==t;)r[_].push(t),t=e.in_these.indexOf(_,t+1);return r},_=function(e,n){var t,i;return i=[],t=r({find_these:e,in_these:n}),d(e,n,t,0,e.length,0,n.length,i)},n=function(n,t){var r,i,f,a,o,s,u,h,l,c,d,b,p,g,w,v;if(null==n)throw new Error(\"before_tokens?\");if(null==t)throw new Error(\"after_tokens?\");for(w=g=0,p=[],r={\"false,false\":\"replace\",\"true,false\":\"insert\",\"false,true\":\"delete\",\"true,true\":\"none\"},(d=_(n,t)).push(new e(n.length,t.length,0)),a=f=0,h=d.length;f<h;a=++f)\"none\"!==(i=r[[w===(c=d[a]).start_in_before,g===c.start_in_after].toString()])&&p.push({action:i,start_in_before:w,end_in_before:\"insert\"!==i?c.start_in_before-1:void 0,start_in_after:g,end_in_after:\"delete\"!==i?c.start_in_after-1:void 0}),0!==c.length&&p.push({action:\"equal\",start_in_before:c.start_in_before,end_in_before:c.end_in_before,start_in_after:c.start_in_after,end_in_after:c.end_in_after}),w=c.end_in_before+1,g=c.end_in_after+1;for(v=[],u={action:\"none\"},o=function(e){return\"equal\"===e.action&&(e.end_in_before-e.start_in_before==0&&/^\\s$/.test(n.slice(e.start_in_before,+e.end_in_before+1||9e9)))},s=0,l=p.length;s<l;s++)o(b=p[s])&&\"replace\"===u.action||\"replace\"===b.action&&\"replace\"===u.action?(u.end_in_before=b.end_in_before,u.end_in_after=b.end_in_after):(v.push(b),u=b);return v},t=function(e,n,t){var r,i,f,_,a,o;for(_=void 0,f=i=0,a=(n=n.slice(e,+n.length+1||9e9)).length;i<a&&(o=n[f],!0===(r=t(o))&&(_=f),!1!==r);f=++i);return null!=_?n.slice(0,+_+1||9e9):[]},p=function(e,n){var r,i,f,_,a;for(_=\"\",f=0,r=n.length;;){if(f>=r)break;if(i=t(f,n,l),f+=i.length,0!==i.length&&(_+=\"<\"+e+\">\"+i.join(\"\")+\"</\"+e+\">\"),f>=r)break;f+=(a=t(f,n,u)).length,_+=a.join(\"\")}return _},(c={equal:function(e,n,t){return n.slice(e.start_in_before,+e.end_in_before+1||9e9).join(\"\")},insert:function(e,n,t){var r;return r=t.slice(e.start_in_after,+e.end_in_after+1||9e9),p(\"ins\",r)},delete:function(e,n,t){var r;return r=n.slice(e.start_in_before,+e.end_in_before+1||9e9),p(\"del\",r)}}).replace=function(e,n,t){return c.delete(e,n,t)+c.insert(e,n,t)},b=function(e,n,t){var r,i,f,_;for(_=\"\",r=0,i=t.length;r<i;r++)f=t[r],_+=c[f.action](f,e,n);return _},(i=function(e,t){var r;return e===t?e:(e=a(e),t=a(t),r=n(e,t),b(e,t,r))}).html_to_tokens=a,i.find_matching_blocks=_,_.find_match=f,_.create_index=r,i.calculate_operations=n,i.render_operations=b,\"function\"==typeof define?define([],function(){return i}):\"undefined\"!=typeof module&&null!==module?module.exports=i:\"undefined\"!=typeof window&&(window.htmldiff=i)}();";

    public static String getCollectionRepresentation(Object[] c, String fieldName, int nestingLevel) {
        int size = c.length;
        if (size == 0) {
            return "";
        }
        return WorkflowRenderer.getIterableRepresentation(Arrays.asList(c), fieldName, nestingLevel);
    }

    public static String fieldNameToSingularItem(String name) {
        if (name.equals("Password List")) {
            return "Password";
        }
        if (name.equals("Custom Metadata")) {
            return "Metadata";
        }
        if (name.contains(" ")) {
            name = name.substring(name.lastIndexOf(32) + 1);
        }
        switch (name) {
            case "Searches": {
                return "Search";
            }
            case "Exclusions": {
                return "Exclusion";
            }
            case "Inclusions": {
                return "Inclusion";
            }
            case "Stages": {
                return "Stage";
            }
            case "Languages": {
                return "Language";
            }
            case "Sets": {
                return "Set";
            }
            case "Names": {
                return "Name";
            }
            case "Queries": {
                return "Query";
            }
            case "Views": {
                return "View";
            }
        }
        return "";
    }

    public static String getIterableRepresentation(Collection collection, String fieldName, int nestingLevel) {
        StringBuilder fieldValueRepresentation = new StringBuilder();
        for (Object collectionValue : collection) {
            String value;
            if (collectionValue instanceof Object[]) {
                value = WorkflowRenderer.getCollectionRepresentation((Object[])collectionValue, fieldName, nestingLevel + 1);
            } else if (collectionValue instanceof Collection) {
                value = WorkflowRenderer.getCollectionRepresentation((Collection)collectionValue, fieldName, nestingLevel + 1);
            } else if (collectionValue instanceof Boolean) {
                value = ((Boolean)collectionValue).booleanValue() ? iu.getString("Options.Yes") : iu.getString("Options.No");
            } else {
                if (collectionValue instanceof StaticParameter) {
                    WorkflowRenderer.generateReportParameter((StaticParameter)collectionValue, fieldValueRepresentation);
                    continue;
                }
                value = WorkflowRenderer.encodeValueToHtml(collectionValue.toString());
            }
            if (value.length() <= 0) continue;
            fieldValueRepresentation.append("<li>").append(value).append("</li>\n");
        }
        if (fieldValueRepresentation.length() > 0) {
            String singularFieldName;
            fieldValueRepresentation = new StringBuilder("<ul>" + String.valueOf(fieldValueRepresentation) + "</ul>");
            if (fieldName != null && nestingLevel == 1 && (singularFieldName = WorkflowRenderer.fieldNameToSingularItem(fieldName)).length() > 0) {
                fieldValueRepresentation.insert(0, "<span>" + singularFieldName + ": </span>\n");
            }
        }
        return fieldValueRepresentation.toString();
    }

    private static void generateReportParameter(StaticParameter parameter, StringBuilder fieldValueRepresentation) {
        String parameterRepresentation = WorkflowRenderer.encodeValueToHtml(parameter.toString());
        fieldValueRepresentation.append("<li>").append(parameterRepresentation).append("</li>\n");
        if (parameter.getScriptCode() != null && parameter.getScriptCode().length() > 0) {
            String scriptCode = WorkflowRenderer.encodeValueToHtml(parameter.getScriptCode());
            fieldValueRepresentation.append("<table class=\"settings\"><tr><td>" + WorkflowRenderer.encodeValueToHtml(parameter.getScriptLanguage().toLocalizedString()) + ": </td><td class=\"multiline\">" + scriptCode + "</td></tr></table>");
        }
        if (parameter.isUseLibraryFile() && parameter.getLibraryFileId() != null && !parameter.getLibraryFileId().trim().equals("")) {
            fieldValueRepresentation.append(iu.getFormattedString("General.LibraryFileId", (Object)WorkflowRenderer.encodeValueToHtml(parameter.getLibraryFileId())));
        }
    }

    public static String getCollectionRepresentation(Collection c, String fieldName, int nestingLevel) {
        int size = c.size();
        if (size == 0) {
            return "";
        }
        return WorkflowRenderer.getIterableRepresentation(c, fieldName, nestingLevel);
    }

    public static String diffHtml(String originalHtml, String newHtml) {
        StringBuilder result = new StringBuilder();
        result.append("<html>\n");
        result.append("<head>\n");
        result.append("<title>Compare Workflows</title>\n");
        result.append("</head>\n");
        result.append(WORKFLOW_REPORT_STYLE);
        result.append("<body>\n");
        result.append("<div id=\"output\">---</div>\n");
        result.append("<script type=\"text/javascript\">");
        result.append(SCRIPT_COMPARE_HTML);
        result.append("let originalHTML = `\n");
        result.append(originalHtml.replace("\\", "\\\\").replace("`", "\\`"));
        result.append("`;\n");
        result.append("let newHTML = `\n");
        result.append(newHtml.replace("\\", "\\\\").replace("`", "\\`"));
        result.append("`;\n");
        result.append("let output = htmldiff(originalHTML, newHTML);\n");
        result.append("document.getElementById(\"output\").innerHTML = output;\n");
        result.append("</script>\n");
        result.append("</body>\n");
        result.append("</html>\n");
        return result.toString();
    }

    public static String getWorkflowHtmlReport(ImmutableWorkflow workflow, long defaultLastModifiedEpoch) {
        return WorkflowRenderer.getWorkflowHtmlReport(workflow, defaultLastModifiedEpoch, false);
    }

    public static String getWorkflowHtmlReport(ImmutableWorkflow workflow, long defaultLastModifiedEpoch, boolean verbose) {
        long lastModifiedEpoch = defaultLastModifiedEpoch;
        if (workflow.getLastModifiedEpoch() != null) {
            lastModifiedEpoch = workflow.getLastModifiedEpoch();
        }
        StringBuilder result = new StringBuilder("<html>\n<head>\n<title>" + WorkflowRenderer.encodeValueToHtml(workflow.getName()) + "</title>\n</head>\n<style>\nbody{\n  font-family: -apple-system,BlinkMacSystemFont,\"Segoe UI\",Roboto,Oxygen,Ubuntu,\"Fira Sans\",\"Droid Sans\",\"Helvetica Neue\",sans-serif;\n  font-size: .9rem;\n}\ntable.operations {\n    border-collapse: collapse;\n    margin-top: 10px;\n}\ntable.operations th {\n  background-color: #fafafa;\n}\ndiv.report-date{\n  margin-top: -10px;\n  margin-bottom: 10px;\n}\nth.operation {\n  width:1px;  \n}\nth.index {\n  width:16px;\n}\n.operations td, .operations th {\n    border: 1px solid #dddddd;\n    text-align: left;\n    padding: 8px;\n}\n.details td, .details th {\n    text-align: left;\n}\nimg.operation-icon {\n  width: 2rem;\n}\n\ntable.operation-name td {\n    border-collapse: collapse;\n    border: 0px;\n    padding: 0px;\n    margin: 0px;\n}\ntable.settings {\n    border-collapse: collapse;\n    margin-top: 5px;\n}\n.settings td {\n    border: 0px solid #dddddd;\n    text-align: left;\n    padding: 5px;\n}\n.settings td.multiline {\n    border-left:  1px solid #dddddd;\n}\n.parameter{\n    color: #005696;\n}\n.operations tr.operation-disabled {\n  background-color: #cccccc;\n}\n.operations tr.operation-disabled table td > table {\n  color: #a0a0a0;\n}\n.operations tr.operation-softFail {\n  background-color: #F4ECCC;\n}\n.operations tr.operation-suppressWarnings {\n}\nul {\n  margin: 0px\n}\nli:not(:last-child) {\n    margin-bottom: 10px;\n}\nli li {\n    margin-bottom: 0px;\n    margin-top: 5px;\n}\nins {\n    text-decoration: none;\n    background-color: #d4fcbc;\n}\ndel {\n    text-decoration: line-through;\n    background-color: #fbb6c2;\n    color: #555;\n}\nimg.logo{\n  height: 2.5rem;\n  vertical-align: bottom;\n}\nh1 {\n    font-weight: 400;\n    margin-bottom: 0px;\n    margin-top: 0px;\n}\nh2 {\n    font-weight: 400;\n    margin-bottom: 2px;\n    margin-top: 8px;\n}\ntable.title td{\n  vertical-align: baseline;\n}\ntd.logo{\n  padding-right: 5px;\n}\n.separator-parameter {\n  width: 100%;\n  min-width: 100%;\n}\n.separator-parameter:not(:first-child) {\n  margin-top: 1.5rem;\n}\n.separator-parameter .separator {\n  display: flex;\n  align-items: center;\n  text-align: center;\n  margin-bottom: 0.875rem;\n}\n.separator-parameter .separator:before, .separator-parameter .separator:after {\n  content: \"\";\n  flex: 1;\n  border-bottom: 1px solid hsl(0deg, 0%, 71%);\n}\n.separator-parameter .separator:not(:empty)::before {\n  margin-right: 0.25em;\n}\n.separator-parameter .separator:not(:empty)::after {\n  margin-left: 0.25em;\n}\n.separator-parameter .separator:last-child {\n  margin-bottom: 1.375rem;\n}\n.separator-parameter-description {\n  margin-bottom: 0.875rem;\n}\n.scripted-parameter {\n  border-left:  1px solid #dddddd;\n}\n</style>\n<body>\n<table class=\"title\"><tr><td class=\"logo\">\n<h1><img class=\"logo\" src=\"data:image/svg+xml;base64," + Icons.getInstance().getImageBase64(IconType.AUTOMATE_WORKFLOW_LOGO) + "\" />\n" + WorkflowRenderer.encodeValueToHtml("Automate " + iu.getFormattedString("WorkflowReport.Name", (Object)workflow.getName())) + "</h1></td></tr></table><table class=\"details\">" + WorkflowRenderer.getWorkflowDescription(workflow.getDescription()) + WorkflowRenderer.getWorkflowPrerequisites(workflow.getPrerequisites()) + workflow.useReadOnlyOperations(WorkflowRenderer::getWorkflowParameters) + WorkflowRenderer.getWorkflowUsage(workflow.getUsage()) + "<tr><td><h2>" + iu.getString("General.Settings") + "</h2></td></tr><tr><td>" + iu.getString("General.ExecutionMode") + ": " + workflow.getExecutionMode().toLocalizedString() + "</td></tr><tr><td>" + iu.getString("Options.LastModifiedDate") + ": " + FormattingUtils.dateTimeToLocalString((DateTime)new DateTime(lastModifiedEpoch, DateTimeZone.UTC)) + "</td></tr></table><h2>" + iu.getString("General.Operations") + "</h2>\n<table class=\"operations\">\n");
        result.append("   <tr>\n");
        result.append("       <th class=\"index\">").append(iu.getString("WorkflowExecution.Status.HashTagColumn")).append("</th>").append("\n");
        result.append("       <th class=\"operation\">").append(iu.getString("WorkflowExecution.Status.OperationColumn")).append("</th>").append("\n");
        result.append("       <th class=\"options\">").append(iu.getString("WorkflowExecution.Status.OptionsColumn")).append("</th>").append("\n");
        result.append("   </tr>");
        workflow.useReadOnlyOperations(operations -> {
            int operationId = 0;
            for (Operation operation : operations) {
                ++operationId;
                String tdClass = "";
                if (operation.disabled) {
                    tdClass = " class=\"operation-disabled\"";
                }
                if (Boolean.TRUE.equals(operation.softFail)) {
                    tdClass = " class=\"operation-softFail\"";
                }
                if (Boolean.TRUE.equals(operation.suppressWarnings)) {
                    tdClass = " class=\"operation-suppressWarnings\"";
                }
                result.append("   <tr").append(tdClass).append(">").append("\n");
                result.append("       <td>").append(operationId).append("</td>").append("\n");
                String svgImage = Icons.getInstance().getImageBase64(operation.getIconType());
                result.append("       <td><table class=\"operation-name\"><tr><td class=\"operation-icon\"><img class=\"operation-icon\" src=\"data:image/svg+xml;base64,").append(svgImage).append("\" /></td><td>").append(operation.getOperationName()).append("</td></tr></table></td>").append("\n");
                result.append("       <td>").append(WorkflowRenderer.getOperationOptionsReport(operation, verbose)).append("</td>").append("\n");
                result.append("   </tr>\n");
            }
        });
        result.append("</table>\n");
        result.append("</body>\n");
        result.append("</html>");
        return result.toString();
    }

    private static String getWorkflowDescription(String description) {
        if (description == null || description.trim().equals("")) {
            return "";
        }
        StringBuilder result = new StringBuilder("<tr><td><h2>" + iu.getString("General.Description") + "</h2></td></tr>");
        return WorkflowRenderer.generateDetailsRows(result, description);
    }

    private static String getWorkflowUsage(String usage) {
        if (usage == null || usage.trim().equals("")) {
            return "";
        }
        StringBuilder result = new StringBuilder("<tr><td><h2>" + iu.getString("General.Usage") + "</h2></td></tr>");
        return WorkflowRenderer.generateDetailsRows(result, usage);
    }

    private static String generateDetailsRows(StringBuilder result, String text) {
        if (text.contains("\n")) {
            String[] textLines;
            for (String textLine : textLines = text.split("\n")) {
                result.append("<tr><td>").append(WorkflowRenderer.encodeValueToHtml(textLine)).append("</td></tr>");
            }
        } else {
            result.append("<tr><td>").append(WorkflowRenderer.encodeValueToHtml(text)).append("</td></tr>");
        }
        return result.toString();
    }

    private static String getWorkflowPrerequisites(List<String> prerequisites) {
        if (prerequisites == null || prerequisites.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder("<tr><td><h2>" + iu.getString("General.Prerequisites") + "</h2></td></tr>");
        result.append("<tr><td><ul>");
        for (String prerequisite : prerequisites) {
            result.append("<li>").append(WorkflowRenderer.encodeValueToHtml(prerequisite)).append("</li>");
        }
        result.append("</ul></td></tr>");
        return result.toString();
    }

    private static String getWorkflowParameters(List<Operation> operations) {
        StringBuilder result = new StringBuilder("<tr><td><h2>" + iu.getString("General.Parameters") + "</h2></td></tr><tr><td><ul>");
        for (Operation operation : operations) {
            ConfigureParametersOperation configurationOperation;
            List<StaticParameter> userParameters;
            if (!(operation instanceof ConfigureParametersOperation) || (userParameters = (configurationOperation = (ConfigureParametersOperation)operation).getParameterFromListType(ParameterListType.USER_PARAMETERS)) == null) continue;
            for (StaticParameter parameter : userParameters) {
                if (parameter.getParameterType() == ParameterType.SEPARATOR) {
                    result.append("<div class=\"separator-parameter\"><div class=\"separator\"><label class=\"label\">").append(WorkflowRenderer.encodeValueToHtml(parameter.getFriendlyName())).append("</label></div>");
                    if (parameter.getDescription() != null && !parameter.getDescription().equals("")) {
                        result.append("<div class=\"separator-parameter-description\"><label>").append(parameter.getDescription()).append("</label></div>");
                    }
                    result.append("</div>");
                    continue;
                }
                result.append("<li>").append(WorkflowRenderer.encodeValueToHtml(parameter.getFriendlyNameAndName()));
                if (parameter.getDescription() != null && !parameter.getDescription().trim().equals("")) {
                    result.append(": ").append(WorkflowRenderer.encodeValueToHtml(parameter.getDescription()));
                }
                result.append("</li>");
            }
        }
        result.append("</ul></td></tr>");
        return result.toString();
    }

    private static String encodeValueToHtml(String optionValue) {
        Object result = StringEscapeUtils.escapeHtml4((String)optionValue);
        if (((String)result).contains("\n")) {
            result = "<pre>" + (String)result + "</pre>";
        } else {
            Matcher matcher = parameterPattern.matcher((CharSequence)result);
            result = matcher.replaceAll("<span class=\"parameter\">$1</span>");
        }
        return result;
    }

    public static Object getCollectionRepresentationText(Object[] c, String fieldName, int nestingLevel, List<Object> fieldValuePrintableOption) {
        int size = c.length;
        if (size == 0) {
            return null;
        }
        return WorkflowRenderer.getIterableRepresentationText(Arrays.asList(c), fieldName, nestingLevel, fieldValuePrintableOption);
    }

    public static Object getCollectionRepresentationText(Collection c, String fieldName, int nestingLevel, List<Object> fieldValuePrintableOption) {
        int size = c.size();
        if (size == 0) {
            return null;
        }
        return WorkflowRenderer.getIterableRepresentationText(c, fieldName, nestingLevel, fieldValuePrintableOption);
    }

    public static Object getIterableRepresentationText(Collection collection, String fieldName, int nestingLevel, List<Object> fieldValuePrintableOption) {
        ArrayList<String> singularItem = new ArrayList<String>();
        for (Object collectionValue : collection) {
            if (collectionValue == null) continue;
            Object value = collectionValue instanceof Object[] ? WorkflowRenderer.getCollectionRepresentationText((Object[])collectionValue, fieldName, nestingLevel + 1, fieldValuePrintableOption) : (collectionValue instanceof Collection ? WorkflowRenderer.getCollectionRepresentationText((Collection)collectionValue, fieldName, nestingLevel + 1, fieldValuePrintableOption) : (collectionValue instanceof Boolean ? (((Boolean)collectionValue).booleanValue() ? iu.getString("Options.Yes") : iu.getString("Options.No")) : collectionValue.toString()));
            if (!(value instanceof String) || value.toString().length() <= 0) continue;
            singularItem.add(value.toString());
        }
        if (singularItem.size() > 0) {
            if (fieldName != null && nestingLevel == 1) {
                String singularFieldName = WorkflowRenderer.fieldNameToSingularItem(fieldName);
                ArrayList<Object> header = new ArrayList<Object>();
                header.add(singularFieldName);
                header.add(singularItem);
                fieldValuePrintableOption.add(header);
            } else {
                fieldValuePrintableOption.add(singularItem);
            }
        }
        if (fieldValuePrintableOption.size() > 0) {
            return fieldValuePrintableOption;
        }
        return null;
    }

    public static List<PrintableOption> getOperationPrintableOptions(Operation operation, boolean verbose, boolean includeSensitiveOptions) {
        ArrayList<PrintableOption> options = new ArrayList<PrintableOption>();
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method method : operation.getClass().getMethods()) {
            methods.put(method.getName(), method);
        }
        if (operation.disabled) {
            options.add(new PrintableOption(null, null, (Object)iu.getString("Options.Disabled")));
        }
        if (operation.enableFieldOverwrite) {
            options.add(new PrintableOption(null, null, (Object)iu.getString("Options.EnableFieldOverwrite")));
        }
        if (Boolean.TRUE.equals(operation.softFail)) {
            options.add(new PrintableOption(null, null, (Object)iu.getString("Options.SoftFail")));
        }
        if (Boolean.TRUE.equals(operation.suppressWarnings)) {
            options.add(new PrintableOption(null, null, (Object)iu.getString("Options.SuppressWarnings")));
        }
        if (operation.skippable) {
            options.add(new PrintableOption(null, null, (Object)iu.getString("Options.Skippable")));
        }
        for (AccessibleObject accessibleObject : operation.getClass().getFields()) {
            try {
                Object fieldValueRepresentation;
                String localizedFieldName;
                String getDisplayMethodName;
                String fieldName;
                int fieldModifiers = ((Field)accessibleObject).getModifiers();
                if (Modifier.isTransient(fieldModifiers) || Modifier.isStatic(fieldModifiers) || Modifier.isPrivate(fieldModifiers) || Modifier.isProtected(fieldModifiers) || (fieldName = ((Field)accessibleObject).getName()).equals("disabled") || fieldName.equals("softFail") || fieldName.equals("skippable") || fieldName.equals("notes") || fieldName.equals("printableOptions") || fieldName.equals("enableFieldOverwrite") || !includeSensitiveOptions && ((Field)accessibleObject).getAnnotation(SensitiveField.class) != null) continue;
                if (!verbose && methods.containsKey(getDisplayMethodName = "getDisplay" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1))) {
                    Method getDisplayMethod = (Method)methods.get(getDisplayMethodName);
                    try {
                        Object result = getDisplayMethod.invoke((Object)operation, new Object[0]);
                        if (result != null && result.equals(false)) {
                            continue;
                        }
                    }
                    catch (InvocationTargetException result) {
                        // empty catch block
                    }
                }
                if ((localizedFieldName = iu.getString("Options." + fieldName)).trim().length() == 0) continue;
                fieldName = localizedFieldName;
                Object fieldValue = ((Field)accessibleObject).get(operation);
                if (fieldValue == null) {
                    if (!verbose) continue;
                    fieldValue = "";
                }
                if (fieldValue instanceof Boolean) {
                    fieldValue = (Boolean)fieldValue != false ? iu.getString("Options.Yes") : iu.getString("Options.No");
                }
                if (fieldValue.toString().equals("") && !verbose) continue;
                PrintableOptionStyle style = null;
                if (fieldValue instanceof Object[]) {
                    fieldValueRepresentation = WorkflowRenderer.getCollectionRepresentationText((Object[])fieldValue, fieldName, 0, new ArrayList<Object>());
                } else if (fieldValue instanceof Collection) {
                    fieldValueRepresentation = WorkflowRenderer.getCollectionRepresentationText((Collection)fieldValue, fieldName, 0, new ArrayList<Object>());
                } else {
                    fieldValueRepresentation = fieldValue.toString();
                    if (fieldValue.toString().contains("\n")) {
                        style = PrintableOptionStyle.CODE;
                    }
                }
                if (fieldValueRepresentation == null) continue;
                options.add(new PrintableOption(fieldName, style, fieldValueRepresentation));
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Unexpected error", (Throwable)e);
            }
        }
        return options;
    }

    private static String getOperationOptionsReport(Operation operation, boolean verbose) {
        StringBuilder htmlReport = new StringBuilder();
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method method : operation.getClass().getMethods()) {
            methods.put(method.getName(), method);
        }
        if (operation.disabled) {
            htmlReport.append("<div class=\"operation-disabled\">" + iu.getString("Options.Disabled") + "</div>");
        }
        if (Boolean.TRUE.equals(operation.softFail)) {
            htmlReport.append("<div class=\"operation-softFail\">" + iu.getString("Options.SoftFail") + "</div>");
        }
        if (Boolean.TRUE.equals(operation.suppressWarnings)) {
            htmlReport.append("<div class=\"operation-suppressWarnings\">" + iu.getString("Options.SuppressWarnings") + "</div>");
        }
        if (Boolean.TRUE.equals(operation.enableFieldOverwrite)) {
            htmlReport.append("<div class=\"operation-softFail\">" + iu.getString("Options.EnableFieldOverwrite") + "</div>");
        }
        if (operation.skippable) {
            htmlReport.append("<div class=\"operation-skippable\">" + iu.getString("Options.SoftFail") + "</div>");
        }
        if (operation.notes != null && operation.notes.length() > 0) {
            htmlReport.append("<table class=\"settings\"><tr><td>Notes: </td><td class=\"notes\">" + WorkflowRenderer.encodeValueToHtml(operation.notes.trim()) + "</td></tr></table>");
        }
        for (AccessibleObject accessibleObject : operation.getClass().getFields()) {
            try {
                String localizedFieldName;
                String getDisplayMethodName;
                String fieldName;
                int fieldModifiers = ((Field)accessibleObject).getModifiers();
                if (Modifier.isTransient(fieldModifiers) || Modifier.isStatic(fieldModifiers) || Modifier.isPrivate(fieldModifiers) || Modifier.isProtected(fieldModifiers) || (fieldName = ((Field)accessibleObject).getName()).equals("disabled") || fieldName.equals("skippable") || fieldName.equals("softFail") || fieldName.equals("enableFieldOverwrite") || fieldName.equals("notes") || fieldName.equals("printableOptions")) continue;
                if (!verbose && methods.containsKey(getDisplayMethodName = "getDisplay" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1))) {
                    Method getDisplayMethod = (Method)methods.get(getDisplayMethodName);
                    try {
                        Object result = getDisplayMethod.invoke((Object)operation, new Object[0]);
                        if (result != null && result.equals(false)) {
                            continue;
                        }
                    }
                    catch (InvocationTargetException result) {
                        // empty catch block
                    }
                }
                if ((localizedFieldName = iu.getString("Options." + fieldName)).trim().length() == 0) continue;
                fieldName = localizedFieldName;
                Object fieldValue = ((Field)accessibleObject).get(operation);
                if (fieldValue == null) {
                    if (!verbose) continue;
                    fieldValue = "";
                }
                if (fieldValue instanceof Boolean) {
                    fieldValue = (Boolean)fieldValue != false ? iu.getString("Options.Yes") : iu.getString("Options.No");
                }
                if (fieldValue.toString().equals("") && !verbose) continue;
                String fieldValueRepresentation = fieldValue instanceof Object[] ? WorkflowRenderer.getCollectionRepresentation((Object[])fieldValue, fieldName, 0) : (fieldValue instanceof Collection ? WorkflowRenderer.getCollectionRepresentation((Collection)fieldValue, fieldName, 0) : WorkflowRenderer.encodeValueToHtml(fieldValue.toString()));
                String tdClass = "";
                if (fieldValueRepresentation.contains("\n")) {
                    tdClass = " class=\"multiline\"";
                }
                if (fieldValueRepresentation.length() <= 0) continue;
                htmlReport.append("<table class=\"settings\"><tr><td>" + WorkflowRenderer.encodeValueToHtml(fieldName) + ": </td><td" + tdClass + ">" + fieldValueRepresentation + "</td></tr></table>");
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Unexpected error", (Throwable)e);
            }
        }
        return htmlReport.toString();
    }
}

