/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.workflow;

import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.IdEncryptor;
import com.nuix.automate.utils.security.LegacyIdEncryptor;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WorkflowStub
implements Serializable {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowStub.class);
    private static InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private static final transient String OPAQUE_KEY = "abc69e38-02ec-46eb-8481-dfbb61630b5b";
    private String producerName;
    private String producerVersion;

    public WorkflowStub(String producerName, String producerVersion) {
        this.producerName = producerName;
        this.producerVersion = producerVersion;
    }

    private static WorkflowStub parseXml(String xml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(xml));
        Document doc = db.parse(inputSource);
        doc.getDocumentElement().normalize();
        Node workflowNode = doc.getElementsByTagName("workflow").item(0);
        Element workflowElement = (Element)workflowNode;
        String producerName = workflowElement.getElementsByTagName("producerName").item(0).getTextContent();
        String producerVersion = workflowElement.getElementsByTagName("producerVersion").item(0).getTextContent();
        return new WorkflowStub(producerName, producerVersion);
    }

    public static WorkflowStub fromXml(String xml) throws IOException {
        String encryptedWorkflow;
        WorkflowStub workflow;
        block9: {
            String decryptedWorkflow;
            IdEncryptor encryptor;
            block8: {
                workflow = null;
                encryptedWorkflow = xml;
                try {
                    encryptor = new IdEncryptor(OPAQUE_KEY);
                    decryptedWorkflow = encryptor.decrypt(encryptedWorkflow);
                    workflow = WorkflowStub.parseXml(decryptedWorkflow);
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block8;
                    LOGGER.debug("Cannot deserialize workflow as Opaque");
                }
            }
            if (workflow == null) {
                try {
                    encryptor = new LegacyIdEncryptor(OPAQUE_KEY);
                    decryptedWorkflow = encryptor.decrypt(encryptedWorkflow);
                    workflow = WorkflowStub.parseXml(decryptedWorkflow);
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block9;
                    LOGGER.debug("Cannot deserialize workflow as Legacy Opaque");
                }
            }
        }
        if (workflow == null) {
            try {
                workflow = WorkflowStub.parseXml(encryptedWorkflow);
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new IOException(e);
            }
        }
        return workflow;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public String getProducerVersion() {
        return this.producerVersion;
    }

    public void setProducerVersion(String producerVersion) {
        this.producerVersion = producerVersion;
    }
}

