/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.licence;

import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.LicenceFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Format;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.nuix.NuixLicenceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nuix.Licence;

public class NuixLicenceFactory
extends LicenceFactory {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NuixLicenceFactory.class);
    private transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private static NuixLicenceFactory instance;
    private Licence nuixLicence;
    private Set<String> softwareSysIds = null;
    private Map<Format, String> softwareDetails = new HashMap<Format, String>();
    private String nuixLicenceId;

    public static NuixLicenceFactory getInstance() {
        return NuixLicenceFactory.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NuixLicenceFactory getInstance(ExecutionContext executionContext) {
        Class<NuixLicenceFactory> clazz = NuixLicenceFactory.class;
        synchronized (NuixLicenceFactory.class) {
            if (instance == null) {
                instance = new NuixLicenceFactory();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (executionContext != null && NuixLicenceFactory.instance.nuixLicence == null && executionContext.nuixUtilities != null) {
                NuixLicenceFactory.instance.nuixLicence = executionContext.nuixUtilities.getLicence();
            }
            return instance;
        }
    }

    public Set<String> getSoftwareSysIds() {
        if (this.softwareSysIds == null) {
            this.softwareSysIds = NuixLicenceUtils.getLicenceFingerprint(this.nuixLicence);
            LOGGER.info("Software IDs: " + SerializationUtils.toJson(this.softwareSysIds));
        }
        return this.softwareSysIds;
    }

    public String getSoftwareDetails() {
        return this.getSoftwareDetails(Format.TEXT);
    }

    public String getSoftwareDetails(Format format) {
        if (this.softwareDetails.get(format) == null) {
            this.softwareDetails.put(format, NuixLicenceUtils.getLicenceDetails(this.nuixLicence, format));
            LOGGER.info("Software details: " + String.valueOf(this.softwareDetails));
        }
        return this.softwareDetails.get(format);
    }

    public void setNuixLicence(Licence nuixLicence) {
        this.nuixLicence = nuixLicence;
        this.softwareSysIds = null;
        this.softwareDetails.clear();
    }

    public Licence getNuixLicence() {
        return this.nuixLicence;
    }

    public String getNuixLicenceId() {
        if (this.nuixLicenceId == null) {
            Map licenseProperties = (Map)SerializationUtils.fromJson((String)this.getSoftwareDetails(Format.JSON), Map.class);
            this.nuixLicenceId = String.valueOf(licenseProperties.get("id"));
            String[] splits = this.nuixLicenceId.split("@");
            this.nuixLicenceId = splits[splits.length - 1];
        }
        return this.nuixLicenceId;
    }
}

