/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.licence;

import com.nuix.automate.utils.licence.services.LicenceSession;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.workflow.core.execution.operations.MimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecutionEvent;

public class UtilizationUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UtilizationUtils.class);

    public static void trackSessionVolumes(LicenceSession licenceSession, WorkflowExecution workflowExecution, WorkflowExecutionEvent workflowExecutionEvent, Operation operation, boolean operationIsLast) {
        if (operation instanceof MimeTypeVolumesUtilizationOperation) {
            try {
                MimeTypeVolumesUtilizationOperation mimeTypeVolumesUtilizationOperation = (MimeTypeVolumesUtilizationOperation)operation;
                Activity activity = mimeTypeVolumesUtilizationOperation.getActivity();
                if (activity != null) {
                    long volumeBytes = mimeTypeVolumesUtilizationOperation.getVolume(workflowExecution);
                    licenceSession.trackMetricsAsync(activity, volumeBytes);
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot handle operation utilization", (Throwable)e);
            }
        }
    }

    public static void trackConsumption(LicenceSession licenceSession, Operation operation) {
        Consumption consumption = operation.getOperationConsumption();
        if (consumption != null) {
            LOGGER.info("Tracking consumption");
            licenceSession.trackConsumptionAsync(consumption);
        }
    }
}

