/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.licence;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.services.Credentials;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.Product;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.Client;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.Engine;
import com.nuix.automate.utils.utilization.ExecutionProfile;
import com.nuix.automate.utils.utilization.Job;
import com.nuix.automate.utils.utilization.Key;
import com.nuix.automate.utils.utilization.Library;
import com.nuix.automate.utils.utilization.Matter;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.NuixCase;
import com.nuix.automate.utils.utilization.ResourcePool;
import com.nuix.automate.utils.utilization.Server;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.Workflow;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.LogLevel;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.Parameters;
import com.nuix.automate.workflow.core.execution.operations.CloseCaseOperation;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.UseCaseOperation;
import com.nuix.automate.workflow.core.execution.operations.UseCaseOperationImplementation;
import com.nuix.automate.workflow.core.execution.workflow.UserCancelledException;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecutionEvent;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecutionListener;
import com.nuix.automate.workflow.core.licence.WorkflowLicenceSession;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.general.OsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixCaseUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.TimeZone;
import nuix.Licence;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class WorkflowExecutionLicenceSession
extends WorkflowLicenceSession {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowExecutionLicenceSession.class);
    private WorkflowExecution workflowExecution;
    private NuixCase nuixCase;
    private Job job;
    private WorkflowExecutionListener licenseExecutionListener;
    private Key key;

    public WorkflowExecutionLicenceSession(final WorkflowExecution workflowExecution, ExecutionContext executionContext, Credentials credentials, LicenceInfo licenceInfo, Licence nuixLicence, Product product, String productVersion, String nuixVersion, Key key, DiagnosticLevel diagnosticLevel) {
        super(executionContext, credentials, licenceInfo, nuixLicence, product, productVersion, nuixVersion, key, diagnosticLevel);
        this.workflowExecution = workflowExecution;
        this.key = key;
        this.licenseExecutionListener = new WorkflowExecutionListener(){

            @Override
            public void beforeWorkflowExecutionInitialized(WorkflowExecutionEvent workflowExecutionEvent) {
            }

            @Override
            public void workflowExecutionInitialized(WorkflowExecutionEvent workflowExecutionEvent) {
            }

            @Override
            public void workflowExecutionStateChanged(WorkflowExecutionEvent workflowExecutionEvent, ExecutionState executionState) {
            }

            @Override
            public void workflowExecutionProgress(WorkflowExecutionEvent workflowExecutionEvent, int operationWithProgressPosition) {
            }

            @Override
            public void workflowExecutionPrerequisiteError(WorkflowExecutionEvent workflowExecutionEvent, String errorTitle, String errorMessage, String detailedHtmlErrorMessage, Exception e) {
            }

            @Override
            public void workflowExecutionLog(WorkflowExecutionEvent workflowExecutionEvent, String logMessage, LogLevel logLevel) {
            }

            @Override
            public void beforeOperationStart(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) {
            }

            @Override
            public void afterOperationSkipped(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) {
            }

            private void handleNuixCase(Operation operation) {
                if (operation instanceof UseCaseOperation || workflowExecution.getExecutionContext().nuixCase != null) {
                    if (WorkflowExecutionLicenceSession.this.nuixCase == null) {
                        WorkflowExecutionLicenceSession.this.nuixCase = new NuixCase();
                        WorkflowExecutionLicenceSession.this.nuixCase.setNuixCaseName(workflowExecution.getExecutionContext().nuixCase.getName());
                        WorkflowExecutionLicenceSession.this.nuixCase.setNuixCaseId(workflowExecution.getExecutionContext().nuixCase.getGuid());
                        WorkflowExecutionLicenceSession.this.nuixCase.setNuixCaseLocation(workflowExecution.getExecutionContext().nuixCase.getLocation().getAbsolutePath());
                        WorkflowExecutionLicenceSession.this.nuixCase.setNuixCaseVersion(NuixCaseUtils.getNuixCaseVersion(workflowExecution.getExecutionContext().nuixCase.getLocation().getAbsolutePath()));
                        if (operation instanceof UseCaseOperationImplementation) {
                            UseCaseOperationImplementation useCaseOperation = (UseCaseOperationImplementation)operation;
                            WorkflowExecutionLicenceSession.this.nuixCase.setNuixCaseCreationEpoch(useCaseOperation.getCaseCreationEpoch());
                        } else {
                            WorkflowExecutionLicenceSession.this.nuixCase.setNuixCaseCreationEpoch(NuixCaseUtils.getNuixCaseCreationTime(WorkflowExecutionLicenceSession.this.nuixCase.getNuixCaseLocation()));
                        }
                    }
                    if (operation.getModifiesNuixCase()) {
                        WorkflowExecutionLicenceSession.this.nuixCase.setNuixCaseLastModifiedEpoch(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
                    }
                    WorkflowExecutionLicenceSession.this.tryTrackNuixCaseAsync(WorkflowExecutionLicenceSession.this.nuixCase);
                }
            }

            @Override
            public void afterOperationFinish(WorkflowExecutionEvent workflowExecutionEvent, Operation operation, boolean operationIsLast) {
                com.nuix.automate.utils.utilization.Operation operationUtilization;
                this.handleNuixCase(operation);
                if (operation instanceof ConfigureParametersOperation) {
                    ConfigureParametersOperation configureParametersOperation = (ConfigureParametersOperation)operation;
                    if (configureParametersOperation.userParameters != null && configureParametersOperation.userParameters.size() > 0) {
                        for (Parameter parameter : configureParametersOperation.userParameters) {
                            try {
                                WorkflowExecutionLicenceSession.this.job.getJobParameters().put(parameter.getName(), parameter.getValue());
                            }
                            catch (ParameterException e) {
                                LOGGER.warn("Cannot evaluate parameter " + parameter.getName());
                            }
                        }
                    }
                }
                if ((operationUtilization = operation.getOperationUtilization(WorkflowExecutionLicenceSession.this.getId())).getMimeTypeVolumes() != null) {
                    for (MimeTypeVolume mimeTypeVolume : operationUtilization.getMimeTypeVolumes()) {
                        mimeTypeVolume.setOperationId(operationUtilization.getOperationId());
                    }
                }
                if (WorkflowExecutionLicenceSession.this.nuixCase != null) {
                    operationUtilization.setNuixCaseId(WorkflowExecutionLicenceSession.this.nuixCase.getNuixCaseId());
                }
                WorkflowExecutionLicenceSession.this.tryTrackOperationUtilizationAsync(operationUtilization);
                if (operation instanceof CloseCaseOperation) {
                    WorkflowExecutionLicenceSession.this.nuixCase = null;
                }
                WorkflowExecutionLicenceSession.this.handleJobProgress(false);
            }

            @Override
            public void afterOperationError(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) {
                this.handleNuixCase(operation);
                com.nuix.automate.utils.utilization.Operation operationUtilization = operation.getOperationUtilization(WorkflowExecutionLicenceSession.this.getId());
                operationUtilization.setMimeTypeVolumes(null);
                operationUtilization.setUtilizationRecords(null);
                if (WorkflowExecutionLicenceSession.this.nuixCase != null) {
                    operationUtilization.setNuixCaseId(WorkflowExecutionLicenceSession.this.nuixCase.getNuixCaseId());
                }
                WorkflowExecutionLicenceSession.this.tryTrackOperationUtilizationAsync(operationUtilization);
            }

            @Override
            public void onOperationWarning(WorkflowExecutionEvent workflowExecutionEvent, Operation operation, String message) {
            }

            @Override
            public void onConfigurationPrompt(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) {
            }

            @Override
            public void onUseCasePrompt(WorkflowExecutionEvent workflowExecutionEvent, ExecutionContext context, Operation operation) throws UserCancelledException {
            }
        };
        workflowExecution.addWorkflowExecutionListener(this.licenseExecutionListener);
    }

    public synchronized void startSchedule() {
        Server server = new Server();
        server.setServerName(OsUtils.getComputerName());
        server.setServerId(UidUtils.fromString((String)(OsUtils.getComputerName() + OsUtils.getSerialNumber()), (String)"server", (String)this.key.getId()).toString());
        Engine engine = new Engine();
        engine.setEngineName(OsUtils.getComputerName());
        engine.setEngineId(UidUtils.fromString((String)(OsUtils.getComputerName() + OsUtils.getSerialNumber()), (String)"engine", (String)this.key.getId()).toString());
        engine.setServerId(server.getServerId());
        ResourcePool resourcePool = new ResourcePool();
        resourcePool.setResourcePoolName(OsUtils.getComputerName());
        resourcePool.setResourcePoolId(UidUtils.fromString((String)(OsUtils.getComputerName() + OsUtils.getSerialNumber()), (String)"resourcePool", (String)this.key.getId()).toString());
        Client client = new Client();
        client.setClientName("_Undefined");
        client.setClientId(UidUtils.fromString((String)"_Undefined", (String)"client").toString());
        Matter matter = new Matter();
        matter.setMatterName("_Undefined");
        matter.setMatterId(UidUtils.fromString((String)"_Undefined", (String)"matter").toString());
        matter.setClientId(client.getClientId());
        Library library = new Library();
        library.setLibraryName(new File(this.workflowExecution.getWorkflowFilename()).getParentFile().getAbsolutePath());
        library.setLibraryId(UidUtils.fromString((String)"_Undefined", (String)"library").toString());
        Workflow workflow = new Workflow();
        workflow.setWorkflowName(this.workflowExecution.getWorkflow().getName());
        try {
            workflow.setWorkflowId(UidUtils.fromString((String)this.workflowExecution.getWorkflowXml()).toString());
        }
        catch (IOException e) {
            workflow.setWorkflowId(UidUtils.getRandom());
        }
        workflow.setLibraryId(library.getLibraryId());
        ExecutionProfile executionProfile = new ExecutionProfile();
        executionProfile.setExecutionProfileName("_Undefined");
        executionProfile.setExecutionProfileId(UidUtils.fromString((String)"_Undefined", (String)"executionProfile").toString());
        User user = new User();
        user.setUserName(OsUtils.getUserName().toLowerCase());
        user.setUserTimeZone(TimeZone.getDefault().getID());
        user.setUserId(User.getIdFromName((String)user.getUserName(), (String)this.key.getSecret()));
        this.job = new Job();
        this.job.setJobId(UidUtils.getRandom());
        this.job.setEngineId(engine.getEngineId());
        this.job.setExecutionProfileId(executionProfile.getExecutionProfileId());
        this.job.setJobExecutionState(ExecutionState.RUNNING);
        this.job.setJobName(this.workflowExecution.getWorkflow().getName());
        this.job.setJobPercentageComplete(1.0E-4);
        this.job.setJobSubmissionEpoch(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        this.job.setJobStartEpoch(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        this.job.setMatterId(matter.getMatterId());
        this.job.setResourcePoolId(resourcePool.getResourcePoolId());
        this.job.setJobSubmittedByUserId(user.getUserId());
        this.job.setWorkflowId(workflow.getWorkflowId());
        HashMap<String, String> jobParameters = new HashMap<String, String>();
        Parameters parameters = this.workflowExecution.getExecutionContext().getSessionConfigParameters();
        for (Parameter parameter : parameters.getParameters()) {
            try {
                jobParameters.put(parameter.getName(), parameter.getValue());
            }
            catch (ParameterException parameterException) {}
        }
        this.job.setJobParameters(jobParameters);
        super.startSchedule();
        this.tryTrackJobStartAsync(client, matter, library, workflow, server, engine, resourcePool, executionProfile, this.job, user);
    }

    private void handleJobProgress(boolean jobFinished) {
        if (jobFinished) {
            this.job.setJobEndEpoch(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        }
        this.job.setJobPercentageComplete(this.workflowExecution.getPercentageComplete());
        this.job.setJobExecutionState(this.workflowExecution.getExecutionState());
        this.job.setJobHasErrors(Boolean.valueOf(this.workflowExecution.getHasErrors()));
        this.job.setJobHasSoftErrors(Boolean.valueOf(this.workflowExecution.getHasSoftErrors()));
        this.job.setJobHasWarnings(Boolean.valueOf(this.workflowExecution.getHasWarnings()));
        this.tryTrackJobUpdateAsync(this.job);
    }

    public synchronized void close() {
        this.handleJobProgress(true);
        if (this.licenseExecutionListener != null) {
            this.workflowExecution.removeWorkflowExecutionListener(this.licenseExecutionListener);
        }
        super.close();
    }

    @Override
    public EventInfo getSessionStartEvent() {
        EventInfo eventInfo = super.getSessionStartEvent();
        if (this.job != null) {
            eventInfo.getProperties().put("jobId", this.job.getJobId());
        }
        return eventInfo;
    }
}

