/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.nuix;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.exceptions.ParameterNotDefinedException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.Licence;
import com.nuix.automate.utils.licence.LicenceFactory;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenceValidationException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.LicenceSession;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.job.RemoteWorkersSpecModel;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.Parameters;
import com.nuix.automate.utils.workflow.PreDefinedStaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.RecursiveParameterException;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.configuration.KeystoreFile;
import com.nuix.automate.workflow.core.execution.parameters.LastBatchLoadDateParameter;
import com.nuix.automate.workflow.core.execution.parameters.LastBatchLoadDateTimeLocalParameter;
import com.nuix.automate.workflow.core.execution.parameters.LastBatchLoadDateTimeParameter;
import com.nuix.automate.workflow.core.execution.parameters.LastBatchLoadGuidParameter;
import com.nuix.automate.workflow.core.execution.parameters.LastEvidenceGuidParameter;
import com.nuix.automate.workflow.core.execution.parameters.LastEvidenceNameParameter;
import com.nuix.automate.workflow.core.execution.parameters.LastItemSetBatchParameter;
import com.nuix.automate.workflow.core.execution.parameters.LastItemSetDuplicatesBatchParameter;
import com.nuix.automate.workflow.core.execution.parameters.LastItemSetNameParameter;
import com.nuix.automate.workflow.core.execution.parameters.LastItemSetOriginalsBatchParameter;
import com.nuix.automate.workflow.core.execution.parameters.LastProductionSetNameParameter;
import com.nuix.automate.workflow.core.execution.workflow.DynamicParameter;
import com.nuix.automate.workflow.core.execution.workflow.Engine;
import com.nuix.automate.workflow.core.execution.workflow.ExecutionStateDynamicParameter;
import com.nuix.automate.workflow.core.execution.workflow.UndefinedParameter;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import nuix.Case;
import nuix.CaseNotesStore;
import nuix.Utilities;
import nuix.Window;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ExecutionContext {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ExecutionContext.class);
    private static final int MAX_PARAMETER_NESTING = 100;
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    public static final Set<String> jobBuiltInParameters = new HashSet<String>(Arrays.asList("{job_name}", "{job_notes}", "{job_id}", "{job_id_short}", "{job_resource_pool_id}", "{job_resource_pool_name}", "{job_execution_profile_id}", "{job_execution_profile_name}", "{job_priority}", "{job_submitted_by}", "{job_submitted_date}", "{job_engine_id}", "{job_engine_name}", "{job_server_id}", "{job_server_name}"));
    private static final Set<String> builtInParameters = new HashSet<String>(Arrays.asList("{case_name}", "{case_folder}", "{previous_case_folder}", "{first_case_folder}", "{case_prefix}", "{last_case_name}", "{last_case_folder}", "{last_case_guid}", "{last_production_set_name}", "{last_docid_start_numbering_at}", "{last_box_start_at}", "{last_folder_start_at}", "{last_page_start_at}", "{last_word_list_export_file}", "{last_evidence_guid}", "{last_evidence_name}", "{last_item_set_name}", "{last_item_set_batch}", "{last_item_set_originals_batch}", "{last_item_set_duplicates_batch}", "{last_export_folder}", "{last_metadata_export_file}", "{last_report_file}", "{last_batch_load_guid}", "{last_batch_load_date}", "{last_batch_load_date_time}", "{last_batch_load_date_time_local}", "{last_failed_items_tag_name}", "{last_script_output}", "{last_script_error}", "{last_script_return_value}", "{last_exit_code}", "{operation_name}", "{operation_position}", "{last_operation_position}", "{last_operation_name}", "{export_production_set_name}", "{workflow_name}", "{workflow_log}", "{workflow_state}", "{workflow_status}", "{simple_style_html}", "{automate_logo_html}", "{rampiva_logo_html}", "{workflow_status_html}", "{wfn_use_configuration_profile}", "{wfn_processing_profile_name}", "{wfn_relativity_service_endpoint}", "{wfn_relativity_hostname}", "{wfn_relativity_username}", "{wfn_relativity_password}", "{wfn_relativity_folder_path}", "{wfn_relativity_endpoint_type}", "{wfn_relativity_whitelisted_cert_fingerprints}", "{wfn_relativity_import_threads}", "{wfn_relativity_import_thread_timeout}", "{wfn_relativity_import_thread_retries}", "{wfn_relativity_patch_invalid_entries}", "{wfn_relativity_metadata_threads}", "{wfn_relativity_client_version}", "{wfn_relativity_rest_version}", "{wfn_relativity_instance_id}", "{wfn_relativity_authentication_method}", "{wfn_graph_service_id}", "{wfn_memgraph_playbook_file}", "{wfn_memgraph_transaction_size}", "{wfn_memgraph_url}", "{wfn_memgraph_username}", "{wfn_memgraph_password}", "{wfn_gen_ai_service_id}", "{wfn_gen_ai_override_model}", "{wfn_gen_ai_model}", "{wfn_gen_ai_url}", "{wfn_gen_ai_model}", "{wfn_gen_ai_api_token_protected}", "{wfn_gen_ai_api_disable_system_role}", "{wfn_gen_ai_api_authentication_method}", "{wfn_gen_ai_custom_parameters}", "{wfn_semantic_service_url}", "{wfn_semantic_service_name}", "{wfn_semantic_text_model}", "{wfn_semantic_image_model}", "{wfn_semantic_detect_faces}", "{wfn_semantic_transcription_model}", "{wfn_nlp_service_id}", "{wfn_nlp_url}", "{wfn_nlp_feeds_url}", "{wfn_nlp_jobs_url}", "{wfn_nlp_api_token_protected}", "{wfn_nlp_whitelisted_cert_fingerprints}", "{wfn_discover_hostname}", "{wfn_discover_api_token_protected}", "{wfn_discover_whitelisted_cert_fingerprints}", "{wfn_discover_file_repository_type}", "{wfn_discover_windows_file_repository}", "{wfn_native_ocr_workers_assignment_mode}", "{wfn_native_ocr_predetermined_worker_count}", "{wfn_native_ocr_workers_per_cpu_core}", "{wfn_native_ocr_engine_binaries_folder}", "{wfn_native_ocr_user_words_file}", "{wfn_native_ocr_user_patterns_file}", "{wfn_native_ocr_dpi}", "{wfn_native_ocr_rasterize_pdf_dpi}", "{wfn_native_ocr_log_level}", "{wfn_native_ocr_languages}", "{wfn_native_ocr_psm}", "{wfn_native_ocr_oem}", "{wfn_native_ocr_engine_config_file}", "{wfn_native_ocr_timeout_per_file}", "{wfn_native_ocr_temp_folder}", "{wfn_native_ocr_dont_clear_temp}", "{wfn_native_ocr_deskew}", "{wfn_native_ocr_rotate}", "{discover_case_name}", "{discover_case_id}", "{discover_version}", "{wfn_brainspace_api_url}", "{wfn_brainspace_api_key_protected}", "{wfn_brainspace_api_certificate_fingerprint}", "{wfn_es_host}", "{wfn_es_port}", "{wfn_es_username}", "{wfn_es_password}", "{wfn_es_certificateFingerprint}", "{wfn_es_bulk_operations_count}", "{es_version}", "{brainspace_version}", "{brainspace_dataset_id}", "{brainspace_dataset_name}", "{date_time_local}", "{date_local}", "{date_time}", "{date_time_epoch}", "{date}", "{time}", "{date_time_spreadsheet}", "{date_spreadsheet}", "{time_spreadsheet}", "{start_date_time_local}", "{start_date_local}", "{start_date_time}", "{start_date_time_epoch}", "{start_date}", "{start_time}", "{start_date_time_spreadsheet}", "{start_date_spreadsheet}", "{start_time_spreadsheet}", "{job_name}", "{job_notes}", "{job_id}", "{job_id_short}", "{job_resource_pool_id}", "{job_resource_pool_name}", "{job_execution_profile_id}", "{job_execution_profile_name}", "{job_priority}", "{job_submitted_by}", "{job_submitted_date}", "{job_engine_id}", "{job_engine_name}", "{job_execution_log}", "{job_server_id}", "{job_server_name}", "{job_worker_broker_port}", "{job_worker_broker_ip}", "{server_name}", "{server_fqdn}", "{matter_name}", "{matter_reference}", "{matter_id}", "{client_name}", "{client_reference}", "{client_id}", "{scheduler_url}", "{scheduler_cert_fingerprint}", "{job_bearer_token_protected}", "{random_guid}", "{relativity_client_name}", "{relativity_client_id}", "{relativity_client_created}", "{relativity_matter_name}", "{relativity_matter_id}", "{relativity_matter_created}", "{relativity_workspace_name}", "{relativity_workspace_id}", "{relativity_workspace_created}", "{last_arm_archive_path}", "{call_api_response_code}", "{call_api_response_headers}", "{call_api_response_body}", "{powershell_parameters}", "{last_group_permissions_file}", "{relativity_search_term_results_json}", "{case_or_workspace_name}", "{relativity_saved_searches_file}", "{last_overwritten_permissions_file}", "{relativity_call_api_response_code}", "{relativity_call_api_response_headers}", "{relativity_call_api_response_body}", "{relativity_run_saved_search_results_json}", "{purview_service_id}", "{purview_whitelisted_cert_fingerprints}", "{purview_case_id}", "{purview_case_name}", "{purview_case_status}", "{purview_case_created}", "{purview_case_reopened}", "{purview_case_closed}", "{purview_case_deleted}", "{purview_case_settings}", "{purview_custodian_ids}", "{purview_custodian_emails}", "{purview_custodial_data_source_ids}", "{purview_custodial_data_source_odata_ids}", "{purview_user_teams_json}", "{purview_released_custodian_ids}", "{purview_non_custodial_data_source_ids}", "{purview_non_custodial_data_source_odata_ids}", "{purview_released_non_custodial_data_source_ids}", "{purview_apply_hold_to_custodians_job_id}", "{purview_remove_hold_from_custodians_job_id}", "{purview_apply_hold_to_non_custodial_data_sources_job_id}", "{purview_remove_hold_to_non_custodial_data_sources_job_id}", "{purview_search_id}", "{purview_search_name}", "{purview_search_created}", "{purview_search_deleted}", "{purview_review_set_id}", "{purview_review_set_name}", "{purview_review_set_created}", "{purview_review_set_query_id}", "{purview_review_set_query_name}", "{purview_review_set_query_created}", "{purview_review_set_query_deleted}", "{purview_estimate_statistics_job_id}", "{purview_add_to_review_set_job_id}", "{purview_export_job_id}", "{purview_export_job_download_location}", "{purview_custodians}", "{purview_custodial_data_sources}", "{purview_non_custodial_data_sources}", "{azure_storage_account_url}", "{azure_storage_account_name}", "{azure_storage_account_key_protected}", "{azure_storage_account_container_url}", "{azure_storage_account_container_name}", "{azure_storage_account_sas_token_protected}", "{purview_container_url}", "{purview_sas_token_protected}", "{purview_estimate_statistics_indexed_item_count}", "{purview_estimate_statistics_indexed_item_size}", "{purview_estimate_statistics_unindexed_item_count}", "{purview_estimate_statistics_unindexed_item_size}", "{purview_estimate_statistics_mailbox_count}", "{purview_estimate_statistics_site_count}", "{purview_download_zip_count}", "{veritone_service_id}", "{veritone_whitelisted_cert_fingerprints}", "{vault_service_id}", "{vault_whitelisted_cert_fingerprints}", "{vault_matter_id}", "{vault_matter_name}", "{vault_matter_state}", "{vault_matter_created}", "{vault_saved_query_mail_options}", "{vault_saved_query_drive_options}", "{vault_saved_query_hangouts_chat_options}", "{vault_saved_query_voice_options}", "{vault_saved_query_ids}", "{vault_export_ids}", "{vault_export_download_location}", "{vault_hold_voice_options}", "{vault_hold_ids}", "{vault_hold_locations}", "{vault_duplicate_families_tag_name}", "{ecc_service_id}", "{ecc_whitelisted_cert_fingerprints}", "{wfn_ecc_collection_sources}", "{ecc_user_computer_mapping}", "{legal_hold_id}", "{legal_hold_name}", "{legal_hold_event_trigger}", "{legal_hold_custodian_ids}", "{legal_hold_custodian_names}", "{legal_hold_custodian_emails}", "{legal_hold_custodian_id}", "{legal_hold_custodian_name}", "{legal_hold_custodian_email}", "{legal_hold_notice_event_id}", "{legal_hold_notice_event_response}", "{item_text}", "{item_properties}", "{email_header}", "{answer_text}"));
    public Case nuixCase;
    public Case workstationCase;
    public Window nuixWindow;
    public Utilities nuixUtilities;
    public Version nuixVersion;
    public boolean runningFromWorkstation;
    public WorkflowExecution workflowExecution;
    public boolean workflowExecutedInWorkstationCase;
    public Set<String> passwords;
    public List<KeystoreFile> keystoreList;
    public boolean workflowParallelSettings;
    public int workflowLocalWorkersCount;
    public int workflowLocalWorkersMemoryMb;
    public String workflowLocalWorkersTempFolder;
    public int workflowBrokerWorkersCount;
    public String workflowBrokerIp;
    public int workflowBrokerPort;
    public String jobBrokerIp;
    public int jobBrokerPort;
    private Parameters executionCustomParameters;
    private Parameters sessionConfigParameters;
    private Parameters executionBuiltInParameters;
    private Operation currentOperation;
    private Engine engine;
    public String binariesLocation;
    public LicenceSession licenceSession;
    public LicenceInfo licenceInfo;
    public String userDataDirPath;
    private String jobFilesDirectory;
    private static final String datePattern = "yyyyMMdd";
    private static final String dateTimePattern = "yyyyMMdd'T'HHmmss";

    public ExecutionContext(Case nuixCase, Case workstationCase, Window nuixWindow, Utilities nuixUtilities, String nuixVersion, boolean runningFromWorkstation, Parameters sessionConfigParameters, Engine engine) {
        this(nuixCase, workstationCase, nuixWindow, nuixUtilities, nuixVersion, runningFromWorkstation, sessionConfigParameters);
        this.engine = engine;
    }

    public ExecutionContext(Case nuixCase, Case workstationCase, Window nuixWindow, Utilities nuixUtilities, String nuixVersion, boolean runningFromWorkstation, Parameters sessionConfigParameters) {
        this(nuixCase, workstationCase, nuixWindow, nuixUtilities, nuixVersion, runningFromWorkstation);
        this.sessionConfigParameters = sessionConfigParameters;
    }

    public ExecutionContext(Case nuixCase, Case workstationCase, Window nuixWindow, Utilities nuixUtilities, String nuixVersion, boolean runningFromWorkstation) {
        this.nuixCase = nuixCase;
        this.workstationCase = workstationCase;
        this.nuixWindow = nuixWindow;
        this.nuixUtilities = nuixUtilities;
        this.runningFromWorkstation = runningFromWorkstation;
        if (runningFromWorkstation) {
            workstationCase = nuixCase;
        }
        this.nuixVersion = new Version(nuixVersion);
        this.sessionConfigParameters = new Parameters();
        this.binariesLocation = SystemUtils.getProgramFilesDir() + "\\Nuix\\Automate\\bin";
    }

    public void initializeJobParameters(JobModel jobModel, EngineModel model, ExecutionProfileModel executionProfile) {
        if (jobModel != null) {
            LOGGER.info("Setting job info parameters");
            LOGGER.info("Setting {job_name}: " + jobModel.getName());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_name}", jobModel.getName()));
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_notes}", jobModel.getNotes()));
            LOGGER.info("Setting {job_id}: " + jobModel.getId());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_id}", jobModel.getId()));
            String shortId = UidUtils.getShortId((String)jobModel.getId());
            LOGGER.info("Setting {job_id_short}: " + shortId);
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_id_short}", shortId));
            LOGGER.info("Setting {job_resource_pool_id}: " + jobModel.getResourcePoolId());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_resource_pool_id}", jobModel.getResourcePoolId()));
            LOGGER.info("Setting {job_resource_pool_name}: " + jobModel.getResourcePoolName());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_resource_pool_name}", jobModel.getResourcePoolName()));
            LOGGER.info("Setting {job_execution_profile_id}: " + jobModel.getExecutionProfileId());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_execution_profile_id}", jobModel.getExecutionProfileId()));
            LOGGER.info("Setting {job_execution_profile_name}: " + jobModel.getExecutionProfileName());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_execution_profile_name}", jobModel.getExecutionProfileName()));
            LOGGER.info("Setting {job_priority}: " + jobModel.getPriority().name());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_priority}", jobModel.getPriority().name()));
            LOGGER.info("Setting {job_submitted_by}: " + jobModel.getSubmittedBy());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_submitted_by}", jobModel.getSubmittedBy()));
            LOGGER.info("Setting {job_submitted_date}: " + new DateTime((Object)jobModel.getSubmittedDate()).withZone(DateTimeZone.getDefault()).toString());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_submitted_date}", new DateTime((Object)jobModel.getSubmittedDate()).withZone(DateTimeZone.getDefault()).toString()));
            LOGGER.info("Setting {job_engine_id}: " + jobModel.getEngineId());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_engine_id}", jobModel.getEngineId()));
            LOGGER.info("Setting {job_engine_name}: " + model.getName());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_engine_name}", model.getName()));
            LOGGER.info("Setting {job_execution_log}: " + model.getLogFile());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_execution_log}", model.getLogFile()));
            RemoteWorkersSpecModel remoteWorkerSpec = jobModel.getRemoteWorkersSpec();
            if (remoteWorkerSpec != null && remoteWorkerSpec.getUseRemoteWorkers()) {
                LOGGER.info("Setting WorkerBrokerIp: " + remoteWorkerSpec.getWorkerBrokerIp());
                LOGGER.info("Setting WorkerBrokerPort: " + remoteWorkerSpec.getWorkerBrokerPort());
                LOGGER.info("Setting {job_worker_broker_ip}: " + remoteWorkerSpec.getWorkerBrokerIp());
                this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_worker_broker_ip}", remoteWorkerSpec.getWorkerBrokerIp()));
                LOGGER.info("Setting {job_worker_broker_port}: " + remoteWorkerSpec.getWorkerBrokerPort());
                this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_worker_broker_port}", "" + remoteWorkerSpec.getWorkerBrokerPort()));
            }
            LOGGER.info("Setting {job_server_name}: " + jobModel.getServerName());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_server_name}", jobModel.getServerName()));
        }
        if (model != null) {
            LOGGER.info("Setting {job_server_id}: " + model.getServerId());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_server_id}", model.getServerId()));
        }
        if (executionProfile == null) {
            LOGGER.warn("Execution profile is null");
        } else {
            if (executionProfile.getSchedulerUrl() == null) {
                LOGGER.warn("Scheduler URL is null");
            } else {
                LOGGER.info("Setting {scheduler_url}: " + executionProfile.getSchedulerUrl());
                this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{scheduler_url}", executionProfile.getSchedulerUrl()));
            }
            if (executionProfile.getWorkerTempFolder() == null) {
                LOGGER.warn("Worker Temp Directory is null");
            } else {
                LOGGER.info("workflowLocalWorkersTempFolder");
                this.workflowLocalWorkersTempFolder = executionProfile.getWorkerTempFolder();
            }
        }
        if (executionProfile != null) {
            LOGGER.info("Setting {scheduler_cert_fingerprint}: " + executionProfile.getSchedulerCertFingeprint());
            this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{scheduler_cert_fingerprint}", executionProfile.getSchedulerCertFingeprint()));
        }
        if (jobModel != null) {
            if (jobModel.getJobApiBearerToken() != null) {
                String schedulerApiHeader = jobModel.getJobApiBearerToken();
                LOGGER.info("Setting {job_bearer_token_protected}");
                this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{job_bearer_token_protected}", schedulerApiHeader));
            }
            if (jobModel.getMatterId() != null) {
                LOGGER.info("Setting {matter_id}: " + jobModel.getMatterId());
                this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{matter_id}", jobModel.getMatterId()));
                LOGGER.info("Setting {matter_name}: " + jobModel.getMatterName());
                this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{matter_name}", jobModel.getMatterName()));
                LOGGER.info("Setting {matter_reference}: " + jobModel.getMatterReference());
                this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{matter_reference}", jobModel.getMatterReference()));
            }
            if (jobModel.getClientId() != null) {
                LOGGER.info("Setting {client_id}: " + jobModel.getClientId());
                this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{client_id}", jobModel.getClientId()));
                LOGGER.info("Setting {client_name}: " + jobModel.getClientName());
                this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{client_name}", jobModel.getClientName()));
                LOGGER.info("Setting {client_reference}: " + jobModel.getClientReference());
                this.getExecutionBuiltInParameters().put((Parameter)new PreDefinedStaticParameter("{client_reference}", jobModel.getClientReference()));
            }
        }
    }

    public void trackCaseCreated() {
        if (this.nuixCase != null) {
            CaseNotesStore notesStore = this.nuixCase.getCaseNotesStore();
            try {
                notesStore.addNote("automate_client_name", "nuix", this.evalParametersIfSet("{client_name}", null));
                notesStore.addNote("automate_client_id", "nuix", this.evalParametersIfSet("{client_id}", null));
            }
            catch (ParameterException parameterException) {
                // empty catch block
            }
            try {
                notesStore.addNote("automate_matter_name", "nuix", this.evalParametersIfSet("{matter_name}", null));
                notesStore.addNote("automate_matter_id", "nuix", this.evalParametersIfSet("{matter_id}", null));
            }
            catch (ParameterException parameterException) {
                // empty catch block
            }
            try {
                notesStore.addNote("automate_resource_pool_name", "nuix", this.evalParametersIfSet("{job_resource_pool_name}", null));
                notesStore.addNote("automate_resource_pool_id", "nuix", this.evalParametersIfSet("{job_resource_pool_id}", null));
            }
            catch (ParameterException parameterException) {
                // empty catch block
            }
        }
    }

    public void trackCaseSession() {
        if (this.nuixCase != null && this.licenceSession != null) {
            try {
                this.nuixCase.searchUnsorted("flag:Automate_Session_Start_" + this.licenceSession.getId());
                this.nuixCase.searchUnsorted("flag:Automate_Session_Type_" + this.licenceSession.getClass().getSimpleName());
            }
            catch (IOException e) {
                LOGGER.warn("Cannot record session start", (Throwable)e);
            }
        }
    }

    public void closeNuixCase() {
        if (this.nuixCase != null) {
            if (this.licenceSession != null) {
                try {
                    this.nuixCase.searchUnsorted("flag:Automate_Session_End_" + this.licenceSession.getId());
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot record session end", (Throwable)e);
                }
            }
            this.nuixCase.close();
        }
    }

    public void setJobFilesDirectory(String jobFilesDirectory) {
        this.jobFilesDirectory = jobFilesDirectory;
    }

    public Path getJobFilesDirectory(String jobId) {
        return Paths.get(this.jobFilesDirectory, jobId);
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Parameters getExecutionBuiltInParameters() {
        return this.executionBuiltInParameters;
    }

    public Parameters getExecutionCustomParameters() {
        if (this.executionCustomParameters == null) {
            this.executionCustomParameters = new Parameters();
        }
        return this.executionCustomParameters;
    }

    public Parameters getSessionConfigParameters() {
        if (this.sessionConfigParameters == null) {
            this.sessionConfigParameters = new Parameters();
        }
        return this.sessionConfigParameters;
    }

    public boolean checkIfBuiltInParameter(String parameterName) {
        return builtInParameters.contains(parameterName);
    }

    public Set<String> getExecutionStateDynamicParameterNames() {
        TreeSet<String> parameterNames = new TreeSet<String>();
        for (Parameter p : this.executionBuiltInParameters.getParameters()) {
            if (!(p instanceof ExecutionStateDynamicParameter)) continue;
            parameterNames.add(p.getName());
        }
        return parameterNames;
    }

    public Set<String> getParameterNames() {
        TreeSet<String> parameterNames = new TreeSet<String>();
        parameterNames.addAll(this.executionBuiltInParameters.getNames());
        if (this.executionCustomParameters != null) {
            parameterNames.addAll(this.executionCustomParameters.getNames());
        }
        if (this.sessionConfigParameters != null) {
            parameterNames.addAll(this.sessionConfigParameters.getNames());
        }
        return parameterNames;
    }

    public Parameters getAllParameters() {
        Parameters parameters = new Parameters();
        if (this.executionBuiltInParameters == null) {
            this.executionBuiltInParameters = new Parameters(builtInParameters);
        }
        for (Parameter p : this.executionBuiltInParameters.getParameters()) {
            parameters.putIfNotExists(p);
        }
        if (this.executionCustomParameters == null) {
            this.executionCustomParameters = new Parameters();
        }
        for (Parameter p : this.executionCustomParameters.getParameters()) {
            parameters.putIfNotExists(p);
        }
        if (this.sessionConfigParameters == null) {
            this.sessionConfigParameters = new Parameters();
        }
        for (Parameter p : this.sessionConfigParameters.getParameters()) {
            parameters.putIfNotExists(p);
        }
        return parameters;
    }

    public Version getVersion() {
        String implementationVersion = this.getClass().getPackage().getImplementationVersion();
        return new Version(implementationVersion);
    }

    public File getReportTemplate() {
        File templateFile = new File(System.getProperty("user.home") + "/.automate/Templates/Report Template v" + this.getVersion().toMajorMinorString() + ".xlsx");
        return templateFile;
    }

    public void initializeBuiltInParameters() {
        this.executionBuiltInParameters = new Parameters(builtInParameters);
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{server_name}", "The name of the current server"){

            @Override
            public String getProtectedValue() throws ParameterException {
                try {
                    return InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    return "";
                }
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{server_fqdn}", "The fully qualified domain name (FQDN) of the current server"){

            @Override
            public String getProtectedValue() throws ParameterException {
                try {
                    return InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    return "";
                }
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{case_name}", "The name of the current Nuix case"){

            @Override
            public String getProtectedValue() throws ParameterException {
                if (ExecutionContext.this.nuixCase == null) {
                    String lastCaseName = ExecutionContext.this.evalParameters("{last_case_name}", null, true);
                    if (!lastCaseName.equals("{last_case_name}")) {
                        return lastCaseName;
                    }
                    throw new ParameterNotDefinedException(iu.getFormattedString("Parameters.Log.NoCase", (Object)this.getName()));
                }
                return ExecutionContext.this.nuixCase.getName();
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{case_folder}", "The folder in which the previously used Nuix case resides"){

            @Override
            public String getProtectedValue() throws ParameterException {
                if (ExecutionContext.this.nuixCase == null) {
                    throw new ParameterNotDefinedException(iu.getFormattedString("Parameters.Log.NoCase", (Object)this.getName()));
                }
                return ExecutionContext.this.nuixCase.getLocation().getAbsolutePath();
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{case_prefix}", "The first 5 letters of the current Nuix case, in uppercase"){

            @Override
            public String getProtectedValue() throws ParameterException {
                if (ExecutionContext.this.nuixCase == null) {
                    throw new ParameterNotDefinedException(iu.getFormattedString("Parameters.Log.NoCase", (Object)this.getName()));
                }
                String casePrefix = ExecutionContext.this.nuixCase.getName().toUpperCase().replaceAll("[^A-Za-z]", "");
                if ((casePrefix = casePrefix.substring(0, Math.min(casePrefix.length(), 5))).length() == 0) {
                    casePrefix = "DOC";
                }
                return casePrefix;
            }
        });
        this.executionBuiltInParameters.put((Parameter)new UndefinedParameter("{previous_case_folder}", "The folder in which the current Nuix case resides", iu.getString("Parameters.Error.NoCase")));
        this.executionBuiltInParameters.put((Parameter)new UndefinedParameter("{first_case_folder}", "The folder in which the first Nuix used case resides", iu.getString("Parameters.Error.NoCase")));
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{date_time_local}", "The current local date and time"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{date_local}", "The current local date"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToLocalDateString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{date_time}", "The current date and time"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{date_time_epoch}", "The current date and time as epoch millis"){

            @Override
            public String getProtectedValue() {
                return String.valueOf(System.currentTimeMillis());
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{random_guid}", "Randomly generated GUID"){

            @Override
            public String getProtectedValue() {
                return UidUtils.getRandom();
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{date}", "The current date"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToInternationalDateString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{time}", "The current time"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToInternationalTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{date_time_spreadsheet}", "The current date and time in a spreadsheet-compatible format"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToExcelDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{date_spreadsheet}", "The current date in a spreadsheet-compatible format"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToExcelDateString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{time_spreadsheet}", "The current time in a spreadsheet-compatible format"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToExcelTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{start_date_time_local}", "The start local date and time"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToLocalString((DateTime)new DateTime(ExecutionContext.this.workflowExecution.getStartEpoch()));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{start_date_local}", "The start local date"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToLocalDateString((DateTime)new DateTime(ExecutionContext.this.workflowExecution.getStartEpoch()));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{start_date_time}", "The start date and time"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)new DateTime(ExecutionContext.this.workflowExecution.getStartEpoch()));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{start_date_time_epoch}", "The start date and time as epoch millis"){

            @Override
            public String getProtectedValue() {
                return String.valueOf(ExecutionContext.this.workflowExecution.getStartEpoch());
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{start_date}", "The start date"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToInternationalDateString((DateTime)new DateTime(ExecutionContext.this.workflowExecution.getStartEpoch()));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{start_time}", "The start time"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToInternationalTimeString((DateTime)new DateTime(ExecutionContext.this.workflowExecution.getStartEpoch()));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{start_date_time_spreadsheet}", "The start date and time in a spreadsheet-compatible format"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToExcelDateTimeString((DateTime)new DateTime(ExecutionContext.this.workflowExecution.getStartEpoch()));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{start_date_spreadsheet}", "The start date in a spreadsheet-compatible format"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToExcelDateString((DateTime)new DateTime(ExecutionContext.this.workflowExecution.getStartEpoch()));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{start_time_spreadsheet}", "The start time in a spreadsheet-compatible format"){

            @Override
            public String getProtectedValue() {
                return FormattingUtils.dateTimeToExcelTimeString((DateTime)new DateTime(ExecutionContext.this.workflowExecution.getStartEpoch()));
            }
        });
        this.executionBuiltInParameters.put((Parameter)new LastBatchLoadGuidParameter("{last_batch_load_guid}", "The GUID of the last batch of data loaded", this));
        this.executionBuiltInParameters.put((Parameter)new LastBatchLoadDateParameter("{last_batch_load_date}", "The date of the last batch of data load", this));
        this.executionBuiltInParameters.put((Parameter)new LastBatchLoadDateTimeParameter("{last_batch_load_date_time}", "The date and time of the last batch of data load", this));
        this.executionBuiltInParameters.put((Parameter)new LastBatchLoadDateTimeLocalParameter("{last_batch_load_date_time_local}", "The date and time of the last batch of data load in local format", this));
        this.executionBuiltInParameters.put((Parameter)new LastEvidenceGuidParameter("{last_evidence_guid}", "The GUID of the last evidence container loaded", this));
        this.executionBuiltInParameters.put((Parameter)new LastEvidenceNameParameter("{last_evidence_name}", "The name of the last evidence container loaded", this));
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{operation_name}", "The name of the current operation"){

            @Override
            public String getProtectedValue() {
                if (ExecutionContext.this.currentOperation == null) {
                    return "Undefined Operation";
                }
                return ExecutionContext.this.currentOperation.getOperationName();
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{operation_position}", "The position of the current operation in the workflow"){

            @Override
            public String getProtectedValue() {
                if (ExecutionContext.this.currentOperation == null) {
                    return "0";
                }
                int position = 1;
                for (Operation operation : ExecutionContext.this.workflowExecution.getWorkflow().getOperations()) {
                    if (ExecutionContext.this.currentOperation == operation) {
                        return String.valueOf(position);
                    }
                    ++position;
                }
                return "0";
            }
        });
        this.executionBuiltInParameters.put((Parameter)new LastItemSetNameParameter("{last_item_set_name}", "The name of the last item-set used", this));
        this.executionBuiltInParameters.put((Parameter)new LastItemSetBatchParameter("{last_item_set_batch}", "The name and batch of the last item-set used", this));
        this.executionBuiltInParameters.put((Parameter)new LastItemSetOriginalsBatchParameter("{last_item_set_originals_batch}", "The name and original batch of the last item-set used", this));
        this.executionBuiltInParameters.put((Parameter)new LastItemSetDuplicatesBatchParameter("{last_item_set_duplicates_batch}", "The name and duplicate batch of the last item-set used", this));
        this.executionBuiltInParameters.put((Parameter)new LastProductionSetNameParameter("{last_production_set_name}", "The name of the last production set created in the case", this));
        this.executionBuiltInParameters.put((Parameter)new UndefinedParameter("{last_export_folder}", "The folder to which the last export was performed", iu.getString("Parameters.Error.NoExport")));
        this.executionBuiltInParameters.put((Parameter)new UndefinedParameter("{last_metadata_export_file}", "The full path to the last metadata export generated", iu.getString("Parameters.Error.NoMetadata")));
        this.executionBuiltInParameters.put((Parameter)new UndefinedParameter("{export_production_set_name}", "The name of the last production set exported", iu.getString("Parameters.Error.NoProductionSet")));
        this.executionBuiltInParameters.put((Parameter)new UndefinedParameter("{last_report_file}", "The full path of the last report generated", iu.getString("Parameters.Error.NoReport")));
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{workflow_name}", "The name of the current workflow"){

            @Override
            public String getProtectedValue() {
                return ExecutionContext.this.workflowExecution.getWorkflow().getName();
            }
        });
        this.executionBuiltInParameters.put((Parameter)new ExecutionStateDynamicParameter("{workflow_log}", "The text log of the current workflow"){

            @Override
            public String getProtectedValue() {
                return ExecutionContext.this.workflowExecution.getExecutionLog();
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{workflow_state}", "The execution state of the current workflow"){

            @Override
            public String getProtectedValue() {
                return ExecutionContext.this.workflowExecution.getExecutionState().toString();
            }
        });
        this.executionBuiltInParameters.put((Parameter)new ExecutionStateDynamicParameter("{workflow_status}", "The execution status of the current workflow in text format"){

            @Override
            public String getProtectedValue() {
                return ExecutionContext.this.workflowExecution.getWorkflowStatusText();
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{automate_logo_html}", "Automate logo in <h1> HTML tag with image"){

            @Override
            public String getProtectedValue() {
                return "<h1><div style=\"display: flex; align-items: center;\">Automate</div></h1>\n";
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{rampiva_logo_html}", "Automate logo in <h1> HTML tag with image"){

            @Override
            public String getProtectedValue() {
                return "<h1><div style=\"display: flex; align-items: center;\">Automate</div></h1>\n";
            }
        });
        this.executionBuiltInParameters.put((Parameter)new PreDefinedStaticParameter("{simple_style_html}", "table.workflow-status {\n    font-family: arial, sans-serif;\n    border-collapse: collapse;\n    width: 100%;\n}\n\nth.workflow-status-operation {\n\twidth:15%;\n}\nth.workflow-status-text {\n\twidth:15%;\n}\nth.workflow-status-icon {\n\twidth:16px;\n}\nth.workflow-status-index {\n\twidth:16px;\n}\n\n.workflow-status td, .workflow-status th {\n    border: 1px solid #dddddd;\n    text-align: left;\n    padding: 8px;\n}\n\n.workflow-status td.workflow-status-inprogress{\n\tfont-weight: bold;\n}\n\n.workflow-status td.workflow-status-complete-with-warnings{\n\tfont-weight: bold;\n    color: red;\n}\n\n.workflow-status tr:nth-child(even) {\n    background-color: #e6ecf2;\n}", "Simple HTML style"){});
        this.executionBuiltInParameters.put((Parameter)new ExecutionStateDynamicParameter("{workflow_status_html}", "The execution status of the current workflow in HTML format"){

            @Override
            public String getProtectedValue() {
                return ExecutionContext.this.workflowExecution.getWorkflowStatusHtml();
            }
        });
        this.executionBuiltInParameters.put((Parameter)new UndefinedParameter("{last_script_output}", "The output of the last script", iu.getString("Parameters.Error.NoScript")));
        this.executionBuiltInParameters.put((Parameter)new UndefinedParameter("{last_script_error}", "The error of the last script", iu.getString("Parameters.Error.NoScript")));
        this.executionBuiltInParameters.put((Parameter)new UndefinedParameter("{last_script_return_value}", "The return value of the last script", iu.getString("Parameters.Error.NoScript")));
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{relativity_client_name}", "The relativity client name"){

            @Override
            public String getProtectedValue() throws ParameterException {
                return "";
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{relativity_client_id}", "The relativity client artifact ID"){

            @Override
            public String getProtectedValue() throws ParameterException {
                return "";
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{relativity_client_created}", "Was the relativity client created"){

            @Override
            public String getProtectedValue() throws ParameterException {
                return "";
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{relativity_matter_name}", "The relativity matter name"){

            @Override
            public String getProtectedValue() throws ParameterException {
                return "";
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{relativity_matter_id}", "The relativity matter artifact ID"){

            @Override
            public String getProtectedValue() throws ParameterException {
                return "";
            }
        });
        this.executionBuiltInParameters.put((Parameter)new DynamicParameter("{relativity_matter_created}", "Was the relativity matter created"){

            @Override
            public String getProtectedValue() throws ParameterException {
                return "";
            }
        });
    }

    public boolean versionGreaterOrEqualTo(String requiredNuixVersion) {
        int requiredVersionSatisfied = this.nuixVersion.compareTo(new Version(requiredNuixVersion));
        return requiredVersionSatisfied > 0;
    }

    public boolean versionGreaterOrEqualTo(Version requiredNuixVersion) {
        int requiredVersionSatisfied = this.nuixVersion.compareTo(requiredNuixVersion);
        return requiredVersionSatisfied > 0;
    }

    public boolean closeAllTabs() {
        if (this.nuixCase != this.workstationCase) {
            LOGGER.info("Workflow not ran in Workstation case, skipping closing tabs");
            return false;
        }
        if (this.nuixWindow != null) {
            LOGGER.info("Closing all tabs");
            try {
                if (this.versionGreaterOrEqualTo("7.0.0")) {
                    this.nuixWindow.closeAllTabs();
                    return true;
                }
            }
            catch (NoSuchMethodError e) {
                LOGGER.error("Cannot close tabs", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Cannot close tabs", (Throwable)e);
            }
        } else {
            LOGGER.warn("Nuix window is null");
        }
        return false;
    }

    public boolean openTab() {
        if (!this.workflowExecutedInWorkstationCase) {
            LOGGER.info("Workflow  not ran in Workstation case, skipping opening tab");
            return false;
        }
        if (this.nuixWindow != null) {
            HashMap<String, String> openTabOptions = new HashMap<String, String>();
            openTabOptions.put("search", "");
            try {
                this.nuixWindow.openTab("workbench", openTabOptions);
                return true;
            }
            catch (NoSuchMethodError e) {
                LOGGER.error("Cannot open tabs", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Cannot open tabs", (Throwable)e);
            }
        }
        return false;
    }

    public void initializeDynamicParameters() {
        this.executionCustomParameters = new Parameters();
    }

    public String evalParameterUserPrintableValue(String parameterName) throws ParameterException {
        Parameter parameter;
        if (this.executionBuiltInParameters != null && (parameter = this.executionBuiltInParameters.get(parameterName)) != null) {
            return parameter.getUserDisplayableValue();
        }
        if (this.sessionConfigParameters != null && (parameter = this.sessionConfigParameters.get(parameterName)) != null) {
            return parameter.getUserDisplayableValue();
        }
        if (this.executionCustomParameters != null && (parameter = this.executionCustomParameters.get(parameterName)) != null) {
            return parameter.getUserDisplayableValue();
        }
        throw new ParameterException("Parameter " + parameterName + " not defined");
    }

    public String evalProtectedParameterIfSet(String originalString) throws ParameterException {
        String result;
        if (originalString == null) {
            originalString = "";
        }
        if (originalString.equals(result = this.evalProtectedParameter(originalString))) {
            throw new ParameterException("Parameter not set");
        }
        return result;
    }

    public String evalProtectedParameter(String parameterName) throws ParameterException {
        Parameter parameter;
        String result = parameterName;
        if (this.executionBuiltInParameters != null && (parameter = this.executionBuiltInParameters.get(parameterName)) != null) {
            return parameter.getProtectedValue();
        }
        if (this.sessionConfigParameters != null && (parameter = this.sessionConfigParameters.get(parameterName)) != null) {
            return parameter.getProtectedValue();
        }
        if (this.executionCustomParameters != null && (parameter = this.executionCustomParameters.get(parameterName)) != null) {
            return parameter.getProtectedValue();
        }
        return parameterName;
    }

    public String evalParametersIfSet(String originalString, Operation operation) throws ParameterException {
        String result;
        if (originalString == null) {
            originalString = "";
        }
        if (originalString.equals(result = this.evalParameters(originalString, operation, true))) {
            throw new ParameterException("Parameter " + originalString + " not set");
        }
        return result;
    }

    public String evalParametersTrim(String originalString, Operation operation) throws ParameterException {
        return this.evalParameters(originalString, operation).trim();
    }

    public String evalParameters(String originalString, Operation operation) throws ParameterException {
        if (originalString == null) {
            originalString = "";
        }
        return this.evalParameters(originalString, operation, false);
    }

    public String evalProtectedStringParameter(String originalString, Operation operation) throws ParameterException {
        String result = this.evalProtectedParameter(originalString);
        if (result.equals(originalString)) {
            return null;
        }
        return result;
    }

    public String evalStringParameter(String originalString, Operation operation) throws ParameterException {
        String result = this.evalParameters(originalString, operation, true);
        if (result.equals(originalString)) {
            return null;
        }
        return result;
    }

    public DateTime evalDateTimeParameter(String originalString, Operation operation) throws ParameterException {
        String result = this.evalParameters(originalString, operation, true);
        if (result.equals(originalString)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimePattern);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return new DateTime((Object)simpleDateFormat.parse(result));
        }
        catch (ParseException e) {
            throw new ParameterException((Throwable)e);
        }
    }

    public DateTime evalDateParameter(String originalString, Operation operation) throws ParameterException {
        String result = this.evalParameters(originalString, operation, true);
        if (result.equals(originalString)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(datePattern);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return new DateTime((Object)simpleDateFormat.parse(result));
        }
        catch (ParseException e) {
            throw new ParameterException((Throwable)e);
        }
    }

    public Integer evalIntParameter(String originalString, Operation operation) throws ParameterException {
        String result = this.evalParameters(originalString, operation, true);
        if (result.equals(originalString)) {
            return null;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            throw new ParameterException((Throwable)e);
        }
    }

    public Double evalDoubleParameter(String originalString, Operation operation) throws ParameterException {
        String result = this.evalParameters(originalString, operation, true);
        if (result.equals(originalString)) {
            return null;
        }
        try {
            return Double.parseDouble(result);
        }
        catch (NumberFormatException e) {
            throw new ParameterException((Throwable)e);
        }
    }

    public Long evalLongParameter(String originalString, Operation operation) throws ParameterException {
        String result = this.evalParameters(originalString, operation, true);
        if (result.equals(originalString)) {
            return null;
        }
        try {
            return Long.parseLong(result);
        }
        catch (NumberFormatException e) {
            throw new ParameterException((Throwable)e);
        }
    }

    public Boolean evalBooleanParameter(String originalString, Operation operation) throws ParameterException {
        String result = this.evalParameters(originalString, operation, true);
        if (result.equals(originalString)) {
            return null;
        }
        if (result.equalsIgnoreCase("true") || result.equalsIgnoreCase("yes") || result.equalsIgnoreCase("y")) {
            return true;
        }
        if (result.equalsIgnoreCase("false") || result.equalsIgnoreCase("no") || result.equalsIgnoreCase("n")) {
            return false;
        }
        String errorMessage = iu.getFormattedString("Parameters.Error.CannotParse", new Object[]{originalString, result, "boolean"});
        throw new ParameterException(errorMessage);
    }

    public List<String> evalOneOrManyStringParameter(String originalString, Operation operation) {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            String evaluatedString = this.evalParameters(originalString, operation);
            boolean addInitial = true;
            if (evaluatedString.startsWith("[") && evaluatedString.endsWith("]")) {
                try {
                    for (Object element : (Collection)SerializationUtils.fromJson((String)evaluatedString, Collection.class)) {
                        if (!(element instanceof String)) continue;
                        strings.add(((String)element).trim());
                    }
                    addInitial = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (addInitial) {
                strings.add(evaluatedString.trim());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error normalizing parameter " + originalString, (Throwable)e);
        }
        return strings;
    }

    public <T> T evalJsonParameter(String parameterName, Class<T> clazz, Operation operation) {
        try {
            String json = this.evalParameters(parameterName, operation);
            if (!parameterName.equals(json)) {
                return (T)SerializationUtils.fromJson((String)json, clazz);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to evaluate json parameter " + parameterName, (Throwable)e);
        }
        return null;
    }

    public String evalParameters(String originalString, Operation operation, boolean ignoreUndefinedParameters) throws ParameterException {
        return this.evalParameters(originalString, operation, ignoreUndefinedParameters, true);
    }

    public String evalParameters(String originalString, Operation operation, boolean ignoreUndefinedParameters, boolean unmask) throws ParameterException {
        try {
            if (originalString == null) {
                originalString = "";
            }
            String result = originalString;
            result = result.replace("{call_api_response_body}", "{AUTOMATETEMP_call_api_response_body}");
            result = result.replace("{workflow_log}", "{AUTOMATETEMP_workflow_log}");
            result = result.replace("{workflow_status}", "{AUTOMATETEMP_workflow_status}");
            result = result.replace("{workflow_status_html}", "{AUTOMATETEMP_workflow_status_html}");
            boolean recursiveParameter = true;
            for (int count = 0; count < 100; ++count) {
                String unpacked = this.evalParametersSingleStep(result, operation, ignoreUndefinedParameters, unmask);
                if (unpacked == null) {
                    recursiveParameter = false;
                    break;
                }
                if (result.equals(unpacked)) {
                    recursiveParameter = false;
                    break;
                }
                result = unpacked;
            }
            if (recursiveParameter) {
                LOGGER.error("Recursive parameter detected in string: `" + originalString + "`.\nReached eval string: `" + result + "`");
                throw new RecursiveParameterException("Recursive parameter detected in string: " + originalString);
            }
            if (result.contains("{AUTOMATETEMP_call_api_response_body}")) {
                result = result.replace("{AUTOMATETEMP_call_api_response_body}", this.executionBuiltInParameters.get("{call_api_response_body}").getValue());
            }
            if (result.contains("{AUTOMATETEMP_workflow_log}")) {
                result = result.replace("{AUTOMATETEMP_workflow_log}", this.executionBuiltInParameters.get("{workflow_log}").getValue());
            }
            if (result.contains("{AUTOMATETEMP_workflow_status}")) {
                result = result.replace("{AUTOMATETEMP_workflow_status}", this.executionBuiltInParameters.get("{workflow_status}").getValue());
            }
            if (result.contains("{AUTOMATETEMP_workflow_status_html}")) {
                result = result.replace("{AUTOMATETEMP_workflow_status_html}", this.executionBuiltInParameters.get("{workflow_status_html}").getValue());
            }
            if (!result.equals(originalString) && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Evaluated '" + originalString + "' to '" + result + "'");
            }
            return result;
        }
        catch (ParameterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParameterException((Throwable)e);
        }
    }

    public String evalParametersSingleStep(String originalString, Operation currentOperation, boolean ignoreUndefinedParameters, boolean unmask) throws ParameterException {
        String parameterValue;
        String userPrintableParameterName;
        String parameterValue2;
        this.currentOperation = currentOperation;
        String result = originalString;
        if (result != null) {
            result = result.replace("batch-load-guid:{last_evidence_guid}", "batch-load-guid:{last_batch_load_guid}");
        }
        if (this.executionBuiltInParameters != null) {
            for (Parameter parameter : this.executionBuiltInParameters.getParameters()) {
                block25: {
                    if (result != null && result.contains(parameter.getName())) {
                        try {
                            parameterValue2 = parameter.getValue(unmask);
                            if (parameterValue2 == null) {
                                parameterValue2 = "";
                            }
                            result = result.equals(parameter.getName()) ? parameterValue2 : result.replace(parameter.getName(), parameterValue2);
                        }
                        catch (ParameterNotDefinedException e) {
                            if (ignoreUndefinedParameters) break block25;
                            throw e;
                        }
                    }
                }
                userPrintableParameterName = parameter.getName().replace("}", "_userprintable}");
                if (result == null || !result.contains(userPrintableParameterName)) continue;
                try {
                    parameterValue = parameter.getUserDisplayableValue(unmask);
                    if (parameterValue == null) {
                        parameterValue = "";
                    }
                    if (result.equals(userPrintableParameterName)) {
                        result = parameterValue;
                        continue;
                    }
                    result = result.replace(userPrintableParameterName, parameterValue);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot resolve parameter " + userPrintableParameterName, (Throwable)e);
                }
            }
        }
        if (this.executionCustomParameters != null) {
            for (Parameter parameter : this.executionCustomParameters.getParameters()) {
                if (result != null && result.contains(parameter.getName())) {
                    parameterValue2 = parameter.getValue(unmask);
                    if (parameterValue2 == null) {
                        parameterValue2 = "";
                    }
                    result = result.replace(parameter.getName(), parameterValue2);
                }
                userPrintableParameterName = parameter.getName().replace("}", "_userprintable}");
                if (result == null || !result.contains(userPrintableParameterName)) continue;
                try {
                    parameterValue = parameter.getUserDisplayableValue();
                    if (parameterValue == null) {
                        parameterValue = "";
                    }
                    result = result.replace(userPrintableParameterName, parameterValue);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot resolve parameter " + userPrintableParameterName, (Throwable)e);
                }
            }
        }
        if (this.sessionConfigParameters != null) {
            for (Parameter parameter : this.sessionConfigParameters.getParameters()) {
                if (result != null && result.contains(parameter.getName())) {
                    parameterValue2 = parameter.getValue(unmask);
                    if (parameterValue2 == null) {
                        parameterValue2 = "";
                    }
                    result = result.replace(parameter.getName(), parameterValue2);
                }
                userPrintableParameterName = parameter.getName().replace("}", "_userprintable}");
                if (result == null || !result.contains(userPrintableParameterName)) continue;
                try {
                    parameterValue = parameter.getUserDisplayableValue();
                    if (parameterValue == null) {
                        parameterValue = "";
                    }
                    result = result.replace(userPrintableParameterName, parameterValue);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot resolve parameter " + userPrintableParameterName, (Throwable)e);
                }
            }
        }
        return result;
    }

    public void assertModuleLicensed(ModuleType moduleType) throws LicenceValidationException {
        LicenceUtils licenceUtils = new LicenceUtils();
        try {
            licenceUtils.setLicenceInfo(this.getDeployedLicenceInfo());
        }
        catch (IOException e) {
            throw new LicenceValidationException("Cannot validate license");
        }
        licenceUtils.assertModuleLicensed(moduleType, false);
    }

    public LicenceInfo getDeployedLicenceInfo() throws IOException {
        LicenceFactory licenceFactory;
        Licence rampivaLicence;
        LicenceInfo licenceInfo = this.licenceInfo != null ? this.licenceInfo : ((rampivaLicence = (licenceFactory = LicenceFactory.getInstance()).getDeployedLicence()) != null ? LicenceFactory.getInstance().convertToLicenseInfo(rampivaLicence) : licenceFactory.getDeployedLicenceInfo());
        return licenceInfo;
    }
}

