/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils;

import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class CaseScanner {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CaseScanner.class);
    private static InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"BaselineText");
    private static final int MAX_DEPTH = 100;

    public static void testLocation(Path sourcePath, Status status) throws IOException {
        try (Stream<Path> paths = Files.find(sourcePath, 1, (path, attributes) -> attributes.isDirectory(), new FileVisitOption[0]);){
            ArrayList subFoldersLocations = new ArrayList();
            paths.forEach(path -> subFoldersLocations.add(path));
        }
        catch (IOException e) {
            LOGGER.warn("Path " + sourcePath.toString() + " is not valid", (Throwable)e);
            throw e;
        }
    }

    public static List<String> getCasesFromLocation(String startingLocation, Status status) throws IOException {
        LOGGER.info("Searching for cases in path: " + startingLocation);
        Path startingPath = Paths.get(startingLocation, new String[0]);
        CaseScanner.testLocation(startingPath, status);
        ArrayList<Path> startingLocations = new ArrayList<Path>();
        startingLocations.add(startingPath);
        List<String> result = CaseScanner.getCasesFromLocation(startingLocations, status, 0);
        LOGGER.info("Finished searching for cases in path: " + startingLocation + ". Cases found: " + result.size());
        return result;
    }

    public static List<String> getCasesFromLocation(List<Path> startingLocations, Status status, int level) {
        List<Path> caseBaseLocations = startingLocations;
        ArrayList<String> caseLocations = new ArrayList<String>();
        if (level >= 100) {
            return caseLocations;
        }
        for (Path caseBaseLocation : caseBaseLocations) {
            LOGGER.debug("Searching for cases in " + String.valueOf(caseBaseLocation));
            status.setInfoMessage(iu.getFormattedString("CaseScanner.Info.SearchingFolder", (Object)caseBaseLocation.toString()), iu.getString("CaseScanner.Info.SearchingFolder.Short"));
            Path fbiFile = caseBaseLocation.resolve("case.fbi2");
            boolean caseFbi2Exists = Files.exists(fbiFile, new LinkOption[0]);
            if (caseFbi2Exists) {
                caseLocations.add(caseBaseLocation.toAbsolutePath().toString());
                continue;
            }
            ArrayList<Path> subFoldersLocations = new ArrayList<Path>();
            try (Stream<Path> paths = Files.find(caseBaseLocation, 1, (path, attributes) -> attributes.isDirectory() && !path.toAbsolutePath().equals(caseBaseLocation.toAbsolutePath()), new FileVisitOption[0]);){
                paths.forEach(path -> subFoldersLocations.add((Path)path));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot scan folder " + String.valueOf(caseBaseLocation) + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                LOGGER.debug("Cannot scan folder " + String.valueOf(caseBaseLocation), (Throwable)e);
            }
            caseLocations.addAll(CaseScanner.getCasesFromLocation(subFoldersLocations, status, level + 1));
        }
        return caseLocations;
    }
}

