/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.antlr;

import com.nuix.automate.workflow.core.execution.options.relativity.restv1.CriteriaOperator;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.DocumentField;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldValueType;
import com.nuix.automate.workflow.core.utils.antlr.AntlrUtils;
import com.nuix.automate.workflow.core.utils.antlr.CriteriaDetails;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaCollection;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaCondition;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaConditionBase;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaDateCondition;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelativitySearchCriteriaUtils {
    private static RelativitySearchCriteriaUtils instance;
    private final Map<RelativityFieldValueType, Set<CriteriaOperator>> typeAllowedOperators = new HashMap<RelativityFieldValueType, Set<CriteriaOperator>>();

    public static RelativitySearchCriteriaUtils getInstance() {
        if (instance == null) {
            instance = new RelativitySearchCriteriaUtils();
        }
        return instance;
    }

    private RelativitySearchCriteriaUtils() {
        this.initTypeMap();
    }

    private void initTypeMap() {
        EnumSet<CriteriaOperator[]> textBasedOperators = EnumSet.of(CriteriaOperator.ANY_OF_THESE, new CriteriaOperator[]{CriteriaOperator.IS_SET, CriteriaOperator.IS, CriteriaOperator.IS_LIKE, CriteriaOperator.LESS_THAN, CriteriaOperator.GREATER_THAN, CriteriaOperator.LESS_THAN_OR_EQUAL_TO, CriteriaOperator.GREATER_THAN_OR_EQUAL_TO, CriteriaOperator.STARTS_WITH, CriteriaOperator.ENDS_WITH, CriteriaOperator.CONTAINS});
        EnumSet<CriteriaOperator[]> numberBasedOperators = EnumSet.of(CriteriaOperator.IS_SET, new CriteriaOperator[]{CriteriaOperator.IS, CriteriaOperator.LESS_THAN, CriteriaOperator.GREATER_THAN, CriteriaOperator.LESS_THAN_OR_EQUAL_TO, CriteriaOperator.GREATER_THAN_OR_EQUAL_TO});
        this.typeAllowedOperators.put(RelativityFieldValueType.FIXED_LENGTH_TEXT, new HashSet<CriteriaOperator[]>(textBasedOperators));
        this.typeAllowedOperators.put(RelativityFieldValueType.LONG_TEXT, new HashSet<CriteriaOperator[]>(textBasedOperators));
        this.typeAllowedOperators.put(RelativityFieldValueType.CURRENCY, new HashSet<CriteriaOperator[]>(numberBasedOperators));
        this.typeAllowedOperators.put(RelativityFieldValueType.DECIMAL, new HashSet<CriteriaOperator[]>(numberBasedOperators));
        this.typeAllowedOperators.put(RelativityFieldValueType.WHOLE_NUMBER, new HashSet<CriteriaOperator[]>(numberBasedOperators));
        this.typeAllowedOperators.put(RelativityFieldValueType.FILE, new HashSet());
        this.typeAllowedOperators.put(RelativityFieldValueType.MULTIPLE_CHOICE, new HashSet<CriteriaOperator>(EnumSet.of(CriteriaOperator.IS_SET, CriteriaOperator.ANY_OF_THESE, CriteriaOperator.ALL_OF_THESE)));
        this.typeAllowedOperators.put(RelativityFieldValueType.DATE, new HashSet<CriteriaOperator[]>(EnumSet.of(CriteriaOperator.IS_SET, new CriteriaOperator[]{CriteriaOperator.BETWEEN, CriteriaOperator.IN, CriteriaOperator.IS, CriteriaOperator.IS_BEFORE, CriteriaOperator.IS_BEFORE_OR_ON, CriteriaOperator.IS_AFTER, CriteriaOperator.IS_AFTER_OR_ON})));
        this.typeAllowedOperators.put(RelativityFieldValueType.MULTIPLE_OBJECT, new HashSet<CriteriaOperator[]>(EnumSet.of(CriteriaOperator.IS_SET, new CriteriaOperator[]{CriteriaOperator.ANY_OF_THESE, CriteriaOperator.IN, CriteriaOperator.ALL_OF_THESE, CriteriaOperator.IS_LIKE, CriteriaOperator.GREATER_THAN, CriteriaOperator.LESS_THAN})));
        this.typeAllowedOperators.put(RelativityFieldValueType.SINGLE_CHOICE, new HashSet<CriteriaOperator>(EnumSet.of(CriteriaOperator.IS_SET, CriteriaOperator.ANY_OF_THESE)));
        this.typeAllowedOperators.put(RelativityFieldValueType.SINGLE_OBJECT, new HashSet<CriteriaOperator>(EnumSet.of(CriteriaOperator.IS_SET, CriteriaOperator.ANY_OF_THESE, CriteriaOperator.IS_LIKE, CriteriaOperator.LESS_THAN, CriteriaOperator.GREATER_THAN)));
        this.typeAllowedOperators.put(RelativityFieldValueType.USER, new HashSet<CriteriaOperator>(EnumSet.of(CriteriaOperator.IS_SET, CriteriaOperator.IS_LOGGED_IN, CriteriaOperator.ANY_OF_THESE)));
        this.typeAllowedOperators.put(RelativityFieldValueType.YES_NO, new HashSet<CriteriaOperator>(EnumSet.of(CriteriaOperator.IS_SET, CriteriaOperator.IS)));
        this.typeAllowedOperators.put(RelativityFieldValueType.SAVED_SEARCH, new HashSet<CriteriaOperator>(EnumSet.of(CriteriaOperator.IN)));
    }

    private boolean isValidOperatorForFieldType(RelativityFieldValueType type, CriteriaOperator operator) {
        return this.typeAllowedOperators.get((Object)type).contains((Object)operator);
    }

    private String getAllowedTypeOperatorValues(RelativityFieldValueType type) {
        HashSet<String> allowedValues = new HashSet<String>();
        for (CriteriaOperator operator : this.typeAllowedOperators.get((Object)type)) {
            allowedValues.add(CriteriaOperator.toQueryString(operator, false));
            allowedValues.add(CriteriaOperator.toQueryString(operator, true));
        }
        return String.join((CharSequence)", ", allowedValues);
    }

    public CriteriaCollection verifyAndGetSavedSearch(String savedSearchQuery, Map<String, DocumentField> fields) throws Exception {
        CriteriaDetails details = AntlrUtils.getInstance().getSavedSearchConditions(savedSearchQuery);
        List<CriteriaConditionBase> infoList = details.getConditions();
        for (CriteriaConditionBase criteria : infoList) {
            if (!fields.containsKey(criteria.getFieldIdentifier().getName())) {
                throw new IllegalArgumentException("The field " + criteria.getFieldIdentifier().getName() + " does not exist");
            }
            RelativityFieldValueType type = fields.get(criteria.getFieldIdentifier().getName()).getFieldType();
            CriteriaOperator operator = null;
            operator = criteria.getClass().equals(CriteriaDateCondition.class) ? ((CriteriaDateCondition)criteria).getOperator() : ((CriteriaCondition)criteria).getOperator();
            if (this.isValidOperatorForFieldType(type, operator)) continue;
            throw new IllegalArgumentException("The field " + criteria.getFieldIdentifier().getName() + " has an invalid operator '" + CriteriaOperator.toQueryString(operator, criteria.isNotOperator()) + "'. The allowed operators for this field are: " + this.getAllowedTypeOperatorValues(type));
        }
        return details.getSearchCriteria();
    }
}

