/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.nuix.automate.workflow.core.utils.cds.AddressUtils;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.loadfile.CdsLoadFileItem;
import jakarta.mail.internet.InternetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CdsConversation {
    private String conversationId;
    private Set<InternetAddress> participants;
    private CdsItem rootItem;
    private Set<String> immutableIds;
    private Set<String> fileIds;
    private Map<String, List<CdsLoadFileItem>> userMessages;
    private String teamName;
    private String channelName;
    private String messageKind;

    public CdsConversation(String conversationId) {
        this.conversationId = conversationId;
        this.participants = new LinkedHashSet<InternetAddress>();
        this.immutableIds = new HashSet<String>();
        this.fileIds = new HashSet<String>();
        this.userMessages = new LinkedHashMap<String, List<CdsLoadFileItem>>();
    }

    public boolean isAttachmentFromConversation(String familyId, String modernParentId, String conversationId) {
        return this.fileIds.contains(familyId) || this.immutableIds.contains(modernParentId) || this.conversationId.equalsIgnoreCase(conversationId);
    }

    public void setRootItem(CdsItem rootItem) {
        this.rootItem = rootItem;
        if (rootItem != null) {
            this.setChannelName(rootItem.getChannelName());
            this.setTeamName(rootItem.getTeamName());
            this.setMessageKind(rootItem.getMessageKind());
        }
    }

    public void setParticipants(Set<InternetAddress> participants, String location) {
        this.participants = participants;
        this.updateRootItemLocation(location);
    }

    public void appendParticipants(Set<InternetAddress> participants, String location) {
        if (participants != null) {
            this.participants.addAll(participants);
            this.updateRootItemLocation(location);
        }
    }

    public void updateRootItemLocation(String location) {
        if (this.rootItem != null) {
            this.rootItem.setLocation(location, AddressUtils.render(this.participants));
        }
    }

    public void addMessage(CdsLoadFileItem item, CdsItem cdsItem) {
        this.addMessage(item, cdsItem.getCustodian(), cdsItem.getLocationName());
    }

    public void addMessage(CdsLoadFileItem item, String custodian, String locationName) {
        List<CdsLoadFileItem> userChatMessages;
        if (item == null) {
            return;
        }
        if ((custodian == null || custodian.trim().isEmpty()) && ((custodian = locationName) == null || custodian.trim().isEmpty())) {
            custodian = AddressUtils.renderShort(item.getItem().getSender());
        }
        if ((userChatMessages = this.userMessages.get(custodian)) == null) {
            userChatMessages = new ArrayList<CdsLoadFileItem>();
        }
        userChatMessages.add(item);
        this.userMessages.put(custodian, userChatMessages);
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public Set<InternetAddress> getParticipants() {
        return this.participants;
    }

    public CdsItem getRootItem() {
        return this.rootItem;
    }

    public Set<String> getImmutableIds() {
        return this.immutableIds;
    }

    public Set<String> getFileIds() {
        return this.fileIds;
    }

    public Map<String, List<CdsLoadFileItem>> getUserMessages() {
        return this.userMessages;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getMessageKind() {
        return this.messageKind;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setParticipants(Set<InternetAddress> participants) {
        this.participants = participants;
    }

    public void setImmutableIds(Set<String> immutableIds) {
        this.immutableIds = immutableIds;
    }

    public void setFileIds(Set<String> fileIds) {
        this.fileIds = fileIds;
    }

    public void setUserMessages(Map<String, List<CdsLoadFileItem>> userMessages) {
        this.userMessages = userMessages;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public void setMessageKind(String messageKind) {
        this.messageKind = messageKind;
    }
}

