/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.CdsExportFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CdsExportZip
extends CdsExportFile {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CdsExportZip.class);
    private ZipFile zipFile;

    public CdsExportZip(Path path) throws IOException {
        this.setName(path.getFileName().toString());
        this.setPath(path);
        this.zipFile = new ZipFile(path.toFile());
    }

    @Override
    public InputStream getInputStream(String fileName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(fileName);
        if (entry != null) {
            return this.zipFile.getInputStream(entry);
        }
        String purviewPatchedFileName = fileName + ".html";
        entry = this.zipFile.getEntry(purviewPatchedFileName);
        if (entry != null) {
            LOGGER.debug("Detected native " + fileName + " with .html suffix");
            return this.zipFile.getInputStream(entry);
        }
        LOGGER.warn("ZipFile does not contain entry: " + fileName);
        return null;
    }

    @Override
    public Long getSize(String fileName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(fileName);
        if (entry != null) {
            return entry.getSize();
        }
        String purviewPatchedFileName = fileName + ".html";
        entry = this.zipFile.getEntry(purviewPatchedFileName);
        if (entry != null) {
            LOGGER.debug("Detected native " + fileName + " with .html suffix");
            return entry.getSize();
        }
        LOGGER.warn("ZipFile does not contain entry: " + fileName);
        return null;
    }

    @Override
    public Long getCrc(String fileName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(fileName);
        if (entry != null) {
            return entry.getCrc();
        }
        String purviewPatchedFileName = fileName + ".html";
        entry = this.zipFile.getEntry(purviewPatchedFileName);
        if (entry != null) {
            LOGGER.debug("Detected native " + fileName + " with .html suffix");
            return entry.getCrc();
        }
        LOGGER.warn("ZipFile does not contain entry: " + fileName);
        return null;
    }

    @Override
    public void findAndSetLoadfile(String loadfileRegex) {
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            LOGGER.debug("Detected zip entry " + entry.getName());
            if (!entry.getName().matches(loadfileRegex)) continue;
            this.setLoadfileName(entry.getName());
            break;
        }
        if (this.getLoadfileName() == null) {
            LOGGER.error("Failed to set loadfile name with regex: " + loadfileRegex);
        }
    }

    @Override
    public FileTime getFileTime() {
        ZipEntry cdsLoadfile = this.zipFile.getEntry(this.getLoadfileName());
        if (cdsLoadfile != null) {
            FileTime creationTime = cdsLoadfile.getCreationTime();
            FileTime lastModifiedTime = cdsLoadfile.getLastModifiedTime();
            return this.getEarliestFileTime(creationTime, lastModifiedTime);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.zipFile != null) {
            this.zipFile.close();
        }
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
    }
}

