/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.aspose.email.MapiAttachment;
import com.aspose.email.MapiAttachmentCollection;
import com.aspose.email.MapiMessage;
import com.aspose.email.MapiProperty;
import com.aspose.email.MapiPropertyCollection;
import com.aspose.email.system.collections.generic.KeyValuePair;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.icu.lang.UCharacter;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UnicodeUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.AddressUtils;
import com.nuix.automate.workflow.core.utils.cds.CdsConversation;
import com.nuix.automate.workflow.core.utils.cds.CdsConversationMimeType;
import com.nuix.automate.workflow.core.utils.cds.CdsConversationReaction;
import com.nuix.automate.workflow.core.utils.cds.CdsConversationSource;
import com.nuix.automate.workflow.core.utils.cds.CdsCopilotApplication;
import com.nuix.automate.workflow.core.utils.cds.CdsFileClassType;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.CdsSystemMessageType;
import com.nuix.automate.workflow.core.utils.cds.CdsTeamsMessageType;
import com.nuix.automate.workflow.core.utils.cds.CdsUtils;
import com.nuix.automate.workflow.core.utils.loadfile.CdsLoadFileItem;
import jakarta.mail.internet.InternetAddress;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.safety.Safelist;
import org.jsoup.select.Elements;

public class CdsTeamsMessageParser {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CdsTeamsMessageParser.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private final Gson gson;
    private final String messageAuthorRegex = ".*?<.*?@.*?>";
    private final String copilotTextReferenceRegex = "%c\\d{1,}+%c";
    private final String conversationIdRegex = "\\d\\d:[a-zA-z0-9]+@thread\\.[a-z]+\\d";
    private final long itemDataProperty = 2151219231L;
    Map<String, String> teamsDefaultIcons = new HashMap<String, String>(){
        {
            this.put("like", "\ud83d\udc4d");
            this.put("heart", "\u2764\ufe0f");
            this.put("laugh", "\ud83d\ude06");
            this.put("surprised", "\ud83d\ude32");
        }
    };
    private final String mapiItemDataIdentifier = "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension";
    private final String mapiRecipientsIdentifier = "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension#RecipientsPreview";
    private final String mapiMessageSubType = "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension#MessageSubType";
    private final String mapiMessageSoftDeleted = "SkypeIsMessageSoftDeleted";
    private static final String conversationTypeIdentifier = "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension#ConversationType";
    private static final String threadTypeIdentifier = "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension#ThreadType";
    private static final String teamNameIdentifier = "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension#TeamName";
    private static final String channelNameIdentifier = "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension#Topic";
    private static final String lastModifiedMapiIdentifier = "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension#LastModifiedDateTime";
    private final String meetingItemDataIdentifier = "IOpenTypedFacet.SkypeSpaces_Meeting_Extension";
    private final String reactionsBlobIdentifier = "MapiReactionsBlob";
    private final String mapiCopilotHasCardAttachment = "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension#HasCardAttachments";
    private final Pattern tagXmlPattern = Pattern.compile("<([^>]+)>");
    private final Pattern valueXmlPattern = Pattern.compile("<value>([^<]+)<\\/value>");
    private final Pattern initiatorXmlPattern = Pattern.compile("<initiator>([^<]+)<\\/initiator>");
    private final Pattern targetXmlPattern = Pattern.compile("<target>([^<]+)<\\/target>");
    private static CdsTeamsMessageParser instance;

    public static CdsTeamsMessageParser getInstance() {
        if (instance == null) {
            instance = new CdsTeamsMessageParser();
        }
        return instance;
    }

    public CdsTeamsMessageParser() {
        this.gson = new GsonBuilder().create();
    }

    public List<CdsItem> parseHtmlGroupedMessages(CdsConversation cdsConversation, CdsItem cdsItem, String contents) {
        CdsItem parent = cdsConversation.getRootItem();
        ArrayList<CdsItem> conversations = new ArrayList<CdsItem>();
        String itemClass = parent.getItemClass();
        if (itemClass.equalsIgnoreCase("IPM.SkypeTeams.SystemMessage")) {
            itemClass = "IPM.SkypeTeams.Message";
        }
        String conversationId = parent.getConversationId();
        String parentLocation = parent.getLocation();
        String parentPath = parent.getPath();
        CdsTeamsMessageType parentTeamsMessageType = parent.getTeamsMessageType();
        CdsCopilotApplication parentCopilotApplication = parent.getCopilotApplication();
        Document doc = Jsoup.parse((String)contents);
        Elements messages = doc.select(".message");
        int messageIndex = 0;
        for (Element message : messages) {
            Element deleteDateTimeElement;
            String documentId;
            String clientMessageId;
            String systemMessageId;
            String[] messageInfo;
            if (parentTeamsMessageType == CdsTeamsMessageType.YAMMER_CONVERSATION) {
                messageInfo = message.attr("id").split("[.@_]");
                systemMessageId = messageInfo[2];
                clientMessageId = messageInfo[2];
                documentId = messageInfo[5];
            } else {
                messageInfo = message.attr("id").split("_");
                systemMessageId = messageInfo[1];
                clientMessageId = messageInfo[2];
                documentId = messageInfo[3];
            }
            CdsItem conversationMessage = new CdsItem();
            conversationMessage.setSystemMessageId(systemMessageId);
            conversationMessage.setDocumentId(documentId);
            conversationMessage.setImmutableId(documentId);
            conversationMessage.setClientMessageId(clientMessageId);
            conversationMessage.setTeamAddress(parent.getTeamAddress());
            conversationMessage.setTeamAndChannelName(parent.getTeamName(), parent.getChannelName());
            List<InternetAddress> recipientsPreview = this.setRecipientDataFromScript(conversationMessage, message);
            if (!conversationMessage.getSystemMessageId().equals(conversationMessage.getClientMessageId()) && parentTeamsMessageType != CdsTeamsMessageType.YAMMER_CONVERSATION) {
                conversationMessage.setOriginalMessageId(conversationMessage.getSystemMessageId());
                conversationMessage.setMessageRevision("Edit");
            } else {
                conversationMessage.setMessageRevision("Original");
            }
            if (parentTeamsMessageType != CdsTeamsMessageType.YAMMER_CONVERSATION) {
                try {
                    long dateEpoch = Long.parseLong(clientMessageId);
                    DateTime dateTime = new DateTime(dateEpoch);
                    conversationMessage.setDate(dateTime);
                }
                catch (Exception e) {
                    this.setDateTimeStringFromWrapper(message, conversationMessage);
                }
            } else {
                this.setDateTimeStringFromWrapper(message, conversationMessage);
            }
            conversationMessage.setFileClass(CdsFileClassType.CONVERSATION);
            conversationMessage.setConversationMimeType(cdsItem.getConversationMimeType());
            conversationMessage.setConversationSource(CdsConversationSource.GENERATED);
            conversationMessage.setItemClass(itemClass);
            Element author = message.selectFirst(".message__author");
            if (conversationMessage.getSender() == null && author != null) {
                InternetAddress senderAddress = AddressUtils.parseAddress(author.text());
                conversationMessage.setSender(senderAddress);
            }
            String custodian = AddressUtils.renderShort(conversationMessage.getSender());
            conversationMessage.setCustodian(custodian);
            Element callRecording = message.selectFirst("uriobject[type=Video.2/CallRecording.1]");
            if (callRecording != null) {
                List<CdsItem> recordingTranscriptItems = this.handleMessageRecordingTranscript(callRecording, conversationMessage);
                for (CdsItem recordingTranscriptItem : recordingTranscriptItems) {
                    if (recordingTranscriptItem.getRecipients() == null || recordingTranscriptItem.getRecipients().size() == 0) {
                        recordingTranscriptItem.setRecipients(parent.getRecipients());
                    }
                    recordingTranscriptItem.setConversationId(conversationId);
                    String chatMessageName = CdsTeamsMessageParser.getChatMessageName(recordingTranscriptItem);
                    recordingTranscriptItem.setLocation(parentLocation, chatMessageName);
                    recordingTranscriptItem.setPath(parentPath);
                    conversations.add(recordingTranscriptItem);
                }
                continue;
            }
            StringBuilder messageContent = new StringBuilder();
            Element content = message.selectFirst(".message__content");
            if (AddressUtils.getSystemEventAddresses().contains(conversationMessage.getSender())) {
                conversationMessage.setSystemMessageType(CdsSystemMessageType.SYSTEM_MESSAGE);
                this.setSystemMessageData(conversationMessage, message, cdsItem.getConversationType(), recipientsPreview);
                if ((conversationMessage.getContent() == null || conversationMessage.getContent().isEmpty()) && content != null) {
                    conversationMessage.setContent(content.text());
                }
            }
            if (conversationMessage.isSystemMessage()) {
                if (conversationMessage.getContent() == null || conversationMessage.getContent().isEmpty()) {
                    conversationMessage.setContent(CdsSystemMessageType.getSystemMessageContent(conversationMessage.getSystemMessageType(), conversationMessage.getSystemMessageScope()));
                }
            } else if (parentTeamsMessageType == CdsTeamsMessageType.COPILOT_CONVERSATION) {
                if (content != null) {
                    Element adaptiveCardElement = content.selectFirst(".ac-adaptivecard");
                    if (adaptiveCardElement != null) {
                        String text = adaptiveCardElement.text();
                        Object result = this.getMessageContent(conversationMessage, text, messageContent);
                        result = ((String)result).trim();
                        result = ((String)result).replaceAll("%c\\d{1,}+%c", "");
                        conversationMessage.setContent((String)result);
                    } else {
                        String result = this.getMessageContent(conversationMessage, (Node)content, messageContent);
                        result = result.trim();
                        result = result.replaceAll("%c\\d{1,}+%c", "");
                        conversationMessage.setContent(result);
                    }
                } else {
                    conversationMessage.setContent("");
                }
            } else {
                String result = this.getMessageContent(conversationMessage, (Node)content, messageContent);
                result = result.trim();
                conversationMessage.setContent(result);
            }
            conversationMessage.setTeamsMessageTypeFromParent(parentTeamsMessageType);
            if (parentTeamsMessageType == CdsTeamsMessageType.COPILOT_CONVERSATION) {
                conversationMessage.setCopilotApplication(parentCopilotApplication);
                if (messageIndex == 0) {
                    if (conversationMessage.getTeamsMessageType().equals((Object)CdsTeamsMessageType.COPILOT_ANSWER)) {
                        conversationMessage.setSender(AddressUtils.getCopilotAddress(parentCopilotApplication.toString()));
                    } else if (conversationMessage.getTeamsMessageType().equals((Object)CdsTeamsMessageType.COPILOT_QUESTION)) {
                        conversationMessage.setRecipients(new LinkedHashSet<InternetAddress>(Collections.singletonList(AddressUtils.getCopilotAddress(parentCopilotApplication.toString()))));
                    } else {
                        LOGGER.debug("Copilot interaction unknown");
                    }
                    parent.setSender(conversationMessage.getSender());
                    parent.setRecipients(conversationMessage.getRecipients());
                } else if (conversationMessage.getTeamsMessageType().equals((Object)CdsTeamsMessageType.COPILOT_ANSWER)) {
                    conversationMessage.setRecipients(new LinkedHashSet<InternetAddress>(Collections.singletonList(parent.getSender())));
                    if (!parent.getRecipients().isEmpty()) {
                        conversationMessage.setSender(parent.getRecipients().iterator().next());
                    }
                } else if (conversationMessage.getTeamsMessageType().equals((Object)CdsTeamsMessageType.COPILOT_QUESTION)) {
                    conversationMessage.setSender(parent.getSender());
                    conversationMessage.setRecipients(parent.getRecipients());
                }
            }
            if (parentTeamsMessageType == CdsTeamsMessageType.TEAMS_CHANNEL_CONVERSATION) {
                conversationMessage.setRecipients(new LinkedHashSet<InternetAddress>(Collections.singletonList(parent.getTeamAddress())));
            }
            Elements attachments = message.select("#OwaReferenceAttachments > div > a");
            Map<String, String> fileLocationIdMap = this.buildFileLocationIdMap(message);
            for (Element attachment : attachments) {
                String attachmentFilePath = attachment.attr("href").trim();
                String attachmentFileName = attachment.text().trim();
                String fileId = fileLocationIdMap.get(attachmentFilePath);
                if (conversationMessage.getItemClass().startsWith("IPM.SkypeTeams.Message.Copilot")) {
                    boolean attachmentHandled = false;
                    if (attachmentFileName.equalsIgnoreCase("TeamsChat") && attachmentFilePath.contains(fileId)) {
                        String formattedConversationId = this.getFormattedConversationId(fileId);
                        conversationMessage.setParentConversationId(formattedConversationId);
                        attachmentHandled = true;
                    }
                    if (attachmentHandled) continue;
                }
                Object linkAttachment = null;
                Elements linkAttachmentElements = message.select("[itemtype=http://schema.skype.com/HyperLink/Files]");
                if (!linkAttachmentElements.isEmpty()) {
                    for (Element linkAttachmentElement : linkAttachmentElements) {
                        String linkAttachmentText = linkAttachmentElement.text();
                        if (!linkAttachmentText.toLowerCase().contains(fileId.toLowerCase())) continue;
                        linkAttachment = linkAttachmentText;
                        break;
                    }
                }
                boolean attachmentFilePathNotEncoded = attachmentFilePath.endsWith(attachmentFileName);
                if (linkAttachment != null) {
                    conversationMessage.getMessageAttachmentPaths().add((String)(attachmentFilePathNotEncoded ? linkAttachment : linkAttachment + "/" + attachmentFileName));
                }
                conversationMessage.getMessageAttachmentPaths().add((String)(attachmentFilePathNotEncoded ? attachmentFilePath : (String)attachmentFilePath + "/" + attachmentFileName));
            }
            Element messageDelete = message.selectFirst(".deletion__header");
            if (messageDelete != null && (deleteDateTimeElement = messageDelete.selectFirst(".deletion__date-item-wrapper")) != null) {
                conversationMessage.setDeletedDateTime(this.parseMessageDateTime(deleteDateTimeElement.text()));
            }
            this.generateParentMessageIds(conversationMessage);
            Elements reactions = message.select(".reaction");
            for (Element reaction : reactions) {
                Element reactionDateTimeElement;
                Element reactionContentElement;
                CdsConversationReaction chatReaction = new CdsConversationReaction();
                Element reactionAuthorElement = reaction.selectFirst(".reaction__author");
                if (reactionAuthorElement != null) {
                    chatReaction.setAuthor(AddressUtils.parseAddress(reactionAuthorElement.text()));
                }
                if ((reactionContentElement = reaction.selectFirst(".reaction__content")) != null) {
                    chatReaction.setContent(this.getEmojiFromReaction(reactionContentElement.text()));
                }
                if ((reactionDateTimeElement = reaction.selectFirst(".reaction__date-time-wrapper")) != null) {
                    this.setReactionDateTime(reaction, chatReaction);
                }
                if (!chatReaction.isValidReaction()) continue;
                conversationMessage.getReactions().add(chatReaction);
            }
            if (conversationMessage.getRecipients() == null || conversationMessage.getRecipients().isEmpty()) {
                conversationMessage.setRecipients(parent.getRecipients());
            }
            conversationMessage.setConversationId(conversationId);
            String chatMessageName = CdsTeamsMessageParser.getChatMessageName(conversationMessage);
            conversationMessage.setLocation(parentLocation, chatMessageName);
            conversationMessage.setPath(parentPath);
            conversations.add(conversationMessage);
            ++messageIndex;
        }
        return conversations;
    }

    private String extractCdataFromScript(Element messageElement) {
        Element scriptElement = messageElement.selectFirst("script");
        String cdataPrefix = "<![CDATA[";
        String cdataSuffix = "]]";
        String scriptString = null;
        if (scriptElement != null) {
            List scriptNodes = scriptElement.dataNodes();
            for (DataNode script : scriptNodes) {
                if (!script.getWholeData().contains(cdataPrefix)) continue;
                scriptString = script.getWholeData();
                break;
            }
        }
        if (scriptString != null) {
            int cdataEnd = scriptString.lastIndexOf(cdataSuffix);
            int cdataStart = scriptString.indexOf(cdataPrefix);
            scriptString = scriptString.substring(cdataStart + cdataPrefix.length(), cdataEnd);
        }
        return scriptString;
    }

    private List<InternetAddress> setRecipientDataFromScript(CdsItem item, Element messageElement) {
        String cdata = this.extractCdataFromScript(messageElement);
        return this.setRecipientDataFromScript(item, cdata);
    }

    private List<InternetAddress> setRecipientDataFromScript(CdsItem item, String scriptString) {
        ArrayList<InternetAddress> recipientsPreviewList = new ArrayList<InternetAddress>();
        if (scriptString != null) {
            int recipientsPreviewIndex = ((String)scriptString).indexOf("\"RecipientsPreview\":");
            if (recipientsPreviewIndex == -1) {
                return null;
            }
            scriptString = "{" + ((String)scriptString).substring(recipientsPreviewIndex);
            try {
                JsonObject o = (JsonObject)this.gson.fromJson((String)scriptString, JsonObject.class);
                String recipientsPreviewJson = o.get("RecipientsPreview").getAsString();
                this.setRecipientsPreviewFromJson(item, recipientsPreviewJson, recipientsPreviewList);
            }
            catch (Exception e) {
                LOGGER.error("Unable to parse recipient count", (Throwable)e);
            }
        }
        return recipientsPreviewList;
    }

    public void setRecipientsPreviewFromJson(CdsItem item, String recipientsPreviewJson, List<InternetAddress> recipientsPreviewList) {
        if (recipientsPreviewJson != null && recipientsPreviewJson.trim().length() != 0) {
            try {
                LinkedHashSet<InternetAddress> recipients = new LinkedHashSet<InternetAddress>();
                JsonObject recipientsPreview = (JsonObject)this.gson.fromJson(recipientsPreviewJson, JsonObject.class);
                JsonObject senderObject = recipientsPreview.get("Sender").getAsJsonObject();
                String senderEmail = senderObject.get("EmailAddress").getAsString();
                String senderName = senderObject.get("Name").getAsString();
                InternetAddress sender = AddressUtils.fromEmailName(senderEmail, senderName);
                if (!senderEmail.contains("@teams.microsoft.com")) {
                    item.setSender(sender);
                    item.setCustodian(senderName);
                }
                if (recipientsPreviewList != null) {
                    recipientsPreviewList.add(sender);
                }
                JsonArray recipientsArray = recipientsPreview.get("Recipients").getAsJsonArray();
                for (JsonElement ele : recipientsArray) {
                    JsonObject recipientObject = ele.getAsJsonObject();
                    String name = recipientObject.get("Name").getAsString();
                    String emailAddress = recipientObject.get("EmailAddress").getAsString();
                    InternetAddress recipient = AddressUtils.fromEmailName(emailAddress, name);
                    recipients.add(recipient);
                    if (recipientsPreviewList == null) continue;
                    recipientsPreviewList.add(recipient);
                }
                item.setRecipients(recipients);
            }
            catch (Exception e) {
                LOGGER.error("Unable to parse recipient count", (Throwable)e);
            }
        }
    }

    public void parseAdaptiveCardContent(CdsItem item, Element element) {
    }

    public List<CdsItem> handleMessageRecordingTranscript(Element root, CdsItem parent) {
        Element videoExportElement;
        Element amsTranscriptElement;
        Element amsVideoElement;
        Element recordingDurationElement;
        Element callIdElement;
        Element fileNameElement;
        Element recordingPathElement;
        ArrayList<CdsItem> recordingTranscriptItems = new ArrayList<CdsItem>();
        String name = "";
        String fileName = "";
        String callId = "";
        String amsVideo = "";
        String amsTranscript = "";
        String videoExportUrl = "";
        String recordingDuration = "";
        Object recordingPath = "";
        Element nameElement = root.selectFirst("title");
        if (nameElement != null) {
            name = nameElement.text();
        }
        if ((recordingPathElement = root.selectFirst("a")) != null) {
            recordingPath = recordingPathElement.attr("href");
        }
        if ((fileNameElement = root.selectFirst("originalname")) != null && (fileName = fileNameElement.attr("v")).endsWith(".mp4")) {
            String tempPath = fileName.substring(0, fileName.length() - 4);
            recordingPath = (String)recordingPath + "/" + tempPath + ".zip";
        }
        if ((callIdElement = root.selectFirst("identifiers > id[type=callId]")) != null) {
            callId = callIdElement.attr("value");
        }
        if ((recordingDurationElement = root.selectFirst("recordingcontent")) != null) {
            recordingDuration = recordingDurationElement.attr("duration");
        }
        if ((amsVideoElement = root.selectFirst("recordingcontent > item[type=amsVideo]")) != null) {
            amsVideo = amsVideoElement.attr("uri");
        }
        if ((amsTranscriptElement = root.selectFirst("recordingcontent > item[type=amsTranscript]")) != null) {
            amsTranscript = amsTranscriptElement.attr("uri");
        }
        if ((videoExportElement = root.selectFirst("recordingcontent > item[type=onedriveForBusinessVideo]")) != null) {
            videoExportUrl = videoExportElement.attr("uri");
        }
        CdsItem recordingSystemEvent = parent.clone();
        recordingSystemEvent.setConversationMimeType(CdsConversationMimeType.SYSTEM_MESSAGE);
        recordingSystemEvent.setSystemMessageType(CdsSystemMessageType.CALL_RECORDING);
        recordingSystemEvent.setSystemMessageScope(2);
        recordingSystemEvent.setCallId(callId);
        recordingSystemEvent.setRecordingName(name);
        recordingSystemEvent.setRecordingFileName(fileName);
        recordingSystemEvent.setAmsVideoUrl(amsVideo);
        recordingSystemEvent.setVideoExportUrl(videoExportUrl);
        recordingSystemEvent.setDocumentId(UUID.randomUUID().toString().replace("-", ""));
        recordingSystemEvent.setContent(CdsSystemMessageType.getSystemMessageContent(CdsSystemMessageType.CALL_RECORDING, 2));
        recordingSystemEvent.setRecordingDuration(recordingDuration);
        recordingSystemEvent.setTeamsMessageType(CdsTeamsMessageType.TEAMS_VIDEO_RECORDING);
        recordingSystemEvent.getMessageAttachmentPaths().add((String)recordingPath);
        recordingTranscriptItems.add(recordingSystemEvent);
        if (!amsTranscript.trim().equals("")) {
            CdsItem transcriptSystemEvent = parent.clone();
            transcriptSystemEvent.setCallId(callId);
            transcriptSystemEvent.setConversationMimeType(CdsConversationMimeType.SYSTEM_MESSAGE);
            transcriptSystemEvent.setSystemMessageType(CdsSystemMessageType.CALL_TRANSCRIPT);
            transcriptSystemEvent.setSystemMessageScope(2);
            transcriptSystemEvent.setDocumentId(UUID.randomUUID().toString().replace("-", ""));
            transcriptSystemEvent.setAmsTranscriptUrl(amsTranscript);
            transcriptSystemEvent.setContent(CdsSystemMessageType.getSystemMessageContent(CdsSystemMessageType.CALL_TRANSCRIPT, 2));
            transcriptSystemEvent.setTeamsMessageType(CdsTeamsMessageType.TEAMS_TRANSCRIPT);
            recordingTranscriptItems.add(transcriptSystemEvent);
        }
        return recordingTranscriptItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CdsItem> parseTeamsCallEvent(CdsItem baseItem, String conversationLocation, InputStream entryInputStream) {
        ArrayList<CdsItem> callEvents = new ArrayList<CdsItem>();
        InternetAddress sender = baseItem.getSender();
        MapiMessage mapiMessage = null;
        try {
            MapiPropertyCollection mapiProperties;
            MapiProperty prop;
            mapiMessage = CdsUtils.loadEmail(entryInputStream);
            if (mapiMessage != null && (prop = CdsTeamsMessageParser.getMapiPropertyValue(mapiProperties = mapiMessage.getNamedProperties(), "IOpenTypedFacet.SkypeSpaces_Meeting_Extension")) != null) {
                String objStr = prop.getString();
                JsonObject itemDataParent = (JsonObject)this.gson.fromJson(objStr, JsonObject.class);
                String itemDataStr = itemDataParent.get("ItemData").getAsString();
                JsonObject itemData = (JsonObject)this.gson.fromJson(itemDataStr, JsonObject.class);
                String startTime = itemData.get("startTime").getAsString();
                String endTime = itemData.get("endTime").getAsString();
                String callId = itemData.get("communicationId").getAsString();
                String communicationType = itemData.get("communicationType").getAsString();
                String threadId = "";
                if (itemData.has("threadId")) {
                    threadId = itemData.get("threadId").getAsString();
                }
                DateTime startDateTime = DateTime.parse((String)startTime);
                DateTime endDateTime = DateTime.parse((String)endTime);
                baseItem.setFileClass(CdsFileClassType.CONVERSATION);
                baseItem.setConversationSource(CdsConversationSource.GENERATED);
                baseItem.setConversationMimeType(CdsConversationMimeType.SYSTEM_MESSAGE);
                baseItem.setCustodian(AddressUtils.renderShort(sender));
                baseItem.setSystemMessageScope(2);
                baseItem.setCallId(callId);
                switch (communicationType.toLowerCase()) {
                    default: {
                        baseItem.setTeamsMessageType(CdsTeamsMessageType.TEAMS_CALL);
                        break;
                    }
                    case "meeting": {
                        baseItem.setTeamsMessageType(CdsTeamsMessageType.TEAMS_MEETING);
                        break;
                    }
                    case "screenshare": {
                        baseItem.setTeamsMessageType(CdsTeamsMessageType.TEAMS_SCREEN_SHARE);
                    }
                }
                CdsItem callStarted = baseItem.clone();
                callStarted.setDate(startDateTime);
                callStarted.setClientMessageId("" + startDateTime.getMillis());
                callStarted.setSystemMessageId(callStarted.getClientMessageId());
                callStarted.setDocumentId(UUID.randomUUID().toString().replace("-", ""));
                callStarted.setSystemMessageType(CdsSystemMessageType.CALL_STARTED);
                callStarted.setCallStartTime(startTime);
                callStarted.setContent(CdsSystemMessageType.getSystemMessageContent(CdsSystemMessageType.CALL_STARTED, 2));
                callStarted.setLocation(conversationLocation, CdsTeamsMessageParser.getChatMessageName(callStarted));
                if (!threadId.equals("")) {
                    callStarted.setConversationId(this.getFormattedConversationId(threadId));
                }
                callEvents.add(callStarted);
                CdsItem callEnded = baseItem.clone();
                callEnded.setDate(endDateTime);
                callEnded.setClientMessageId("" + endDateTime.getMillis());
                callEnded.setSystemMessageId(callEnded.getClientMessageId());
                callEnded.setDocumentId(UUID.randomUUID().toString().replace("-", ""));
                callEnded.setSystemMessageType(CdsSystemMessageType.CALL_ENDED);
                callEnded.setCallEndTime(endTime);
                callEnded.setContent(CdsSystemMessageType.getSystemMessageContent(CdsSystemMessageType.CALL_ENDED, 2));
                callEnded.setLocation(conversationLocation, CdsTeamsMessageParser.getChatMessageName(callEnded));
                if (!threadId.equals("")) {
                    callEnded.setConversationId(this.getFormattedConversationId(threadId));
                }
                callEnded.setCallDuration(this.toReadableDuration(startDateTime, endDateTime));
                if (callEnded.getCallDuration() == null || callEnded.getCallDuration().trim().equals("")) {
                    callEnded.setCallDuration("0 seconds");
                }
                callEvents.add(callEnded);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to parse teams call/meeting", e);
            List<CdsItem> list = null;
            return list;
        }
        finally {
            CdsUtils.closeMapiMessage(mapiMessage);
        }
        return callEvents;
    }

    private String toReadableDuration(DateTime startTime, DateTime endTime) {
        Period period = new Period((ReadableInstant)startTime, (ReadableInstant)endTime);
        return period.toString(new PeriodFormatterBuilder().appendDays().appendSuffix(" Day ", " Days ").appendHours().appendSuffix(" Hour ", " Hours ").appendMinutes().appendSuffix(" Minute ", " Minutes ").printZeroRarelyLast().appendSeconds().appendSuffix(" Second", " Seconds").toFormatter());
    }

    private void setDateTimeStringFromWrapper(Element message, CdsItem item) {
        Element timeWrapper;
        Object dateTime = "";
        Element dateWrapper = message.selectFirst(".message__date-item-wrapper > .message__date");
        if (dateWrapper != null) {
            dateTime = (String)dateTime + dateWrapper.text();
        }
        if ((timeWrapper = message.selectFirst(".message__date-item-wrapper > .message__time")) != null) {
            dateTime = (String)dateTime + " " + timeWrapper.text();
        }
        dateTime = ((String)dateTime).trim();
        try {
            DateTime dt = this.parseMessageDateTime((String)dateTime);
            item.setDate(dt);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse item " + item.getNativeExportPath() + " date " + (String)dateTime, (Throwable)e);
            item.setDate(DateTime.now());
        }
    }

    private void setReactionDateTime(Element reactionElement, CdsConversationReaction reaction) {
        Element timeWrapper;
        Object dateTime = "";
        Element dateWrapper = reactionElement.selectFirst(".reaction__date-time-wrapper > .reaction__date");
        if (dateWrapper != null) {
            dateTime = (String)dateTime + dateWrapper.text();
        }
        if ((timeWrapper = reactionElement.selectFirst(".reaction__date-time-wrapper > .reaction__time")) != null) {
            dateTime = (String)dateTime + " " + timeWrapper.text();
        }
        dateTime = ((String)dateTime).trim();
        try {
            DateTime dt = this.parseMessageDateTime((String)dateTime);
            reaction.setDateTime(dt);
        }
        catch (Exception e) {
            reaction.setDateTime(null);
        }
    }

    public List<CdsItem> getCallContentsFromMapi(CdsItem cdsItem, MapiPropertyCollection properties) {
        try {
            MapiProperty prop;
            MapiProperty subType = CdsTeamsMessageParser.getMapiPropertyValue(properties, "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension#MessageSubType");
            if (subType != null && subType.getString().equalsIgnoreCase("Media_CallRecording") && (prop = CdsTeamsMessageParser.getMapiPropertyValue(properties, "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension")) != null) {
                JsonObject itemDataJson;
                String itemContent;
                Document doc;
                Element ele;
                Element callRecording;
                JsonObject o = (JsonObject)this.gson.fromJson(prop.getString(), JsonObject.class);
                if (o.has("RecipientsPreview")) {
                    String recipientsPreviewJson = o.get("RecipientsPreview").getAsString();
                    this.setRecipientsPreviewFromJson(cdsItem, recipientsPreviewJson, null);
                }
                if ((callRecording = (ele = (doc = Jsoup.parse((String)(itemContent = (itemDataJson = (JsonObject)this.gson.fromJson(o.get("ItemData").getAsString(), JsonObject.class)).get("content").getAsString()))).body()).selectFirst("uriobject[type=Video.2/CallRecording.1]")) != null) {
                    return this.handleMessageRecordingTranscript(callRecording, cdsItem);
                }
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to check if message is call recording system event", (Throwable)e);
        }
        return null;
    }

    public void updateCdsItemFromMsg(CdsConversation cdsConversation, CdsItem cdsItem, MapiMessage mapiMessage) {
        if (mapiMessage != null) {
            MapiProperty itemDataProp;
            MapiPropertyCollection mapiProperties = mapiMessage.getNamedProperties();
            CdsItem parent = cdsConversation.getRootItem();
            Object custodian = parent.getCustodian();
            if (cdsItem.isItemClassSystemMessage()) {
                cdsItem.setSystemMessageType(CdsSystemMessageType.SYSTEM_MESSAGE);
                cdsItem.setTeamsMessageType(CdsTeamsMessageType.TEAMS_SYSTEM_MESSAGE);
                custodian = "System Event";
            }
            if ((itemDataProp = CdsTeamsMessageParser.getMapiPropertyValue(mapiProperties, "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension")) != null) {
                cdsItem.setConversationSource(CdsConversationSource.GENERATED);
                String itemDataPropValue = itemDataProp.getString();
                JsonObject itemDataContainerJson = (JsonObject)this.gson.fromJson(itemDataPropValue, JsonObject.class);
                JsonObject itemDataJson = (JsonObject)this.gson.fromJson(itemDataContainerJson.get("ItemData").getAsString(), JsonObject.class);
                String itemContent = itemDataJson.get("content").getAsString();
                StringBuilder sb = new StringBuilder();
                this.getMessageContent(cdsItem, itemContent, sb);
                cdsItem.setContent(sb.toString());
                if (itemDataJson.has("messageVersion")) {
                    cdsItem.setClientMessageId(itemDataJson.get("messageVersion").getAsString());
                } else {
                    cdsItem.setClientMessageId(itemDataJson.get("clientMessageId").getAsString());
                }
                cdsItem.setSystemMessageId(itemDataJson.get("serverMessageId").getAsString());
                if (!cdsItem.getSystemMessageId().equals(cdsItem.getClientMessageId())) {
                    cdsItem.setOriginalMessageId(cdsItem.getSystemMessageId());
                    cdsItem.setMessageRevision("Edit");
                } else {
                    cdsItem.setMessageRevision("Original");
                }
                if (itemDataContainerJson.has("RecipientsPreview") && !cdsItem.isSystemMessage()) {
                    String recipientsPreviewJson = itemDataContainerJson.get("RecipientsPreview").getAsString();
                    this.setRecipientsPreviewFromJson(cdsItem, recipientsPreviewJson, null);
                }
                if (cdsItem.isSystemMessage()) {
                    List<InternetAddress> recipientsPreview = this.setRecipientDataFromScript(cdsItem, itemDataPropValue);
                    this.setSystemMessageData(cdsItem, itemDataPropValue, null, cdsItem.getConversationType(), recipientsPreview);
                }
                if (parent.isCopilotConversation()) {
                    block30: {
                        cdsItem.setTeamsMessageTypeFromParent(parent.getTeamsMessageType());
                        if (cdsItem.getTeamsMessageType() == CdsTeamsMessageType.COPILOT_ANSWER) {
                            custodian = "Copilot in " + cdsItem.getCopilotApplication().toString();
                        } else if (cdsItem.getTeamsMessageType() == CdsTeamsMessageType.COPILOT_QUESTION && cdsItem.getSender().getPersonal() != null) {
                            custodian = cdsItem.getSender().getPersonal();
                        }
                        if (itemDataContainerJson.has("Links")) {
                            LinkedHashSet<String> copilotLinks = new LinkedHashSet<String>();
                            JsonArray copilotLinksEle = itemDataContainerJson.get("Links").getAsJsonArray();
                            Iterator iterator = copilotLinksEle.iterator();
                            while (iterator.hasNext()) {
                                JsonElement link = (JsonElement)iterator.next();
                                copilotLinks.add(link.getAsString());
                            }
                            cdsItem.setCopilotLinks(copilotLinks);
                        }
                        try {
                            if (cdsItem.getCopilotApplication() != CdsCopilotApplication.TEAMS || !itemDataContainerJson.has("FileItemIds")) break block30;
                            JsonArray array = itemDataContainerJson.get("FileItemIds").getAsJsonArray();
                            for (JsonElement ele : array) {
                                String fileId = ele.getAsString();
                                if (!fileId.matches("\\d\\d:[a-zA-z0-9]+@thread\\.[a-z]+\\d")) continue;
                                cdsItem.setParentConversationId(this.getFormattedConversationId(fileId));
                                break;
                            }
                        }
                        catch (Exception array) {
                            // empty catch block
                        }
                    }
                    MapiProperty cardAttachmentProperty = CdsTeamsMessageParser.getMapiPropertyValue(mapiProperties, "IOpenTypedFacet.SkypeSpaces_ConversationPost_Extension#HasCardAttachments");
                    if (cardAttachmentProperty != null && cardAttachmentProperty.getBoolean()) {
                        try {
                            MapiAttachmentCollection attachments = mapiMessage.getAttachments();
                            for (MapiAttachment attachment : attachments) {
                                if (!CdsUtils.isCopilotCardAttachment(attachment)) continue;
                                byte[] attachmentData = attachment.getBinaryData();
                                Document doc = Jsoup.parse((String)new String(attachmentData, StandardCharsets.UTF_8));
                                Element element = doc.body();
                                StringBuilder cardContent = new StringBuilder();
                                this.getMessageContent(cdsItem, (Node)element, cardContent);
                                cdsItem.setContent(cardContent.toString());
                            }
                        }
                        catch (Exception e) {
                            LOGGER.info("Failed to set copilot content from MAPI message properties " + cdsItem.getNativeExportPath(), (Throwable)e);
                        }
                    }
                }
                if (cdsItem.getCustodian() == null || cdsItem.getCustodian().trim().length() == 0) {
                    cdsItem.setCustodian((String)custodian);
                }
            }
            this.parseMessageReactionFromMapi(cdsItem, mapiProperties);
            MapiProperty softDeleteProp = CdsTeamsMessageParser.getMapiPropertyValue(mapiProperties, "SkypeIsMessageSoftDeleted");
            MapiProperty deletedOnProp = mapiProperties.get_Item(1720647744L);
            if (softDeleteProp != null && Boolean.parseBoolean(softDeleteProp.getString()) || deletedOnProp != null) {
                String lastModifiedDate;
                cdsItem.setDeleted(true);
                MapiProperty lastModifiedTime = CdsTeamsMessageParser.getMapiPropertyValue(mapiProperties, lastModifiedMapiIdentifier);
                if (lastModifiedTime != null) {
                    lastModifiedDate = lastModifiedTime.toString();
                    cdsItem.setDeletedDateTime(this.parseReactionDateTime(lastModifiedDate));
                } else {
                    lastModifiedTime = mapiProperties.get_Item(805830720L);
                    if (lastModifiedTime != null) {
                        lastModifiedDate = lastModifiedTime.toString();
                        cdsItem.setDeletedDateTime(this.parseMessageDateTime(lastModifiedDate));
                    }
                }
            }
            cdsItem.setTeamsMessageTypeFromParent(parent.getTeamsMessageType());
            if (cdsItem.getContent() == null) {
                cdsItem.setConversationSource(CdsConversationSource.PREDEFINED);
            }
            if (cdsItem.isSystemMessage()) {
                cdsItem.setSender(AddressUtils.fromEmailName("SystemEvent@teams.microsoft.com", "System Event"));
                cdsItem.setCustodian("System Event");
            }
            if (cdsItem.isCopilotItem() && cdsItem.getTeamsMessageType() == CdsTeamsMessageType.COPILOT_ANSWER) {
                cdsItem.setCustodian("Copilot in " + String.valueOf((Object)cdsItem.getCopilotApplication()));
            }
            String chatMessageName = CdsTeamsMessageParser.getChatMessageName(cdsItem);
            cdsItem.setLocation(parent.getLocation(), chatMessageName);
            cdsItem.setPath(parent.getPath() + "/" + chatMessageName);
        }
    }

    public static String getStringFromMapiProperties(MapiPropertyCollection properties, String key) {
        MapiProperty prop = CdsTeamsMessageParser.getMapiPropertyValue(properties, key);
        if (prop != null) {
            return prop.getString();
        }
        return null;
    }

    public static String getTeamNameFromMapiProperties(MapiPropertyCollection properties) {
        return CdsTeamsMessageParser.getStringFromMapiProperties(properties, teamNameIdentifier);
    }

    public static String getChannelNameFromMapiProperties(MapiPropertyCollection properties) {
        return CdsTeamsMessageParser.getStringFromMapiProperties(properties, channelNameIdentifier);
    }

    public static String getConversationTypeFromMapiProperties(MapiPropertyCollection properties) {
        String conversationType = CdsTeamsMessageParser.getStringFromMapiProperties(properties, conversationTypeIdentifier);
        if (conversationType == null) {
            conversationType = CdsTeamsMessageParser.getStringFromMapiProperties(properties, threadTypeIdentifier);
        }
        return conversationType;
    }

    public void parseMessageReactionFromMapi(CdsItem item, MapiPropertyCollection properties) {
        try {
            MapiProperty reactionsBlob = CdsTeamsMessageParser.getMapiPropertyValue(properties, "MapiReactionsBlob");
            if (reactionsBlob != null) {
                String data = new String(reactionsBlob.getData(), StandardCharsets.UTF_8);
                JsonObject o = (JsonObject)this.gson.fromJson(data, JsonObject.class);
                JsonArray reactionsArray = o.get("Reactions").getAsJsonArray();
                for (JsonElement reactionElement : reactionsArray) {
                    JsonObject reactionObject = reactionElement.getAsJsonObject();
                    CdsConversationReaction reaction = new CdsConversationReaction();
                    DateTime parsedDateTime = this.parseReactionDateTime(reactionObject.get("DateTime").getAsString());
                    reaction.setDateTime(parsedDateTime);
                    reaction.setContent(this.getEmojiFromReaction(reactionObject.get("Type").getAsString()));
                    reaction.setAuthor(AddressUtils.fromEmailName(reactionObject.get("Email").getAsString(), reactionObject.get("Name").getAsString()));
                    if (!reaction.isValidReaction()) continue;
                    item.getReactions().add(reaction);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse reactions from MAPI properties " + item.getNativeExportPath(), (Throwable)e);
        }
    }

    protected static MapiProperty getMapiPropertyValue(MapiPropertyCollection properties, String identifier) {
        long tagIdentifier = 0L;
        try {
            Method getTagMethod = MapiPropertyCollection.class.getMethod("getTagFromNamedProperty", String.class);
            tagIdentifier = (Long)getTagMethod.invoke((Object)properties, identifier);
            MapiProperty prop = properties.get_Item(tagIdentifier);
            if (prop != null) {
                return prop;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (properties != null) {
            for (KeyValuePair value : properties) {
                String propertyName = ((MapiProperty)value.getValue()).getDescriptor().getName();
                if (propertyName == null || !propertyName.equalsIgnoreCase(identifier)) continue;
                return (MapiProperty)value.getValue();
            }
        }
        return null;
    }

    public List<CdsItem> generateMessageReactions(CdsLoadFileItem parentLoadFileItem, boolean fromEmail) {
        CdsItem parent = parentLoadFileItem.getItem();
        ArrayList<CdsItem> reactions = new ArrayList<CdsItem>();
        for (CdsConversationReaction reaction : parent.getReactions()) {
            CdsItem reactionItem = new CdsItem();
            String id = UUID.randomUUID().toString().replace("-", "");
            reactionItem.setDocumentId(id);
            reactionItem.setImmutableId(id);
            reactionItem.setConversationId(parent.getConversationId());
            reactionItem.setModernParentId(parent.getImmutableId());
            reactionItem.setFileClass(CdsFileClassType.ATTACHMENT);
            reactionItem.setConversationMimeType(CdsConversationMimeType.REACTION);
            reactionItem.setLocation(parent.getLocation(), this.getReactionName(reaction));
            reactionItem.setCustodian(AddressUtils.renderShort(reaction.getAuthor()));
            if (fromEmail) {
                reactionItem.setTeamsMessageType(CdsTeamsMessageType.EMAIL_REACTION);
            } else {
                reactionItem.setTeamsMessageType(CdsTeamsMessageType.TEAMS_CHAT_REACTION);
            }
            reactionItem.setSender(reaction.getAuthor());
            reactionItem.setRecipients(parent.getParticipants());
            reactionItem.setContent(reaction.getContent());
            reactionItem.setDate(reaction.getDateTime());
            reactions.add(reactionItem);
        }
        return reactions;
    }

    private void generateParentMessageIds(CdsItem item) {
        LinkedHashSet<String> parentMessageIds = new LinkedHashSet<String>();
        String itemContentHtml = "<html><body>" + item.getContent() + "</body></html>";
        Document copilotHtml = Jsoup.parse((String)itemContentHtml);
        Elements links = copilotHtml.select("a");
        for (Element link : links) {
            String href = link.attr("href");
            if (href.equals("")) continue;
            try {
                String[] path = new URL(href).getPath().split("/");
                parentMessageIds.add(path[path.length - 1]);
            }
            catch (Exception e) {
                LOGGER.error("Unable to parse teams co-pilot link", (Throwable)e);
            }
        }
        item.setParentMessageIds(parentMessageIds);
    }

    private DateTime parseUsUtcDateTime(String dateTime, boolean withSeconds) {
        if (dateTime == null || dateTime.trim().isEmpty()) {
            return null;
        }
        try {
            return DateTime.parse((String)(dateTime + " UTC"), (DateTimeFormatter)DateTimeFormat.forPattern((String)("MM/dd/yyyy hh:mm" + (withSeconds ? ":ss" : "") + " a z")));
        }
        catch (Exception exception) {
            try {
                return DateTime.parse((String)(dateTime + " UTC"), (DateTimeFormatter)DateTimeFormat.forPattern((String)("M/d/yyyy h:mm" + (withSeconds ? ":ss" : "") + " a z")));
            }
            catch (Exception exception2) {
                try {
                    return DateTime.parse((String)dateTime);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot parse dateTime " + (withSeconds ? "wih seconds " : "") + dateTime, (Throwable)e);
                    return null;
                }
            }
        }
    }

    private DateTime parseMessageDateTime(String dateTime) {
        return this.parseUsUtcDateTime(dateTime, false);
    }

    private DateTime parseReactionDateTime(String dateTime) {
        return this.parseUsUtcDateTime(dateTime, true);
    }

    private Map<String, String> buildFileLocationIdMap(Element message) {
        HashMap<String, String> fileLocationIdMap = new HashMap<String, String>();
        Elements fileLinks = message.select(".file__link");
        for (Element fileLink : fileLinks) {
            fileLocationIdMap.put(fileLink.text().trim(), fileLink.attr("id"));
        }
        return fileLocationIdMap;
    }

    private String getReactionName(CdsConversationReaction reaction) {
        return String.valueOf(reaction.getDateTime().withZone(DateTimeZone.UTC)) + ": " + String.valueOf(reaction.getAuthor()) + ": " + reaction.getContent();
    }

    public static String getChatMessageName(CdsItem message) {
        if (message.getItemClass() == null) {
            return "Unknown";
        }
        if (message.getItemClass().startsWith("IPM.Yammer.")) {
            return message.getPrintableDate() + ": " + AddressUtils.render(message.getSender()) + " -> " + String.valueOf((Object)message.getTeamsMessageType());
        }
        if (message.isSystemMessage()) {
            return message.getPrintableDate() + ": " + message.getSystemMessageType().getEventName();
        }
        if (message.getConversationMimeType() == CdsConversationMimeType.CHANNEL_MESSAGE && message.getChannelName() != null && message.getTeamName() != null) {
            return message.getPrintableDate() + ": " + AddressUtils.render(message.getSender()) + " -> " + message.getChannelName();
        }
        if (message.getTeamsMessageType() == CdsTeamsMessageType.COPILOT_QUESTION) {
            return message.getPrintableDate() + ": " + AddressUtils.render(message.getSender()) + " -> Copilot in " + String.valueOf((Object)message.getCopilotApplication());
        }
        if (message.getTeamsMessageType() == CdsTeamsMessageType.COPILOT_ANSWER) {
            return message.getPrintableDate() + ": Copilot in " + String.valueOf((Object)message.getCopilotApplication()) + " -> " + AddressUtils.render(message.getRecipients());
        }
        Set<InternetAddress> participants = message.getRecipients();
        Object recipientsDisplay = participants.size() == 1 ? AddressUtils.render((InternetAddress)participants.stream().iterator().next()) : "[" + message.getNonSystemRecipientsCount() + " recipients]";
        return message.getPrintableDate() + ": " + AddressUtils.render(message.getSender()) + " -> " + (String)recipientsDisplay;
    }

    private String getFormattedConversationId(String conversationId) {
        return conversationId.replaceAll("[^a-zA-Z0-9-]+", "");
    }

    private void setSystemMessageData(CdsItem item, Element messageElement, String conversationType, List<InternetAddress> recipientsPreview) {
        String cdata = this.extractCdataFromScript(messageElement);
        Element messageContent = messageElement.selectFirst(".message__content");
        if (messageContent != null) {
            String messageContentText = messageContent.text();
            this.setSystemMessageData(item, cdata, messageContentText, conversationType, recipientsPreview);
        }
    }

    private void setSystemMessageData(CdsItem item, String content, String messageContentText, String conversationType, List<InternetAddress> recipientsPreview) {
        if (content != null) {
            try {
                JsonObject itemDataObject;
                JsonObject contentJson = (JsonObject)this.gson.fromJson(content, JsonObject.class);
                String parsedMessageSubType = null;
                if (contentJson.has("MessageSubType")) {
                    parsedMessageSubType = contentJson.get("MessageSubType").getAsString();
                }
                String parsedConversationType = null;
                if (contentJson.has("ConversationType")) {
                    parsedConversationType = contentJson.get("ConversationType").getAsString();
                }
                this.setSystemMessageDataFromJson(item, parsedConversationType, parsedMessageSubType, conversationType);
                String itemData = null;
                if (contentJson.has("ItemData")) {
                    itemData = contentJson.get("ItemData").getAsString();
                }
                if (itemData != null && (itemDataObject = (JsonObject)this.gson.fromJson(itemData, JsonObject.class)) != null) {
                    String itemDataContent;
                    JsonObject fromObj;
                    int recipientIndex = 0;
                    HashMap<String, InternetAddress> idToAddress = new HashMap<String, InternetAddress>();
                    String senderId = "unknown";
                    if (itemDataObject.has("from") && (fromObj = itemDataObject.get("from").getAsJsonObject()).has("internalId")) {
                        senderId = fromObj.get("internalId").getAsString();
                    }
                    if (recipientsPreview != null) {
                        idToAddress.put(senderId, recipientsPreview.get(recipientIndex));
                        ++recipientIndex;
                    }
                    JsonArray toArray = null;
                    if (itemDataObject.has("to")) {
                        toArray = itemDataObject.get("to").getAsJsonArray();
                        for (JsonElement jsonElement : toArray) {
                            JsonObject obj = jsonElement.getAsJsonObject();
                            String recipientId = "unknown";
                            if (obj.has("internalId")) {
                                recipientId = obj.get("internalId").getAsString();
                            }
                            if (recipientsPreview == null || recipientIndex >= recipientsPreview.size()) continue;
                            idToAddress.put(recipientId, recipientsPreview.get(recipientIndex));
                            ++recipientIndex;
                        }
                    }
                    if ((itemDataContent = itemDataObject.get("content").getAsString()) != null) {
                        item.setContent(this.getSystemMessageBody(item, messageContentText, idToAddress, itemDataContent));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to parse content", (Throwable)e);
            }
        }
    }

    private String getSystemMessageBody(CdsItem item, String systemMessage, Map<String, InternetAddress> idToAddress, String itemDataContent) {
        String initiatorId;
        InternetAddress initiatorAddress;
        StringBuilder message = new StringBuilder();
        if (systemMessage == null) {
            systemMessage = itemDataContent;
        }
        if (systemMessage.startsWith("<")) {
            if (!item.getSystemMessageType().equals((Object)CdsSystemMessageType.GENERIC) && !item.getSystemMessageType().equals((Object)CdsSystemMessageType.SYSTEM_MESSAGE)) {
                String convertedSystemMessage = CdsSystemMessageType.getSystemMessageContent(item.getSystemMessageType(), item.getSystemMessageScope());
                message.append(convertedSystemMessage);
            } else {
                Matcher tagMatcher = this.tagXmlPattern.matcher(systemMessage);
                if (tagMatcher.find()) {
                    message.append("\n").append(this.iu.getFormattedString("ConvertPurviewCdsOperation.Event", (Object)tagMatcher.group(1)));
                }
            }
            Matcher valueMatcher = this.valueXmlPattern.matcher(systemMessage);
            if (valueMatcher.find()) {
                message.append("\n").append(this.iu.getFormattedString("ConvertPurviewCdsOperation.Value", (Object)valueMatcher.group(1)));
            }
        } else {
            message.append(systemMessage);
        }
        Matcher initiatorMatcher = this.initiatorXmlPattern.matcher(itemDataContent);
        if (initiatorMatcher.find() && (initiatorAddress = idToAddress.get(initiatorId = initiatorMatcher.group(1))) != null) {
            message.append(" \n").append(this.iu.getFormattedString("ConvertPurviewCdsOperation.Initiator", (Object)AddressUtils.render(initiatorAddress)));
        }
        Matcher targetMatcher = this.targetXmlPattern.matcher(itemDataContent);
        while (targetMatcher.find()) {
            InternetAddress targetAddress = idToAddress.get(targetMatcher.group(1));
            if (targetAddress == null) continue;
            message.append(" \n").append(this.iu.getFormattedString("ConvertPurviewCdsOperation.Target", (Object)AddressUtils.render(targetAddress)));
        }
        return message.toString();
    }

    private void setSystemMessageDataFromJson(CdsItem item, String conversationLevel, String messageType, String conversationType) {
        int level = 0;
        if (conversationLevel != null) {
            if (conversationLevel.equalsIgnoreCase("P2PChat") || conversationLevel.equalsIgnoreCase("GroupChat")) {
                level = 2;
            } else if (conversationLevel.equalsIgnoreCase("Channel")) {
                level = 1;
            }
        } else if (conversationType.equalsIgnoreCase("Group")) {
            level = 2;
        } else if (conversationType.equalsIgnoreCase("Channel")) {
            level = 1;
        }
        item.setSystemMessageScope(level);
        if (messageType == null) {
            item.setSystemMessageType(CdsSystemMessageType.GENERIC);
        } else {
            item.setSystemMessageType(CdsSystemMessageType.getType(messageType));
        }
        item.setConversationMimeType(CdsConversationMimeType.SYSTEM_MESSAGE);
    }

    private String getMessageContent(CdsItem item, String contents, StringBuilder sb) {
        try {
            Document doc = Jsoup.parse((String)contents);
            Element body = doc.body();
            return this.getMessageContent(item, (Node)body, sb);
        }
        catch (Exception e) {
            return contents;
        }
    }

    private String getMessageContent(CdsItem item, Node contentNode, StringBuilder sb) {
        if (contentNode == null) {
            return "";
        }
        List children = contentNode.childNodes();
        for (Node node : children) {
            if (node instanceof Element) {
                Element child = (Element)node;
                String childStyle = child.attr("style");
                if (childStyle.contains("display:none") || childStyle.contains("visibility:hidden")) continue;
                if (!child.children().isEmpty()) {
                    this.getMessageContent(item, (Node)child, sb);
                    continue;
                }
                String childText = child.text();
                if (childText.startsWith("<") && childText.endsWith(">")) {
                    String htmlText = Jsoup.clean((String)childText, (Safelist)Safelist.relaxed());
                    Element textElement = Jsoup.parseBodyFragment((String)htmlText).body();
                    this.getMessageContent(item, (Node)textElement, sb);
                    continue;
                }
                if (child.tagName().equals("a")) {
                    String linkText = this.parseElementLink(child, childText);
                    sb.append(linkText);
                    continue;
                }
                if (child.tagName().equals("img")) {
                    this.parseElementImage(item, child, sb);
                    continue;
                }
                if (childText.trim().isEmpty()) continue;
                sb.append(childText);
                continue;
            }
            if (!(node instanceof TextNode)) continue;
            sb.append(((TextNode)node).text());
        }
        return sb.toString();
    }

    private String parseElementLink(Element child, String childText) {
        String href = child.attr("href");
        Object linkText = !childText.trim().isEmpty() && !href.equals(childText) ? childText + " {" + href + "}" : href;
        return linkText;
    }

    private void parseElementImage(CdsItem cdsItem, Element child, StringBuilder sb) {
        String itemType = child.attr("itemtype");
        String imageSrc = child.attr("src");
        String imageName = child.attr("title");
        if (imageName.isEmpty()) {
            imageName = child.attr("alt");
        }
        if (itemType.equals("http://schema.skype.com/Emoji")) {
            String emoji = this.getEmoji(child);
            sb.append(emoji);
        } else if (imageSrc.startsWith("data:")) {
            String dataTypeContent = imageSrc.substring("data:".length());
            String[] dataTypeContentSplits = dataTypeContent.split(",");
            if (dataTypeContentSplits.length > 1) {
                byte[] dataBytes;
                String data = dataTypeContentSplits[1];
                try {
                    String dataType = dataTypeContentSplits[0];
                    String[] dataTypeSplits = dataType.split(";");
                    dataBytes = dataTypeSplits.length > 1 && dataTypeSplits[1].equalsIgnoreCase("base64") ? Base64.getDecoder().decode(data.replace("\n", "").replace("\r", "")) : URLDecoder.decode(data, "UTF-8").getBytes(StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot decode embedded data", (Throwable)e);
                    dataBytes = data.getBytes(StandardCharsets.UTF_8);
                }
                cdsItem.addEmbeddedAttachment(imageName, dataBytes);
            }
        } else {
            sb.append(imageName).append(" {").append(imageSrc).append("}");
        }
    }

    private String getEmojiFromReaction(String emojiReaction) {
        return this.getEmojiFromReaction(emojiReaction, false, false);
    }

    private String getEmojiFromReaction(String emojiReaction, boolean addLeadingPlus, boolean addTrailingRenderCharacter) {
        if (emojiReaction == null || emojiReaction.trim().equals("")) {
            return "";
        }
        String emoji = emojiReaction;
        if (emoji.startsWith("+")) {
            emoji = emoji.substring(1);
        }
        emoji = emoji.trim();
        int codePoint = -1;
        String leadingPlus = addLeadingPlus ? "+" : "";
        String[] split = emoji.split("_");
        if (split.length == 1) {
            String teamsDefaultIcon = this.teamsDefaultIcons.get(split[0]);
            if (teamsDefaultIcon != null) {
                return leadingPlus + emoji.toLowerCase() + (String)(addTrailingRenderCharacter ? " " + teamsDefaultIcon : "");
            }
            String c = UnicodeUtils.getInstance().getCharFromName(emoji);
            if (c != null) {
                return leadingPlus + emoji.toLowerCase() + (String)(addTrailingRenderCharacter ? " " + c : "");
            }
            codePoint = UCharacter.getCharFromExtendedName((String)split[0].toUpperCase());
            if (codePoint == -1) {
                return leadingPlus + emoji.toLowerCase();
            }
            return leadingPlus + split[0].toLowerCase() + (String)(addTrailingRenderCharacter ? " " + UCharacter.toString((int)codePoint) : "");
        }
        try {
            codePoint = Integer.decode("0x" + split[0]);
            return leadingPlus + split[1].toLowerCase() + (String)(addTrailingRenderCharacter ? " " + UCharacter.toString((int)codePoint) : "");
        }
        catch (Exception e) {
            return leadingPlus + emoji.toLowerCase();
        }
    }

    private String getEmoji(Element emojiElement) {
        String emoji = null;
        String itemId = emojiElement.attr("itemid");
        String title = emojiElement.attr("title");
        String alt = emojiElement.attr("alt");
        if (!alt.startsWith("\ufffd")) {
            return title + " " + alt;
        }
        emoji = UnicodeUtils.getInstance().getCharFromName(title);
        if (emoji == null) {
            emoji = UnicodeUtils.getInstance().getCharFromName(alt.replace("(", "").replace(")", ""));
        }
        if (emoji == null) {
            emoji = UnicodeUtils.getInstance().getCharFromName(itemId);
        }
        if (emoji != null) {
            return title + " " + emoji;
        }
        String[] split = itemId.split("_");
        int codePoint = -1;
        try {
            codePoint = Integer.decode("0x" + split[0]);
        }
        catch (Exception e) {
            codePoint = UCharacter.getCharFromExtendedName((String)itemId);
        }
        emoji = UCharacter.toString((int)codePoint);
        if (emoji != null) {
            return title + " " + emoji;
        }
        return title + " {" + itemId + "}";
    }
}

