/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.aspose.email.FolderInfo;
import com.aspose.email.FolderInfoCollection;
import com.aspose.email.KnownPropertyList;
import com.aspose.email.MapiProperty;
import com.aspose.email.MapiPropertyCollection;
import com.aspose.email.MessageInfo;
import com.aspose.email.MessageInfoCollection;
import com.aspose.email.PersonalStorage;
import com.aspose.email.PersonalStorageLoadOptions;
import com.aspose.email.PropertyDescriptor;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.MessageRef;
import com.nuix.automate.workflow.core.utils.cds.PurviewExportFile;
import com.nuix.automate.workflow.core.utils.loadfile.CountingCrcOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PurviewExportPst
extends PurviewExportFile {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewExportPst.class);
    private final Map<String, List<MessageRef>> messages = new HashMap<String, List<MessageRef>>();
    private final List<PersonalStorage> psts = new ArrayList<PersonalStorage>();
    private final ZipFile zipFile;
    private final Path pstFolderPath;
    private final Map<String, Long> messageToSize;
    private final Map<String, Long> messageToCrc;
    private final Set<String> seenMessageRefIds;

    public PurviewExportPst(Path filePath) throws IOException {
        if (filePath.toFile().isFile()) {
            this.zipFile = new ZipFile(filePath.toFile());
            this.pstFolderPath = null;
        } else {
            this.pstFolderPath = filePath;
            this.zipFile = null;
        }
        this.messageToSize = new HashMap<String, Long>();
        this.messageToCrc = new HashMap<String, Long>();
        this.seenMessageRefIds = new HashSet<String>();
        this.init();
    }

    private void init() throws IOException {
        PersonalStorageLoadOptions loadOptions = new PersonalStorageLoadOptions();
        loadOptions.setLeaveStreamOpen(this.zipFile != null);
        loadOptions.setWritable(false);
        if (this.zipFile != null) {
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().toLowerCase().endsWith(".pst")) continue;
                this.psts.add(PersonalStorage.fromStream((InputStream)this.zipFile.getInputStream(entry), (PersonalStorageLoadOptions)loadOptions));
            }
        } else {
            Files.walk(this.pstFolderPath, new FileVisitOption[0]).forEach(file -> {
                try {
                    if (file.toFile().isFile() && file.toFile().getName().toLowerCase().endsWith(".pst")) {
                        this.psts.add(PersonalStorage.fromFile((String)this.pstFolderPath.resolve((Path)file).toString(), (PersonalStorageLoadOptions)loadOptions));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load PST file " + String.valueOf(file.getFileName()), (Throwable)e);
                }
            });
        }
        for (PersonalStorage pst : this.psts) {
            FolderInfo rootFolder = pst.getRootFolder();
            this.buildMessages(rootFolder, pst);
        }
    }

    private void buildMessages(FolderInfo folder, PersonalStorage pst) {
        FolderInfoCollection subFolders;
        MessageInfoCollection contents = folder.getContents();
        if (!contents.isEmpty()) {
            for (MessageInfo message : contents) {
                MapiPropertyCollection properties = message.getProperties();
                MapiProperty messageId = properties.getProperty((PropertyDescriptor)KnownPropertyList.INTERNET_MESSAGE_ID);
                if (messageId != null) {
                    List<MessageRef> messageRefs;
                    String internetMessageId = String.valueOf(messageId.getValue());
                    if (this.messages.containsKey(internetMessageId)) {
                        LOGGER.warn("MapiMessage with the same internet message ID already exists: " + internetMessageId);
                    }
                    if ((messageRefs = this.messages.get(internetMessageId)) == null) {
                        messageRefs = new ArrayList<MessageRef>();
                    }
                    messageRefs.add(new MessageRef(pst, message.getEntryIdString()));
                    this.messages.put(internetMessageId, messageRefs);
                    continue;
                }
                LOGGER.warn("Internet message ID does not exist");
            }
        }
        if (!(subFolders = folder.getSubFolders()).isEmpty()) {
            for (FolderInfo subFolder : subFolders) {
                this.buildMessages(subFolder, pst);
            }
        }
    }

    private MessageRef getUniqueMessageRef(CdsItem cdsItem, List<MessageRef> messageRefs) {
        if (cdsItem.getMessageRefId() != null) {
            for (MessageRef messageRef : messageRefs) {
                if (!messageRef.getId().equals(cdsItem.getMessageRefId())) continue;
                return messageRef;
            }
        }
        for (MessageRef messageRef : messageRefs) {
            if (this.seenMessageRefIds.contains(messageRef.getId())) continue;
            this.seenMessageRefIds.add(messageRef.getId());
            cdsItem.setMessageRefId(messageRef.getId());
            if (messageRefs.size() > 1) {
                cdsItem.setDuplicateItem(true);
            }
            return messageRef;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(CdsItem cdsItem) throws IOException {
        String internetMessageId = cdsItem.getInternetMessageId();
        if (internetMessageId == null) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(8192);
        CountingCrcOutputStream countingCrcOutputStream = new CountingCrcOutputStream(stream);
        List<MessageRef> messageRefs = this.messages.get(internetMessageId);
        MessageRef messageRef = this.getUniqueMessageRef(cdsItem, messageRefs);
        if (messageRef == null) {
            return null;
        }
        PurviewExportPst purviewExportPst = this;
        synchronized (purviewExportPst) {
            messageRef.getPst().saveMessageToStream(messageRef.getId(), (OutputStream)countingCrcOutputStream);
            this.messageToSize.putIfAbsent(messageRef.getId(), Long.valueOf(stream.size()));
            this.messageToCrc.putIfAbsent(messageRef.getId(), countingCrcOutputStream.getCrc());
            return new ByteArrayInputStream(stream.toByteArray());
        }
    }

    @Override
    public Long getSize(CdsItem cdsItem) throws IOException {
        String internetMessageId = cdsItem.getInternetMessageId();
        if (internetMessageId == null) {
            return null;
        }
        if (this.messageToSize.containsKey(internetMessageId)) {
            return this.messageToSize.get(internetMessageId);
        }
        return null;
    }

    @Override
    public Long getCrc(CdsItem cdsItem) throws IOException {
        String internetMessageId = cdsItem.getInternetMessageId();
        if (internetMessageId == null) {
            return null;
        }
        if (this.messageToCrc.containsKey(internetMessageId)) {
            return this.messageToCrc.get(internetMessageId);
        }
        return null;
    }

    @Override
    public boolean hasItem(CdsItem cdsItem) {
        String internetMessageId = cdsItem.getInternetMessageId();
        if (internetMessageId == null) {
            return false;
        }
        return this.messages.containsKey(internetMessageId);
    }

    @Override
    public void close() throws IOException {
        for (PersonalStorage pst : this.psts) {
            try {
                pst.close();
            }
            catch (Exception e) {
                LOGGER.error("Unable to close PST", (Throwable)e);
            }
        }
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (Exception e) {
                LOGGER.error("Unable to close zip", (Throwable)e);
            }
        }
    }
}

