/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.CdsUtils;
import com.nuix.automate.workflow.core.utils.cds.PurviewExportFile;
import com.nuix.automate.workflow.core.utils.cds.PurviewExportFolder;
import com.nuix.automate.workflow.core.utils.cds.PurviewExportPst;
import com.nuix.automate.workflow.core.utils.cds.PurviewExportZip;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PurviewItemsZipHandler {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewItemsZipHandler.class);
    private Map<String, PurviewExportFile> purviewExports;
    private Path exportPath;

    public PurviewItemsZipHandler(Path path) {
        this.exportPath = path;
        this.purviewExports = new HashMap<String, PurviewExportFile>();
    }

    public void scanForPurviewExports(String itemsRegex, String pstRegex) throws IOException {
        String extractedItemsRegex = itemsRegex.length() > "\\.zip".length() ? itemsRegex.substring(0, itemsRegex.length() - "\\.zip".length()) : itemsRegex;
        String extractedPstRegex = pstRegex.length() > "\\.zip".length() ? pstRegex.substring(0, pstRegex.length() - "\\.zip".length()) : pstRegex;
        try {
            Files.walk(this.exportPath, 1, new FileVisitOption[0]).forEach(file -> {
                String fileName = file.getFileName().toString();
                PurviewExportFile exportFile = null;
                if (fileName.matches(itemsRegex) || fileName.matches(extractedItemsRegex)) {
                    if (fileName.toLowerCase().endsWith(".zip")) {
                        try {
                            exportFile = new PurviewExportZip((Path)file);
                            LOGGER.info("Found new ZIP export: " + fileName);
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot handle Purview export ZIP", (Throwable)e);
                        }
                    } else if (file.toFile().isDirectory()) {
                        try {
                            exportFile = new PurviewExportFolder((Path)file);
                            LOGGER.info("Found new export folder: " + fileName);
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot handle Purview export Folder", (Throwable)e);
                        }
                    }
                }
                if ((fileName.matches(pstRegex) || fileName.matches(extractedPstRegex)) && (fileName.toLowerCase().endsWith(".zip") || file.toFile().isDirectory())) {
                    try {
                        exportFile = new PurviewExportPst((Path)file);
                        LOGGER.info("Found new PST export: " + fileName);
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot handle Purview export PST", (Throwable)e);
                    }
                }
                if (exportFile != null) {
                    this.purviewExports.put(fileName.toLowerCase(), exportFile);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Error scanning for Purview exports", (Throwable)e);
        }
    }

    private String checkPstContainers(CdsItem cdsItem) {
        for (String containerKey : this.purviewExports.keySet()) {
            if (!containerKey.toLowerCase().startsWith("pst") || !this.purviewExports.get(containerKey).hasItem(cdsItem)) continue;
            return containerKey;
        }
        return null;
    }

    public InputStream getItemInputStream(CdsItem cdsItem) throws IOException {
        List<String> pathSplit = CdsUtils.getPathSplit(cdsItem.getNativeExportPath());
        String exportContainerKey = pathSplit.get(0).toLowerCase();
        String extractedExportContainerKey = exportContainerKey.replace(".zip", "");
        if (this.purviewExports.containsKey(exportContainerKey)) {
            return this.purviewExports.get(exportContainerKey).getInputStream(cdsItem);
        }
        if (this.purviewExports.containsKey(extractedExportContainerKey)) {
            return this.purviewExports.get(extractedExportContainerKey).getInputStream(cdsItem);
        }
        String pstContainerKey = this.checkPstContainers(cdsItem);
        if (pstContainerKey != null) {
            return this.purviewExports.get(pstContainerKey).getInputStream(cdsItem);
        }
        return null;
    }

    public Long getCrc(CdsItem cdsItem) throws IOException {
        List<String> pathSplit = CdsUtils.getPathSplit(cdsItem.getNativeExportPath());
        String exportContainerKey = pathSplit.get(0).toLowerCase();
        String extractedExportContainerKey = exportContainerKey.replace(".zip", "");
        if (this.purviewExports.containsKey(exportContainerKey)) {
            return this.purviewExports.get(exportContainerKey).getCrc(cdsItem);
        }
        if (this.purviewExports.containsKey(extractedExportContainerKey)) {
            return this.purviewExports.get(extractedExportContainerKey).getCrc(cdsItem);
        }
        String pstContainerKey = this.checkPstContainers(cdsItem);
        if (pstContainerKey != null) {
            return this.purviewExports.get(pstContainerKey).getCrc(cdsItem);
        }
        return null;
    }

    public Long getSize(CdsItem cdsItem) throws IOException {
        List<String> pathSplit = CdsUtils.getPathSplit(cdsItem.getNativeExportPath());
        String exportContainerKey = pathSplit.get(0).toLowerCase();
        String extractedExportContainerKey = exportContainerKey.replace(".zip", "");
        if (this.purviewExports.containsKey(exportContainerKey)) {
            return this.purviewExports.get(exportContainerKey).getSize(cdsItem);
        }
        if (this.purviewExports.containsKey(extractedExportContainerKey)) {
            return this.purviewExports.get(extractedExportContainerKey).getSize(cdsItem);
        }
        String pstContainerKey = this.checkPstContainers(cdsItem);
        if (pstContainerKey != null) {
            return this.purviewExports.get(pstContainerKey).getSize(cdsItem);
        }
        return null;
    }

    public Map<String, PurviewExportFile> getPurviewExports() {
        return this.purviewExports;
    }

    public Path getExportPath() {
        return this.exportPath;
    }

    public void setPurviewExports(Map<String, PurviewExportFile> purviewExports) {
        this.purviewExports = purviewExports;
    }

    public void setExportPath(Path exportPath) {
        this.exportPath = exportPath;
    }
}

