/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.PurviewItemsZipHandler;
import com.nuix.automate.workflow.core.utils.cds.PurviewReportFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;

public class PurviewReportFolder
extends PurviewReportFile {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewReportFolder.class);

    public PurviewReportFolder(Path path) throws IOException {
        super(path);
        this.itemsHandler = new PurviewItemsZipHandler(path.getParent());
    }

    @Override
    public InputStream getInputStream(CdsItem cdsItem) throws IOException {
        return this.itemsHandler.getItemInputStream(cdsItem);
    }

    @Override
    public Long getCrc(CdsItem cdsItem) throws IOException {
        return this.itemsHandler.getCrc(cdsItem);
    }

    @Override
    public Long getSize(CdsItem cdsItem) throws IOException {
        return this.itemsHandler.getSize(cdsItem);
    }

    @Override
    public List<InputStream> getLoadfileInputStreams() throws IOException {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        for (String loadfileName : this.loadfileNames) {
            inputStreams.add(this.getInternalInputStream(loadfileName));
        }
        return inputStreams;
    }

    @Override
    public InputStream getInternalInputStream(String fileName) throws IOException {
        Path filePath = FileUtils.safeResolveParent((Path)this.getPath(), (String[])new String[]{fileName});
        if (!Files.isDirectory(filePath, new LinkOption[0]) && Files.exists(filePath, new LinkOption[0])) {
            return Files.newInputStream(filePath, new OpenOption[0]);
        }
        LOGGER.error("Export does not contain file: " + fileName);
        return null;
    }

    @Override
    public void findAndSetLoadfileName(String purviewReportItemsRegex) {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.getPath());){
            for (Path filePath : dirStream) {
                if (Files.isDirectory(filePath, new LinkOption[0])) continue;
                LOGGER.debug("Detected path entry: " + String.valueOf(filePath));
                if (!filePath.getFileName().toString().matches(purviewReportItemsRegex)) continue;
                this.loadfileNames.add(filePath.getFileName().toString());
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading path: " + String.valueOf(this.getPath()), (Throwable)e);
        }
        if (this.getLoadfileNames().isEmpty()) {
            LOGGER.error("Failed to set loadfile name with regex: " + purviewReportItemsRegex);
        }
    }

    @Override
    public FileTime getFileTime() throws IOException {
        Path loadfilePath = this.getPath().resolve(this.getFirstLoadfileName());
        BasicFileAttributes attr = Files.readAttributes(loadfilePath, BasicFileAttributes.class, new LinkOption[0]);
        FileTime creationTime = attr.creationTime();
        FileTime lastModifiedTime = attr.lastModifiedTime();
        return this.getEarliestFileTime(creationTime, lastModifiedTime);
    }
}

