/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.derbycontrol;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.workflow.core.utils.derbycontrol.DerbyControlCaseInfo;
import com.nuix.automate.workflow.core.utils.general.ThirdPartyProxyRestClient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;

public class DerbyControlServiceRestClient
extends ThirdPartyProxyRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DerbyControlServiceRestClient.class);

    public DerbyControlServiceRestClient(String thirdPartyServiceId, String schedulerUrl, String bearerToken, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        super(thirdPartyServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
    }

    @Override
    public String getLogFileName() {
        return System.getProperty("automate.derbycontrolservice.log");
    }

    @Override
    public String getServiceName() {
        return "Derby Control Service";
    }

    public void callDerbyControlService(DerbyControlCaseInfo derbyControlCaseInfo) throws IOException {
        LOGGER.info("Calling Derby Control Service on case " + derbyControlCaseInfo.getCaseId() + " at " + derbyControlCaseInfo.getCasePath());
        ApiProxyRequest apiProxyRequest = new ApiProxyRequest();
        apiProxyRequest.setBody((Object)derbyControlCaseInfo);
        this.proxyApiRequest(apiProxyRequest);
    }
}

