/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.discover;

import com.google.gson.Gson;
import com.nuix.automate.utils.api.script.RestSSLException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.JwtUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.DiscoverService;
import com.nuix.automate.utils.models.api.thirdparty.DiscoverUserCredential;
import com.nuix.automate.workflow.core.execution.events.ItemHandledCallback;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.discover.DiscoverItemSourceType;
import com.nuix.automate.workflow.core.execution.options.promotetodiscover.DiscoverDateFormat;
import com.nuix.automate.workflow.core.execution.options.promotetodiscover.DiscoverExportOptions;
import com.nuix.automate.workflow.core.execution.options.promotetodiscover.DocumentIdType;
import com.nuix.automate.workflow.core.execution.options.promotetodiscover.LevelStrategy;
import com.nuix.automate.workflow.core.execution.options.usediscovercase.DiscoverFileRepositoryType;
import com.nuix.automate.workflow.core.execution.options.usediscovercase.DiscoverIdentifierType;
import com.nuix.automate.workflow.core.execution.options.usediscovercase.DiscoverUserCaseCategory;
import com.nuix.automate.workflow.core.utils.discover.DiscoverCaseDoesNotExistException;
import com.nuix.automate.workflow.core.utils.discover.DiscoverError;
import com.nuix.automate.workflow.core.utils.discover.DiscoverErrors;
import com.nuix.automate.workflow.core.utils.discover.DiscoverRestException;
import com.nuix.automate.workflow.core.utils.discover.DocumentMapping;
import com.nuix.automate.workflow.core.utils.discover.Query;
import com.nuix.automate.workflow.core.utils.discover.responses.BinderResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.Case;
import com.nuix.automate.workflow.core.utils.discover.responses.CaseCloneResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.CaseGroupsResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.CaseResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.DiscoverDocument;
import com.nuix.automate.workflow.core.utils.discover.responses.DiscoverFieldsResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.DiscoverObject;
import com.nuix.automate.workflow.core.utils.discover.responses.DocumentSearchResultsResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.EntityResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.Group;
import com.nuix.automate.workflow.core.utils.discover.responses.ImportJob;
import com.nuix.automate.workflow.core.utils.discover.responses.ImportJobAddConversationsResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.ImportJobAddDocumentsResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.ImportJobAddMessageEventsResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.ImportJobCreateResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.ImportJobSubmitResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.Job;
import com.nuix.automate.workflow.core.utils.discover.responses.MeResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.Org;
import com.nuix.automate.workflow.core.utils.discover.responses.OrgResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.ProductionResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.RpfResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.SavedSearchResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.SearchRunResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.UserCaseAssignResponse;
import com.nuix.automate.workflow.core.utils.discover.responses.UserGroupAssignResponse;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import nuix.Address;
import nuix.Communication;
import nuix.DocumentNumber;
import nuix.Item;
import nuix.MutablePrintedImage;
import nuix.ProductionSet;
import nuix.ProductionSetItem;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.MethodNotSupportedException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class DiscoverRestClient
implements AutoCloseable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DiscoverRestClient.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private String apiUrl;
    private String apiToken;
    private Client client;
    private Gson gson;
    private Pattern emailDomain = Pattern.compile(".*@(\\S+).*");
    private Pattern emailOu = Pattern.compile(".*\\/ou=([^\\/]+)\\/.*");
    private boolean usingCustomFingerprint = false;
    private boolean reattemptEnabled;
    private int maxAttempts;
    private Operation operation;
    private static final String healthServiceEndpoint = "/health/test";
    private static final String queryServiceEndpoint = "/api/query";
    private static final Set<String> illegalFieldNames = new HashSet<String>(Arrays.asList("Document Date", "Document Description", "Document Title", "Document Type", "Estimated Date"));
    private LogChannel logChannel;
    private transient LogHandler logHandler;
    private String clientName;

    public DiscoverRestClient(String hostname, String apiToken, String clientName, LogChannel logChannel, Set<String> whitelistedCertificateFingerprints) throws GeneralSecurityException {
        this.logChannel = logChannel;
        this.reattemptEnabled = true;
        this.maxAttempts = this.getSystemProperty("automate.discover.maxAttempts", 5);
        Map claims = JwtUtils.getTokenClaimsNoVerify((String)apiToken);
        Object apiUrlClaim = claims.get("apiUrl");
        if (apiUrlClaim == null) {
            throw new GeneralSecurityException(this.iu.getFormattedString("DiscoverRestClient.Error.InvalidToken", new Object[0]));
        }
        this.apiUrl = apiUrlClaim.toString();
        if (!this.apiUrl.toLowerCase(Locale.ROOT).startsWith("http://" + hostname + "/") && !this.apiUrl.toLowerCase(Locale.ROOT).startsWith("https://" + hostname + "/")) {
            throw new GeneralSecurityException(this.iu.getFormattedString("DiscoverRestClient.Error.InvalidHostname", new Object[]{this.apiUrl, hostname}));
        }
        this.apiToken = apiToken;
        if (clientName == null || clientName.isEmpty()) {
            clientName = "discover-api";
        }
        this.clientName = clientName;
        this.client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)this.clientName, whitelistedCertificateFingerprints, (boolean)false);
        if (whitelistedCertificateFingerprints != null && whitelistedCertificateFingerprints.size() >= 1) {
            this.usingCustomFingerprint = true;
        }
        this.gson = new Gson();
        this.logHandler = LogHandler.getInstance();
    }

    public DiscoverRestClient(String hostname, String apiToken, LogChannel logChannel, Set<String> whitelistedCertificateFingerprints) throws GeneralSecurityException {
        this(hostname, apiToken, null, logChannel, whitelistedCertificateFingerprints);
    }

    public DiscoverRestClient(DiscoverService discoverService, DiscoverUserCredential userCredential, String clientName, LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        this(discoverService.getHostname(), userCredential.getToken(), clientName, logChannel, whitelistedCertFingerprints);
    }

    @Override
    public void close() {
        block3: {
            try {
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Unable to close client", (Throwable)e);
            }
        }
    }

    public void setReattemptEnabled(boolean reattemptEnabled) {
        this.reattemptEnabled = reattemptEnabled;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <ResponseType, RequestType> ResponseType callApi(String url, String method, RequestType requestData, GenericType<ResponseType> entityType) throws IOException {
        DiscoverRestClient.LOGGER.info(method + " " + url);
        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent(method + " " + url));
        if (requestData instanceof Query) {
            query = (Query)requestData;
            this.logHandler.addLogEvent(this.logChannel.getLogEvent(query.getQuery() + "\n"));
            this.logHandler.addLogEvent(this.logChannel.getLogEvent(this.gson.toJson(query.getVariables()) + "\n"));
        } else {
            this.logHandler.addLogEvent(this.logChannel.getLogEvent(this.gson.toJson(requestData) + "\n"));
        }
        response = null;
        attemptDelaySeconds = this.getSystemProperty("automate.discover.attemptDelaySeconds", 10);
        attempt = 1;
        errorMessage = null;
        while (true) {
            try {
                block47: {
                    while (true) {
                        webTarget = this.client.target(url);
                        invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.apiToken)).header("ApiKey", (Object)this.apiToken);
                        logFileName = System.getProperty("automate.discover.log");
                        logFile = null;
                        if (logFileName != null) {
                            logFile = new File(logFileName);
                        }
                        if (logFile != null) {
                            try {
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)(method + " " + url + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)this.gson.toJson(requestData), (Charset)StandardCharsets.UTF_8, (boolean)true);
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)"\n\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                            }
                            catch (Exception e) {
                                DiscoverRestClient.LOGGER.warn("Cannot write Discover log", (Throwable)e);
                            }
                        }
                        e = method;
                        var14_20 = -1;
                        switch (e.hashCode()) {
                            case 2461856: {
                                if (!e.equals("POST")) break;
                                var14_20 = 0;
                                break;
                            }
                            case 79599: {
                                if (!e.equals("PUT")) break;
                                var14_20 = 1;
                                break;
                            }
                        }
                        switch (var14_20) {
                            case 0: {
                                response = invocationBuilder.post(Entity.entity((Object)SerializationUtils.toJson(requestData, (boolean)false), (String)"application/json"));
                                break;
                            }
                            case 1: {
                                response = invocationBuilder.put(Entity.entity((Object)SerializationUtils.toJson(requestData, (boolean)false), (String)"application/json"));
                                break;
                            }
                            default: {
                                throw new NotImplementedException("Method " + method + " not implemented in server API with body");
                            }
                        }
                        stringResponse = (String)response.readEntity(String.class);
                        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent("HTTP/" + response.getStatus()));
                        this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                        this.logHandler.addLogEvent(this.logChannel.getSeparator());
                        if (logFile != null) {
                            try {
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                            }
                            catch (Exception e) {
                                DiscoverRestClient.LOGGER.warn("Cannot write Discover log", (Throwable)e);
                            }
                        }
                        if (response.getStatus() == 401) {
                            throw new IOException(this.iu.getString("DiscoverRestClient.Error.InvalidApiToken"));
                        }
                        if (response.getStatus() == 403) {
                            throw new IOException("User does not have permissions to perform operation in Discover");
                        }
                        if (response.getStatus() == 404) {
                            throw new NotFoundException(this.iu.getString("DiscoverRestClient.Error.CannotConnectToService"));
                        }
                        if (response.getStatus() == 405) {
                            throw new MethodNotSupportedException(this.iu.getString("DiscoverRestClient.Error.CannotConnectToService"));
                        }
                        if (response.getStatus() == 200 || response.getStatus() == 201 || response.getStatus() == 202) break block47;
                        DiscoverRestClient.LOGGER.error(method + ": " + this.apiUrl + "\nBody: " + this.gson.toJson(requestData));
                        DiscoverRestClient.LOGGER.error(this.apiUrl + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                        if (logFile != null) {
                            try {
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                            }
                            catch (Exception e) {
                                DiscoverRestClient.LOGGER.warn("Cannot write Discover log", (Throwable)e);
                            }
                        }
                        if ((discoverErrors = (DiscoverErrors)SerializationUtils.fromJson((String)stringResponse, DiscoverErrors.class)) != null && discoverErrors.getErrors() != null && discoverErrors.getErrors().size() > 0) {
                            discoverRestException = new DiscoverRestException(discoverErrors);
                            if (errorMessage == null) {
                                errorMessage = discoverRestException.getMessage();
                            }
                        } else if (errorMessage == null) {
                            errorMessage = "HTTP/" + response.getStatus() + " " + stringResponse;
                        }
                        if (response.getStatus() < 500 || response.getStatus() >= 600 || !this.reattemptEnabled || attempt > this.maxAttempts) break;
                        if (this.operation != null && errorMessage != null && attempt == 1) {
                            this.operation.addTransientWarning((String)errorMessage, false);
                        }
                        ++attempt;
                        try {
                            Thread.sleep(attemptDelaySeconds * 1000);
                        }
                        catch (InterruptedException e) {
                            DiscoverRestClient.LOGGER.error((Throwable)e);
                            Thread.currentThread().interrupt();
lbl96:
                            // 4 sources

                            while (true) {
                                if (logFile != null) {
                                    try {
                                        org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                                        org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                                    }
                                    catch (Exception e) {
                                        DiscoverRestClient.LOGGER.warn("Cannot write Discover log", (Throwable)e);
                                    }
                                }
                                responseData = entityType.getType().equals(String.class) != false ? stringResponse : SerializationUtils.fromJson((String)stringResponse, (Class)entityType.getRawType());
                                e = responseData;
                                return (ResponseType)e;
                            }
                        }
                    }
                    if (discoverErrors == null) throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
                    if (discoverErrors.getErrors() == null) throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
                    if (discoverErrors.getErrors().size() <= 0) throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
                    throw new DiscoverRestException(discoverErrors);
                }
                if (this.operation == null) ** GOTO lbl96
            }
            catch (DiscoverRestException e) {
                throw e;
            }
            catch (ProcessingException e) {
                if (e.getCause() == null) throw e;
                if (e.getCause() instanceof SSLHandshakeException == false) throw e;
                if (this.usingCustomFingerprint != false) throw new RestSSLException(e.getCause().getMessage());
                dummyFingerprints = new HashSet<String>();
                dummyFingerprints.add("dummy-invalid-fingerprint");
                try {
                    dummyClient = WsRsRestClientFactory.getClientWithWhitelistValidation((String)(this.clientName + "-dummyFingerprint"), dummyFingerprints, (boolean)true);
                    dummyWebTarget = dummyClient.target(url);
                    dummyMediaType = "application/json";
                    dummyInvocationBuilder = dummyWebTarget.request(new String[]{dummyMediaType});
                    dummyResponse = dummyInvocationBuilder.get();
                    DiscoverRestClient.LOGGER.info("Got response code " + dummyResponse.getStatus());
                    throw e;
                }
                catch (Exception ex) {
                    if (ex.getCause() == null) throw e;
                    if (ex.getCause() instanceof SSLHandshakeException == false) throw e;
                    throw new RestSSLException(ex.getCause().getMessage());
                }
            }
            catch (Exception e) {
                DiscoverRestClient.LOGGER.error("Cannot query Discover API, " + e.getMessage());
                throw new IOException(e.getMessage());
            }
            if (errorMessage == null) ** GOTO lbl96
            this.operation.addTransientWarning((String)errorMessage, true);
            ** continue;
            finally {
                if (response == null) continue;
                response.close();
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <ResponseType, RequestType> ResponseType callApi(String url, String method, GenericType<ResponseType> entityType) throws IOException {
        DiscoverRestClient.LOGGER.info(method + " " + url);
        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent(method + " " + url + "\n"));
        response = null;
        attemptDelaySeconds = this.getSystemProperty("automate.discover.attemptDelaySeconds", 10);
        attempt = 1;
        errorMessage = null;
        while (true) {
            try {
                block45: {
                    while (true) {
                        webTarget = this.client.target(url);
                        invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.apiToken)).header("ApiKey", (Object)this.apiToken);
                        logFileName = System.getProperty("automate.discover.log");
                        logFile = null;
                        if (logFileName != null) {
                            logFile = new File(logFileName);
                        }
                        if (logFile != null) {
                            try {
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)(method + " " + url + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                            }
                            catch (Exception e) {
                                DiscoverRestClient.LOGGER.warn("Cannot write Discover log", (Throwable)e);
                            }
                        }
                        e = method;
                        var13_19 = -1;
                        switch (e.hashCode()) {
                            case 70454: {
                                if (!e.equals("GET")) break;
                                var13_19 = 0;
                                break;
                            }
                            case 2012838315: {
                                if (!e.equals("DELETE")) break;
                                var13_19 = 1;
                                break;
                            }
                        }
                        switch (var13_19) {
                            case 0: {
                                response = invocationBuilder.get();
                                break;
                            }
                            case 1: {
                                response = invocationBuilder.delete();
                                break;
                            }
                            default: {
                                throw new NotImplementedException("Method " + method + " not implemented in server API without body");
                            }
                        }
                        stringResponse = (String)response.readEntity(String.class);
                        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent("HTTP/" + response.getStatus()));
                        this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                        this.logHandler.addLogEvent(this.logChannel.getSeparator());
                        if (logFile != null) {
                            try {
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                            }
                            catch (Exception e) {
                                DiscoverRestClient.LOGGER.warn("Cannot write Discover log", (Throwable)e);
                            }
                        }
                        if (response.getStatus() == 401) {
                            throw new IOException(this.iu.getString("DiscoverRestClient.Error.InvalidApiToken"));
                        }
                        if (response.getStatus() == 403) {
                            throw new IOException("User does not have permissions to perform operation in Discover");
                        }
                        if (response.getStatus() == 404) {
                            throw new NotFoundException(this.iu.getString("DiscoverRestClient.Error.CannotConnectToService"));
                        }
                        if (response.getStatus() == 405) {
                            throw new MethodNotSupportedException(this.iu.getString("DiscoverRestClient.Error.CannotConnectToService"));
                        }
                        if (response.getStatus() == 200 || response.getStatus() == 201 || response.getStatus() == 202) break block45;
                        DiscoverRestClient.LOGGER.error(method + ": " + this.apiUrl);
                        DiscoverRestClient.LOGGER.error(this.apiUrl + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                        if (logFile != null) {
                            try {
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                                org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                            }
                            catch (Exception e) {
                                DiscoverRestClient.LOGGER.warn("Cannot write Discover log", (Throwable)e);
                            }
                        }
                        if ((discoverErrors = (DiscoverErrors)SerializationUtils.fromJson((String)stringResponse, DiscoverErrors.class)) != null && discoverErrors.getErrors() != null && discoverErrors.getErrors().size() > 0) {
                            discoverRestException = new DiscoverRestException(discoverErrors);
                            if (errorMessage == null) {
                                errorMessage = discoverRestException.getMessage();
                            }
                        } else if (errorMessage == null) {
                            errorMessage = "HTTP/" + response.getStatus() + " " + stringResponse;
                        }
                        if (response.getStatus() < 500 || response.getStatus() >= 600 || !this.reattemptEnabled || attempt > this.maxAttempts) break;
                        if (this.operation != null && errorMessage != null && attempt == 1) {
                            this.operation.addTransientWarning((String)errorMessage, false);
                        }
                        ++attempt;
                        try {
                            Thread.sleep(attemptDelaySeconds * 1000);
                        }
                        catch (InterruptedException e) {
                            DiscoverRestClient.LOGGER.error((Throwable)e);
                            Thread.currentThread().interrupt();
lbl89:
                            // 4 sources

                            while (true) {
                                responseData = entityType.getType().equals(String.class) != false ? stringResponse : SerializationUtils.fromJson((String)stringResponse, (Class)entityType.getRawType());
                                if (logFile != null) {
                                    try {
                                        org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                                        org.apache.commons.io.FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                                    }
                                    catch (Exception e) {
                                        DiscoverRestClient.LOGGER.warn("Cannot write Discover log", (Throwable)e);
                                    }
                                }
                                e = responseData;
                                return (ResponseType)e;
                            }
                        }
                    }
                    if (discoverErrors == null) throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
                    if (discoverErrors.getErrors() == null) throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
                    if (discoverErrors.getErrors().size() <= 0) throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
                    throw new DiscoverRestException(discoverErrors);
                }
                if (this.operation == null) ** GOTO lbl89
            }
            catch (DiscoverRestException e) {
                throw e;
            }
            catch (ProcessingException e) {
                if (e.getCause() == null) throw e;
                if (e.getCause() instanceof SSLHandshakeException == false) throw e;
                if (this.usingCustomFingerprint != false) throw new RestSSLException(e.getCause().getMessage());
                dummyFingerprints = new HashSet<String>();
                dummyFingerprints.add("dummy-invalid-fingerprint");
                try {
                    dummyClient = WsRsRestClientFactory.getClientWithWhitelistValidation((String)(this.clientName + "-dummyFingerprint"), dummyFingerprints, (boolean)true);
                    dummyWebTarget = dummyClient.target(url);
                    dummyMediaType = "application/json";
                    dummyInvocationBuilder = dummyWebTarget.request(new String[]{dummyMediaType});
                    dummyResponse = dummyInvocationBuilder.get();
                    DiscoverRestClient.LOGGER.info("Got response code " + dummyResponse.getStatus());
                    throw e;
                }
                catch (Exception ex) {
                    if (ex.getCause() == null) throw e;
                    if (ex.getCause() instanceof SSLHandshakeException == false) throw e;
                    throw new RestSSLException(ex.getCause().getMessage());
                }
            }
            catch (Exception e) {
                DiscoverRestClient.LOGGER.error("Cannot query Discover API", (Throwable)e);
                throw new IOException(e.getMessage());
            }
            if (errorMessage == null) ** GOTO lbl89
            this.operation.addTransientWarning((String)errorMessage, true);
            ** continue;
            finally {
                if (response == null) continue;
                response.close();
                continue;
            }
            break;
        }
    }

    private void addDocumentsForImportJobHeader(StringBuilder query, int caseId, int rdxJobId) throws IOException {
        query.append("mutation {");
        query.append("\n  importJobAddDocuments (");
        query.append("\n   caseId:" + this.gson.toJson((Object)caseId) + ", ");
        query.append("\n   input:{");
        query.append("\n   rdxJobId:" + this.gson.toJson((Object)rdxJobId) + ", ");
        query.append("\n   documents:[");
    }

    private void addDocumentsForImportJobFooter(StringBuilder query) throws IOException {
        query.append("]");
        query.append("}");
        query.append("\n  )");
        query.append("\n  {documentCount}");
        query.append("\n}");
    }

    private void addConversationsForImportJobHeader(StringBuilder query, int caseId, int rdxJobId) throws IOException {
        query.append("mutation {");
        query.append("\n  importJobAddConversations (");
        query.append("\n   caseId:" + this.gson.toJson((Object)caseId) + ", ");
        query.append("\n   input:{");
        query.append("\n   rdxJobId:" + this.gson.toJson((Object)rdxJobId) + ", ");
        query.append("\n   conversations:[");
    }

    private void addConversationsForImportJobFooter(StringBuilder query) throws IOException {
        query.append("]");
        query.append("}");
        query.append("\n  )");
        query.append("\n  {conversationCount}");
        query.append("\n}");
    }

    private void addConversationsForImportJobSubmit(StringBuilder query) throws IOException {
        ImportJobAddConversationsResponse response = this.callApi(this.apiUrl, "POST", new Query(query.toString()), new GenericType<ImportJobAddConversationsResponse>(){});
        LOGGER.info("Added " + response.getData().getImportJobAddConversations().getConversationCount() + " conversations to job");
    }

    private void addMessageEventsForImportJobHeader(StringBuilder query, int caseId, int rdxJobId) throws IOException {
        query.append("mutation {");
        query.append("\n  importJobAddMessageEvents (");
        query.append("\n   caseId:" + this.gson.toJson((Object)caseId) + ", ");
        query.append("\n   input:{");
        query.append("\n   rdxJobId:" + this.gson.toJson((Object)rdxJobId) + ", ");
        query.append("\n   messageEvents:[");
    }

    private void addMessageEventsForImportJobFooter(StringBuilder query) throws IOException {
        query.append("]");
        query.append("}");
        query.append("\n  )");
        query.append("\n  {messageEventCount}");
        query.append("\n}");
    }

    private void addMessageEventsForImportJobSubmit(StringBuilder query) throws IOException {
        ImportJobAddMessageEventsResponse response = this.callApi(this.apiUrl, "POST", new Query(query.toString()), new GenericType<ImportJobAddMessageEventsResponse>(){});
        LOGGER.info("Added " + response.getData().getImportJobAddMessageEvents().getMessageEventCount() + " message events to job");
    }

    private void addDocumentsForImportJobSubmit(StringBuilder query) throws IOException {
        ImportJobAddDocumentsResponse response = this.callApi(this.apiUrl, "POST", new Query(query.toString()), new GenericType<ImportJobAddDocumentsResponse>(){});
        LOGGER.info("Added " + response.getData().getImportJobAddDocuments().getDocumentCount() + " documents to job");
    }

    private String getDocId(Item item, Map<String, DocumentMapping> documentsMapping, ProductionSet productionSet) {
        DocumentMapping itemMapping = documentsMapping.get(item.getGuid());
        String docId = null;
        if (itemMapping != null && itemMapping.getDocId() != null && itemMapping.getDocId().length() > 0) {
            docId = itemMapping.getDocId();
        } else {
            ProductionSetItem productionSetItem = NuixUtils.getProductionSetItem(item, productionSet);
            if (productionSetItem != null) {
                docId = productionSetItem.getDocumentNumber().toString();
            }
        }
        return docId;
    }

    private Set<String> getAddressesRepresentations(List<Address> addresses) {
        HashSet<String> people = new HashSet<String>();
        if (addresses != null) {
            for (Address address : addresses) {
                people.add(address.toDisplayString());
            }
        }
        return people;
    }

    private Set<String> getAddressesDomains(List<Address> addresses) {
        HashSet<String> domains = new HashSet<String>();
        String exportOrgsDomains = System.getProperty("automate.discover.skipExportOrgDomains");
        if (exportOrgsDomains != null && Boolean.parseBoolean(exportOrgsDomains)) {
            return domains;
        }
        if (addresses != null) {
            for (Address address : addresses) {
                String emailAddress = address.getAddress();
                Matcher matcher = this.emailDomain.matcher(emailAddress);
                if (matcher.matches()) {
                    domains.add(matcher.group(1));
                    continue;
                }
                matcher = this.emailOu.matcher(emailAddress);
                if (!matcher.matches()) continue;
                domains.add(matcher.group(1));
            }
        }
        return domains;
    }

    private String getGraphqlList(Set<String> people) {
        StringBuilder query = new StringBuilder();
        boolean firstPerson = true;
        for (String person : people) {
            if (!firstPerson) {
                query.append(",");
            }
            query.append(this.gson.toJson((Object)person));
            firstPerson = false;
        }
        return query.toString();
    }

    private String encodeMultiValue(Object value) {
        if (value instanceof String) {
            return this.gson.toJson(value);
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            List multiValue = (List)value;
            boolean firstItem = true;
            for (String v : multiValue) {
                if (!firstItem) {
                    sb.append(",");
                }
                sb.append(this.gson.toJson((Object)String.valueOf(v)));
                firstItem = false;
            }
            sb.append("]");
            return sb.toString();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot convert field to multi-value", (Throwable)e);
            return this.gson.toJson(value);
        }
    }

    private void addDocumentsForImportJobItem(StringBuilder query, Item item, ProductionSet productionSet, Map<String, DocumentMapping> documentsMapping, String exportFolderName, DiscoverFileRepositoryType fileRepositoryType, String level, DateTimeZone caseDateTimeZone, DiscoverExportOptions exportOptions) throws IOException {
        MutablePrintedImage printedImage;
        Object path;
        Object documentTitle;
        DocumentMapping itemMapping = documentsMapping.get(item.getGuid());
        String docId = this.getDocId(item, documentsMapping, productionSet);
        String parentDocId = null;
        Item parentItem = null;
        if (!item.isTopLevel()) {
            for (Item parent = (Item)item.getParent(); parentDocId == null && parent != null; parent = (Item)parent.getParent()) {
                parentDocId = this.getDocId(parent, documentsMapping, productionSet);
                parentItem = parent;
            }
        }
        query.append("{");
        query.append("documentId:" + this.gson.toJson((Object)docId) + ", ");
        if (parentDocId != null) {
            query.append("parentId:" + this.gson.toJson((Object)parentDocId) + ", ");
            if (this.isChatMessage(parentItem)) {
                query.append("isMessageEventAttachment: true, ");
            }
        }
        query.append("hash:" + this.gson.toJson((Object)item.getDigests().getMd5()) + ", ");
        Item topLevelItem = item.getTopLevelItem();
        if (topLevelItem == null) {
            topLevelItem = item;
        }
        query.append("familyhash:" + this.gson.toJson((Object)topLevelItem.getDigests().getMd5()) + ", ");
        if (level != null) {
            query.append("level:" + this.gson.toJson((Object)level) + ", ");
        }
        query.append("mainfields:[");
        DateTime localDocumentDate = new DateTime((Object)item.getDate(), caseDateTimeZone);
        Map<String, Object> itemFields = documentsMapping.get(item.getGuid()).getFields();
        Object documentDate = itemFields.get("DocumentDate");
        if (documentDate == null) {
            documentDate = itemFields.get("Document Date");
        }
        if (documentDate == null) {
            documentDate = ISODateTimeFormat.dateTime().print((ReadableInstant)localDocumentDate);
        }
        query.append("{name:DocumentDate,value:" + this.gson.toJson((Object)String.valueOf(documentDate)) + ",action:Update},");
        Object documentDescription = itemFields.get("DocumentDescription");
        if (documentDescription == null) {
            documentDescription = itemFields.get("Document Description");
        }
        if (documentDescription != null) {
            query.append("{name:DocumentDescription,value:" + this.gson.toJson((Object)String.valueOf(documentDescription)) + ",action:Update},");
        }
        if ((documentTitle = itemFields.get("DocumentTitle")) == null) {
            documentTitle = itemFields.get("Document Title");
        }
        if (documentTitle == null) {
            documentTitle = item.getName();
        }
        query.append("{name:DocumentTitle,value:" + this.gson.toJson((Object)String.valueOf(documentTitle)) + ",action:Update},");
        Object documentType = itemFields.get("DocumentType");
        if (documentType == null) {
            documentType = itemFields.get("Document Type");
        }
        if (documentType == null) {
            documentType = item.getType().getName();
        }
        query.append("{name:DocumentType,value:" + this.gson.toJson((Object)String.valueOf(documentType)) + ",action:Update},");
        Object estimatedDate = itemFields.get("EstimatedDate");
        if (estimatedDate == null) {
            estimatedDate = itemFields.get("Estimated Date");
        }
        if (estimatedDate != null) {
            query.append("{name:EstimatedDate,value:" + this.gson.toJson((Object)String.valueOf(estimatedDate)) + ",action:Update},");
        }
        query.append(" ],");
        query.append("fields:[");
        int fieldCount = 0;
        if (itemMapping != null && itemMapping.getFields() != null) {
            Map<String, Object> fields = itemMapping.getFields();
            for (Map.Entry<String, Object> entry : fields.entrySet()) {
                if (illegalFieldNames.contains(entry.getKey())) continue;
                Object value = entry.getValue();
                if (value instanceof String && ((String)value).isEmpty()) {
                    value = null;
                }
                if (value == null) continue;
                if (fieldCount > 0) {
                    query.append(",");
                }
                query.append("{name:" + this.gson.toJson((Object)entry.getKey()) + ",values:" + this.encodeMultiValue(value) + ",action:InsertUpdate}");
                ++fieldCount;
            }
        }
        query.append("],");
        Communication communication = item.getCommunication();
        if (communication != null) {
            Set<String> domains;
            query.append("correspondence:[");
            boolean firstCommunication = true;
            Set<String> people = this.getAddressesRepresentations(communication.getFrom());
            if (people.size() > 0) {
                if (!firstCommunication) {
                    query.append(",");
                }
                query.append("{action:InsertUpdate,type:\"From\",people:[");
                query.append(this.getGraphqlList(people));
                query.append("]");
                domains = this.getAddressesDomains(communication.getFrom());
                if (domains.size() > 0) {
                    query.append(",orgs:[");
                    query.append(this.getGraphqlList(domains));
                    query.append("]");
                }
                query.append("}");
                firstCommunication = false;
            }
            if ((people = this.getAddressesRepresentations(communication.getTo())).size() > 0) {
                if (!firstCommunication) {
                    query.append(",");
                }
                query.append("{action:InsertUpdate,type:\"To\",people:[");
                query.append(this.getGraphqlList(people));
                query.append("]");
                domains = this.getAddressesDomains(communication.getTo());
                if (domains.size() > 0) {
                    query.append(",orgs:[");
                    query.append(this.getGraphqlList(domains));
                    query.append("]");
                }
                query.append("}");
                firstCommunication = false;
            }
            if ((people = this.getAddressesRepresentations(communication.getCc())).size() > 0) {
                if (!firstCommunication) {
                    query.append(",");
                }
                query.append("{action:InsertUpdate,type:\"CC\",people:[");
                query.append(this.getGraphqlList(people));
                query.append("]");
                domains = this.getAddressesDomains(communication.getCc());
                if (domains.size() > 0) {
                    query.append(",orgs:[");
                    query.append(this.getGraphqlList(domains));
                    query.append("]");
                }
                query.append("}");
                firstCommunication = false;
            }
            if ((people = this.getAddressesRepresentations(communication.getBcc())).size() > 0) {
                if (!firstCommunication) {
                    query.append(",");
                }
                query.append("{action:InsertUpdate,type:\"BCC\",people:[");
                query.append(this.getGraphqlList(people));
                query.append("]");
                domains = this.getAddressesDomains(communication.getBcc());
                if (domains.size() > 0) {
                    query.append(",orgs:[");
                    query.append(this.getGraphqlList(domains));
                    query.append("]");
                }
                query.append("}");
                firstCommunication = false;
            }
            query.append("],");
        }
        if (exportOptions.isExportContentNative() && itemMapping.getNativePath() != null || exportOptions.isExportContentText() && itemMapping.getTextPath() != null) {
            query.append("contentfiles:[");
            int fileCount = 0;
            if (exportOptions.isExportContentNative() && itemMapping != null && itemMapping.getNativePath() != null) {
                String docIdBasedPath = itemMapping.getDocIdBasedNativePath();
                if (itemMapping.getPdfNativePath() != null) {
                    docIdBasedPath = itemMapping.getPdfNativePath();
                }
                Object path2 = exportFolderName + "/" + docIdBasedPath;
                path2 = ((String)path2).replace("/", "\\");
                query.append("{path:" + this.gson.toJson(path2) + "}");
                ++fileCount;
            }
            if (exportOptions.isExportContentText() && itemMapping != null && itemMapping.getTextPath() != null) {
                if (fileCount > 0) {
                    query.append(",");
                }
                Object path3 = exportFolderName + "/" + itemMapping.getDocIdBasedTextPath();
                path3 = ((String)path3).replace("/", "\\");
                query.append("{path:" + this.gson.toJson(path3) + "}");
                ++fileCount;
            }
            query.append("]");
        }
        StringBuilder pagesQuery = new StringBuilder();
        pagesQuery.append("pages:[");
        int pageCount = 0;
        if (exportOptions.isExportPagePdf() && itemMapping.getImagePaths() != null) {
            for (String pagePath : itemMapping.getDocIdBasedImagePaths()) {
                path = exportFolderName + "/" + pagePath;
                String fileExtension = FileUtils.getFileExtension((String)path).toUpperCase();
                path = ((String)path).replace("/", "\\");
                pagesQuery.append("{pagenumber: " + ++pageCount + ", path:" + this.gson.toJson(path) + ", pagelabel: \"" + fileExtension + "\"}");
            }
        }
        boolean exportPageNative = false;
        if (exportOptions.isExportPageNativeAllDocuments()) {
            exportPageNative = true;
        }
        if (exportOptions.isExportPageNativeSlipSheet() && (printedImage = item.getPrintedImage()) != null && printedImage.getInfo() != null && printedImage.getInfo().isSlipSheet()) {
            exportPageNative = true;
        }
        if (exportPageNative && itemMapping.getNativePath() != null) {
            String docIdBasedPath = itemMapping.getDocIdBasedNativePath();
            if (itemMapping.getPdfNativePath() != null) {
                docIdBasedPath = itemMapping.getPdfNativePath();
            }
            path = exportFolderName + "/" + docIdBasedPath;
            path = ((String)path).replace("/", "\\");
            pagesQuery.append("{pagenumber: " + ++pageCount + ", path:" + this.gson.toJson(path) + ", pagelabel: \"Native\"}");
        }
        pagesQuery.append("]");
        if (pageCount > 0) {
            query.append((CharSequence)pagesQuery);
        }
        query.append("}");
    }

    private String getConversationId(Item item) {
        Object conversationId;
        Item tlItem = item.getTopLevelItem();
        if (tlItem == null) {
            tlItem = item;
        }
        if ((conversationId = tlItem.getProperties().get("Conversation ID")) == null) {
            conversationId = tlItem.getProperties().get("Channel Identity Channel ID");
        }
        if (conversationId == null) {
            conversationId = tlItem.getGuid();
        }
        return String.valueOf(conversationId);
    }

    private void addConversationForImportJobItem(StringBuilder query, Item item, ProductionSet productionSet, Map<String, DocumentMapping> documentsMapping, Set<String> participants) throws IOException {
        Object communicationParticipants;
        DocumentMapping itemMapping = documentsMapping.get(item.getGuid());
        String docId = this.getDocId(item, documentsMapping, productionSet);
        String parentDocId = null;
        if (!item.isTopLevel()) {
            for (Item parent = (Item)item.getParent(); parentDocId == null && parent != null; parent = (Item)parent.getParent()) {
                parentDocId = this.getDocId(parent, documentsMapping, productionSet);
            }
        }
        query.append("{");
        query.append("documentId:" + this.gson.toJson((Object)docId) + ", ");
        query.append("conversationId:" + this.gson.toJson((Object)this.getConversationId(item)) + ", ");
        String channelName = item.getProperties().get("Channel Name") != null ? item.getProperties().get("Channel Name").toString() : item.getName();
        query.append("channelName:" + this.gson.toJson((Object)channelName) + ", ");
        query.append("platform:" + this.gson.toJson((Object)item.getType().getName()) + ", ");
        if (item.getProperties().get("Communication Participants") != null) {
            communicationParticipants = item.getProperties().get("Communication Participants");
            if (communicationParticipants instanceof Collection) {
                participants = new HashSet<String>();
                for (Object communicationParticipant : (Collection)communicationParticipants) {
                    participants.add(communicationParticipant.toString());
                }
            }
        } else if (item.getProperties().get("Channel Members") != null && (communicationParticipants = item.getProperties().get("Channel Members")) instanceof Collection) {
            participants = new HashSet<String>();
            for (Object communicationParticipant : (Collection)communicationParticipants) {
                participants.add(communicationParticipant.toString());
            }
        }
        if (participants != null) {
            query.append("participants: [");
            for (String participant : participants) {
                query.append("{id :" + this.gson.toJson((Object)participant) + "} ");
            }
            query.append("], ");
        }
        query.append("fields:[");
        int fieldCount = 0;
        if (itemMapping != null && itemMapping.getFields() != null) {
            Map<String, Object> fields = itemMapping.getFields();
            String[] allowedConversationFields = new String[]{"[Meta] Processing Time Zone", "[Meta] Document Category", "[Meta] Document Kind", "[Meta] GUID", "[Meta] GUID - Parent"};
            HashMap<String, Object> conversationFields = new HashMap<String, Object>();
            for (String allowedConversationField : allowedConversationFields) {
                Object value = fields.get(allowedConversationField);
                if (value == null) continue;
                conversationFields.put(allowedConversationField, value);
            }
            for (Map.Entry entry : conversationFields.entrySet()) {
                if (illegalFieldNames.contains(entry.getKey())) continue;
                Object value = entry.getValue();
                if (value instanceof String && ((String)value).isEmpty()) {
                    value = null;
                }
                if (value == null) continue;
                if (fieldCount > 0) {
                    query.append(",");
                }
                query.append("{name:" + this.gson.toJson(entry.getKey()) + ",values:" + this.encodeMultiValue(value) + " }");
                ++fieldCount;
            }
        }
        query.append("]");
        query.append("}");
    }

    private void assMessageEventForImportJobItem(StringBuilder query, Item item, ProductionSet productionSet, Map<String, DocumentMapping> documentsMapping) throws IOException {
        String type;
        DocumentMapping itemMapping = documentsMapping.get(item.getGuid());
        String docId = this.getDocId(item, documentsMapping, productionSet);
        String parentDocId = null;
        Item parentItem = null;
        if (!item.isTopLevel()) {
            for (Item parent = (Item)item.getParent(); parentDocId == null && parent != null; parent = (Item)parent.getParent()) {
                parentDocId = this.getDocId(parent, documentsMapping, productionSet);
                parentItem = parent;
            }
        }
        query.append("{");
        query.append("eventId:" + this.gson.toJson((Object)docId) + ", ");
        if (parentDocId != null && this.isChatMessage(parentItem)) {
            query.append("parentEventId:" + this.gson.toJson((Object)parentDocId) + ", ");
        }
        query.append("conversationId:" + this.gson.toJson((Object)this.getConversationId(item)) + ", ");
        query.append("eventDateTime:" + this.gson.toJson((Object)FormattingUtils.dateTimeToIsoString((DateTime)item.getDate())) + ", ");
        String content = null;
        Object chatOperations = item.getProperties().get("Operations");
        if (chatOperations != null && "MemberAdded".equalsIgnoreCase(chatOperations.toString())) {
            type = "join";
        } else if (chatOperations != null && "MemberRemoved".equalsIgnoreCase(chatOperations.toString())) {
            type = "leave";
        } else if (item.getType().getName().contains("reaction") && !item.getType().getName().contains("reactions-summary")) {
            type = "reaction";
            Object reactionType = item.getProperties().get("Reaction Type");
            if (reactionType != null) {
                content = reactionType.toString();
            } else {
                LOGGER.warn("Cannot get reaction type for item " + item.getGuid());
                content = "";
            }
        } else {
            type = "message";
            content = item.getTextObject().toString();
        }
        if (content != null) {
            query.append("content:" + this.gson.toJson((Object)content) + ", ");
        }
        query.append("type:" + this.gson.toJson((Object)type) + ", ");
        query.append("platform:" + this.gson.toJson((Object)item.getType().getName()) + ", ");
        String senderId = "[UNKNOWN]";
        if (item.getProperties().get("User ID") != null) {
            senderId = item.getProperties().get("User ID").toString();
        } else if (item.getProperties().get("UPN") != null) {
            senderId = item.getProperties().get("UPN").toString();
        } else {
            Communication communication = item.getCommunication();
            if (communication != null) {
                List fromAddresses = communication.getFrom();
                if (fromAddresses.size() == 0) {
                    LOGGER.warn("Message does not have sender for item " + item.getGuid());
                } else if (fromAddresses.size() > 1) {
                    LOGGER.warn("Message has multiple senders for item " + item.getGuid());
                } else {
                    senderId = ((Address)fromAddresses.get(0)).toDisplayString();
                }
            } else {
                LOGGER.warn("Cannot get sender for item " + item.getGuid());
                senderId = "";
            }
        }
        query.append("sender: { id: " + this.gson.toJson((Object)senderId) + "}");
        query.append("}");
    }

    Set<Address> getAllAddresses(Communication communication) {
        HashSet<Address> addresses = new HashSet<Address>();
        if (communication.getFrom() != null) {
            addresses.addAll(communication.getFrom());
        }
        if (communication.getTo() != null) {
            addresses.addAll(communication.getTo());
        }
        if (communication.getCc() != null) {
            addresses.addAll(communication.getCc());
        }
        if (communication.getBcc() != null) {
            addresses.addAll(communication.getBcc());
        }
        return addresses;
    }

    private boolean isChatMessage(Item item) {
        return item.getKind().getName().equals("chat-message");
    }

    private boolean isConversation(Item item) {
        return item.getKind().getName().equals("chat-conversation");
    }

    public void addDocumentsForImportJob(AtomicLong loadItemsProcessedInStage, int caseId, int rdxJobId, ProductionSet productionSet, List<Item> items, Map<String, DocumentMapping> documentsMapping, String exportFolderName, String exportFolderPath, DiscoverFileRepositoryType fileRepositoryType, LevelStrategy levelStrategy, DateTimeZone caseDateTimeZone, DiscoverExportOptions exportOptions, ItemHandledCallback itemHandledCallback) throws IOException {
        String mimeType;
        String stage;
        StringBuilder query = null;
        Map productionSetNumberingOptions = productionSet.getNumberingOptions();
        ArrayList<Item> conversations = new ArrayList<Item>();
        HashMap conversationParticipants = new HashMap();
        ArrayList<Item> chatMessages = new ArrayList<Item>();
        ArrayList<Item> documents = new ArrayList<Item>();
        for (Item item : items) {
            if (this.isConversation(item)) {
                conversations.add(item);
                continue;
            }
            if (this.isChatMessage(item)) {
                Communication communication;
                chatMessages.add(item);
                Item tlItem = item.getTopLevelItem();
                if (tlItem == null || !this.isConversation(tlItem)) continue;
                String guid = tlItem.getGuid();
                HashSet<String> participants = (HashSet<String>)conversationParticipants.get(guid);
                if (participants == null) {
                    participants = new HashSet<String>();
                    conversationParticipants.put(guid, participants);
                }
                if ((communication = item.getCommunication()) == null) continue;
                for (Address address : this.getAllAddresses(communication)) {
                    participants.add(address.toRfc822String());
                }
                continue;
            }
            documents.add(item);
        }
        int queryId = 1;
        boolean firstItem = true;
        long docsPerQuery = 0L;
        for (Item conversationItem : conversations) {
            if (query != null && query.length() > 1000000) {
                this.addConversationsForImportJobFooter(query);
                LOGGER.info("Submitting partial Discover importJobAddMessageEvents query with " + docsPerQuery + " items, " + FormattingUtils.sizeToDisplaySize((long)query.length()));
                FileUtils.writeToFile((StringBuilder)query, (Path)Paths.get(exportFolderPath + "/discover-mutation-" + String.format("%05d", queryId) + ".graphql", new String[0]));
                this.addConversationsForImportJobSubmit(query);
                ++queryId;
                query = null;
                docsPerQuery = 0L;
            }
            if (query == null) {
                query = new StringBuilder();
                this.addConversationsForImportJobHeader(query, caseId, rdxJobId);
                firstItem = true;
            }
            if (!firstItem) {
                query.append(",");
            }
            firstItem = false;
            this.addConversationForImportJobItem(query, conversationItem, productionSet, documentsMapping, (Set)conversationParticipants.get(conversationItem.getGuid()));
            ++docsPerQuery;
            loadItemsProcessedInStage.incrementAndGet();
            if (itemHandledCallback == null) continue;
            stage = "upload_metadata";
            mimeType = conversationItem.getType().getName();
            itemHandledCallback.itemHandled(mimeType, stage, null, false);
        }
        if (query != null) {
            this.addConversationsForImportJobFooter(query);
            LOGGER.info("Submitting final Discover addDocumentsForImportJob query with " + docsPerQuery + " items, " + FormattingUtils.sizeToDisplaySize((long)query.length()));
            FileUtils.writeToFile((StringBuilder)query, (Path)Paths.get(exportFolderPath + "/discover-mutation-" + String.format("%05d", queryId) + ".graphql", new String[0]));
            this.addConversationsForImportJobSubmit(query);
            ++queryId;
            query = null;
        }
        firstItem = true;
        docsPerQuery = 0L;
        for (Item chatItem : chatMessages) {
            if (query != null && query.length() > 1000000) {
                this.addMessageEventsForImportJobFooter(query);
                LOGGER.info("Submitting partial Discover importJobAddMessageEvents query with " + docsPerQuery + " items, " + FormattingUtils.sizeToDisplaySize((long)query.length()));
                FileUtils.writeToFile((StringBuilder)query, (Path)Paths.get(exportFolderPath + "/discover-mutation-" + String.format("%05d", queryId) + ".graphql", new String[0]));
                this.addMessageEventsForImportJobSubmit(query);
                ++queryId;
                query = null;
                docsPerQuery = 0L;
            }
            if (query == null) {
                query = new StringBuilder();
                this.addMessageEventsForImportJobHeader(query, caseId, rdxJobId);
                firstItem = true;
            }
            if (!firstItem) {
                query.append(",");
            }
            firstItem = false;
            this.assMessageEventForImportJobItem(query, chatItem, productionSet, documentsMapping);
            ++docsPerQuery;
            loadItemsProcessedInStage.incrementAndGet();
            if (itemHandledCallback == null) continue;
            stage = "upload_metadata";
            mimeType = chatItem.getType().getName();
            itemHandledCallback.itemHandled(mimeType, stage, null, false);
        }
        if (query != null) {
            this.addMessageEventsForImportJobFooter(query);
            LOGGER.info("Submitting final Discover addDocumentsForImportJob query with " + docsPerQuery + " items, " + FormattingUtils.sizeToDisplaySize((long)query.length()));
            FileUtils.writeToFile((StringBuilder)query, (Path)Paths.get(exportFolderPath + "/discover-mutation-" + String.format("%05d", queryId) + ".graphql", new String[0]));
            this.addMessageEventsForImportJobSubmit(query);
            ++queryId;
            query = null;
        }
        firstItem = true;
        docsPerQuery = 0L;
        for (Item documentItem : documents) {
            if (query != null && query.length() > 1000000) {
                this.addDocumentsForImportJobFooter(query);
                LOGGER.info("Submitting partial Discover addDocumentsForImportJob query with " + docsPerQuery + " items, " + FormattingUtils.sizeToDisplaySize((long)query.length()));
                FileUtils.writeToFile((StringBuilder)query, (Path)Paths.get(exportFolderPath + "/discover-mutation-" + String.format("%05d", queryId) + ".graphql", new String[0]));
                this.addDocumentsForImportJobSubmit(query);
                ++queryId;
                query = null;
                docsPerQuery = 0L;
            }
            if (query == null) {
                query = new StringBuilder();
                this.addDocumentsForImportJobHeader(query, caseId, rdxJobId);
                firstItem = true;
            }
            if (!firstItem) {
                query.append(",");
            }
            firstItem = false;
            String level = null;
            if (levelStrategy == LevelStrategy.PRODUCTION_SET) {
                ProductionSetItem productionSetItem = NuixUtils.getProductionSetItem(documentItem, productionSet);
                level = this.generateDocumentLevel(productionSetItem, productionSetNumberingOptions);
            }
            this.addDocumentsForImportJobItem(query, documentItem, productionSet, documentsMapping, exportFolderName, fileRepositoryType, level, caseDateTimeZone, exportOptions);
            ++docsPerQuery;
            loadItemsProcessedInStage.incrementAndGet();
            if (itemHandledCallback == null) continue;
            String stage2 = "upload_metadata";
            String mimeType2 = documentItem.getType().getName();
            itemHandledCallback.itemHandled(mimeType2, stage2, null, false);
        }
        if (query != null) {
            this.addDocumentsForImportJobFooter(query);
            LOGGER.info("Submitting final Discover addDocumentsForImportJob query with " + docsPerQuery + " items, " + FormattingUtils.sizeToDisplaySize((long)query.length()));
            FileUtils.writeToFile((StringBuilder)query, (Path)Paths.get(exportFolderPath + "/discover-mutation-" + String.format("%05d", queryId) + ".graphql", new String[0]));
            this.addDocumentsForImportJobSubmit(query);
            ++queryId;
            query = null;
        }
    }

    public ImportJob importJobCreate(int caseId, String jobName, String jobDescription, LevelStrategy levelStrategy, String level, int docsPerLevel, boolean runDeduplication, boolean runIndexing, boolean overwriteExistingFiles, boolean updateGroupCoding, DocumentIdType documentIdType, boolean abortExistingDocId, DiscoverFileRepositoryType fileRepositoryType, boolean useCustomDateFormat, DiscoverDateFormat dateFormat, boolean useCustomDocumentIdPrefix, String documentIdPrefix, String additionalOptions) throws IOException {
        Object levelStr = "";
        if (levelStrategy == LevelStrategy.FOLDER) {
            levelStr = "       level:" + this.gson.toJson((Object)level) + ",        docsPerLevel:" + this.gson.toJson((Object)docsPerLevel) + ", ";
        }
        Object dateFormatString = "";
        if (useCustomDateFormat) {
            dateFormatString = "       dateFormat:" + dateFormat.name() + ", ";
        }
        Object documentIdPrefixString = "";
        if (useCustomDocumentIdPrefix && documentIdPrefix.trim().length() > 0 && documentIdType == DocumentIdType.DISCOVER_SEQUENTIAL) {
            documentIdPrefixString = "       documentIdPrefix:" + this.gson.toJson((Object)documentIdPrefix.trim()) + ", ";
        }
        String query = "mutation{importJobCreate(   caseId:" + this.gson.toJson((Object)caseId) + ",    input:{       name:" + this.gson.toJson((Object)jobName) + ",        description:" + this.gson.toJson((Object)jobDescription) + ", " + (String)levelStr + (String)documentIdPrefixString + (String)dateFormatString + additionalOptions + "       runDeduplication:" + this.gson.toJson((Object)runDeduplication) + ",        runIndexing:" + this.gson.toJson((Object)runIndexing) + ",        overwriteExistingFiles:" + this.gson.toJson((Object)overwriteExistingFiles) + ",        updateGroupCoding:" + this.gson.toJson((Object)updateGroupCoding) + ", ";
        query = fileRepositoryType.equals((Object)DiscoverFileRepositoryType.AMAZON_S3) ? query + "       fileTransferLocation:" + DiscoverFileRepositoryType.AMAZON_S3.toConnectApiString() + ", " : query + "       fileTransferLocation:" + DiscoverFileRepositoryType.WINDOWS.toConnectApiString() + ", ";
        if (documentIdType.equals((Object)DocumentIdType.PRODUCTION_SET) && abortExistingDocId) {
            query = query + "       abortExistingDocId:" + abortExistingDocId + ", ";
        }
        query = query + "       documentIdType:" + documentIdType.toConnectApiString() + "   }) {rdxJobId";
        if (fileRepositoryType.equals((Object)DiscoverFileRepositoryType.AMAZON_S3)) {
            query = query + "    fileTransferLocationInformation{\n      regionEndpoint\n      bucketName\n      rootPrefix\n      accessKey\n      secretAccessKey\n      token\n    }";
        }
        query = query + "}}";
        try {
            ImportJobCreateResponse importJobResponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<ImportJobCreateResponse>(){});
            LOGGER.info("Created Import Job Rdx " + importJobResponse.getData().getImportJobCreate().getRdxJobId());
            return importJobResponse.getData().getImportJobCreate();
        }
        catch (DiscoverRestException e) {
            LOGGER.error("Cannot create import job", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String generateDocumentLevel(ProductionSetItem item, Map<String, Object> numberingOptions) {
        boolean documentIdNoPrefix;
        if (item == null || numberingOptions == null) {
            return null;
        }
        DocumentNumber itemDocumentNumber = item.getDocumentNumber();
        List componentNames = itemDocumentNumber.getComponentNames();
        boolean bl = documentIdNoPrefix = componentNames.size() == 2 && !numberingOptions.containsKey("prefix") && (numberingOptions.containsKey("documentId") || numberingOptions.containsKey("formattedDocumentId"));
        if (componentNames.size() == 1 || documentIdNoPrefix) {
            return null;
        }
        ArrayList<String> itemLevelPath = new ArrayList<String>();
        int i = 0;
        while (true) {
            block17: {
                if (i >= componentNames.size() - 1) {
                    return String.join((CharSequence)"/", itemLevelPath);
                }
                String component = (String)componentNames.get(i);
                String componentValue = String.valueOf(itemDocumentNumber.getComponent(component));
                Map componentOptions = null;
                switch (component) {
                    case "DOCUMENT_ID": {
                        componentOptions = (Map)numberingOptions.get("documentId");
                        if (componentOptions != null) break;
                        componentOptions = (Map)numberingOptions.get("formattedDocumentId");
                        break;
                    }
                    case "BOX": {
                        componentOptions = (Map)numberingOptions.get("box");
                        break;
                    }
                    case "FOLDER": {
                        componentOptions = (Map)numberingOptions.get("folder");
                        break;
                    }
                    case "PREFIX": {
                        itemLevelPath.add(componentValue);
                        break block17;
                    }
                }
                if (componentOptions != null) {
                    int padding = Integer.parseInt(String.valueOf(componentOptions.get("minWidth")));
                    itemLevelPath.add(StringUtils.leftPad((String)componentValue, (int)padding, (String)"0"));
                }
            }
            ++i;
        }
    }

    public int submitImportJob(int caseId, int rdxJobId) throws IOException {
        String query = "mutation{importJobSubmit(   caseId:" + this.gson.toJson((Object)caseId) + ",    input:{       rdxJobId:" + this.gson.toJson((Object)rdxJobId) + "   }) {rpfJobId}}";
        ImportJobSubmitResponse importJobSubmitResponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<ImportJobSubmitResponse>(){});
        LOGGER.info("Submitted Import Job Rpf " + importJobSubmitResponse.getData().getImportJobSubmit().getRpfJobId());
        return importJobSubmitResponse.getData().getImportJobSubmit().getRpfJobId();
    }

    public Case caseClone(String caseName, String description, Integer organizationId, int sourceCaseId, boolean scheduleMetricsJob, boolean clearData) throws IOException {
        String query = "mutation{caseClone(input:{   caseName:" + this.gson.toJson((Object)caseName) + ",    description:" + this.gson.toJson((Object)description) + ", " + (String)(organizationId != null ? "   organizationId:" + this.gson.toJson((Object)organizationId) + ", " : "") + "   sourceCaseId:" + this.gson.toJson((Object)sourceCaseId) + ",    scheduleMetricsJob:" + this.gson.toJson((Object)scheduleMetricsJob) + (String)(!clearData ? "   clearCaseData:" + this.gson.toJson((Object)clearData) : "") + "}) {case{id name}}}";
        CaseCloneResponse submitImportJobResponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<CaseCloneResponse>(){});
        LOGGER.info("Submitted caseClone");
        return submitImportJobResponse.getData().getCaseClone().getCase();
    }

    public void userCaseAssign(int userId, int caseId, DiscoverUserCaseCategory caseCategory) throws IOException {
        String query = "mutation {\n  userCaseAssign(input:\n    {userId: " + this.gson.toJson((Object)userId) + ",\n      caseId: " + this.gson.toJson((Object)caseId) + ",\n      caseUserCategory: " + caseCategory.toConnectApiString() + "\n    }) {\n    errorCount\n  }\n}\n";
        UserCaseAssignResponse userCaseAssignResponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<UserCaseAssignResponse>(){});
        if (userCaseAssignResponse.getErrors() != null) {
            DiscoverErrors discoverErrors = new DiscoverErrors();
            discoverErrors.setErrors(userCaseAssignResponse.getErrors());
            throw new DiscoverRestException(discoverErrors);
        }
    }

    public void userGroupAssign(int userId, int caseId, int groupId) throws IOException {
        String query = "mutation {\n  userGroupAssign(input:\n    {userId: " + this.gson.toJson((Object)userId) + ",\n      caseId: " + this.gson.toJson((Object)caseId) + ",\n      groupId: " + this.gson.toJson((Object)groupId) + "\n    }) {\n    errorCount\n  }\n}\n";
        UserGroupAssignResponse userGroupAssignResponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<UserGroupAssignResponse>(){});
        if (userGroupAssignResponse.getErrors() != null) {
            DiscoverErrors discoverErrors = new DiscoverErrors();
            discoverErrors.setErrors(userGroupAssignResponse.getErrors());
            throw new DiscoverRestException(discoverErrors);
        }
    }

    public String getVersion() throws DiscoverRestException {
        String healthUrl = this.apiUrl.replaceAll("(?i)/api/query", healthServiceEndpoint);
        if (healthUrl.equals(this.apiUrl)) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Warning.CannotDetermineServiceHealth", (Object)this.apiUrl))));
        }
        try {
            Map<String, Object> response = this.callApi(healthUrl, "GET", new GenericType<Map<String, Object>>(){});
            Object serviceVersion = response.get("ServiceVersion");
            if (serviceVersion != null) {
                return serviceVersion.toString();
            }
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Warning.CannotVerifyServiceHealth", (Object)healthUrl))));
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public Job getRpfJobStatus(long id) throws DiscoverRestException {
        try {
            String query = "query {\n  rpf{\n    jobs (id:" + this.gson.toJson((Object)id) + "){\n      status\n      dateFinished\n      stages {       \n        status\n        name\n      }\n    }\n  }\n}";
            RpfResponse rpfResponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<RpfResponse>(){});
            if (rpfResponse.getData().getRpf().getJobs().size() == 0) {
                throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.CannotFindRpfJobId", (Object)id))));
            }
            return rpfResponse.getData().getRpf().getJobs().get(0);
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public boolean getCaseActive(int caseId) throws DiscoverRestException, DiscoverCaseDoesNotExistException {
        try {
            String query = "query{cases(id:" + this.gson.toJson((Object)caseId) + ") {id name active}}";
            CaseResponse casesListReponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<CaseResponse>(){});
            if (casesListReponse.getData().getCases().size() == 0) {
                throw new DiscoverCaseDoesNotExistException();
            }
            return casesListReponse.getData().getCases().get(0).getActive();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public Case getCase(int caseId) throws DiscoverRestException, DiscoverCaseDoesNotExistException {
        try {
            String query = "query{cases(decommissionStatus: Live, id:" + this.gson.toJson((Object)caseId) + ") {id name active}}";
            CaseResponse casesListReponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<CaseResponse>(){});
            if (casesListReponse.getData().getCases().size() == 0) {
                throw new DiscoverCaseDoesNotExistException();
            }
            return casesListReponse.getData().getCases().get(0);
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public Case getCase(String caseName) throws DiscoverRestException, DiscoverCaseDoesNotExistException {
        try {
            String query = "query{cases(decommissionStatus: Live, name:" + this.gson.toJson((Object)caseName) + ") {id name active}}";
            CaseResponse casesListReponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<CaseResponse>(){});
            ArrayList<Case> cases = new ArrayList<Case>();
            for (Case c : casesListReponse.getData().getCases()) {
                if (!c.getName().equals(caseName)) continue;
                cases.add(c);
            }
            if (cases.size() == 0) {
                throw new DiscoverCaseDoesNotExistException();
            }
            if (cases.size() > 1) {
                throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.MultipleCasesWithName", new Object[]{String.valueOf(cases.size()), caseName}))));
            }
            return (Case)cases.get(0);
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public Case getCase(Pattern pattern) throws DiscoverRestException, DiscoverCaseDoesNotExistException {
        try {
            String query = "query{cases(decommissionStatus: Live) {id name active}}";
            CaseResponse casesListReponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<CaseResponse>(){});
            ArrayList<Case> cases = new ArrayList<Case>();
            HashSet<CallSite> caseNamesWithIds = new HashSet<CallSite>();
            for (Case c : casesListReponse.getData().getCases()) {
                Matcher matcher = pattern.matcher(c.getName());
                if (!matcher.find()) continue;
                cases.add(c);
                caseNamesWithIds.add((CallSite)((Object)(c.getName() + " (ID " + c.getId() + ")")));
            }
            if (cases.size() == 0) {
                throw new DiscoverCaseDoesNotExistException();
            }
            if (cases.size() > 1) {
                throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.MultipleCasesMatchingRegex", new Object[]{caseNamesWithIds.size(), String.join((CharSequence)", ", caseNamesWithIds)}))));
            }
            return (Case)cases.get(0);
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public String getOrgName(int orgId) throws DiscoverRestException, DiscoverCaseDoesNotExistException {
        try {
            String query = "query{organizations(id:" + this.gson.toJson((Object)orgId) + ") {id name}}";
            OrgResponse orgListReponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<OrgResponse>(){});
            if (orgListReponse.getData().getOrganizations().size() == 0) {
                throw new DiscoverCaseDoesNotExistException();
            }
            return orgListReponse.getData().getOrganizations().get(0).getName();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public int getOrgId(String orgName) throws DiscoverRestException, DiscoverCaseDoesNotExistException {
        try {
            String query = "query{organizations(name:" + this.gson.toJson((Object)orgName) + ") {id name}}";
            OrgResponse orgListReponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<OrgResponse>(){});
            ArrayList<Org> orgs = new ArrayList<Org>();
            for (Org org : orgListReponse.getData().getOrganizations()) {
                if (!org.getName().equals(orgName)) continue;
                orgs.add(org);
            }
            if (orgs.size() == 0) {
                throw new DiscoverCaseDoesNotExistException();
            }
            if (orgs.size() > 1) {
                throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.MultipleOrgsWithName", new Object[]{String.valueOf(orgs.size()), orgName}))));
            }
            return ((Org)orgs.get(0)).getId();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public Group getCaseGroup(int caseId, String groupName) throws DiscoverRestException, DiscoverCaseDoesNotExistException {
        try {
            String query = "query\n{\n  cases(id: " + this.gson.toJson((Object)caseId) + "){\n    groups(name:" + this.gson.toJson((Object)groupName) + "){\n      id name\n    }\n  }\n}\n";
            CaseGroupsResponse caseGroupsResponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<CaseGroupsResponse>(){});
            if (caseGroupsResponse.getData().getCases().size() == 0) {
                throw new DiscoverCaseDoesNotExistException();
            }
            List<Group> groups = caseGroupsResponse.getData().getCases().get(0).getGroups();
            if (groups.size() == 0) {
                throw new DiscoverCaseDoesNotExistException();
            }
            if (groups.size() > 1) {
                throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(this.iu.getFormattedString("DiscoverRestClient.Error.MultipleGroupsWithName", new Object[]{String.valueOf(groups.size()), groupName}))));
            }
            return groups.get(0);
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public int getMeId() throws DiscoverRestException {
        try {
            String query = "query{me {id}}";
            MeResponse meResponse = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<MeResponse>(){});
            return meResponse.getData().getMe().getId();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public int getDocumentEntityId(int caseId) throws DiscoverRestException {
        try {
            String query = "query default {\n  cases(id: " + caseId + ") {\n    dataModels {\n      entities {\n        id\n        name\n      }\n    }\n  }\n}";
            EntityResponse response = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<EntityResponse>(){});
            for (EntityResponse.Entity entity : response.getData().getCases().get(0).getDataModels().get(0).getEntities()) {
                if (!entity.getName().equalsIgnoreCase("document")) continue;
                return entity.getId();
            }
            throw new IOException("Failed to find document entity ID");
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public Set<String> queryDocumentFieldsMap(int caseId) throws DiscoverRestException {
        HashSet<String> documentFieldsMap = new HashSet<String>();
        try {
            int documentEntityId = this.getDocumentEntityId(caseId);
            String query = "query default {\n  cases(id: " + caseId + ") {\n    fields(entityId: " + documentEntityId + ") {\n      name\n    }\n  }\n}";
            DiscoverFieldsResponse response = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<DiscoverFieldsResponse>(){});
            for (DiscoverFieldsResponse.Field field : response.getData().getCases().get(0).getFields()) {
                documentFieldsMap.add(field.getName());
            }
            return documentFieldsMap;
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public int getDocumentInternalIdSearchRunId(int caseId, DiscoverItemSourceType itemSourceType, String itemSourceIdentifier) throws DiscoverRestException {
        try {
            Object searchQuery = "";
            switch (itemSourceType) {
                case SAVED_SEARCH: {
                    searchQuery = "{singleQuery: {field: \"Saved Search\", operator: Equal, value: \"" + itemSourceIdentifier + "\"}}";
                    break;
                }
                case PRODUCTION: {
                    searchQuery = "{singleQuery: {field: \"Production\", operator: Equal, value: \"" + itemSourceIdentifier + "\"}}";
                    break;
                }
                case BINDER: {
                    searchQuery = "{singleQuery: {field: \"Binder - Shared\", operator: Equal, value: \"" + itemSourceIdentifier + "\"}}";
                }
            }
            Query query = this.buildDocumentSearchRunRequest(caseId, (String)searchQuery);
            SearchRunResponse searchRunResponse = this.callApi(this.apiUrl, "POST", query, new GenericType<SearchRunResponse>(){});
            return searchRunResponse.getData().getSearchRun().getId();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public DocumentSearchResultsResponse queryDocumentInternalId(int caseId, int searchRunId, int limit, int page) throws DiscoverRestException {
        try {
            Query query = this.buildQueryDocumentIdRequest(caseId, searchRunId, limit, page);
            return this.callApi(this.apiUrl, "POST", query, new GenericType<DocumentSearchResultsResponse>(){});
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public int getDocumentQuerySearchRunId(int caseId, DiscoverItemSourceType itemSourceType, String itemSourceIdentifier) throws DiscoverRestException {
        try {
            Object searchQuery = "";
            if (itemSourceType != DiscoverItemSourceType.ALL_ITEMS && (itemSourceIdentifier == null || itemSourceIdentifier.trim().equals(""))) {
                throw new IOException("Item source identifier must be defined for " + itemSourceType.toString());
            }
            switch (itemSourceType) {
                case ALL_ITEMS: {
                    searchQuery = "{singleQuery: {field: \"Document ID\", operator: HasValue}}";
                    break;
                }
                case SAVED_SEARCH: {
                    searchQuery = "{singleQuery: {field: \"Saved Search\", operator: Equal, value: \"" + itemSourceIdentifier + "\"}}";
                    break;
                }
                case PRODUCTION: {
                    searchQuery = "{singleQuery: {field: \"Production\", operator: Equal, value: \"" + itemSourceIdentifier + "\"}}";
                    break;
                }
                case BINDER: {
                    searchQuery = "{singleQuery: {field: \"Binder - Shared\", operator: Equal, value: \"" + itemSourceIdentifier + "\"}}";
                    break;
                }
                default: {
                    throw new IOException("Item source type " + itemSourceType.toString() + " is not implemented");
                }
            }
            Query query = this.buildDocumentSearchRunRequest(caseId, (String)searchQuery);
            SearchRunResponse searchRunResponse = this.callApi(this.apiUrl, "POST", query, new GenericType<SearchRunResponse>(){});
            return searchRunResponse.getData().getSearchRun().getId();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public DocumentSearchResultsResponse queryDocumentsResponse(int caseId, int searchRunId, int limit, int page, Set<String> fields) throws DiscoverRestException {
        String fieldsString = this.convertFieldsToQueryString(fields);
        try {
            Query query = this.buildQueryDocumentRequest(caseId, searchRunId, limit, page, fieldsString);
            return this.callApi(this.apiUrl, "POST", query, new GenericType<DocumentSearchResultsResponse>(){});
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public List<DiscoverDocument> queryDocuments(int caseId, int searchRunId, int limit, int page, Set<String> fields) throws DiscoverRestException {
        try {
            DocumentSearchResultsResponse response = this.queryDocumentsResponse(caseId, searchRunId, limit, page, fields);
            return response.getData().getCases().get(0).getSearchResults().get(0).getDocuments();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public List<DiscoverDocument> queryAllDocuments(int caseId, int searchRunId, int limit, Set<String> fields) throws DiscoverRestException {
        ArrayList<DiscoverDocument> discoverDocuments = new ArrayList<DiscoverDocument>();
        int receivedResults = 0;
        int page = 0;
        try {
            while (true) {
                DocumentSearchResultsResponse response = this.queryDocumentsResponse(caseId, searchRunId, limit, page, fields);
                int resultsTotalCount = response.getData().getCases().get(0).getSearchResults().get(0).getCount();
                List<DiscoverDocument> responseDocuments = response.getData().getCases().get(0).getSearchResults().get(0).getDocuments();
                if (responseDocuments == null || responseDocuments.size() == 0) break;
                discoverDocuments.addAll(responseDocuments);
                if ((receivedResults += responseDocuments.size()) >= resultsTotalCount) break;
                LOGGER.info("Progress (" + receivedResults + " of " + resultsTotalCount + ")");
                ++page;
            }
            return discoverDocuments;
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    private DiscoverObject filterDiscoverObjects(List<DiscoverObject> objects, DiscoverIdentifierType identifierType, String identifier, String discoverObjectType) throws IOException {
        ArrayList<DiscoverObject> matchingObjects = new ArrayList<DiscoverObject>();
        switch (identifierType) {
            case ID: {
                for (DiscoverObject obj : objects) {
                    if (!String.valueOf(obj.getId()).equals(identifier)) continue;
                    matchingObjects.add(obj);
                }
                break;
            }
            case NAME: {
                for (DiscoverObject obj : objects) {
                    if (!obj.getName().equals(identifier)) continue;
                    matchingObjects.add(obj);
                }
                break;
            }
            case NAME_REGEX: {
                for (DiscoverObject obj : objects) {
                    if (!obj.getName().matches(identifier)) continue;
                    matchingObjects.add(obj);
                }
                break;
            }
        }
        if (matchingObjects.size() == 0) {
            throw new IOException("Could not find any " + discoverObjectType + " that match identifier " + identifier);
        }
        if (matchingObjects.size() > 1) {
            String identifierTypeString = identifierType == DiscoverIdentifierType.ID ? identifierType.toString() : DiscoverIdentifierType.NAME.toString();
            throw new IOException("Found " + matchingObjects.size() + " " + discoverObjectType + " with the same " + identifierTypeString);
        }
        return (DiscoverObject)matchingObjects.get(0);
    }

    public List<DiscoverObject> getSavedSearches(int caseId) throws DiscoverRestException {
        try {
            String query = "query default {\n  cases(id: " + caseId + ") {\n    savedSearches {\n      id\n      name\n    }\n  }\n}";
            SavedSearchResponse response = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<SavedSearchResponse>(){});
            return response.getData().getCases().get(0).getSavedSearches();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public String getSavedSearch(int caseId, DiscoverIdentifierType identifierType, String identifier) throws DiscoverRestException {
        try {
            List<DiscoverObject> savedSearches = this.getSavedSearches(caseId);
            DiscoverObject discoverObject = this.filterDiscoverObjects(savedSearches, identifierType, identifier, "saved search");
            return discoverObject.getName();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public List<DiscoverObject> getProductions(int caseId) throws DiscoverRestException {
        try {
            String query = "query default {\n  cases(id: " + caseId + ") {\n    productions {\n      name\n    }\n  }\n}";
            ProductionResponse response = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<ProductionResponse>(){});
            return response.getData().getCases().get(0).getProductions();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public String getProduction(int caseId, DiscoverIdentifierType identifierType, String identifier) throws DiscoverRestException {
        try {
            List<DiscoverObject> productions = this.getProductions(caseId);
            DiscoverObject discoverObject = this.filterDiscoverObjects(productions, identifierType, identifier, "production");
            return discoverObject.getName();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public List<DiscoverObject> getBinders(int caseId) throws DiscoverRestException {
        try {
            String query = "query default {\n  cases(id: " + caseId + ") {\n    binders(type: Shared){\n      id\n      name\n    }\n  }\n}";
            BinderResponse response = this.callApi(this.apiUrl, "POST", new Query(query), new GenericType<BinderResponse>(){});
            return response.getData().getCases().get(0).getBinders();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public String getBinder(int caseId, DiscoverIdentifierType identifierType, String identifier) throws DiscoverRestException {
        try {
            List<DiscoverObject> binders = this.getBinders(caseId);
            DiscoverObject discoverObject = this.filterDiscoverObjects(binders, identifierType, identifier, "binder");
            return discoverObject.getName();
        }
        catch (IOException e) {
            throw new DiscoverRestException(new DiscoverErrors(new DiscoverError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e))));
        }
    }

    public Query buildDocumentSearchRunRequest(int caseId, String searchQuery) {
        return new Query("mutation default {\n  searchRun(\n    caseId: " + caseId + "\n    input: " + searchQuery + ") {\n       id\n    }\n}");
    }

    private Query buildQueryDocumentRequest(int caseId, int searchRunId, int limit, int page, String fieldsString) {
        return new Query("query default {\n  cases(id: " + caseId + ") {\n    searchResults(id: " + searchRunId + ") {\n      count\n      documents(scroll: {limit: " + limit + ", start: " + page + "}) {\n        id,\n        title,\n        documentId,\n        fields(fields: [" + fieldsString + "]) {\n          name\n          values {\n            value\n          }\n        }\n      }\n    }\n  }\n}");
    }

    private Query buildQueryDocumentIdRequest(int caseId, int searchRunId, int limit, int page) {
        return new Query("query default {\n  cases(id: " + caseId + ") {\n    searchResults(id: " + searchRunId + ") {\n      count\n      documents(scroll: {limit: " + limit + ", start: " + page + "}) {\n        id,\n      }\n    }\n  }\n}");
    }

    private String convertFieldsToQueryString(Set<String> fields) {
        ArrayList<CallSite> queryStrings = new ArrayList<CallSite>();
        for (String field : fields) {
            queryStrings.add((CallSite)((Object)("{name: \"" + field + "\"}")));
        }
        return String.join((CharSequence)", ", queryStrings);
    }

    private Integer getSystemProperty(String key, Integer defaultValue) {
        String property = System.getProperty(key);
        if (property != null) {
            return Integer.parseInt(property);
        }
        return defaultValue;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }
}

