/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.ecc;

import com.nuix.automate.utils.ecc.internal.Pair;
import com.nuix.automate.utils.ecc.responses.EccResponse;
import com.nuix.automate.utils.ecc.responses.cases.Case;
import com.nuix.automate.utils.ecc.responses.cases.Cases;
import com.nuix.automate.utils.ecc.responses.collections.CollectionByConfiguration;
import com.nuix.automate.utils.ecc.responses.collections.CollectionByPath;
import com.nuix.automate.utils.ecc.responses.collections.CollectionResponse;
import com.nuix.automate.utils.ecc.responses.collections.Collections;
import com.nuix.automate.utils.ecc.responses.computers.Computer;
import com.nuix.automate.utils.ecc.responses.computers.Computers;
import com.nuix.automate.utils.ecc.responses.configurations.Configuration;
import com.nuix.automate.utils.ecc.responses.configurations.Configurations;
import com.nuix.automate.utils.ecc.responses.filter.FilterRequest;
import com.nuix.automate.utils.ecc.responses.jobs.Job;
import com.nuix.automate.utils.ecc.responses.jobs.Jobs;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.workflow.core.utils.general.ThirdPartyProxyRestClient;
import jakarta.ws.rs.core.GenericType;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EccRestClient
extends ThirdPartyProxyRestClient {
    private static final int PAGE_SIZE = 1000;

    public EccRestClient(String thirdPartyServiceId, String schedulerUrl, String bearerToken, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        super(thirdPartyServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
    }

    @Override
    public String getLogFileName() {
        return System.getProperty("automate.ecc.log");
    }

    @Override
    public String getServiceName() {
        return "Nuix ECC";
    }

    public Cases getCases() throws IOException {
        return this.proxyApiGetRequest("/api/ecc/v2/cases", new GenericType<Cases>(){});
    }

    public Case getCase(int id) throws IOException {
        String endpoint = "/api/ecc/v2/cases/" + id;
        Cases cases = this.proxyApiGetRequest(endpoint, new GenericType<Cases>(){});
        if (cases == null || cases.getCases() == null || cases.getCases().size() == 0) {
            return null;
        }
        return (Case)cases.getCases().get(0);
    }

    public Case createCase(Case eccCase) throws IOException {
        EccResponse caseCreationRequest = this.proxyApiRequest("/api/ecc/v2/cases", "POST", eccCase, new GenericType<EccResponse>(){});
        eccCase.setId(caseCreationRequest.getId());
        eccCase.setStatus("Open");
        return eccCase;
    }

    public boolean deleteCase(int caseId) throws IOException {
        String endpoint = "/api/ecc/v2/cases/" + caseId;
        this.proxyApiRequest(endpoint, "DELETE", 200);
        return true;
    }

    public Case updateCase(Case eccCase) throws IOException {
        EccResponse caseCreationRequest = this.proxyApiRequest("/api/ecc/v2/cases", "POST", eccCase, new GenericType<EccResponse>(){});
        eccCase.setId(caseCreationRequest.getId());
        return eccCase;
    }

    public Collections getCaseCollections(int caseId) throws IOException {
        String endpoint = "/api/ecc/v2/collections?caseId=" + caseId;
        return this.proxyApiGetRequest(endpoint, new GenericType<Collections>(){});
    }

    public CollectionResponse launchCollection(CollectionByConfiguration arguments) throws IOException {
        String collectionJson = this.proxyApiRequest("/api/ecc/v2/collectionsByConfiguration", "POST", arguments, new GenericType<String>(){});
        return (CollectionResponse)SerializationUtils.fromJson((String)collectionJson, CollectionResponse.class);
    }

    public CollectionResponse launchCollection(CollectionByPath arguments) throws IOException {
        String collectionJson = this.proxyApiRequest("/api/ecc/v2/collectionsByPath", "POST", arguments, new GenericType<String>(){});
        return (CollectionResponse)SerializationUtils.fromJson((String)collectionJson, CollectionResponse.class);
    }

    public Configurations getConfigurations() throws IOException {
        String configurationsJson = this.proxyApiGetRequest("/api/ecc/v2/configurations", new GenericType<String>(){});
        return (Configurations)SerializationUtils.fromJson((String)configurationsJson, Configurations.class);
    }

    public Configuration getConfigurationForId(int configId) throws IOException {
        String endpoint = "/api/ecc/v2/configurations?id=" + configId;
        String configurationsJson = this.proxyApiGetRequest(endpoint, new GenericType<String>(){});
        Configurations configurations = (Configurations)SerializationUtils.fromJson((String)configurationsJson, Configurations.class);
        if (configurations == null || configurations.getConfigurations() == null || configurations.getConfigurations().size() == 0) {
            return null;
        }
        return (Configuration)configurations.getConfigurations().get(0);
    }

    public List<Computer> getComputers() throws IOException {
        FilterRequest filter = new FilterRequest(1000);
        ArrayList<Computer> computers = new ArrayList<Computer>();
        String endpoint = "/api/ecc/v2/computers";
        while (true) {
            String next;
            String computersJson;
            Computers response;
            if ((response = (Computers)SerializationUtils.fromJson((String)(computersJson = this.proxyApiRequest(endpoint, "POST", filter, new GenericType<String>(){})), Computers.class)).getComputers() != null) {
                computers.addAll(response.getComputers());
            }
            if ((next = response.getNext()) == null) break;
            endpoint = response.getNext();
        }
        return computers;
    }

    private String encodeForDerby(String computerName) {
        return computerName.replace("'", "''");
    }

    private String buildWhereClause(List<String> computerNames) {
        HashSet<CallSite> computerQueries = new HashSet<CallSite>();
        for (String computerName : computerNames) {
            computerQueries.add((CallSite)((Object)("Name = '" + this.encodeForDerby(computerName) + "'")));
        }
        return "Purpose = 'Client' AND (" + String.join((CharSequence)" OR ", computerQueries) + ")";
    }

    public List<Computer> getFilteredComputer(List<String> computerNames) throws IOException {
        FilterRequest filter = new FilterRequest(1000);
        filter.setAscending(Boolean.valueOf(false));
        filter.setSortBy("FirstContactTime");
        filter.setWhere(this.buildWhereClause(computerNames));
        String endpoint = "/api/ecc/v2/computers";
        ArrayList<Computer> computers = new ArrayList<Computer>();
        while (true) {
            String next;
            String computersJson;
            Computers response;
            if ((response = (Computers)SerializationUtils.fromJson((String)(computersJson = this.proxyApiRequest(endpoint, "POST", filter, new GenericType<String>(){})), Computers.class)).getComputers() != null) {
                computers.addAll(response.getComputers());
            }
            if ((next = response.getNext()) == null) break;
            endpoint = response.getNext();
        }
        return computers;
    }

    public List<Job> getJobsForCollections(Set<Integer> collectionIds) throws IOException {
        FilterRequest filter = new FilterRequest();
        filter.setLimit(collectionIds.size() + 1);
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (Integer id : collectionIds) {
            pairs.add(new Pair("CollectionID", (Object)id));
        }
        filter.setWhere(EccRestClient.buildWhereClause(pairs, "OR"));
        ArrayList<Job> jobs = new ArrayList<Job>();
        String endpoint = "/api/ecc/v2/jobs";
        while (true) {
            String next;
            String jobsJson;
            Jobs response;
            if ((response = (Jobs)SerializationUtils.fromJson((String)(jobsJson = this.proxyApiRequest(endpoint, "POST", filter, new GenericType<String>(){})), Jobs.class)).getJobs() != null) {
                jobs.addAll(response.getJobs());
            }
            if ((next = response.getNext()) == null) break;
            endpoint = response.getNext();
        }
        return jobs;
    }

    public static String buildWhereClause(List<Pair> pairs, String operator) {
        ArrayList<CallSite> clauses = new ArrayList<CallSite>();
        for (Pair pair : pairs) {
            String identifier = pair.getKey();
            Object value = pair.getValue();
            String delimiter = value.getClass() == String.class ? "'" : "";
            clauses.add((CallSite)((Object)(identifier + " = " + delimiter + String.valueOf(value) + delimiter)));
        }
        return String.join((CharSequence)(" " + operator + " "), clauses);
    }
}

