/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.es;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.proxy.NonProxyListProxyRoutePlanner;
import com.nuix.automate.workflow.core.utils.es.EsConfig;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(EsFactory.class);

    public static ElasticsearchClient getEsClient(EsConfig elasticConfig) throws IOException {
        try {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(elasticConfig.getUsername(), elasticConfig.getPassword()));
            HashSet<String> fingerprints = new HashSet<String>();
            fingerprints.add(elasticConfig.getCertFingerprint());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{WsRsRestClientFactory.getTrustManager(fingerprints)}, new SecureRandom());
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(elasticConfig.getHost(), elasticConfig.getPort(), "https")}).setHttpClientConfigCallback(arg_0 -> EsFactory.lambda$getEsClient$0(sslContext, (CredentialsProvider)credentialsProvider, arg_0));
            LOGGER.info("Creating Elasticsearch client (host=" + elasticConfig.getHost() + ", port=" + elasticConfig.getPort() + ", fingerprint=" + elasticConfig.getCertFingerprint() + ")");
            RestClient restClient = builder.build();
            RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
            ElasticsearchClient client = new ElasticsearchClient((ElasticsearchTransport)transport);
            return client;
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Cannot prepare HTTPS client", e);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$getEsClient$0(SSLContext sslContext, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        HttpAsyncClientBuilder clientBuilder = httpClientBuilder.setSSLContext(sslContext).setSSLHostnameVerifier(WsRsRestClientFactory.getAllowAllHostnameVerifier()).setDefaultCredentialsProvider(credentialsProvider);
        NetworkConfiguration networkConfiguration = NetworkConfiguration.fromSystemProperties();
        if (networkConfiguration.isProxyConfigured()) {
            HttpHost httpHost = new HttpHost(networkConfiguration.getProxyHost(), networkConfiguration.getProxyPort().intValue());
            clientBuilder.setProxy(httpHost);
            clientBuilder.setRoutePlanner((HttpRoutePlanner)new NonProxyListProxyRoutePlanner(httpHost, new ArrayList(networkConfiguration.getNonProxyHosts())));
        }
        return clientBuilder;
    }
}

