/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi;

import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.StatusLogger;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.genai.GenAiProtocol;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.genAi.GenAiClient;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiModel;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.genAi.InvalidModelGenAiException;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.anthropic.AnthropicClient;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.converse.ConverseClient;
import com.nuix.automate.workflow.core.utils.genAi.ollama.OllamaClient;
import com.nuix.automate.workflow.core.utils.genAi.openAi.OpenAiClient;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import nuix.Case;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.ProductionSetItem;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class GenAiHelper {
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private static final String GEN_AI_PREFIX = "GenAI";
    public static final String GEN_AI_MODEL = "System|Model";
    public static final String GEN_AI_SERVICE = "System|Service";
    public static final String GEN_AI_TRACE = "System|Trace";
    public static final String GEN_AI_ERROR_METADATA = "System|Error";
    public static final String GEN_AI_WARNING_METADATA = "System|Warning";
    public static final String DOC_ID_PARAMETER = "{doc_id}";
    public static final String ITEM_NAME_PARAMETER = "{item_name}";
    public static final String ITEM_GUID_PARAMETER = "{item_guid}";
    public static final String EMAIL_HEADER_PARAMETER = "{email_header}";
    public static final Double CONTEXT_WINDOW_TARGET_RATIO = 0.9;
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenAiHelper.class);
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final int DEFAULT_WAIT_MS = 1000;
    private GenAiService genAiService;
    private transient Long requestsTotal;
    private transient AtomicLong requestsRemaining;
    private transient Long requestsResetMs;
    private transient Long tokensTotal;
    private transient AtomicLong tokensRemaining;
    private transient Long tokensResetMs;
    private transient BlockingDeque<GenAiClient> clientsIdle;
    private transient Semaphore clientsAllowed;
    private AtomicBoolean requestsLimitError;
    private AtomicBoolean tokensLimitError;
    private transient AtomicLong promptTokens;
    private transient AtomicLong completionTokens;
    private boolean stopRequested;
    private long genericBackOffMs = 1000L;
    private long genericBackOffMsMin = 1000L;
    private long genericBackOffMsMax = 120000L;
    private double genericBackOffMultiplier = 1.5;
    private String metadataProfileName;
    private Case nuixCase;
    private HuggingFaceTokenizer tokenizer;
    private Set<String> metadataNames;
    private int previousMetadataNamesSize;

    private void increaseGenericBackOff() {
        boolean maxReached;
        boolean bl = maxReached = this.genericBackOffMs >= this.genericBackOffMsMax;
        if (!maxReached) {
            this.genericBackOffMs = (long)Math.max((double)this.genericBackOffMsMin, Math.min((double)this.genericBackOffMsMax, (double)this.genericBackOffMs * this.genericBackOffMultiplier));
            LOGGER.info("Increasing generic back off to " + this.genericBackOffMs + "ms");
        }
    }

    private void decreaseGenericBackOff() {
        boolean minReached;
        boolean bl = minReached = this.genericBackOffMs <= this.genericBackOffMsMin;
        if (!minReached) {
            this.genericBackOffMs = (long)Math.max((double)this.genericBackOffMsMin, Math.min((double)this.genericBackOffMsMax, (double)this.genericBackOffMs / this.genericBackOffMultiplier));
            LOGGER.info("Decreasing generic back off to " + this.genericBackOffMs + "ms");
        }
    }

    public GenAiHelper(ExecutionContext executionContext, Operation operation, Map<String, ThirdPartyService> thirdPartyServices) throws GenAiException, ParameterException {
        this(executionContext, operation, thirdPartyServices, null);
    }

    public GenAiHelper(ExecutionContext executionContext, Operation operation, Map<String, ThirdPartyService> thirdPartyServices, String metadataProfileName) throws GenAiException, ParameterException {
        this.metadataProfileName = metadataProfileName;
        this.nuixCase = executionContext.nuixCase;
        this.metadataNames = ConcurrentHashMap.newKeySet();
        String genAiServiceId = executionContext.evalParameters("{wfn_gen_ai_service_id}", operation);
        if (thirdPartyServices == null || thirdPartyServices.get(genAiServiceId) == null) {
            throw new GenAiException(this.iu.getFormattedString("GenAiConfigureConnectionOperation.Exception.MissingService", (Object)genAiServiceId));
        }
        GenAiService genAiService = (GenAiService)thirdPartyServices.get(genAiServiceId);
        boolean overrideModel = executionContext.evalBooleanParameter("{wfn_gen_ai_override_model}", operation);
        if (overrideModel) {
            String model = executionContext.evalParameters("{wfn_gen_ai_model}", operation);
            genAiService.setModel(model);
        }
        this.initDefaults(genAiService);
        this.initTokenizer();
    }

    public GenAiHelper() {
        this.metadataNames = ConcurrentHashMap.newKeySet();
    }

    private synchronized void createOrUpdateMetadataProfile() {
        if (this.metadataProfileName == null) {
            return;
        }
        ArrayList<String> userAndSystemMetadataNames = new ArrayList<String>(this.metadataNames);
        userAndSystemMetadataNames.sort(String.CASE_INSENSITIVE_ORDER);
        LOGGER.info("Creating metadata profile " + this.metadataProfileName + " with fields: " + String.join((CharSequence)", ", userAndSystemMetadataNames));
        try {
            NuixUtils.createMetadataProfile(this.nuixCase.getLocation().toString(), this.metadataProfileName, userAndSystemMetadataNames);
        }
        catch (IOException e) {
            LOGGER.error("Cannot create metadata profile", (Throwable)e);
        }
    }

    public GenAiHelper(GenAiService genAiService) {
        this.initDefaults(genAiService);
        this.initTokenizer();
    }

    public GenAiHelper(GenAiService genAiService, String model) throws GenAiException {
        this.initDefaults(genAiService);
        if (model != null) {
            if (genAiService.getEnableModelOverride().booleanValue()) {
                genAiService.setModel(model);
            } else {
                throw new GenAiException(this.iu.getFormattedString("GenAiOperation.Error.CannotSetModel", new Object[]{model, genAiService.getName()}));
            }
        }
        this.initTokenizer();
    }

    private void initDefaults(GenAiService genAiService) {
        this.genAiService = genAiService;
        this.clientsIdle = new LinkedBlockingDeque<GenAiClient>();
        if (genAiService.getMultiThreading() == null) {
            genAiService.setMultiThreading(Integer.valueOf(1));
        }
        this.clientsAllowed = new Semaphore(Math.max(1, genAiService.getMultiThreading()));
        this.requestsLimitError = new AtomicBoolean(false);
        this.tokensLimitError = new AtomicBoolean(false);
        this.requestsTotal = 0L;
        this.requestsRemaining = new AtomicLong(0L);
        this.requestsResetMs = 0L;
        this.tokensTotal = 0L;
        this.tokensRemaining = new AtomicLong(0L);
        this.tokensResetMs = 0L;
        this.promptTokens = new AtomicLong(0L);
        this.completionTokens = new AtomicLong(0L);
    }

    private synchronized Path getPath(URI uri) {
        Path dirPath;
        try {
            dirPath = Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            try {
                FileSystems.newFileSystem(uri, new HashMap()).getPath("/tokenizers/", new String[0]);
            }
            catch (IOException | FileSystemAlreadyExistsException ex) {
                LOGGER.warn("Cannot create new file system for URI " + String.valueOf(uri) + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)ex, (boolean)true));
            }
            dirPath = Paths.get(uri);
        }
        return dirPath;
    }

    private String getTokenizerNameForModel(String modelName) {
        String defaultTokenizer = "llama33";
        try {
            URI uri = this.getClass().getResource("/tokenizers/").toURI();
            Path dirPath = this.getPath(uri);
            List tokenizerPaths = Files.list(dirPath).collect(Collectors.toCollection(ArrayList::new));
            for (Path tokenizerPath : tokenizerPaths) {
                String tokenizerName = tokenizerPath.getFileName().toString().replace(".json", "");
                if (!modelName.replaceAll("[^a-zA-Z0-9]", "").toLowerCase().contains(tokenizerName)) continue;
                return tokenizerName;
            }
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Cannot get tokenizer name for model " + modelName, (Throwable)e);
        }
        return defaultTokenizer;
    }

    private void initTokenizer() {
        String tokenizerName = this.getTokenizerNameForModel(this.genAiService.getModel());
        LOGGER.info("Service " + this.genAiService.getName() + ", Using tokenizer " + tokenizerName);
        try (InputStream stream = this.getClass().getResourceAsStream("/tokenizers/" + tokenizerName + ".json");){
            Path tempTokenizer = FileUtils.createTempFilePath((String)"tokenizer", (String)".json", (FileAttribute[])new FileAttribute[0]);
            IOUtils.copy((InputStream)stream, (OutputStream)Files.newOutputStream(tempTokenizer.toFile().toPath(), new OpenOption[0]));
            this.tokenizer = HuggingFaceTokenizer.newInstance((Path)tempTokenizer);
            try {
                Files.deleteIfExists(tempTokenizer);
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.info("Service " + this.genAiService.getName() + ", Initialized tokenizer");
        }
        catch (Exception e) {
            LOGGER.error("Service " + this.genAiService.getName() + ", Cannot initialize tokenizer", (Throwable)e);
        }
    }

    public String getPrintableServiceName() {
        try {
            String printableService = FormattingUtils.getHostnameFromUrl((String)this.genAiService.getUrl());
            printableService = printableService.replace("api.", "");
            printableService = printableService.replace("bedrock-runtime.", "bedrock.");
            return printableService;
        }
        catch (URISyntaxException e) {
            return this.genAiService.getUrl();
        }
    }

    public String getPrintableLimits() {
        StringBuilder sb = new StringBuilder();
        if (this.requestsTotal != null && this.requestsTotal > 0L) {
            sb.append(this.iu.getFormattedString("GenAi.RequestsLimits", new Object[]{this.requestsRemaining, this.requestsTotal, this.requestsResetMs / 1000L}));
        }
        if (this.tokensTotal != null && this.tokensTotal > 0L) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append(this.iu.getFormattedString("GenAi.TokensLimits", new Object[]{this.tokensRemaining, this.tokensTotal, this.tokensResetMs / 1000L}));
        }
        return sb.toString();
    }

    private GenAiClient buildClient() {
        if (this.genAiService.getProtocol() == null) {
            this.genAiService.setProtocol(GenAiProtocol.OPEN_AI);
        }
        if (this.genAiService.getMultiThreading() == null) {
            this.genAiService.setMultiThreading(Integer.valueOf(1));
        }
        if (this.genAiService.getEnableSystemRole() == null) {
            this.genAiService.setEnableSystemRole(Boolean.valueOf(false));
        }
        switch (this.genAiService.getProtocol()) {
            case OPEN_AI: {
                return new OpenAiClient(this.genAiService);
            }
            case OLLAMA: {
                return new OllamaClient(this.genAiService);
            }
            case BEDROCK_ANTHROPIC: {
                return new AnthropicClient(this.genAiService);
            }
            case BEDROCK_CONVERSE: {
                return new ConverseClient(this.genAiService);
            }
        }
        throw new IllegalArgumentException("Unsupported protocol " + String.valueOf(this.genAiService.getProtocol()));
    }

    public static String indentMultiLineText(String prompt) {
        return "\n\t" + prompt.replace("\n", "\n\t");
    }

    public long getPromptTokens() {
        return this.promptTokens.get();
    }

    public long getCompletionTokens() {
        return this.completionTokens.get();
    }

    public long getTotalTokens() {
        return this.promptTokens.get() + this.completionTokens.get();
    }

    public boolean fitsInContext(int promptTokens) {
        return (double)promptTokens <= (double)this.genAiService.getContextWindow().intValue() * CONTEXT_WINDOW_TARGET_RATIO;
    }

    public int getContextWindow() {
        return this.genAiService.getContextWindow();
    }

    public String getPrintableContextWindow() {
        return String.format("%.2f", CONTEXT_WINDOW_TARGET_RATIO * 100.0) + "%";
    }

    public int detectContextWindow(StatusLogger statusLogger) {
        LOGGER.info("Service " + this.genAiService.getName() + ", Detecting context window...");
        int targetWindow = 1000;
        int contextWindow = 1000;
        int maxContextWindow = 100000000;
        if (this.tokenizer == null) {
            LOGGER.warn("Service " + this.genAiService.getName() + ", Skip detection of context window because tokenizer is null");
            return contextWindow;
        }
        while (contextWindow < maxContextWindow) {
            String prompt = this.getContextTestPromptOfLength(targetWindow);
            try {
                statusLogger.addLog(this.iu.getFormattedString("GenAi.Log.TestContextWindow", (Object)targetWindow));
                GenAiResponse response = this.testContext(prompt, targetWindow);
                String responseMessage = response.getMessage().getContent();
                responseMessage = responseMessage.replaceAll("[^a-zA-Z]", "").toUpperCase();
                boolean testPass = "PASS".equals(responseMessage);
                LOGGER.info("Service " + this.genAiService.getName() + ", Tested target context window: " + targetWindow + ", prompt tokens: " + response.getUsage().getPromptTokens() + ", pass: " + testPass);
                if (testPass) {
                    statusLogger.addLog(this.iu.getFormattedString("GenAi.Log.ContextWindowPass", new Object[]{targetWindow, response.getUsage().getPromptTokens()}));
                    contextWindow = targetWindow;
                    targetWindow *= 2;
                    continue;
                }
                statusLogger.addLog(this.iu.getFormattedString("GenAi.Log.ContextWindowFail", new Object[]{targetWindow, response.getUsage().getPromptTokens(), "Did not recall initial instructions"}));
            }
            catch (IOException e) {
                statusLogger.addLog(this.iu.getFormattedString("GenAi.Log.ContextWindowFail", new Object[]{targetWindow, "unknown", ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false)}));
                LOGGER.info("Service " + this.genAiService.getName() + ", Failed to test context window " + contextWindow, (Throwable)e);
            }
            break;
        }
        statusLogger.addLog(this.iu.getFormattedString("GenAi.Log.ContextWindowDetected", (Object)contextWindow));
        LOGGER.info("Service " + this.genAiService.getName() + ", Detected context window: " + contextWindow);
        return contextWindow;
    }

    private String getContextTestPromptOfLength(int tokenCount) {
        String initialPrompt = "Remember this word: \"PASS\".\n\nIgnore everything in this xml tag: <ignore>";
        String finalPrompt = "</ignore>\n\nWhat word did I ask you to remember? Only respond with the word, nothing else.\n\nIf I didn't ask you to remember a word, respond with \"NONE\".";
        String padding = "The quick brown fox jumps over the lazy dog. ";
        StringBuilder sb = new StringBuilder();
        sb.append(initialPrompt);
        sb.append(padding);
        sb.append(finalPrompt);
        int currentTokenCount = this.estimateTokens(sb.toString());
        int missingTokens = tokenCount - currentTokenCount;
        sb = new StringBuilder();
        sb.append(initialPrompt);
        sb.append(padding);
        sb.append(padding);
        sb.append(finalPrompt);
        int paddingTokenCount = this.estimateTokens(sb.toString()) - currentTokenCount;
        int paddingMultiple = missingTokens / paddingTokenCount;
        sb = new StringBuilder();
        sb.append(initialPrompt);
        for (int i = 0; i < paddingMultiple; ++i) {
            sb.append(padding);
        }
        sb.append(finalPrompt);
        return sb.toString();
    }

    public GenAiResponse testContext(String prompt, int contextWindow) throws IOException {
        ArrayList<GenAiMessage> chatMessages = new ArrayList<GenAiMessage>();
        chatMessages.add(new GenAiMessage("user", prompt));
        GenAiRequest request = new GenAiRequest("context-window-test-" + contextWindow, chatMessages);
        request.setMaxResponseTokens(10);
        try {
            GenAiResponse genAiResponse = this.getCompletions(request);
            return genAiResponse;
        }
        catch (InvalidModelGenAiException e) {
            List<String> validModelRepresentations = this.getValidModelIdName(e);
            throw new InvalidModelGenAiException(e.getMessage() + "\nAvailable models: " + String.join((CharSequence)", ", validModelRepresentations));
        }
    }

    @NotNull
    private List<String> getValidModelIdName(InvalidModelGenAiException e) throws InvalidModelGenAiException {
        List<GenAiModel> validModels = this.getAvailableModels();
        if (validModels == null || validModels.isEmpty()) {
            throw e;
        }
        ArrayList<String> validModelRepresentations = new ArrayList<String>();
        for (GenAiModel validModel : validModels) {
            if (!validModel.getId().equals(validModel.getName())) {
                validModelRepresentations.add(validModel.getId() + " (" + validModel.getName() + ")");
                continue;
            }
            validModelRepresentations.add(validModel.getId());
        }
        return validModelRepresentations;
    }

    public int estimateTokens(String text) {
        if (this.tokenizer == null) {
            return text.length();
        }
        int tokenCount = 0;
        String[] sentences = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)text, (String)"\n");
        if (text.length() > 1000 && sentences.length == 1) {
            sentences = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)text, (String)". ");
        }
        if (text.length() > 1000 && sentences.length == 1) {
            sentences = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)text, (String)".");
        }
        for (String line : sentences) {
            tokenCount += this.tokenizer.tokenize(line).size();
        }
        return tokenCount;
    }

    public String test() throws IOException {
        ArrayList<GenAiMessage> chatMessages = new ArrayList<GenAiMessage>();
        chatMessages.add(new GenAiMessage("system", "Respond in 1 word"));
        chatMessages.add(new GenAiMessage("user", "What's your name?"));
        GenAiRequest request = new GenAiRequest("test", chatMessages);
        request.setMaxResponseTokens(10);
        try {
            GenAiResponse genAiResponse = this.getCompletions(request);
            if (genAiResponse == null) {
                throw new GenAiException("No response");
            }
            GenAiMessage message = genAiResponse.getMessage();
            LOGGER.info("GenAI model " + this.genAiService.getModel() + " responded with: " + message.getContent());
            LOGGER.info("GenAI limits: " + this.getPrintableLimits());
            return message.getContent();
        }
        catch (InvalidModelGenAiException e) {
            List<String> validModelRepresentations = this.getValidModelIdName(e);
            throw new InvalidModelGenAiException(e.getMessage() + "\nAvailable models: " + String.join((CharSequence)", ", validModelRepresentations));
        }
    }

    public String getModel() {
        return this.genAiService.getModel();
    }

    public List<GenAiModel> getAvailableModels() {
        GenAiClient client = this.buildClient();
        return client.getAvailableModels();
    }

    /*
     * Exception decompiling
     */
    public GenAiResponse getCompletions(GenAiRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stop() {
        this.stopRequested = true;
    }

    public List<String> getAiMetadataNames(List<String> userDefinedNames) {
        ArrayList<String> genAiMetadataNames = new ArrayList<String>();
        for (String userDefinedName : userDefinedNames) {
            genAiMetadataNames.add(GenAiHelper.getNormalizedMetadataName(userDefinedName));
        }
        genAiMetadataNames.addAll(this.getModelServiceMetadataNames());
        genAiMetadataNames.add(GenAiHelper.getNormalizedMetadataName(GEN_AI_WARNING_METADATA));
        genAiMetadataNames.add(GenAiHelper.getNormalizedMetadataName(GEN_AI_ERROR_METADATA));
        return genAiMetadataNames;
    }

    public List<String> getModelServiceMetadataNames() {
        ArrayList<String> genAiMetadataNames = new ArrayList<String>();
        genAiMetadataNames.add(GenAiHelper.getNormalizedMetadataName(GEN_AI_MODEL));
        genAiMetadataNames.add(GenAiHelper.getNormalizedMetadataName(GEN_AI_SERVICE));
        return genAiMetadataNames;
    }

    public static String getNormalizedMetadataName(String name) {
        if (name.startsWith("GenAI|")) {
            return name;
        }
        return "GenAI|" + name;
    }

    public void setItemGenAiMetadata(Item item, String name, String value) {
        this.setItemGenAiMetadata(item, name, value, false);
    }

    public void setItemGenAiMetadata(Item item, String name, String value, boolean autoParseJson) {
        this.setItemGenAiMetadata(item, name, value, autoParseJson, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItemGenAiMetadata(Item item, String name, String value, boolean autoParseJson, boolean updateMetadataProfile) {
        String effectiveName = GenAiHelper.getNormalizedMetadataName(name);
        ItemCustomMetadataMap customMetadata = item.getCustomMetadata();
        if (value == null) {
            value = "";
        }
        Item item2 = item;
        synchronized (item2) {
            if (autoParseJson) {
                try {
                    Object valueMap = SerializationUtils.fromJson((String)GenAiHelper.stripJsonMarkdown(value));
                    GenAiHelper.removeItemMetadata(customMetadata, effectiveName);
                    this.assignItemMetadata(customMetadata, effectiveName, valueMap, updateMetadataProfile);
                    return;
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot parse JSON for GenAI metadata " + effectiveName + ", item: " + item.getGuid() + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                }
            }
            if (!value.equals(customMetadata.get((Object)effectiveName))) {
                customMetadata.remove((Object)effectiveName);
                customMetadata.putText(effectiveName, (Object)value);
            }
            if (updateMetadataProfile && this.metadataNames.add(effectiveName)) {
                this.createOrUpdateMetadataProfile();
            }
        }
    }

    private static String stripJsonMarkdown(String response) {
        if ((response = response.trim()).startsWith("```json")) {
            response = response.substring(7);
        }
        if (response.startsWith("```")) {
            response = response.substring(3);
        }
        if (response.endsWith("```")) {
            response = response.substring(0, response.length() - 3);
        }
        response = response.trim();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeItemMetadata(ItemCustomMetadataMap customMetadata, String metadataName) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : customMetadata.keySet()) {
            if (!key.equals(metadataName) && !key.startsWith(metadataName + "|")) continue;
            keysToRemove.add(key);
        }
        if (!keysToRemove.isEmpty()) {
            ItemCustomMetadataMap itemCustomMetadataMap = customMetadata;
            synchronized (itemCustomMetadataMap) {
                for (String key : keysToRemove) {
                    customMetadata.remove((Object)key);
                }
            }
        }
    }

    private void assignItemMetadata(ItemCustomMetadataMap customMetadata, String baseMetadataName, Object value, boolean updateMetadataProfile) {
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            for (Object key : valueMap.keySet()) {
                String keyString = key.toString();
                String metadataName = baseMetadataName + "|" + keyString;
                this.assignItemMetadata(customMetadata, metadataName, valueMap.get(key), updateMetadataProfile);
            }
        } else if (value instanceof List) {
            List valueList = (List)value;
            HashMap valueMap = new HashMap();
            int i = 1;
            for (Object item : valueList) {
                valueMap.put(i, item);
                ++i;
            }
            this.assignItemMetadata(customMetadata, baseMetadataName, valueMap, updateMetadataProfile);
        } else {
            DateTime dateTime2;
            if (updateMetadataProfile && this.metadataNames.add(baseMetadataName)) {
                this.createOrUpdateMetadataProfile();
            }
            try {
                dateTime2 = DateTime.parse((String)value.toString(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
                if (dateTime2.getYear() > 1900 && dateTime2.getYear() < 2100) {
                    customMetadata.putDate(baseMetadataName, (Object)dateTime2);
                    return;
                }
            }
            catch (Exception dateTime2) {
                // empty catch block
            }
            try {
                dateTime2 = DateTime.parse((String)value.toString());
                if (dateTime2.getYear() > 1900 && dateTime2.getYear() < 2100) {
                    customMetadata.putDate(baseMetadataName, (Object)dateTime2);
                    return;
                }
                return;
            }
            catch (Exception exception) {
                customMetadata.put((Object)baseMetadataName, (Object)Objects.requireNonNullElse(value, ""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearItemGenAiMetadata(Item item, String name) {
        String effectiveName = GenAiHelper.getNormalizedMetadataName(name);
        ItemCustomMetadataMap customMetadata = item.getCustomMetadata();
        HashSet<String> removeKeys = new HashSet<String>();
        for (String key : customMetadata.keySet()) {
            if (!key.equals(effectiveName) && !key.startsWith(effectiveName + "|")) continue;
            removeKeys.add(key);
        }
        if (!removeKeys.isEmpty()) {
            Item item2 = item;
            synchronized (item2) {
                for (String key : removeKeys) {
                    customMetadata.remove((Object)key);
                }
            }
        }
    }

    public int getMaxRetries() {
        if (this.genAiService.getMaxRetries() != null) {
            return this.genAiService.getMaxRetries();
        }
        return 3;
    }

    public GenAiService getGenAiService() {
        return this.genAiService;
    }

    public static String evalItemParameters(Item item, String documentPromptText) throws GenAiException {
        if (documentPromptText.contains(DOC_ID_PARAMETER)) {
            String docId = "";
            Set productionSetItems = item.getProductionSetItems();
            if (!productionSetItems.isEmpty()) {
                Iterator iterator = productionSetItems.iterator();
                if (iterator.hasNext()) {
                    ProductionSetItem productionSetItem = (ProductionSetItem)iterator.next();
                    docId = productionSetItem.getDocumentNumber().toString();
                }
            } else {
                throw new GenAiException("Item does not have a Doc ID");
            }
            documentPromptText = documentPromptText.replace(DOC_ID_PARAMETER, docId);
        }
        if (documentPromptText.contains(ITEM_GUID_PARAMETER)) {
            documentPromptText = documentPromptText.replace(ITEM_GUID_PARAMETER, item.getGuid());
        }
        if (documentPromptText.contains(ITEM_NAME_PARAMETER)) {
            documentPromptText = documentPromptText.replace(ITEM_NAME_PARAMETER, item.getName());
        }
        if (documentPromptText.contains(EMAIL_HEADER_PARAMETER)) {
            String emailHeaderContent = FormattingUtils.getEmailHeader((Item)item);
            documentPromptText = documentPromptText.replace(EMAIL_HEADER_PARAMETER, emailHeaderContent);
        }
        return documentPromptText;
    }
}

