/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi;

import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.StatusLogger;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.GenAiUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import com.nuix.automate.workflow.core.utils.genAi.GenAiModel;
import java.io.IOException;
import java.util.List;

public class GenAiServiceClient
implements AutoCloseable {
    protected static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenAiServiceClient.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    protected GenAiService genAiService;

    public GenAiServiceClient(GenAiService genAiService) {
        this.genAiService = genAiService;
    }

    public String test(GenAiUserCredential userCredential, StatusLogger statusLogger) throws IOException {
        GenAiService authenticatedService = this.genAiService.clone();
        authenticatedService.setUserCredential((ThirdPartyUserCredential)userCredential);
        GenAiHelper genAiHelper = new GenAiHelper(authenticatedService);
        String response = genAiHelper.test();
        statusLogger.addLog(this.iu.getFormattedString("GenAi.Log.NamePromptTest", (Object)response));
        List<GenAiModel> genAiModels = genAiHelper.getAvailableModels();
        if (genAiModels != null && !genAiModels.isEmpty()) {
            StringBuilder modelList = new StringBuilder();
            for (GenAiModel model : genAiModels) {
                if (modelList.length() > 0) {
                    modelList.append(", ");
                }
                modelList.append(model.getId());
                if (model.getName() == null || model.getId().equals(model.getName())) continue;
                modelList.append(" (").append(model.getName()).append(")");
            }
            statusLogger.addLog(this.iu.getFormattedString("GenAi.Log.ModelsAvailable", (Object)modelList.toString()));
        }
        return genAiHelper.getPrintableLimits();
    }

    public int detectContextWindow(GenAiUserCredential userCredential, StatusLogger statusLogger) {
        GenAiService authenticatedService = this.genAiService.clone();
        authenticatedService.setUserCredential((ThirdPartyUserCredential)userCredential);
        GenAiHelper genAiHelper = new GenAiHelper(authenticatedService);
        return genAiHelper.detectContextWindow(statusLogger);
    }

    @Override
    public void close() {
    }
}

