/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi.bedrock;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AmazonRequestSignatureV4Utils {
    public static Map<String, String> calculateAuthorizationHeaders(String method, String host, String path, String query, Map<String, String> headerMap, byte[] body, String isoDateTime, String awsAccessKeyId, String awsSecretAccessKey, String awsRegion, String awsService) throws GeneralSecurityException {
        if (body == null) {
            body = new byte[]{};
        }
        String bodySha256 = AmazonRequestSignatureV4Utils.hex(AmazonRequestSignatureV4Utils.sha256(body));
        String isoJustDate = isoDateTime.substring(0, 8);
        LinkedHashMap<String, String> resultHeaderMap = new LinkedHashMap<String, String>();
        StringBuilder canonicalRequestSb = new StringBuilder();
        AmazonRequestSignatureV4Utils.appendOptionalString(canonicalRequestSb, method);
        AmazonRequestSignatureV4Utils.appendOptionalString(canonicalRequestSb, path);
        AmazonRequestSignatureV4Utils.appendOptionalString(canonicalRequestSb, query);
        String HOST_HEADER = "Host";
        String AMAZON_DATE_HEADER = "X-Amz-Date";
        String AMAZON_CONTENT_HASH_HEADER = "X-Amz-Content-Sha256";
        ArrayList<String> headerList = new ArrayList<String>(headerMap.keySet());
        headerList.add("Host");
        headerList.add("X-Amz-Content-Sha256");
        headerList.add("X-Amz-Date");
        Collections.sort(headerList, String.CASE_INSENSITIVE_ORDER);
        StringBuilder hashedHeadersSb = new StringBuilder();
        for (String header : headerList) {
            String value = headerMap.get(header);
            if (header.equals("Host")) {
                value = host;
            } else if (header.equals("X-Amz-Content-Sha256")) {
                value = bodySha256;
            } else if (header.equals("X-Amz-Date")) {
                value = isoDateTime;
            }
            resultHeaderMap.put(header, value);
            String headerLower = header.toLowerCase();
            if (hashedHeadersSb.length() > 0) {
                hashedHeadersSb.append(';');
            }
            hashedHeadersSb.append(headerLower);
            String cannonicalValue = headerLower + ":" + AmazonRequestSignatureV4Utils.normalizeSpaces(value);
            AmazonRequestSignatureV4Utils.appendOptionalString(canonicalRequestSb, cannonicalValue);
        }
        canonicalRequestSb.append('\n');
        String signedHeaders = hashedHeadersSb.toString();
        AmazonRequestSignatureV4Utils.appendOptionalString(canonicalRequestSb, signedHeaders);
        AmazonRequestSignatureV4Utils.appendOptionalString(canonicalRequestSb, bodySha256);
        canonicalRequestSb.setLength(canonicalRequestSb.length() - 1);
        String canonicalRequestBody = canonicalRequestSb.toString();
        String canonicalRequestHash = AmazonRequestSignatureV4Utils.hex(AmazonRequestSignatureV4Utils.sha256(canonicalRequestBody.getBytes(StandardCharsets.UTF_8)));
        String AWS_ENCRYPTION_ALGORITHM = "AWS4-HMAC-SHA256";
        StringBuilder stringToSignSb = new StringBuilder();
        stringToSignSb.append("AWS4-HMAC-SHA256").append('\n');
        stringToSignSb.append(isoDateTime).append('\n');
        String requestType = "aws4_request";
        String credentialScope = isoJustDate + "/" + awsRegion + "/" + awsService + "/" + requestType;
        stringToSignSb.append(credentialScope).append('\n');
        stringToSignSb.append(canonicalRequestHash);
        String stringToSign = stringToSignSb.toString();
        byte[] keySecret = ("AWS4" + awsSecretAccessKey).getBytes(StandardCharsets.UTF_8);
        byte[] keyDate = AmazonRequestSignatureV4Utils.hmac(keySecret, isoJustDate);
        byte[] keyRegion = AmazonRequestSignatureV4Utils.hmac(keyDate, awsRegion);
        byte[] keyService = AmazonRequestSignatureV4Utils.hmac(keyRegion, awsService);
        byte[] keySigning = AmazonRequestSignatureV4Utils.hmac(keyService, requestType);
        String signature = AmazonRequestSignatureV4Utils.hex(AmazonRequestSignatureV4Utils.hmac(keySigning, stringToSign));
        String authParameter = "AWS4-HMAC-SHA256 Credential=" + awsAccessKeyId + "/" + credentialScope + ",SignedHeaders=" + signedHeaders + ",Signature=" + signature;
        resultHeaderMap.put("Authorization", authParameter);
        return resultHeaderMap;
    }

    private static void appendOptionalString(StringBuilder sb, String str) {
        if (str != null) {
            sb.append(str);
        }
        sb.append('\n');
    }

    private static String normalizeSpaces(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        boolean prevSpace = false;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (sb.length() == 0) continue;
                prevSpace = true;
                continue;
            }
            if (prevSpace) {
                sb.append(' ');
                prevSpace = false;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String hex(byte[] bytes) {
        String HEX_CHARACTERS = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            int val = bytes[i] & 0xFF;
            sb.append("0123456789abcdef".charAt(val >>> 4));
            sb.append("0123456789abcdef".charAt(val & 0xF));
        }
        return sb.toString();
    }

    private static byte[] sha256(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(bytes);
        return digest.digest();
    }

    private static byte[] hmac(byte[] key, String input) throws GeneralSecurityException {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(key, "HmacSHA256"));
        return mac.doFinal(input.getBytes(StandardCharsets.UTF_8));
    }
}

