/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi.bedrock;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.GenAiUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.workflow.core.execution.options.callapi.Verb;
import com.nuix.automate.workflow.core.execution.script.GenericRestClient;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.AmazonRequestSignatureV4Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class BedrockRestClient
extends GenericRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BedrockRestClient.class);
    private GenAiService genAiService;

    public BedrockRestClient(GenAiService genAiService) {
        super("BedrockRestClient-" + genAiService.getId());
        this.genAiService = genAiService;
        this.initAuth();
    }

    private void initAuth() {
        if (this.genAiService.getAuthenticationRequired()) {
            GenAiUserCredential credential = (GenAiUserCredential)this.genAiService.getUserCredential();
            switch (this.genAiService.getAuthenticationMethod()) {
                case API_KEY: 
                case BEARER_TOKEN: {
                    this.setBearerToken(credential.getToken());
                    break;
                }
                case CUSTOM_HEADER: {
                    for (Map.Entry entry : credential.getProperties().entrySet()) {
                        this.setHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                    break;
                }
                case USERNAME_PASSWORD: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported authentication method: " + String.valueOf(this.genAiService.getAuthenticationMethod()));
                }
            }
        }
    }

    @Override
    protected Map<String, String> getHeaders(Verb verb, String url, Object body) {
        URI uri;
        Map<String, String> headerMap = super.getHeaders(verb, url, body);
        try {
            uri = new URI(url.trim());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL: " + url);
        }
        String host = uri.getHost();
        String path = uri.getPath().replace(":", "%3A");
        String query = uri.getQuery();
        String awsRegion = host.split("\\.")[1];
        String awsService = "bedrock";
        String bodyString = body instanceof String ? (String)body : SerializationUtils.toJson((Object)body);
        if (this.genAiService.getAuthenticationRequired()) {
            GenAiUserCredential credential = (GenAiUserCredential)this.genAiService.getUserCredential();
            if (this.genAiService.getAuthenticationMethod() == ThirdPartyAuthenticationMethod.USERNAME_PASSWORD) {
                String isoDateTime = ISODateTimeFormat.basicDateTimeNoMillis().print((ReadableInstant)DateTime.now().withZone(DateTimeZone.UTC));
                try {
                    return AmazonRequestSignatureV4Utils.calculateAuthorizationHeaders(verb.name(), host, path, query, headerMap, bodyString.getBytes(StandardCharsets.UTF_8), isoDateTime, credential.getUsername(), credential.getPassword(), awsRegion, awsService);
                }
                catch (GeneralSecurityException e) {
                    throw new IllegalStateException("Failed to calculate authorization headers", e);
                }
            }
        }
        return headerMap;
    }
}

