/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi.bedrock.anthropic;

import com.google.gson.JsonSyntaxException;
import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiModel;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.genAi.GenAiUsage;
import com.nuix.automate.workflow.core.utils.genAi.InvalidModelGenAiException;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.BedrockClient;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.anthropic.AnthropicRequest;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.anthropic.AnthropicResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class AnthropicClient
extends BedrockClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AnthropicClient.class);

    public AnthropicClient(GenAiService genAiService) {
        super(genAiService);
    }

    @Override
    public List<GenAiModel> getAvailableModels() {
        return this.getAvailableModels("anthropic");
    }

    @Override
    protected GenAiResponse getResponseInternal(GenAiRequest request) throws IOException {
        AnthropicRequest anthropicRequest = new AnthropicRequest(request);
        if (anthropicRequest.getMaxTokens() == null) {
            anthropicRequest.setMaxTokens(128000);
        }
        if (this.genAiService.getCustomParameters() != null) {
            for (Map.Entry entry : this.genAiService.getCustomParameters().entrySet()) {
                Object optionValue;
                try {
                    optionValue = SerializationUtils.fromJson((String)((String)entry.getValue()));
                }
                catch (JsonSyntaxException e) {
                    optionValue = entry.getValue();
                }
                anthropicRequest.setOption((String)entry.getKey(), optionValue);
            }
        }
        if (request.getOptions() != null) {
            request.getOptions().forEach(anthropicRequest::setOption);
        }
        String endpoint = "/model/" + this.genAiService.getModel() + "/invoke";
        Response response = this.restClient.post(endpoint, anthropicRequest);
        this.raiseForStatus(response);
        AnthropicResponse anthropicResponse = (AnthropicResponse)response.getObject(AnthropicResponse.class);
        if (anthropicResponse.getId() == null) {
            try {
                Map errorResponse = (Map)SerializationUtils.fromJson((String)response.text);
                if (errorResponse.containsKey("message")) {
                    String message = String.valueOf(errorResponse.get("message"));
                    if (response.status_code == 400 && message.contains("model identifier is invalid")) {
                        throw new InvalidModelGenAiException(message);
                    }
                    throw new GenAiException(message);
                }
            }
            catch (GenAiException e) {
                throw e;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new GenAiException("Cannot invoke model.\n" + response.text);
        }
        GenAiResponse genAiResponse = new GenAiResponse();
        genAiResponse.setCreatedAt(DateTime.now().getMillis());
        genAiResponse.setModel(anthropicResponse.getModel());
        GenAiMessage genAiMessage = new GenAiMessage(anthropicResponse.getRole(), anthropicResponse.getContent().get(0).getText());
        genAiResponse.setMessage(genAiMessage);
        GenAiUsage genAiUsage = new GenAiUsage();
        genAiUsage.setCompletionTokens(anthropicResponse.getUsage().getOutputTokens());
        genAiUsage.setPromptTokens(anthropicResponse.getUsage().getInputTokens());
        genAiResponse.setUsage(genAiUsage);
        return genAiResponse;
    }
}

