/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi.bedrock.converse;

import com.nuix.automate.utils.general.MimeTypeUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.converse.ConverseContentBlock;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.converse.ConverseImage;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.converse.ConverseImageSource;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.converse.ConverseMessage;
import com.nuix.automate.workflow.core.utils.genAi.openAi.DataElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConverseRequest {
    private List<ConverseContentBlock> system;
    private List<ConverseMessage> messages;
    private Map<String, Object> inferenceConfig = new HashMap<String, Object>();
    private Map<String, Object> toolConfig;

    public ConverseRequest(GenAiRequest genAiRequest) throws GenAiException {
        this.messages = new ArrayList<ConverseMessage>();
        for (GenAiMessage genAiMessage : genAiRequest.getMessages()) {
            Integer maxTokens;
            Double temperature;
            if (genAiRequest.getJsonSchema() != null && !genAiRequest.getJsonSchema().isEmpty()) {
                this.toolConfig = new HashMap<String, Object>();
                ArrayList tools = new ArrayList();
                this.toolConfig.put("tools", tools);
                HashMap tool = new HashMap();
                tools.add(tool);
                HashMap<String, Object> toolSpec = new HashMap<String, Object>();
                tool.put("toolSpec", toolSpec);
                toolSpec.put("name", "formatter");
                toolSpec.put("description", "Formats the response to JSON");
                HashMap<String, Object> inputSchema = new HashMap<String, Object>();
                inputSchema.put("json", SerializationUtils.fromJson((String)genAiRequest.getJsonSchema()));
                toolSpec.put("inputSchema", inputSchema);
            }
            if ((temperature = genAiRequest.getTemperature()) != null) {
                this.setTemperature(temperature);
            }
            if ((maxTokens = genAiRequest.getMaxResponseTokens()) != null) {
                this.setMaxTokens(maxTokens);
            }
            ConverseMessage converseMessage = new ConverseMessage();
            converseMessage.setRole(genAiMessage.getRole());
            ArrayList<ConverseContentBlock> content = new ArrayList<ConverseContentBlock>();
            if (genAiMessage.getContent() != null && !genAiMessage.getContent().isEmpty()) {
                ConverseContentBlock textContentElement = new ConverseContentBlock(genAiMessage.getContent());
                if (genAiMessage.getRole().equals("system")) {
                    if (this.system == null) {
                        this.system = new ArrayList<ConverseContentBlock>();
                    }
                    this.system.add(textContentElement);
                } else {
                    content.add(textContentElement);
                }
            }
            if (genAiMessage.getImages() != null && !genAiMessage.getImages().isEmpty()) {
                for (DataElement dataElement : genAiMessage.getImages()) {
                    ConverseImageSource imageSource = new ConverseImageSource(dataElement.getData());
                    String extension = MimeTypeUtils.getInstance().getDefaultExtension(dataElement.getMediaType());
                    ConverseImage image = new ConverseImage(extension, imageSource);
                    ConverseContentBlock imageContentElement = new ConverseContentBlock(image);
                    content.add(imageContentElement);
                }
            }
            if (content.isEmpty()) continue;
            converseMessage.setContent(content);
            this.messages.add(converseMessage);
        }
    }

    public void setMaxTokens(int maxTokens) {
        if (this.inferenceConfig == null) {
            this.inferenceConfig = new HashMap<String, Object>();
        }
        this.inferenceConfig.put("maxTokens", maxTokens);
    }

    public void setTemperature(double temperature) {
        if (this.inferenceConfig == null) {
            this.inferenceConfig = new HashMap<String, Object>();
        }
        this.inferenceConfig.put("temperature", temperature);
    }

    public void setOption(String key, Object optionValue) {
        if (this.inferenceConfig == null) {
            this.inferenceConfig = new HashMap<String, Object>();
        }
        if (key.equals("max_tokens")) {
            key = "maxTokens";
        }
        this.inferenceConfig.put(key, optionValue);
    }

    public List<ConverseContentBlock> getSystem() {
        return this.system;
    }

    public List<ConverseMessage> getMessages() {
        return this.messages;
    }

    public Map<String, Object> getInferenceConfig() {
        return this.inferenceConfig;
    }

    public Map<String, Object> getToolConfig() {
        return this.toolConfig;
    }

    public void setSystem(List<ConverseContentBlock> system) {
        this.system = system;
    }

    public void setMessages(List<ConverseMessage> messages) {
        this.messages = messages;
    }

    public void setInferenceConfig(Map<String, Object> inferenceConfig) {
        this.inferenceConfig = inferenceConfig;
    }

    public void setToolConfig(Map<String, Object> toolConfig) {
        this.toolConfig = toolConfig;
    }
}

