/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi.openAi;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsJsonSchemaResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsJsonSchemaResponseFormatJsonSchema;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatCompletionsResponseFormat;
import com.azure.ai.openai.models.ChatMessageImageContentItem;
import com.azure.ai.openai.models.ChatMessageImageUrl;
import com.azure.ai.openai.models.ChatMessageTextContentItem;
import com.azure.ai.openai.models.ChatRequestAssistantMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.core.credential.KeyCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.HttpClientOptions;
import com.google.gson.JsonSyntaxException;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.azure.AzureNoRetryPolicy;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.TimeUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.GenAiUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.workflow.core.utils.genAi.GenAiClient;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiModel;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.genAi.GenAiUsage;
import com.nuix.automate.workflow.core.utils.genAi.RetryableGenAiException;
import com.nuix.automate.workflow.core.utils.genAi.openAi.DataElement;
import com.nuix.automate.workflow.core.utils.genAi.openAi.OpenAiRestClient;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class OpenAiClient
extends GenAiClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OpenAiClient.class);
    private OpenAIClient client = this.buildOpenAiClient();
    private boolean stopRequested;
    private transient Long requestsTotal = 0L;
    private transient AtomicLong requestsRemaining;
    private transient Long requestsResetMs = 0L;
    private transient Long tokensTotal = 0L;
    private transient AtomicLong tokensRemaining;
    private transient Long tokensResetMs = 0L;
    private AtomicBoolean requestsLimitError = new AtomicBoolean(false);
    private AtomicBoolean tokensLimitError = new AtomicBoolean(false);
    private static final long BACKOFF_START_MS = 5L;
    private static final double BACKOFF_EXPONENT = 4.0;
    private static final int BACKOFF_MAX_MS = 60000;
    private Map<String, Object> requestOptions;
    private OpenAiRestClient restClient;
    private String chatCompletionsUrl;

    public OpenAiClient(GenAiService genAiService) {
        super(genAiService);
        this.requestsRemaining = new AtomicLong(0L);
        this.tokensRemaining = new AtomicLong(0L);
        this.restClient = new OpenAiRestClient("OpenAiRestClient-" + genAiService.getId());
        if (genAiService.getWhitelistedCertFingerprints() != null && !genAiService.getWhitelistedCertFingerprints().isEmpty()) {
            this.restClient.setFingerprints(genAiService.getWhitelistedCertFingerprints());
        }
        this.chatCompletionsUrl = genAiService.getUrl();
        if (this.chatCompletionsUrl.endsWith("/v1")) {
            this.chatCompletionsUrl = this.chatCompletionsUrl.replace("/v1", "/v1/chat/completions");
        }
        this.restClient.setBaseUrl(this.chatCompletionsUrl);
        if (genAiService.getAuthenticationRequired()) {
            GenAiUserCredential credential = (GenAiUserCredential)genAiService.getUserCredential();
            switch (genAiService.getAuthenticationMethod()) {
                case API_KEY: 
                case BEARER_TOKEN: {
                    this.restClient.setBearerToken(credential.getToken());
                    break;
                }
                case CUSTOM_HEADER: {
                    for (Map.Entry entry : credential.getProperties().entrySet()) {
                        this.restClient.setHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                    break;
                }
            }
        }
    }

    @Override
    public List<GenAiModel> getAvailableModels() {
        ArrayList<GenAiModel> validModels = new ArrayList<GenAiModel>();
        try {
            List modelsData;
            String getModelsUrl = this.chatCompletionsUrl.replace("/chat/completions", "/models");
            this.restClient.setBaseUrl(getModelsUrl);
            com.nuix.automate.utils.api.script.Response response = this.restClient.get(null);
            this.raiseForStatus(response);
            try {
                Map models = (Map)response.getObject(Map.class);
                modelsData = (List)models.get("data");
            }
            catch (JsonSyntaxException e) {
                modelsData = (List)response.getObject(List.class);
            }
            for (Object modelData : modelsData) {
                Map modelDataMap = (Map)modelData;
                String id = (String)modelDataMap.get("id");
                String name = modelDataMap.containsKey("name") ? (String)modelDataMap.get("name") : id;
                validModels.add(new GenAiModel(id, name));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get models", (Throwable)e);
        }
        this.restClient.setBaseUrl(this.chatCompletionsUrl);
        return validModels;
    }

    private void parseHeaders(HttpHeaders headers) {
        Long tokensResetMs;
        Long tokensRemaining;
        Long tokensTotal;
        Long requestsResetMs;
        Long requestsRemaining;
        Long requestsTotal = this.getHeaderLongValue(headers, "x-ratelimit-limit-requests");
        if (requestsTotal != null) {
            this.requestsTotal = requestsTotal;
        }
        if ((requestsRemaining = this.getHeaderLongValue(headers, "x-ratelimit-remaining-requests")) != null) {
            this.requestsRemaining.set(requestsRemaining);
        }
        if ((requestsResetMs = this.getHeaderDurationValue(headers, "x-ratelimit-reset-requests")) != null) {
            this.requestsResetMs = requestsResetMs;
        }
        if ((tokensTotal = this.getHeaderLongValue(headers, "x-ratelimit-limit-tokens")) != null) {
            this.tokensTotal = tokensTotal;
        }
        if ((tokensRemaining = this.getHeaderLongValue(headers, "x-ratelimit-remaining-tokens")) != null) {
            this.tokensRemaining.set(tokensRemaining);
        }
        if ((tokensResetMs = this.getHeaderDurationValue(headers, "x-ratelimit-reset-tokens")) != null) {
            this.tokensResetMs = tokensResetMs;
        }
    }

    private Long getHeaderLongValue(HttpHeaders headers, String name) {
        String value = headers.getValue(HttpHeaderName.fromString((String)name));
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                LOGGER.error("Cannot parse header " + name + " value " + value, (Throwable)e);
            }
        }
        return null;
    }

    private Long getHeaderDurationValue(HttpHeaders headers, String name) {
        String value = headers.getValue(HttpHeaderName.fromString((String)name));
        if (value != null) {
            try {
                return TimeUtils.parsePeriodMs((String)value);
            }
            catch (Exception e) {
                LOGGER.error("Cannot parse header " + name + " value " + value, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected GenAiResponse getResponseInternal(GenAiRequest request) throws IOException {
        this.requestOptions = request.getOptions();
        ArrayList<ChatRequestSystemMessage> chatRequestMessages = new ArrayList<ChatRequestSystemMessage>();
        for (GenAiMessage message : request.getMessages()) {
            ChatRequestSystemMessage chatRequestMessage;
            String role;
            switch (role = message.getRole()) {
                case "system": {
                    chatRequestMessage = new ChatRequestSystemMessage(message.getContent());
                    break;
                }
                case "user": {
                    if (message.getImages() != null && !message.getImages().isEmpty()) {
                        ArrayList<Object> contentItems = new ArrayList<Object>();
                        if (message.getContent() != null && !message.getContent().isEmpty()) {
                            contentItems.add(new ChatMessageTextContentItem(message.getContent()));
                        }
                        for (DataElement dataElement : message.getImages()) {
                            contentItems.add(new ChatMessageImageContentItem(new ChatMessageImageUrl("data:" + dataElement.getMediaType() + ";base64," + dataElement.getData())));
                        }
                        chatRequestMessage = new ChatRequestUserMessage(contentItems);
                        break;
                    }
                    chatRequestMessage = new ChatRequestUserMessage(message.getContent());
                    break;
                }
                case "assistant": {
                    chatRequestMessage = new ChatRequestAssistantMessage(message.getContent());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid role " + role);
                }
            }
            chatRequestMessages.add(chatRequestMessage);
        }
        ChatCompletionsOptions chatCompletionsOptions = new ChatCompletionsOptions(chatRequestMessages);
        if (request.getJsonSchema() != null && !request.getJsonSchema().isEmpty()) {
            ChatCompletionsJsonSchemaResponseFormatJsonSchema chatCompletionsJsonSchemaResponseFormatJsonSchema = new ChatCompletionsJsonSchemaResponseFormatJsonSchema("request-schema");
            chatCompletionsJsonSchemaResponseFormatJsonSchema.setSchema(BinaryData.fromString((String)request.getJsonSchema()));
            ChatCompletionsJsonSchemaResponseFormat chatCompletionsJsonSchemaResponseFormat = new ChatCompletionsJsonSchemaResponseFormat(chatCompletionsJsonSchemaResponseFormatJsonSchema);
            chatCompletionsOptions.setResponseFormat((ChatCompletionsResponseFormat)chatCompletionsJsonSchemaResponseFormat);
        }
        try {
            List choices;
            Response chatCompletionsResponse = this.client.getChatCompletionsWithResponse(this.genAiService.getModel(), chatCompletionsOptions, new RequestOptions());
            ChatCompletions chatCompletions = (ChatCompletions)chatCompletionsResponse.getValue();
            HttpHeaders headers = chatCompletionsResponse.getHeaders();
            this.parseHeaders(headers);
            if (chatCompletions.getUsage() != null) {
                this.requestsLimitError.set(false);
                this.tokensLimitError.set(false);
            }
            if ((choices = chatCompletions.getChoices()) == null || choices.isEmpty()) {
                throw new GenAiException("No choices returned");
            }
            ChatChoice choice = (ChatChoice)choices.get(0);
            GenAiResponse genAiResponse = new GenAiResponse();
            GenAiMessage genAiMessage = new GenAiMessage(choice.getMessage().getRole().toString(), choice.getMessage().getContent());
            genAiResponse.setMessage(genAiMessage);
            genAiResponse.setCreatedAt(chatCompletions.getCreatedAt().toEpochSecond() * 1000L);
            GenAiUsage genAiUsage = new GenAiUsage();
            genAiUsage.setPromptTokens(chatCompletions.getUsage().getPromptTokens());
            genAiUsage.setCompletionTokens(chatCompletions.getUsage().getCompletionTokens());
            genAiResponse.setUsage(genAiUsage);
            return genAiResponse;
        }
        catch (HttpResponseException e) {
            String errorCode = null;
            String errorMessage = null;
            String errorType = null;
            try {
                Map responseMap = (Map)e.getValue();
                Map error = (Map)responseMap.get("error");
                errorCode = (String)error.get("code");
                errorMessage = (String)error.get("message");
                errorType = (String)error.get("type");
            }
            catch (Exception ex) {
                LOGGER.debug("Cannot parse OpenAI API error response body", (Throwable)ex);
                try {
                    Map responseMap = (Map)e.getValue();
                    errorCode = String.valueOf(responseMap.get("code"));
                    errorMessage = (String)responseMap.get("message");
                    errorType = (String)responseMap.get("type");
                }
                catch (Exception ex2) {
                    LOGGER.debug("Cannot parse vLLM error response body", (Throwable)ex2);
                }
            }
            if (e.getResponse() != null) {
                this.parseHeaders(e.getResponse().getHeaders());
            }
            if (errorCode != null && errorCode.equals("rate_limit_exceeded")) {
                if (errorType != null && errorType.equals("tokens")) {
                    if (this.tokensResetMs != null && this.tokensResetMs > 0L) {
                        this.tokensLimitError.set(true);
                        throw new RetryableGenAiException("Tokens rate limit exceeded", this.tokensResetMs);
                    }
                } else if (errorType != null && errorType.equals("requests") && this.requestsResetMs != null && this.requestsResetMs > 0L) {
                    this.requestsLimitError.set(true);
                    throw new RetryableGenAiException("Requests rate limit exceeded", this.requestsResetMs);
                }
                LOGGER.warn("Request " + request.getId() + " received an unexpected rate limit");
                throw new RetryableGenAiException("Unknown rate limit exceeded", 1000L, e);
            }
            if (e.getResponse() != null && (e.getResponse().getStatusCode() == 429 || e.getResponse().getStatusCode() == 502 || e.getResponse().getStatusCode() == 503 || e.getResponse().getStatusCode() == 504)) {
                if (e.getResponse().getHeaders().getValue("Retry-After") != null) {
                    String retryAfter = e.getResponse().getHeaders().getValue("Retry-After");
                    try {
                        long msToWait = Math.max(1000L, Long.parseLong(retryAfter) * 1000L);
                        throw new RetryableGenAiException("Generic error HTTP/" + e.getResponse().getStatusCode(), msToWait);
                    }
                    catch (NumberFormatException ex) {
                        LOGGER.warn("Cannot parse Retry-After header value " + retryAfter, (Throwable)ex);
                    }
                }
                throw new RetryableGenAiException("Generic error HTTP/" + e.getResponse().getStatusCode());
            }
            if (e.getResponse() != null) {
                if (errorMessage != null) {
                    LOGGER.warn("Request " + request.getId() + " received error " + errorMessage, (Throwable)e);
                    throw new GenAiException(errorMessage);
                }
                LOGGER.warn("Request " + request.getId() + " received error status " + e.getResponse().getStatusCode());
                throw new GenAiException("HTTP/" + e.getResponse().getStatusCode(), e);
            }
            LOGGER.warn("Request " + request.getId() + " received unexpected error", (Throwable)e);
            throw new GenAiException(e);
        }
    }

    private OpenAIClient buildOpenAiClient() {
        OpenAIClientBuilder clientBuilder = new OpenAIClientBuilder();
        if (this.genAiService.getAuthenticationRequired()) {
            String token;
            GenAiUserCredential credential = (GenAiUserCredential)this.genAiService.getUserCredential();
            if (ThirdPartyAuthenticationMethod.API_KEY.equals((Object)this.genAiService.getAuthenticationMethod()) && (token = credential.getToken()) != null && !token.trim().isEmpty()) {
                clientBuilder.credential(new KeyCredential(token));
            }
        }
        clientBuilder.endpoint(this.genAiService.getUrl());
        NetworkConfiguration networkConfiguration = NetworkConfiguration.fromSystemProperties();
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        if (networkConfiguration.isProxyConfigured()) {
            InetSocketAddress proxyAddress = new InetSocketAddress(networkConfiguration.getProxyHost(), (int)networkConfiguration.getProxyPort());
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, proxyAddress);
            if (networkConfiguration.getNonProxyHosts() != null && !networkConfiguration.getNonProxyHosts().isEmpty()) {
                proxyOptions.setNonProxyHosts(networkConfiguration.getNonProxyHostsAsString());
            }
            httpClientOptions.setProxyOptions(proxyOptions);
            clientBuilder.clientOptions((ClientOptions)httpClientOptions);
        }
        httpClientOptions.setReadTimeout(Duration.ofSeconds(this.getTimeoutS()));
        httpClientOptions.setResponseTimeout(Duration.ofSeconds(this.getTimeoutS()));
        httpClientOptions.setWriteTimeout(Duration.ofSeconds(this.getTimeoutS()));
        httpClientOptions.setConnectionIdleTimeout(Duration.ofSeconds(this.getTimeoutS()));
        clientBuilder.retryPolicy((RetryPolicy)new AzureNoRetryPolicy());
        HttpClient httpClient = HttpClient.createDefault((HttpClientOptions)httpClientOptions);
        clientBuilder.httpClient(httpRequest -> {
            Map headers;
            if (ThirdPartyAuthenticationMethod.BEARER_TOKEN.equals((Object)this.genAiService.getAuthenticationMethod())) {
                String token = this.genAiUserCredential.getToken();
                if (token != null && !token.trim().isEmpty()) {
                    httpRequest.getHeaders().add(HttpHeaderName.AUTHORIZATION, "Bearer " + token);
                }
            } else if (ThirdPartyAuthenticationMethod.CUSTOM_HEADER.equals((Object)this.genAiService.getAuthenticationMethod()) && (headers = this.genAiUserCredential.getProperties()) != null) {
                for (Map.Entry entry : headers.entrySet()) {
                    httpRequest.getHeaders().add((String)entry.getKey(), (String)entry.getValue());
                }
            }
            String bodyString = httpRequest.getBodyAsBinaryData().toString();
            Map bodyJson = (Map)SerializationUtils.fromJson((String)bodyString);
            bodyJson.put("model", this.genAiService.getModel());
            if (this.genAiService.getCustomParameters() != null) {
                for (Map.Entry entry : this.genAiService.getCustomParameters().entrySet()) {
                    if (bodyJson.containsKey(entry.getKey())) continue;
                    try {
                        bodyJson.put((String)entry.getKey(), SerializationUtils.fromJson((String)((String)entry.getValue())));
                    }
                    catch (JsonSyntaxException e) {
                        bodyJson.put((String)entry.getKey(), entry.getValue());
                    }
                }
            }
            if (this.requestOptions != null) {
                if (this.requestOptions.containsKey("max_tokens")) {
                    this.requestOptions.put("max_completion_tokens", this.requestOptions.get("max_tokens"));
                    this.requestOptions.remove("max_tokens");
                }
                bodyJson.putAll(this.requestOptions);
            }
            String string = SerializationUtils.toJson((Object)bodyJson);
            httpRequest.setBody(string);
            try {
                void var6_12;
                String string2 = this.genAiService.getUrl();
                if (string2.endsWith("/v1")) {
                    String string3 = string2.replace("/v1", "/v1/chat/completions");
                }
                httpRequest.setUrl(new URL((String)var6_12));
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
            return httpClient.send(httpRequest);
        });
        return clientBuilder.buildClient();
    }
}

