/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurationParser {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigurationParser.class);
    Map<String, String> propertyNamesDictionary = new HashMap<String, String>();
    Map<String, String> namingStrategyDictionary;

    public ConfigurationParser() {
        this.propertyNamesDictionary.put("maxBinarySize", "maxStoredBinarySize");
        this.propertyNamesDictionary.put("stemmingEnabled", "stemming");
        this.propertyNamesDictionary.put("stopWordsEnabled", "stopWords");
        this.propertyNamesDictionary.put("calculateSsDeepFuzzyHash", "calculateSSDeepFuzzyHash");
        this.propertyNamesDictionary.put("faceDetection", "detectFaces");
        this.propertyNamesDictionary.put("addBccToEmailDigest", "addBccToEmailDigests");
        this.propertyNamesDictionary.put("addCommunicationDateToEmailDigest", "addCommunicationDateToEmailDigests");
        this.namingStrategyDictionary = new HashMap<String, String>();
        this.namingStrategyDictionary.put("DocumentId", "document_id");
        this.namingStrategyDictionary.put("DocumentIdWithPage", "document_id_with_page");
        this.namingStrategyDictionary.put("PageOnly", "page_only");
        this.namingStrategyDictionary.put("FullFile", "full");
        this.namingStrategyDictionary.put("FullFileWithPeriods", "full_with_periods");
        this.namingStrategyDictionary.put("Item", "item_name");
        this.namingStrategyDictionary.put("ItemWithPath", "item_name_with_path");
        this.namingStrategyDictionary.put("GUID", "guid");
        this.namingStrategyDictionary.put("MD5", "md5");
    }

    boolean isValueLong(String value) {
        try {
            long v = this.getLongValue(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    long getLongValue(String value) {
        int multiplier = 1;
        if (value.contains(" GB")) {
            value = value.replace(" GB", "");
            multiplier = 1000000000;
        } else if (value.contains(" MB")) {
            value = value.replace(" MB", "");
            multiplier = 1000000;
        } else if (value.contains(" KB")) {
            value = value.replace(" KB", "");
            multiplier = 1000;
        }
        return Long.parseLong(value) * (long)multiplier;
    }

    String settingKeyToName(String key) {
        StringBuilder name = new StringBuilder();
        boolean upperCase = false;
        for (char c : key.toCharArray()) {
            if (c == '-') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                name.append(String.valueOf(c).toUpperCase());
                upperCase = false;
                continue;
            }
            name.append(c);
        }
        if (this.propertyNamesDictionary.containsKey(name.toString())) {
            name = new StringBuilder(this.propertyNamesDictionary.get(name.toString()));
        }
        return name.toString();
    }

    public String getNamingStrategyFromType(String namingType) {
        if (this.namingStrategyDictionary.containsKey(namingType)) {
            return this.namingStrategyDictionary.get(namingType);
        }
        return "document_id";
    }

    public Map<String, Object> getParallelProcessingLegalExportSettings() {
        String settingsNode = "com/nuix/investigator/export/legal/parallelProcessingSettings64";
        return this.getParallelProcessingSettingsFromNodePath(settingsNode);
    }

    public Map<String, Object> getParallelProcessingSettings() {
        String settingsNode = "com/nuix/investigator/wizard/parallelProcessingSettings64";
        return this.getParallelProcessingSettingsFromNodePath(settingsNode);
    }

    Map<String, Object> getParallelProcessingSettingsFromNodePath(String settingsNodePath) {
        String workerBrokerAddress;
        long brokerMemory;
        String runLocalWorkers;
        String embedBroker;
        String workerTemp;
        String userDefinedTempDirectory;
        long workerMemory;
        LOGGER.info("Extracting parallel processing settings from node " + settingsNodePath);
        HashMap<String, Object> parallelProcessingSettings = new HashMap<String, Object>();
        Preferences parallelProcessingSettingsNode = Preferences.userRoot().node(settingsNodePath);
        int workerCount = Integer.parseInt(parallelProcessingSettingsNode.get("worker-count", "0"));
        if (workerCount > 0) {
            parallelProcessingSettings.put("workerCount", workerCount);
        }
        if ((workerMemory = Long.parseLong(parallelProcessingSettingsNode.get("worker-memory", "0"))) > 0L) {
            parallelProcessingSettings.put("workerMemory", workerMemory);
        }
        if ((userDefinedTempDirectory = parallelProcessingSettingsNode.get("user-defined-temp-directory", "")).length() > 0 && userDefinedTempDirectory.equals("true") && (workerTemp = parallelProcessingSettingsNode.get("worker-temp-directory", "")).length() > 0) {
            parallelProcessingSettings.put("workerTemp", workerTemp);
        }
        if ((embedBroker = parallelProcessingSettingsNode.get("embed-broker", "")).length() > 0) {
            parallelProcessingSettings.put("embedBroker", embedBroker.equals("true"));
        }
        if ((runLocalWorkers = parallelProcessingSettingsNode.get("run-local-workers", "")).length() > 0) {
            parallelProcessingSettings.put("runLocalWorkers", runLocalWorkers.equals("true"));
        }
        if ((brokerMemory = Long.parseLong(parallelProcessingSettingsNode.get("broker-memory", "0"))) > 0L) {
            parallelProcessingSettings.put("brokerMemory", brokerMemory);
        }
        if (!(workerBrokerAddress = parallelProcessingSettingsNode.get("worker-broker-address", "NUIX-NULL-VALUE")).equals("NUIX-NULL-VALUE")) {
            parallelProcessingSettings.put("workerBrokerAddress", workerBrokerAddress);
        }
        for (String key : parallelProcessingSettings.keySet()) {
            Object settingValue = parallelProcessingSettings.get(key);
            String settingType = settingValue != null ? settingValue.getClass().toString() : "n/a";
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("# Setting: " + key + "\tValue: " + String.valueOf(settingValue) + "\tType: " + settingType);
        }
        return parallelProcessingSettings;
    }

    public Map<String, Map<String, Object>> getMimeTypeSettings() {
        HashMap<String, Map<String, Object>> mimeTypeProperties = new HashMap<String, Map<String, Object>>();
        this.getMimeTypePropertiesFromNode("com/nuix/investigator/wizard/mime-type-settings", mimeTypeProperties);
        try {
            for (String configuratioNodeName : this.getWizardNuixVersions()) {
                this.getMimeTypePropertiesFromNode("com/nuix/investigator/wizard/" + configuratioNodeName + "/mime-type-settings", mimeTypeProperties);
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return mimeTypeProperties;
    }

    String decodeMimeTypeName(String mimeTypeName) {
        String originalMimeTypeName = mimeTypeName;
        String tempDashEncoding = "__AUTOMATE_DASH__";
        String decodedMimeTypeName = mimeTypeName.replace("#-45", tempDashEncoding).replace("#-46", ".").replace("#-32", " ").replace("#-47", "/").replace("#-35", "#").replace("-", "").replace(tempDashEncoding, "-");
        if (!originalMimeTypeName.equals(decodedMimeTypeName) && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Decoded " + originalMimeTypeName + " to " + decodedMimeTypeName);
        }
        return decodedMimeTypeName;
    }

    List<String> getWizardNuixVersions() {
        LOGGER.info("Searching for Nuix configuration file wizard versions");
        ArrayList<String> results = new ArrayList<String>();
        Preferences wizardNode = Preferences.userRoot().node("com/nuix/investigator/wizard");
        try {
            Pattern nuixVersionPattern = Pattern.compile("^\\d(\\.\\d+)*");
            for (String childName : wizardNode.childrenNames()) {
                LOGGER.info("Testing node " + childName);
                Matcher matcher = nuixVersionPattern.matcher(childName);
                if (!matcher.matches()) continue;
                LOGGER.info("Detected Nuix version " + childName);
                results.add(childName);
            }
        }
        catch (BackingStoreException e) {
            LOGGER.error("Error while listing Nuix versions.", (Throwable)e);
        }
        return results;
    }

    void getMimeTypePropertiesFromNode(String settingsNodePath, Map<String, Map<String, Object>> mimeTypeProperties) {
        LOGGER.info("Extracting MimeType settings from node " + settingsNodePath);
        Preferences mimeSettingsNode = Preferences.userRoot().node(settingsNodePath);
        try {
            for (String childName : mimeSettingsNode.childrenNames()) {
                Preferences settingsNode = Preferences.userRoot().node(settingsNodePath + "/" + childName);
                String mimeType = this.decodeMimeTypeName(childName);
                if (!mimeTypeProperties.containsKey(mimeType)) {
                    mimeTypeProperties.put(mimeType, new HashMap());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("# Properties for mime type " + mimeType + " observed for first time");
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("# Properties for mime type " + mimeType + " were previously defined");
                }
                Map<String, Object> properties = mimeTypeProperties.get(mimeType);
                for (String settingKey : settingsNode.keys()) {
                    String settingValue = settingsNode.get(settingKey, "");
                    String settingName = this.settingKeyToName(settingKey);
                    if (settingValue.equals("true")) {
                        properties.put(settingName, true);
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("## " + settingName + ": true");
                        continue;
                    }
                    if (settingValue.equals("false")) {
                        properties.put(settingName, false);
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("## " + settingName + ": false");
                        continue;
                    }
                    if (settingName.equals("textProcessingMode")) {
                        if (settingValue.equals("process_text")) {
                            properties.put("processText", true);
                            properties.remove("textStrip");
                            if (!LOGGER.isDebugEnabled()) continue;
                            LOGGER.debug("## processText: true");
                            continue;
                        }
                        if (settingValue.equals("strip_text")) {
                            properties.remove("processText");
                            properties.put("textStrip", true);
                            if (!LOGGER.isDebugEnabled()) continue;
                            LOGGER.debug("## textStrip: true");
                            continue;
                        }
                        if (settingValue.equals("skip_text")) {
                            properties.put("processText", false);
                            properties.remove("textStrip");
                            if (!LOGGER.isDebugEnabled()) continue;
                            LOGGER.debug("## processText: false");
                            continue;
                        }
                        LOGGER.warn("## Unexpected " + settingName + " value " + settingValue + ", skipping");
                        continue;
                    }
                    LOGGER.warn("## Unexpected setting name/value " + settingName + "/" + settingValue + ", skipping");
                }
            }
        }
        catch (BackingStoreException e) {
            LOGGER.error("Error while listing properties.", (Throwable)e);
        }
    }

    public Map<String, Object> getExportProductProperties(String legalExportType, String productName) {
        String namingStrategy;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String nodePath = "com/nuix/investigator/export/legal/" + legalExportType;
        LOGGER.info("Extracting " + productName + " legal export settings from node " + nodePath);
        Preferences node = Preferences.userRoot().node(nodePath);
        String suffix = node.get(productName + "FileNameSuffix", "");
        properties.put("suffix", suffix);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("# suffix: " + suffix);
        }
        String subFolder = node.get(productName + "SubFolder", productName.toUpperCase());
        properties.put("path", subFolder);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("# path: " + subFolder);
        }
        if (this.namingStrategyDictionary.containsKey(namingStrategy = node.get(productName + "FileNamingStrategy", "DocumentId"))) {
            namingStrategy = this.namingStrategyDictionary.get(namingStrategy);
        } else {
            LOGGER.warn("Unsupported naming strategy " + namingStrategy + ", defaulting to guid");
            namingStrategy = "guid";
        }
        properties.put("naming", namingStrategy);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("# naming: " + namingStrategy);
        }
        if (productName.equals("native")) {
            String separateEmailAttachments;
            String mailFormat = node.get("mailFormat", "NATIVE");
            properties.put("mailFormat", mailFormat.toLowerCase());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("# mailFormat: " + mailFormat.toLowerCase());
            }
            String includeAttachments = (separateEmailAttachments = node.get("separateEmailAttachments", "false")).equals("true") ? "false" : "true";
            properties.put("includeAttachments", includeAttachments);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("# includeAttachments: " + includeAttachments);
            }
        }
        return properties;
    }

    public Map<String, Object> getRingtailExportSettings() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String ringtailNodePath = "com/nuix/investigator/export/legal/Ringtail";
        LOGGER.info("Extracting Ringtail-specific legal export settings from node " + ringtailNodePath);
        Preferences ringtailNode = Preferences.userRoot().node(ringtailNodePath);
        try {
            for (String key : ringtailNode.keys()) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("# Ringtail key: " + key);
            }
        }
        catch (BackingStoreException e) {
            LOGGER.error("Unexpected error", (Throwable)e);
        }
        String value = ringtailNode.get("targetVersion", null);
        if (value != null) {
            properties.put("version", value);
        }
        if ((value = ringtailNode.get("inheritDatesEnabled", null)) != null) {
            try {
                properties.put("inheritDates", Boolean.valueOf(value.toString()));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot convert property inheritDates value " + String.valueOf(value));
            }
        }
        if ((value = ringtailNode.get("directParent", null)) != null) {
            try {
                properties.put("directParent", Boolean.valueOf(value.toString()));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot convert property directParent value " + String.valueOf(value));
            }
        }
        if ((value = ringtailNode.get("docIdPage", null)) != null) {
            try {
                properties.put("useDocumentId", Boolean.valueOf(value.toString()));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot convert property docIdPage value " + String.valueOf(value));
            }
        }
        if ((value = ringtailNode.get("useNativePageCount", null)) != null) {
            try {
                properties.put("nativePageCount", Boolean.valueOf(value.toString()));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot convert property useNativePageCount value " + String.valueOf(value));
            }
        }
        return properties;
    }

    public String getDefaultMetadataProfileName() {
        String legalNodePath = "com/nuix/investigator/export/legal";
        Preferences legalNode = Preferences.userRoot().node(legalNodePath);
        try {
            for (String legalTypeName : legalNode.childrenNames()) {
                Preferences legalTypeNode = Preferences.userRoot().node(legalNodePath + "/" + legalTypeName);
                String metadataProfileName = legalTypeNode.get("metadataProfileName", null);
                if (metadataProfileName == null || metadataProfileName.length() <= 0) continue;
                return metadataProfileName;
            }
        }
        catch (BackingStoreException e) {
            LOGGER.error((Throwable)e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Could not retrieve default legal export metadata profile ");
        }
        return null;
    }

    public Map<String, Object> getProperties(Version nuixVersion) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.getPropertiesFromNode("com/nuix/investigator/wizard", properties);
        this.getPropertiesFromNode("com/nuix/investigator/wizard/textIndexSettings", properties);
        try {
            for (String configuratioNodeName : this.getWizardNuixVersions()) {
                this.getPropertiesFromNode("com/nuix/investigator/wizard/" + configuratioNodeName, properties);
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return properties;
    }

    private void getPropertiesFromNode(String settingsNodePath, Map<String, Object> properties) {
        LOGGER.info("Extracting general settings from node " + settingsNodePath);
        Preferences settingsNode = Preferences.userRoot().node(settingsNodePath);
        try {
            for (String settingKey : settingsNode.keys()) {
                String settingValue = settingsNode.get(settingKey, "");
                String settingName = this.settingKeyToName(settingKey);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("# Converted key " + settingKey + " to name " + settingName);
                }
                if (settingValue.equals("NUIX-NULL-VALUE")) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("## " + settingName + " is " + settingValue + ", skipping");
                    continue;
                }
                if (settingName.equals("calculateProcessingSize")) {
                    if (settingValue.equals("true")) {
                        properties.put("reportProcessingStatus", "physical_files");
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("## reportProcessingStatus is String (custom): physical_files");
                        continue;
                    }
                    properties.put("reportProcessingStatus", "none");
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("## reportProcessingStatus is String (custom): none");
                    continue;
                }
                if (settingValue.equals("true")) {
                    properties.put(settingName, true);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(settingName + " is Boolean: true");
                    continue;
                }
                if (settingValue.equals("false")) {
                    properties.put(settingName, false);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("## " + settingName + " is Boolean: false");
                    continue;
                }
                if (this.isValueLong(settingValue)) {
                    long longValue = this.getLongValue(settingValue);
                    properties.put(settingName, longValue);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("## " + settingName + " is Long: " + settingValue + " parsed as " + longValue);
                    continue;
                }
                if (settingValue.contains(",")) {
                    properties.put(settingName, settingValue.split(","));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("## " + settingName + " is Array");
                    continue;
                }
                if (settingName.equals("analysisLanguage")) {
                    settingValue = settingValue.substring(0, 2).toLowerCase();
                    properties.put(settingName, settingValue);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("## " + settingName + " is String (2 lowercase): " + settingValue);
                    continue;
                }
                if ((settingValue = settingValue.trim()).length() > 0) {
                    properties.put(settingName, settingValue);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("## " + settingName + " is String (default, length:" + settingValue.length() + "): " + settingValue);
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("## " + settingName + " is String (blank), skipping");
            }
        }
        catch (BackingStoreException e) {
            LOGGER.error("Error while listing properties.", (Throwable)e);
        }
    }
}

