/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nuix.Item;
import nuix.ItemExpression;

public class ItemSortablePathNameExpression
implements ItemExpression {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FormattingUtils.class);
    Pattern p = Pattern.compile("(.*?)(\\d+)([^\\d]*)$");

    public String evaluate(Item item) {
        StringBuilder normalizedPathName = new StringBuilder();
        int itemPosition = 0;
        List pathIds = item.getPathIds();
        for (String pathComponent : item.getPathNames()) {
            try {
                Matcher m;
                String ext1 = "";
                String name1 = pathComponent;
                int i = pathComponent.lastIndexOf(46);
                if (i > 0) {
                    ext1 = pathComponent.substring(i + 1);
                    name1 = pathComponent.substring(0, i);
                }
                if ((m = this.p.matcher(name1)).find()) {
                    Long count1 = Long.parseLong(m.group(2));
                    String prefixName1 = m.group(1);
                    normalizedPathName.append(prefixName1);
                    normalizedPathName.append(String.format("%09d", count1));
                    String suffixName1 = m.group(3);
                    normalizedPathName.append(suffixName1);
                    normalizedPathName.append(".");
                    normalizedPathName.append(ext1);
                } else {
                    normalizedPathName.append(pathComponent);
                }
            }
            catch (Exception e) {
                normalizedPathName.append(pathComponent);
            }
            normalizedPathName.append("-");
            normalizedPathName.append((String)pathIds.get(itemPosition));
            normalizedPathName.append("/");
            ++itemPosition;
        }
        return normalizedPathName.toString();
    }
}

