/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.FormConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldProcessor;
import com.nuix.automate.utils.models.internal.formbuilder.OperationHelperConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.OperationParameterConfiguration;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationHelper;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.utils.general.ReflectionUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class OperationUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OperationUtils.class);

    public static Map<String, FormConfiguration> getOperationFormConfigurations(FormFieldProcessor formFieldProcessor) throws IOException, URISyntaxException {
        TreeMap<String, FormConfiguration> operationFormConfigurations = new TreeMap<String, FormConfiguration>();
        boolean todoException = false;
        Set licensedModules = formFieldProcessor.getLicensedModules();
        for (Class<? extends Operation> operationClazz : ReflectionUtils.getOperationClasses()) {
            OperationHelper[] operationHelpers;
            OperationParameter[] operationParameters;
            boolean operationHasLicenseDefinition = false;
            boolean operationLicensed = false;
            Class<? extends Operation> c = operationClazz;
            while (true) {
                OperationLicenseModule operationLicenseModule;
                if ((operationLicenseModule = c.getAnnotation(OperationLicenseModule.class)) != null) {
                    ModuleType module = operationLicenseModule.module();
                    if (licensedModules != null && licensedModules.contains(module)) {
                        operationLicensed = true;
                    }
                    operationHasLicenseDefinition = true;
                    break;
                }
                Class<? extends Operation> superclass = c.getSuperclass();
                if (superclass == null) break;
                c = superclass;
            }
            LinkedHashMap<String, Set> tags = new LinkedHashMap<String, Set>();
            OperationMetadata operationMetadata = operationClazz.getAnnotation(OperationMetadata.class);
            OperationTag[] operationTags = (OperationTag[])operationClazz.getAnnotationsByType(OperationTag.class);
            if (operationMetadata == null) continue;
            if (operationHasLicenseDefinition) {
                if (!operationLicensed) {
                    continue;
                }
            } else {
                todoException = true;
                LOGGER.error("Operation " + operationClazz.getSimpleName() + " does not have license definition");
            }
            tags.put("Platform", new HashSet());
            tags.put("Category", new HashSet());
            tags.put(ExecutionMode.class.getSimpleName(), OperationUtils.buildEnumSet(new Enum[]{operationMetadata.mode()}));
            for (OperationTag operationTag : operationTags) {
                tags.computeIfAbsent(operationTag.name(), k -> new HashSet()).addAll(Arrays.asList(operationTag.value()));
            }
            ArrayList<OperationParameterConfiguration> parameters = new ArrayList<OperationParameterConfiguration>();
            for (OperationParameter operationParameter : operationParameters = (OperationParameter[])operationClazz.getAnnotationsByType(OperationParameter.class)) {
                parameters.add(new OperationParameterConfiguration(operationParameter.label(), operationParameter.parameter()));
            }
            ArrayList<OperationHelperConfiguration> helpers = new ArrayList<OperationHelperConfiguration>();
            for (OperationHelper operationHelper : operationHelpers = (OperationHelper[])operationClazz.getAnnotationsByType(OperationHelper.class)) {
                helpers.add(new OperationHelperConfiguration(operationHelper.label(), operationHelper.icon()));
            }
            FormConfiguration operationFormConfiguration = formFieldProcessor.getClassFormConfiguration(operationClazz);
            operationFormConfiguration.getTemplate().put("@class", operationClazz.getSimpleName());
            operationFormConfiguration.getTemplate().put("operationAlias", operationMetadata.alias().name());
            operationFormConfiguration.setOperationParameters(parameters);
            operationFormConfiguration.setOperationHelpers(helpers);
            operationFormConfiguration.setTags(tags);
            operationFormConfigurations.put(operationMetadata.alias().name(), operationFormConfiguration);
        }
        if (todoException) {
            throw new IllegalStateException("todo");
        }
        return operationFormConfigurations;
    }

    private static void writeAllOperationEnumTranslationsToFile() throws IOException, URISyntaxException {
        File tempFile = FileUtils.createTempFile((String)"EnumsTranslations", (String)"1.0");
        HashMap enumTranslations = new HashMap();
        for (Class<? extends Operation> operationClazz : ReflectionUtils.getOperationClasses()) {
            enumTranslations.putAll(OperationUtils.getEnumFieldTranslations(operationClazz));
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(tempFile));){
            bufferedWriter.write(SerializationUtils.toJson(enumTranslations));
        }
        LOGGER.info("--------------------------------------------------------------------------------");
        LOGGER.info("-----------------------------Enum Translations File: " + tempFile.getAbsolutePath());
        LOGGER.info("--------------------------------------------------------------------------------");
    }

    private static Map<String, Map<Enum<?>, String>> getEnumFieldTranslations(Class<?> clazz) {
        HashMap enumTranslations = new HashMap();
        for (Field field : com.nuix.automate.utils.general.ReflectionUtils.getAllDeclaredFields(clazz, (boolean)true)) {
            field.setAccessible(true);
            Class<?> type = field.getType();
            if (!type.isEnum()) continue;
            HashMap<Enum, String> values = new HashMap<Enum, String>();
            for (Object enumConstant : type.getEnumConstants()) {
                Enum enumValue = (Enum)enumConstant;
                values.put(enumValue, LocalizableEnumUtils.getLocalizedString((Enum)enumValue));
            }
            if (values.size() <= 0) continue;
            enumTranslations.put(type.getSimpleName(), values);
        }
        return enumTranslations;
    }

    private static Set<String> buildEnumSet(Enum<?> ... values) {
        return Arrays.stream(values).map(Enum::name).collect(Collectors.toSet());
    }
}

