/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.ApiClientsLogChannels;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.workflow.ScriptLanguage;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.script.JobSubmissionAutomateRestClient;
import com.nuix.automate.workflow.core.execution.script.JobSubmissionDiscoverRestClient;
import com.nuix.automate.workflow.core.execution.script.JobSubmissionGenAiRestClient;
import com.nuix.automate.workflow.core.execution.script.JobSubmissionGenericRestClient;
import com.nuix.automate.workflow.core.execution.script.JobSubmissionRelativityRestClient;
import com.nuix.automate.workflow.core.execution.script.RestApplication;
import com.nuix.automate.workflow.core.execution.script.RestApplicationsConfiguration;
import com.nuix.automate.workflow.core.execution.script.RestClient;
import com.nuix.automate.workflow.core.utils.general.LineOutputStream;
import com.nuix.automate.workflow.core.utils.general.OsUtils;
import com.nuix.automate.workflow.core.utils.general.ScriptAllowedValueParameters;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class ScriptUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ScriptUtils.class);
    private static ScriptEngineManager scriptEngineManager;
    private static Map<String, ScriptEngine> scriptEngines;

    private static synchronized ScriptEngine getScriptEngine(String scriptEngineName) {
        ScriptEngine scriptEngine;
        if (scriptEngineManager == null) {
            scriptEngineManager = new ScriptEngineManager();
        }
        if (scriptEngines == null) {
            scriptEngines = new HashMap<String, ScriptEngine>();
        }
        if ((scriptEngine = scriptEngines.get(scriptEngineName)) == null) {
            scriptEngine = scriptEngineManager.getEngineByName(scriptEngineName);
            scriptEngines.put(scriptEngineName, scriptEngine);
        }
        return scriptEngine;
    }

    public static String getScriptEngineName(String value) {
        String scriptEngineName = null;
        if (value.startsWith("ruby:")) {
            scriptEngineName = "ruby";
        } else if (value.startsWith("python:")) {
            scriptEngineName = "python";
        } else if (value.startsWith("ecmascript:") || value.startsWith("js:")) {
            scriptEngineName = "ECMAScript";
        }
        return scriptEngineName;
    }

    public static String getScriptEngineName(ScriptLanguage language) {
        String scriptEngineName = null;
        switch (language) {
            case PYTHON: {
                scriptEngineName = "python";
                break;
            }
            case RUBY: {
                scriptEngineName = "ruby";
                break;
            }
            case ECMA_SCRIPT: {
                scriptEngineName = "ECMAScript";
                break;
            }
            case POWERSHELL: {
                scriptEngineName = "Powershell";
            }
        }
        return scriptEngineName;
    }

    public static ScriptLanguage getScriptLanguage(String value) {
        if (value.startsWith("ruby:")) {
            return ScriptLanguage.RUBY;
        }
        if (value.startsWith("python:")) {
            return ScriptLanguage.PYTHON;
        }
        if (value.startsWith("ecmascript:") || value.startsWith("js:")) {
            return ScriptLanguage.ECMA_SCRIPT;
        }
        if (value.startsWith("powershell:")) {
            return ScriptLanguage.POWERSHELL;
        }
        return null;
    }

    public static String getScriptPath(ScriptLanguage language, String value) {
        switch (language) {
            case PYTHON: {
                return value.replace("python:", "");
            }
            case RUBY: {
                return value.replace("ruby:", "");
            }
            case ECMA_SCRIPT: {
                if (value.startsWith("ecmascript:")) {
                    return value.replace("ecmascript:", "");
                }
                if (value.startsWith("js:")) {
                    return value.replace("js:", "");
                }
            }
            case POWERSHELL: {
                return value.replace("powershell:", "");
            }
        }
        return null;
    }

    private static Set<StaticParameter> getBuiltInParameters(String username, String parameterName, Client client, Matter matter, WorkflowLibrary workflowLibrary, Workflow workflow, LinkedHashMap<String, String> parameterNameValueMap) throws Exception {
        HashSet<StaticParameter> parameters = new HashSet<StaticParameter>();
        parameters.add(new StaticParameter("{user_name}", username));
        parameters.add(new StaticParameter("{parameter_name}", parameterName));
        if (matter != null) {
            parameters.add(new StaticParameter("{matter_id}", matter.getId()));
            parameters.add(new StaticParameter("{matter_name}", matter.getName()));
            parameters.add(new StaticParameter("{matter_reference}", matter.getReference()));
        }
        if (client != null) {
            parameters.add(new StaticParameter("{client_id}", client.getId()));
            parameters.add(new StaticParameter("{client_name}", client.getName()));
            parameters.add(new StaticParameter("{client_reference}", client.getReference()));
        }
        if (workflow != null) {
            parameters.add(new StaticParameter("{workflow_id}", workflow.getId()));
            parameters.add(new StaticParameter("{workflow_name}", workflow.getName()));
        }
        if (workflowLibrary != null) {
            parameters.add(new StaticParameter("{library_id}", workflowLibrary.getId()));
            parameters.add(new StaticParameter("{library_name}", workflowLibrary.getName()));
        }
        if (parameterNameValueMap != null) {
            for (Map.Entry<String, String> entry : parameterNameValueMap.entrySet()) {
                if (entry.getKey().equals(parameterName)) break;
                String value = entry.getValue();
                if (value == null) {
                    value = entry.getKey();
                }
                parameters.add(new StaticParameter(entry.getKey(), value));
            }
        }
        return parameters;
    }

    private static List<String> getPowershellScriptAllowedValues(long allowedParameterValuesScriptTimeout, String username, Parameter parameter, Client client, Matter matter, WorkflowLibrary workflowLibrary, Workflow workflow, LinkedHashMap<String, String> parameterNameValueMap, String scriptCode) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        String powershellLocation = OsUtils.getOsWindows() ? "C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe" : "/usr/bin/pwsh";
        Set<StaticParameter> parameters = ScriptUtils.getBuiltInParameters(username, parameter.getName(), client, matter, workflowLibrary, workflow, parameterNameValueMap);
        String resultsFile = FileUtils.createTempFilePath((String)("powershell_" + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC))), (String)".txt", (FileAttribute[])new FileAttribute[0]).toFile().getAbsolutePath();
        Path powershellScriptLocation = FileUtils.createTempFilePath((String)"Automate", (String)".ps1", (FileAttribute[])new FileAttribute[0]);
        scriptCode = scriptCode.replace("{results_file}", resultsFile);
        for (StaticParameter param : parameters) {
            if (param.getValue() == null) continue;
            scriptCode = scriptCode.replace(param.getName(), param.getValue());
        }
        LOGGER.info("Creating temporary PowerShell script file " + String.valueOf(powershellScriptLocation));
        FileUtils.writeToFile((String)scriptCode, (Path)powershellScriptLocation);
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(powershellLocation);
        commandLine.add(powershellScriptLocation.toAbsolutePath().toString());
        ProcessBuilder builder = new ProcessBuilder(commandLine);
        Process powershellCommandProcess = builder.start();
        BufferedReader standardInputReader = new BufferedReader(new InputStreamReader(powershellCommandProcess.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(powershellCommandProcess.getErrorStream()));
        Thread standardOutputThread = new Thread(() -> {
            try {
                ScriptUtils.suppressOutput(standardInputReader);
            }
            catch (IOException e) {
                LOGGER.error("Failed to run powershell allowed values", (Throwable)e);
            }
            finally {
                try {
                    standardInputReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        standardOutputThread.setName("Powershell Allowed Values Script Standard Output Thread");
        standardOutputThread.start();
        Thread standardErrorThread = new Thread(() -> {
            try {
                ScriptUtils.suppressOutput(errorReader);
            }
            catch (IOException e) {
                LOGGER.error("Failed to run powershell allowed values", (Throwable)e);
            }
            finally {
                try {
                    errorReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        standardErrorThread.setName("Powershell Allowed Values Script Standard Error Thread");
        standardErrorThread.start();
        try {
            powershellCommandProcess.waitFor(allowedParameterValuesScriptTimeout, TimeUnit.MILLISECONDS);
            if (powershellCommandProcess.isAlive()) {
                try {
                    powershellCommandProcess.destroyForcibly();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot destroy external application process", (Throwable)e);
                }
                if (standardOutputThread.isAlive()) {
                    standardOutputThread.interrupt();
                }
                if (standardErrorThread.isAlive()) {
                    standardErrorThread.interrupt();
                }
                throw new TimeoutException("Script execution did not complete in " + allowedParameterValuesScriptTimeout + " ms");
            }
            standardOutputThread.join();
            standardErrorThread.join();
        }
        catch (InterruptedException e) {
            LOGGER.error("Cannot wait for script execution to complete", (Throwable)e);
            powershellCommandProcess.destroyForcibly();
            throw new TimeoutException("Script execution interrupted");
        }
        try (BufferedReader resultReader = new BufferedReader(new FileReader(resultsFile));){
            String line;
            while ((line = resultReader.readLine()) != null) {
                result.add(line.trim());
            }
            if (result.size() == 0) {
                throw new NullPointerException();
            }
            if (((String)result.get(result.size() - 1)).trim().equals("")) {
                result.remove(result.get(result.size() - 1));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    private static void suppressOutput(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (!Thread.interrupted()) continue;
            return;
        }
    }

    public static List<String> getScriptAllowedValues(long allowedParameterValuesScriptTimeout, String username, Parameter parameter, Client client, Matter matter, WorkflowLibrary workflowLibrary, Workflow workflow, LinkedHashMap<String, String> parameterNameValueMap) throws Exception {
        return ScriptUtils.getScriptAllowedValues(allowedParameterValuesScriptTimeout, username, parameter, client, matter, workflowLibrary, workflow, parameterNameValueMap, null, null);
    }

    private static void exposeParametersInScriptingContext(Set<StaticParameter> parameters, SimpleScriptContext simpleScriptContext, LinkedHashMap<String, String> parameterNameValueMap, Map<RestApplication, RestClient> restClients) {
        LinkedHashMap<String, String> parameterValues = new LinkedHashMap<String, String>();
        if (parameterNameValueMap != null) {
            for (Map.Entry entry : parameterNameValueMap.entrySet()) {
                parameterValues.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (StaticParameter staticParameter : parameters) {
            String variableName = staticParameter.getName().substring(1, staticParameter.getName().length() - 1);
            simpleScriptContext.setAttribute(variableName, staticParameter.getValue(), 100);
            simpleScriptContext.setAttribute("$" + variableName, staticParameter.getValue(), 100);
        }
        ScriptAllowedValueParameters scriptAllowedValueParameters = new ScriptAllowedValueParameters(parameterValues);
        simpleScriptContext.setAttribute("parameters", scriptAllowedValueParameters, 100);
        simpleScriptContext.setAttribute("$parameters", scriptAllowedValueParameters, 100);
        RestClient restClient = restClients.get((Object)RestApplication.AUTOMATE);
        simpleScriptContext.setAttribute("restRampiva", restClient, 100);
        simpleScriptContext.setAttribute("$restRampiva", restClient, 100);
        simpleScriptContext.setAttribute("rest_rampiva", restClient, 100);
        simpleScriptContext.setAttribute("$rest_rampiva", restClient, 100);
        simpleScriptContext.setAttribute("restAutomate", restClient, 100);
        simpleScriptContext.setAttribute("restAutomate", restClient, 100);
        simpleScriptContext.setAttribute("rest_automate", restClient, 100);
        simpleScriptContext.setAttribute("$rest_automate", restClient, 100);
        RestClient restDiscover = restClients.get((Object)RestApplication.DISCOVER);
        simpleScriptContext.setAttribute("restDiscover", restDiscover, 100);
        simpleScriptContext.setAttribute("$restDiscover", restDiscover, 100);
        simpleScriptContext.setAttribute("rest_discover", restDiscover, 100);
        simpleScriptContext.setAttribute("$rest_discover", restDiscover, 100);
        RestClient restGenAi = restClients.get((Object)RestApplication.GEN_AI);
        simpleScriptContext.setAttribute("genAi", restGenAi, 100);
        simpleScriptContext.setAttribute("$genAi", restGenAi, 100);
        simpleScriptContext.setAttribute("gen_ai", restGenAi, 100);
        simpleScriptContext.setAttribute("$gen_ai", restGenAi, 100);
        RestClient restRelativity = restClients.get((Object)RestApplication.RELATIVITY);
        simpleScriptContext.setAttribute("restRelativity", restRelativity, 100);
        simpleScriptContext.setAttribute("$restRelativity", restRelativity, 100);
        simpleScriptContext.setAttribute("rest_relativity", restRelativity, 100);
        simpleScriptContext.setAttribute("$rest_relativity", restRelativity, 100);
        JobSubmissionGenericRestClient rest = new JobSubmissionGenericRestClient("JobSubmissionGenericRestClient");
        simpleScriptContext.setAttribute("rest", rest, 100);
        simpleScriptContext.setAttribute("$rest", rest, 100);
    }

    private static Map<RestApplication, RestClient> createRestClients(RestApplicationsConfiguration restApplicationsConfiguration, String username) {
        HashMap<RestApplication, RestClient> restClients = new HashMap<RestApplication, RestClient>();
        LogChannel rampivaChannel = ApiClientsLogChannels.getInstance().getLogChannel("logApiAutomate", username);
        LogChannel discoverChannel = ApiClientsLogChannels.getInstance().getLogChannel("logApiDiscover", username);
        LogChannel relativityChannel = ApiClientsLogChannels.getInstance().getLogChannel("logApiRelativity", username);
        LogChannel genAiChannel = ApiClientsLogChannels.getInstance().getLogChannel("logApiGenAi", username);
        restClients.put(RestApplication.AUTOMATE, new JobSubmissionAutomateRestClient(restApplicationsConfiguration.getConfigurations().get((Object)RestApplication.AUTOMATE), rampivaChannel));
        restClients.put(RestApplication.DISCOVER, new JobSubmissionDiscoverRestClient(restApplicationsConfiguration.getConfigurations().get((Object)RestApplication.DISCOVER), discoverChannel));
        restClients.put(RestApplication.RELATIVITY, new JobSubmissionRelativityRestClient(restApplicationsConfiguration.getConfigurations().get((Object)RestApplication.RELATIVITY), relativityChannel));
        restClients.put(RestApplication.GEN_AI, new JobSubmissionGenAiRestClient(restApplicationsConfiguration.getConfigurations().get((Object)RestApplication.GEN_AI), genAiChannel));
        return restClients;
    }

    private static void closeRestClients(Map<RestApplication, RestClient> restClients) {
        for (RestClient restClient : restClients.values()) {
            try {
                restClient.close();
            }
            catch (Exception e) {
                LOGGER.error("Cannot close REST client ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getScriptAllowedValues(long allowedParameterValuesScriptTimeout, String username, Parameter parameter, Client client, Matter matter, WorkflowLibrary workflowLibrary, Workflow workflow, LinkedHashMap<String, String> parameterNameValueMap, FileLibraryFile libraryFile, RestApplicationsConfiguration restApplicationsConfiguration) throws Exception {
        String parameterName = parameter.getName();
        String scriptEngineName = null;
        String scriptCode = "";
        if (parameter.isUseLibraryFile()) {
            byte[] fileData = FileUtils.decodeFileData((String)libraryFile.getData());
            scriptCode = new String(fileData, StandardCharsets.UTF_8);
            switch (libraryFile.getNuixFileType()) {
                case PYTHON_SCRIPT: {
                    scriptEngineName = "python";
                    break;
                }
                case POWERSHELL_SCRIPT: {
                    scriptEngineName = "PowerShell";
                    break;
                }
                case JS_SCRIPT: {
                    scriptEngineName = "ECMAScript";
                    break;
                }
                case RUBY_SCRIPT: {
                    scriptEngineName = "ruby";
                }
            }
        } else {
            scriptCode = parameter.getScriptCode();
            switch (parameter.getScriptLanguage()) {
                case PYTHON: {
                    scriptEngineName = "python";
                    break;
                }
                case RUBY: {
                    scriptEngineName = "ruby";
                    break;
                }
                case POWERSHELL: {
                    scriptEngineName = "PowerShell";
                    break;
                }
                case ECMA_SCRIPT: {
                    scriptEngineName = "ECMAScript";
                }
            }
        }
        if (scriptEngineName == null) {
            throw new Exception("Invalid script engine type");
        }
        if (scriptEngineName.equals("PowerShell")) {
            return ScriptUtils.getPowershellScriptAllowedValues(allowedParameterValuesScriptTimeout, username, parameter, client, matter, workflowLibrary, workflow, parameterNameValueMap, scriptCode);
        }
        ArrayList<String> result = new ArrayList<String>();
        ScriptEngine scriptEngine = ScriptUtils.getScriptEngine(scriptEngineName);
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        LineOutputStream lineOutputStream = new LineOutputStream();
        lineOutputStream.addListener(line -> LOGGER.info(line));
        simpleScriptContext.setWriter(new PrintWriter(lineOutputStream, true));
        LineOutputStream lineErrorOutputStream = new LineOutputStream();
        lineErrorOutputStream.addListener(line -> LOGGER.error(line));
        simpleScriptContext.setErrorWriter(new PrintWriter(lineErrorOutputStream, true));
        Set<StaticParameter> parameters = ScriptUtils.getBuiltInParameters(username, parameter.getName(), client, matter, workflowLibrary, workflow, parameterNameValueMap);
        Map<RestApplication, RestClient> restClients = ScriptUtils.createRestClients(restApplicationsConfiguration, username);
        try {
            ScriptUtils.exposeParametersInScriptingContext(parameters, simpleScriptContext, parameterNameValueMap, restClients);
            LOGGER.info("Evaluating allowed parameter " + parameterName + " values from " + scriptEngineName + " code");
            ArrayList exceptionList = new ArrayList();
            String finalScriptCode = scriptCode;
            Thread scriptThread = new Thread(() -> {
                block12: {
                    try {
                        Object scriptResult = scriptEngine.eval(finalScriptCode, (ScriptContext)simpleScriptContext);
                        if (scriptResult == null) {
                            scriptResult = simpleScriptContext.getAttribute("result", 100);
                        }
                        if (scriptResult == null) {
                            throw new NullPointerException();
                        }
                        if (scriptResult.getClass().getSimpleName().contains("ScriptObjectMirror")) {
                            try {
                                Method valuesMethod = scriptResult.getClass().getMethod("values", new Class[0]);
                                Object valuesReponse = valuesMethod.invoke(scriptResult, new Object[0]);
                                LOGGER.info("Reflection scriptResult values method call response: " + String.valueOf(valuesReponse));
                                if (valuesReponse != null && valuesReponse instanceof Collection) {
                                    for (Object item : (Collection)valuesReponse) {
                                        result.add(item.toString());
                                    }
                                    break block12;
                                }
                                result.add(scriptResult.toString());
                            }
                            catch (NoSuchMethodException e) {
                                LOGGER.warn("Cannot find scriptResult " + String.valueOf(scriptResult.getClass()) + " class values method", (Throwable)e);
                                result.add(scriptResult.toString());
                            }
                            break block12;
                        }
                        if (scriptResult instanceof Collection) {
                            for (Object item : (Collection)scriptResult) {
                                result.add(item.toString());
                            }
                        } else {
                            result.add(scriptResult.toString());
                        }
                    }
                    catch (Exception e) {
                        exceptionList.add(e);
                    }
                }
            });
            scriptThread.setName("Automate - Automate - Allowed Parameters Script");
            scriptThread.start();
            try {
                scriptThread.join(allowedParameterValuesScriptTimeout);
                if (scriptThread.isAlive()) {
                    scriptThread.interrupt();
                    throw new TimeoutException("Script execution did not complete in " + allowedParameterValuesScriptTimeout + " ms");
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Cannot wait for script execution to complete", (Throwable)e);
                scriptThread.interrupt();
                throw new TimeoutException("Script execution interrupted");
            }
            if (exceptionList.size() > 0) {
                throw (Exception)exceptionList.get(0);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            ScriptUtils.closeRestClients(restClients);
        }
    }
}

