/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyRestException;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.utils.general.ObjectMapperProvider;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class ThirdPartyProxyRestClient
implements AutoCloseable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ThirdPartyProxyRestClient.class);
    protected static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private boolean proxyResponse;
    private boolean reattemptEnabled;
    private int maxAttempts;
    private int delayFactorSeconds;
    private Operation operation;
    protected final String schedulerUrl;
    protected final String proxyUrl;
    protected final String bearerToken;
    private final String clientName;
    private final Client client;
    private final Gson gson;
    protected final ObjectMapper objectMapper;
    private final boolean usingCustomFingerprint;
    private Path logFilePath;

    public ThirdPartyProxyRestClient(String thirdPartyServiceId, String schedulerUrl, String bearerToken, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        this.clientName = this.getClass().getSimpleName() + "-" + thirdPartyServiceId;
        this.client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)this.clientName, whitelistedCertFingerprints, (boolean)true);
        this.client.register(ObjectMapperProvider.class);
        this.proxyResponse = false;
        this.reattemptEnabled = true;
        if (this.verifySchedulerConnection()) {
            this.maxAttempts = 7;
            this.delayFactorSeconds = 30;
        } else {
            this.maxAttempts = 3;
            this.delayFactorSeconds = 10;
        }
        this.gson = new Gson();
        this.objectMapper = new ObjectMapperProvider().getContext(null);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.usingCustomFingerprint = whitelistedCertFingerprints != null && whitelistedCertFingerprints.stream().anyMatch(cert -> cert != null && !cert.trim().isEmpty());
        this.schedulerUrl = schedulerUrl.endsWith("/") ? schedulerUrl.substring(0, schedulerUrl.length() - 1) : schedulerUrl;
        String proxyEndpoint = "api/v1/scheduler/resources/thirdPartyService/" + thirdPartyServiceId + "/apiProxy";
        this.proxyUrl = this.schedulerUrl + "/" + proxyEndpoint;
        this.bearerToken = bearerToken;
        String logFileName = this.getLogFileName();
        if (logFileName != null) {
            this.logFilePath = Paths.get(logFileName, new String[0]);
        }
    }

    public boolean verifySchedulerConnection() {
        String result = System.getProperty("workflow.scheduler.connected");
        if (result == null || result.trim().equals("")) {
            return false;
        }
        return Boolean.parseBoolean(result);
    }

    public abstract String getLogFileName();

    public abstract String getServiceName();

    @Override
    public void close() {
        block2: {
            try {
                this.client.close();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Cannot close client", (Throwable)e);
            }
        }
        WsRsRestClientFactory.remove((String)this.getClass().getSimpleName());
    }

    public void setProxyResponse(boolean proxyResponse) {
        this.proxyResponse = proxyResponse;
    }

    public void setReattemptEnabled(boolean reattemptEnabled) {
        this.reattemptEnabled = reattemptEnabled;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setDelayFactorSeconds(int delayFactorSeconds) {
        this.delayFactorSeconds = delayFactorSeconds;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    protected void proxyApiRequest(String endpoint, String method, int expectedStatus) throws IOException {
        this.proxyApiRequest(this.buildApiProxyRequest(endpoint, method, expectedStatus)).close();
    }

    protected void proxyApiRequest(String endpoint, String method, int expectedStatus, Object body) throws IOException {
        this.proxyApiRequest(this.buildApiProxyRequest(endpoint, method, expectedStatus, body)).close();
    }

    protected <ResponseType> ResponseType proxyApiGetRequest(String endpoint, GenericType<ResponseType> entityType) throws IOException {
        return this.proxyApiRequest(endpoint, "GET", 200, null, entityType);
    }

    protected <ResponseType> ResponseType proxyApiPagedGetRequest(String endpoint, GenericType<ResponseType> entityType) throws IOException {
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, "GET", 200);
        apiProxyRequest.setPageRequests(true);
        return this.proxyApiRequest(apiProxyRequest, entityType);
    }

    protected <ResponseType> ResponseType proxyApiRequest(String endpoint, String method, Object body, GenericType<ResponseType> entityType) throws IOException {
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, method, body);
        return this.proxyApiRequest(apiProxyRequest, entityType);
    }

    protected <ResponseType> ResponseType proxyApiRequest(String endpoint, String method, int expectedStatus, Object body, GenericType<ResponseType> entityType) throws IOException {
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, method, expectedStatus, body);
        return this.proxyApiRequest(apiProxyRequest, entityType);
    }

    protected <ResponseType> ResponseType proxyApiRequest(ApiProxyRequest apiProxyRequest, GenericType<ResponseType> entityType) throws IOException {
        try (Response response = this.proxyApiRequest(apiProxyRequest);){
            Object object = response.readEntity(entityType);
            return (ResponseType)object;
        }
    }

    protected ApiProxyRequest buildApiProxyRequest(String endpoint, String method, Object body) {
        return this.buildApiProxyRequest(endpoint, method, 0, body);
    }

    protected ApiProxyRequest buildApiProxyRequest(String endpoint, String method, int expectedStatus) {
        return this.buildApiProxyRequest(endpoint, method, expectedStatus, null);
    }

    protected ApiProxyRequest buildApiProxyRequest(String endpoint, String method, int expectedStatus, Object body) {
        ApiProxyRequest proxyRequest = new ApiProxyRequest(endpoint, method, expectedStatus);
        proxyRequest.setProxyResponse(this.proxyResponse);
        if (body != null) {
            if (body instanceof Collection) {
                proxyRequest.setBody(body);
            } else {
                proxyRequest.setBody(this.objectMapper.convertValue(body, Map.class));
            }
        }
        return proxyRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response proxyApiRequest(ApiProxyRequest body) throws ThirdPartyRestException {
        Response response;
        Object errorMessage;
        block20: {
            Object currentErrorMessage;
            TranslationResponseStatus responseStatus;
            String logEntry = "------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\nPOST " + this.proxyUrl + "\n" + this.gson.toJson((Object)body) + "\n";
            this.writeToLogFile(logEntry);
            int delaySeconds = this.delayFactorSeconds;
            int attempt = 1;
            errorMessage = null;
            while (true) {
                Object dummyResponse;
                try {
                    Invocation.Builder builder = this.client.target(this.proxyUrl).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.bearerToken));
                    response = builder.post(Entity.json((Object)body));
                }
                catch (Exception e) {
                    if ((e.getCause() != null && e.getCause() instanceof SSLHandshakeException || e.getMessage().contains("SSLHandshakeException")) && !this.usingCustomFingerprint) {
                        HashSet<String> dummyFingerprints = new HashSet<String>();
                        dummyFingerprints.add("dummy-fingerprint");
                        try {
                            Client dummyClient = WsRsRestClientFactory.getClientWithWhitelistValidation((String)(this.clientName + "-dummyFingerprint"), dummyFingerprints, (boolean)true);
                            dummyResponse = dummyClient.target(this.proxyUrl).request(new String[]{"application/json"}).get();
                            LOGGER.info("Got response code " + dummyResponse.getStatus());
                        }
                        catch (Exception ex) {
                            if (e.getCause() != null && e.getCause() instanceof SSLHandshakeException || e.getMessage().contains("SSLHandshakeException")) {
                                throw new ThirdPartyRestException(ex.getCause().getMessage());
                            }
                            throw e;
                        }
                    }
                    if (this.reattemptEnabled && attempt < this.maxAttempts) {
                        LOGGER.error("Exception during request", (Throwable)e);
                        ++attempt;
                        continue;
                    }
                    throw e;
                }
                this.writeToLogFile("Response HTTP/" + response.getStatus());
                if (response.getStatus() == 200 || response.getStatus() == body.getExpectedStatus()) break block20;
                response.bufferEntity();
                String responseString = (String)response.readEntity(String.class);
                LOGGER.error(logEntry);
                LOGGER.error("Response HTTP/" + response.getStatus());
                LOGGER.error(this.getServiceName() + " Error: " + responseString);
                responseStatus = (TranslationResponseStatus)SerializationUtils.fromJson((String)responseString, TranslationResponseStatus.class);
                currentErrorMessage = this.parseErrorTranslationResponse(responseStatus);
                if (currentErrorMessage == null) {
                    currentErrorMessage = "HTTP/" + response.getStatus() + " " + responseString;
                }
                LOGGER.error(this.getServiceName() + " Decoded Error: " + (String)currentErrorMessage);
                this.writeToLogFile((String)currentErrorMessage);
                if (errorMessage == null) {
                    errorMessage = currentErrorMessage;
                }
                if (!this.reattemptEnabled || attempt >= this.maxAttempts || !this.isResponseReattemptable(responseStatus)) break;
                if (this.operation != null && attempt == 1) {
                    dummyResponse = this;
                    synchronized (dummyResponse) {
                        this.operation.addTransientWarning((String)errorMessage, false);
                    }
                }
                ++attempt;
                try {
                    Thread.sleep((long)delaySeconds * 1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Throwable)e);
                    Thread.currentThread().interrupt();
                }
                delaySeconds = Math.min(delaySeconds * 2, 90);
            }
            throw new ThirdPartyRestException((String)currentErrorMessage, responseStatus.getCode());
        }
        if (this.operation != null && errorMessage != null) {
            ThirdPartyProxyRestClient thirdPartyProxyRestClient = this;
            synchronized (thirdPartyProxyRestClient) {
                this.operation.addTransientWarning((String)errorMessage, true);
            }
        }
        return response;
    }

    protected boolean isResponseReattemptable(TranslationResponseStatus errorResponse) {
        return errorResponse.getCode() >= 500 && errorResponse.getCode() < 600;
    }

    protected String parseErrorTranslationResponse(TranslationResponseStatus errorResponse) {
        if (errorResponse != null && errorResponse.getValues() != null) {
            String endServiceResponse = (String)errorResponse.getValues().get("response");
            if (endServiceResponse != null) {
                try {
                    Object endServiceResponseMessage;
                    Map endServiceResponseMap = (Map)SerializationUtils.fromJson((String)endServiceResponse, Map.class);
                    Object endServiceResponseError = endServiceResponseMap.get("error");
                    if (endServiceResponseError instanceof Map && (endServiceResponseMessage = ((Map)endServiceResponseError).get("message")) != null) {
                        return endServiceResponseMessage.toString().replace(": .", ".").trim();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot parse " + this.getServiceName() + " error message", (Throwable)e);
                }
            }
            if (errorResponse.getValues().containsKey("exception")) {
                return (String)errorResponse.getValues().get("exception");
            }
        }
        return null;
    }

    protected synchronized void writeToLogFile(String entry) {
        if (this.logFilePath != null) {
            try {
                FileUtils.writeStringToFile((File)this.logFilePath.toFile(), (String)("\n" + entry), (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
            catch (IOException e) {
                LOGGER.error("Error writing to " + this.getServiceName() + " log", (Throwable)e);
            }
        }
    }

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }
}

