/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.loadfile;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NotNull;

public class CountingCrcOutputStream
extends OutputStream {
    private long size = 0L;
    private final CRC32 crc = new CRC32();
    private final OutputStream buffer;

    public CountingCrcOutputStream() {
        this.buffer = null;
    }

    public CountingCrcOutputStream(OutputStream buffer) {
        this.buffer = buffer;
    }

    @Override
    public void write(int b) throws IOException {
        ++this.size;
        this.crc.update(b);
        if (this.buffer != null) {
            this.buffer.write(b);
        }
    }

    @Override
    public void write(@NotNull byte[] b) throws IOException {
        this.size += (long)b.length;
        this.crc.update(b, 0, b.length);
        if (this.buffer != null) {
            this.buffer.write(b, 0, b.length);
        }
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        this.size += (long)len;
        this.crc.update(b, off, len);
        if (this.buffer != null) {
            this.buffer.write(b, off, len);
        }
    }

    public long getCrc() {
        return this.crc.getValue();
    }

    public long getSize() {
        return this.size;
    }
}

