/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.loadfile;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.nuix.automate.utils.general.XmlTransformerFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.exceptions.DocIdErrorListener;
import com.nuix.automate.workflow.core.utils.loadfile.CountingCrcOutputStream;
import com.nuix.automate.workflow.core.utils.loadfile.LoadFileField;
import com.nuix.automate.workflow.core.utils.loadfile.LoadfileItem;
import com.nuix.automate.workflow.core.utils.loadfile.PathItem;
import com.nuix.automate.workflow.core.utils.loadfile.Relationship;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringEscapeUtils;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Loadfile {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Loadfile.class);
    private final Map<String, LoadfileItem> topLevelItems;
    private final Map<String, LoadFileField> loadFileFields = new LinkedHashMap<String, LoadFileField>();
    private final ThreadPoolExecutor pool;
    PathItem rootFolder;
    Set<Relationship> relationships;

    public PathItem getCreateFolderAtLocation(String path) {
        path = path.replace("://", ":\u2588\u2588");
        String[] pathSplits = path.split("/");
        PathItem currentFolder = this.rootFolder;
        for (int i = 0; i < pathSplits.length - 1; ++i) {
            PathItem existingSubFolder = currentFolder.getSubFolders().get(pathSplits[i]);
            if (existingSubFolder == null) {
                existingSubFolder = new PathItem(pathSplits[i]);
                currentFolder.getSubFolders().put(existingSubFolder.getFolderName(), existingSubFolder);
            }
            currentFolder = existingSubFolder;
        }
        return currentFolder;
    }

    private void trackItemPath(LoadfileItem item) {
        String path = item.getLocation();
        PathItem folder = this.getCreateFolderAtLocation(path);
        folder.getLoadfileItems().add(item);
    }

    public Loadfile(List<LoadFileField> loadFileFields) {
        for (LoadFileField field : loadFileFields) {
            this.loadFileFields.put(field.getName(), field);
        }
        this.topLevelItems = new LinkedHashMap<String, LoadfileItem>();
        this.relationships = new HashSet<Relationship>();
        this.rootFolder = new PathItem("");
        this.pool = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public void addTopLevelItem(LoadfileItem loadfileItem) {
        this.topLevelItems.put(loadfileItem.getDocId(), loadfileItem);
        this.trackItemPath(loadfileItem);
    }

    public void addRelationships(Set<Relationship> relationships) {
        this.relationships.addAll(relationships);
    }

    public void writeNli(ZipOutputStream zipOutputStream, AtomicLong itemsProcessedCount, AtomicLong itemsWithErrorsCount) throws IOException, ParserConfigurationException, TransformerException {
        this.writeNli(zipOutputStream, itemsProcessedCount, itemsWithErrorsCount, null);
    }

    public void writeNli(ZipOutputStream zipOutputStream, AtomicLong itemsProcessedCount, AtomicLong itemsWithErrorsCount, DocIdErrorListener errorListener) throws IOException, ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document xmlDocument = docBuilder.newDocument();
        Element xmlRootElement = xmlDocument.createElement("Root");
        xmlDocument.appendChild(xmlRootElement);
        xmlRootElement.setAttribute("MajorVersion", "1");
        xmlRootElement.setAttribute("MinorVersion", "2");
        xmlRootElement.setAttribute("Description", "Exported with Automate");
        Element fieldsXmlElement = xmlDocument.createElement("Fields");
        xmlRootElement.appendChild(fieldsXmlElement);
        for (LoadFileField field : this.loadFileFields.values()) {
            Element fieldXmlElement = xmlDocument.createElement("Field");
            if (field.isEdrmField()) {
                fieldXmlElement.setAttribute("EDRMFieldMap", StringEscapeUtils.escapeXml11((String)field.getType()));
            } else {
                fieldXmlElement.setAttribute("DataType", StringEscapeUtils.escapeXml11((String)field.getType()));
            }
            fieldXmlElement.setAttribute("Key", field.getNormalizedFieldName());
            if (field.isLoadFileField()) {
                fieldXmlElement.setAttribute("Name", "Loadfile " + StringEscapeUtils.escapeXml11((String)field.getName()));
            } else {
                fieldXmlElement.setAttribute("Name", StringEscapeUtils.escapeXml11((String)field.getName()));
            }
            fieldsXmlElement.appendChild(fieldXmlElement);
        }
        Element batchXmlElement = xmlDocument.createElement("Batch");
        xmlRootElement.appendChild(batchXmlElement);
        Element documentsXmlElement = xmlDocument.createElement("Documents");
        batchXmlElement.appendChild(documentsXmlElement);
        for (LoadfileItem loadfileItem : this.topLevelItems.values()) {
            this.pool.execute(() -> {
                try {
                    boolean resultOk = loadfileItem.write(this, xmlDocument, documentsXmlElement, zipOutputStream, errorListener);
                    itemsProcessedCount.incrementAndGet();
                    if (!resultOk) {
                        itemsWithErrorsCount.incrementAndGet();
                    }
                }
                catch (Exception e) {
                    errorListener.onError(loadfileItem.getDocId(), "Unable to write item " + loadfileItem.getDocId(), e, false);
                    LOGGER.warn("Unable to write item " + loadfileItem.getDocId(), (Throwable)e);
                    itemsWithErrorsCount.incrementAndGet();
                }
            });
        }
        while (this.pool.getActiveCount() != 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.pool.shutdown();
        if (this.relationships.size() > 0) {
            Element relationshipsXmlElement = xmlDocument.createElement("Relationships");
            batchXmlElement.appendChild(relationshipsXmlElement);
            for (Relationship relationship : this.relationships) {
                relationship.writeRelationshipXml(xmlDocument, relationshipsXmlElement);
            }
        }
        Element foldersXmlElement = xmlDocument.createElement("Folders");
        batchXmlElement.appendChild(foldersXmlElement);
        for (PathItem subFolder : this.rootFolder.getSubFolders().values()) {
            subFolder.writePathXml(xmlDocument, foldersXmlElement, "");
        }
        ZipEntry zipEntry = new ZipEntry("._metadata/image_contents.xml");
        CountingCrcOutputStream countingCrcOutputStream = new CountingCrcOutputStream();
        HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)countingCrcOutputStream);
        Loadfile.writeXml(xmlDocument, (OutputStream)hashingOutputStream);
        zipEntry.setCrc(countingCrcOutputStream.getCrc());
        zipEntry.setSize(countingCrcOutputStream.getSize());
        zipEntry.setCompressedSize(countingCrcOutputStream.getSize());
        zipOutputStream.putNextEntry(zipEntry);
        Loadfile.writeXml(xmlDocument, zipOutputStream);
        zipOutputStream.closeEntry();
        ZipEntry imageContentsHash = new ZipEntry("._metadata/image_contents.sha1_hash");
        byte[] hashContents = hashingOutputStream.hash().asBytes();
        long imageContentHashCrc = this.calculateCrcFromBytes(hashContents);
        long imageContentHashSize = hashContents.length;
        imageContentsHash.setCrc(imageContentHashCrc);
        imageContentsHash.setSize(imageContentHashSize);
        imageContentsHash.setCompressedSize(imageContentHashSize);
        zipOutputStream.putNextEntry(imageContentsHash);
        zipOutputStream.write(hashContents);
        zipOutputStream.closeEntry();
        ZipEntry imageMetadata = new ZipEntry("._metadata/image_metadata.xml");
        ByteArrayOutputStream imageMetadataBaos = new ByteArrayOutputStream();
        this.writeImageMetadata(imageMetadataBaos);
        long imageMetadataCrc = this.calculateCrcFromBytes(imageMetadataBaos.toByteArray());
        long imageMetadataSize = imageMetadataBaos.size();
        imageMetadata.setCrc(imageMetadataCrc);
        imageMetadata.setSize(imageMetadataSize);
        imageMetadata.setCompressedSize(imageMetadataSize);
        zipOutputStream.putNextEntry(imageMetadata);
        zipOutputStream.write(imageMetadataBaos.toByteArray());
        zipOutputStream.closeEntry();
    }

    private long calculateCrcFromBytes(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes, 0, bytes.length);
        return crc32.getValue();
    }

    private void writeImageMetadata(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        bufferedWriter.append("<?xml version=\"1.0\"?>\n<image-metadata xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n  <properties>\n    <property key=\"creation-software-name\" value=\"Automate\" />\n    <property key=\"creation-software-version\" value=\"" + this.getClass().getPackage().getImplementationVersion() + "\" />\n    <property key=\"creation-datetime\" value=\"" + DateTime.now().toString() + "\" />\n  </properties>\n</image-metadata>");
        bufferedWriter.flush();
    }

    private static void writeXml(Document doc, OutputStream output) throws TransformerException {
        TransformerFactory transformerFactory = XmlTransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(output);
        transformer.transform(source, result);
    }

    public LoadfileItem getItem(String docId) {
        return this.topLevelItems.get(docId);
    }

    public Map<String, LoadfileItem> getTopLevelItems() {
        return this.topLevelItems;
    }

    public int getLoadFileFieldIndex(String fieldName) {
        LoadFileField field = this.loadFileFields.get(fieldName);
        if (field != null) {
            return field.getIndex();
        }
        return -1;
    }

    public Map<String, LoadFileField> getLoadFileFields() {
        return this.loadFileFields;
    }

    public LoadFileField getLoadFileField(String fieldName) {
        return this.loadFileFields.get(fieldName);
    }
}

