/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.loadfile;

import com.aspose.email.MailAddress;
import com.aspose.email.MailMessage;
import com.aspose.email.MapiMessage;
import com.aspose.email.SaveOptions;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.common.io.ByteStreams;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.exceptions.DocIdErrorListener;
import com.nuix.automate.workflow.core.utils.cds.CdsConversationMimeType;
import com.nuix.automate.workflow.core.utils.cds.CdsUtils;
import com.nuix.automate.workflow.core.utils.loadfile.LoadFileField;
import com.nuix.automate.workflow.core.utils.loadfile.Loadfile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class LoadfileItem {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LoadfileItem.class);
    public static String INTERNALLY_ENCODED_FS = "__0x2F__";
    public static String FS = "/";
    public static String URI_ENCODED_FS = "%2F";
    public static String URI_ENCODED_PERCENTAGE = "%25";
    public static String PERCENTAGE = "%";
    public static String HTTPS_PREFIX = "https://";
    public static String URI_ENCODED_HTTPS_PREFIX = "https%3A%2F%2F";
    protected String loadfileSender;
    protected String docId;
    protected String familyId;
    protected String location;
    protected List<String> fieldValues;
    protected Map<String, String> fieldValueMap;
    protected List<LoadfileItem> children;
    protected String fileClass;
    protected String name;
    protected String md5;
    protected String custodian;
    protected String mimeType;
    protected boolean convertToEml;
    protected Long size;
    protected Long crc;

    public static String encodeFs(String pathComponent) {
        return pathComponent.replace(FS, URI_ENCODED_FS);
    }

    public LoadfileItem(String docId, String familyId, String location, String fileClass, Map<String, String> fieldValueMap, boolean convertToEml) {
        this(docId, familyId, location, fileClass, null, null, null, null, convertToEml);
        this.fieldValueMap = fieldValueMap;
    }

    public LoadfileItem(String docId, String familyId, String location, String fileClass, List<String> fieldValues) {
        this(docId, familyId, location, fileClass, fieldValues, false);
    }

    public LoadfileItem(String docId, String familyId, String location, String fileClass, List<String> fieldValues, boolean convertToEml) {
        this(docId, familyId, location, fileClass, null, null, null, fieldValues, convertToEml);
    }

    public LoadfileItem(String docId, String familyId, String location, String fileClass, String md5, String custodian, String mimeType, List<String> fieldValues, boolean convertToEml) {
        this.docId = StringEscapeUtils.escapeXml11((String)docId);
        this.familyId = StringEscapeUtils.escapeXml11((String)familyId);
        this.location = location;
        this.location = this.location == null ? "/" : StringEscapeUtils.escapeXml11((String)location);
        this.fileClass = StringEscapeUtils.escapeXml11((String)fileClass);
        this.fieldValues = fieldValues;
        this.md5 = StringEscapeUtils.escapeXml11((String)md5);
        this.custodian = StringEscapeUtils.escapeXml11((String)custodian);
        this.mimeType = StringEscapeUtils.escapeXml11((String)mimeType);
        this.children = new ArrayList<LoadfileItem>();
        int pathLength = this.location.lastIndexOf(47);
        this.name = this.location.substring(pathLength + 1);
        this.convertToEml = convertToEml;
    }

    public String toString() {
        return "Loadfile Item (DocId: " + this.docId + ", Name: " + this.name + ")";
    }

    public void addChild(LoadfileItem child) {
        String updatedLocation = this.location + "/" + LoadfileItem.encodeFs(child.getName());
        if (!child.getLocation().equals(updatedLocation)) {
            child.setLocation(updatedLocation);
        }
        this.children.add(child);
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = StringEscapeUtils.escapeXml11((String)docId);
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public void setFamilyId(String familyId) {
        this.familyId = StringEscapeUtils.escapeXml11((String)familyId);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = StringEscapeUtils.escapeXml11((String)location);
    }

    public List getFieldValues() {
        return this.fieldValues;
    }

    public List<LoadfileItem> getChildren() {
        return this.children;
    }

    public void setFieldValues(List fieldValues) {
        this.fieldValues = fieldValues;
    }

    public Map<String, String> getFieldValueMap() {
        return this.fieldValueMap;
    }

    public void setFieldValueMap(Map<String, String> fieldValueMap) {
        this.fieldValueMap = fieldValueMap;
    }

    public String getLoadfileSender() {
        return this.loadfileSender;
    }

    public void setLoadfileSender(String loadfileSender) {
        this.loadfileSender = StringEscapeUtils.escapeXml11((String)loadfileSender);
    }

    protected void copyStreamAsEml(InputStream inputStream, ZipOutputStream zipOutputStream, String sender) throws IOException {
        MapiMessage mapiMessage = CdsUtils.loadEmail(inputStream);
        if (mapiMessage != null) {
            this.copyStreamAsEml(mapiMessage, zipOutputStream, sender, false, null);
        } else {
            LOGGER.error("Could not load mapi message");
        }
    }

    protected void copyStreamAsEml(MapiMessage mapiMessage, ZipOutputStream zipOutputStream, String sender, boolean stripAttachments, List<String> stubAttachmentNames) throws IOException {
        if (stripAttachments) {
            mapiMessage.getAttachments().clear();
        }
        if (stubAttachmentNames != null) {
            for (String stubAttachment : stubAttachmentNames) {
                mapiMessage.getAttachments().add(stubAttachment, new byte[]{64});
            }
        }
        if (sender != null) {
            mapiMessage.setSenderEmailAddress(sender);
            mapiMessage.setSentRepresentingEmailAddress(sender);
        }
        MailMessage mailMessage = null;
        ByteArrayOutputStream bOutput = new ByteArrayOutputStream();
        try {
            mapiMessage.save((OutputStream)bOutput, (SaveOptions)SaveOptions.getDefaultEml());
            ByteArrayInputStream bInput = new ByteArrayInputStream(bOutput.toByteArray());
            mailMessage = CdsUtils.loadMailMessage(bInput);
            mailMessage.setFrom(new MailAddress(sender));
            mailMessage.setSender(new MailAddress(sender));
        }
        catch (Throwable e) {
            LOGGER.error("Cannot reload email from EML", e);
        }
        this.saveMailStream(mapiMessage, mailMessage, zipOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMailStream(MapiMessage originalMapiMessage, MailMessage convertedMailMessage, ZipOutputStream outputStream) throws IOException {
        Throwable ex = null;
        ZipOutputStream zipOutputStream = outputStream;
        synchronized (zipOutputStream) {
            ZipEntry nativeFileContents = new ZipEntry("Native/" + this.docId);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                boolean emailSaved = false;
                if (convertedMailMessage != null) {
                    try {
                        convertedMailMessage.save((OutputStream)baos, (SaveOptions)SaveOptions.getDefaultEml());
                        emailSaved = true;
                    }
                    catch (Exception e) {
                        ex = e;
                    }
                }
                if (!emailSaved) {
                    try {
                        originalMapiMessage.save((OutputStream)baos, (SaveOptions)SaveOptions.getDefaultMsgUnicode());
                        ex = null;
                    }
                    catch (Exception e) {
                        ex = e;
                    }
                }
                CRC32 crc32 = new CRC32();
                crc32.update(baos.toByteArray(), 0, baos.size());
                this.crc = crc32.getValue();
                this.size = baos.size();
                nativeFileContents.setCrc(this.crc);
                nativeFileContents.setSize(this.size);
                nativeFileContents.setCompressedSize(this.size);
                outputStream.putNextEntry(nativeFileContents);
                outputStream.write(baos.toByteArray());
                outputStream.closeEntry();
            }
            catch (Throwable e) {
                ex = e;
            }
            finally {
                outputStream.closeEntry();
            }
        }
        if (ex != null) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMapiStream(MapiMessage message, ZipOutputStream outputStream, SaveOptions option) throws IOException {
        ZipOutputStream zipOutputStream = outputStream;
        synchronized (zipOutputStream) {
            ZipEntry nativeFileContents = new ZipEntry("Native/" + this.docId);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.save((OutputStream)baos, option);
            CRC32 crc32 = new CRC32();
            crc32.update(baos.toByteArray(), 0, baos.size());
            this.crc = crc32.getValue();
            this.size = baos.size();
            nativeFileContents.setCrc(this.crc);
            nativeFileContents.setSize(this.size);
            nativeFileContents.setCompressedSize(this.size);
            outputStream.putNextEntry(nativeFileContents);
            outputStream.write(baos.toByteArray());
            outputStream.closeEntry();
        }
    }

    protected synchronized void writeXml(Loadfile loadfile, Document xmlDocument, Element documentsXmlElement, String md5Hash, String extension, boolean skipNativeFile, boolean isDuplicateItem) {
        Element documentXmlElement = xmlDocument.createElement("Document");
        documentsXmlElement.appendChild(documentXmlElement);
        documentXmlElement.setAttribute("DocID", this.docId);
        if (this.mimeType != null) {
            documentXmlElement.setAttribute("MimeType", this.mimeType);
        }
        if (!this.convertToEml && extension != null && extension.endsWith(".msg")) {
            documentXmlElement.setAttribute("MimeType", "application/vnd.ms-outlook-note");
        }
        Element fieldValuesXmlDocument = this.createAndPopulateFieldValuesXmlElement(loadfile, xmlDocument, isDuplicateItem);
        documentXmlElement.appendChild(fieldValuesXmlDocument);
        Element locationsXmlDocument = xmlDocument.createElement("Locations");
        documentXmlElement.appendChild(locationsXmlDocument);
        Element locationXmlDocument = xmlDocument.createElement("Location");
        locationsXmlDocument.appendChild(locationXmlDocument);
        if (this.custodian != null && this.custodian.length() > 0) {
            Element custodianXmlDocument = xmlDocument.createElement("Custodian");
            custodianXmlDocument.setTextContent(this.custodian);
            locationXmlDocument.appendChild(custodianXmlDocument);
        }
        Element locationUriXmlDocument = xmlDocument.createElement("LocationURI");
        locationUriXmlDocument.setTextContent(this.patchLocation(this.location));
        locationXmlDocument.appendChild(locationUriXmlDocument);
        if (!skipNativeFile) {
            Element filesXmlDocument = xmlDocument.createElement("Files");
            documentXmlElement.appendChild(filesXmlDocument);
            Element fileXmlDocument = xmlDocument.createElement("File");
            fileXmlDocument.setAttribute("FileType", "Native");
            filesXmlDocument.appendChild(fileXmlDocument);
            Element externalFileXmlDocument = xmlDocument.createElement("ExternalFile");
            externalFileXmlDocument.setAttribute("FileName", this.docId);
            externalFileXmlDocument.setAttribute("FilePath", "Native");
            if (md5Hash != null) {
                externalFileXmlDocument.setAttribute("HashType", "MD5");
                externalFileXmlDocument.setAttribute("Hash", md5Hash);
            }
            fileXmlDocument.appendChild(externalFileXmlDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Loadfile loadfile, Document xmlDocument, Element documentsXmlElement, ZipOutputStream zipOutputStream, DocIdErrorListener errorListener) throws IOException {
        boolean shouldIgnoreNative;
        boolean resultOk = true;
        Exception ex = null;
        String md5Hash = null;
        try {
            block22: {
                try (InputStream inputStream = this.getInputStream();){
                    if (inputStream == null) break block22;
                    try {
                        if (this.convertToEml) {
                            this.copyStreamAsEml(inputStream, zipOutputStream, this.getLoadfileSender());
                        } else if (this.md5 != null && this.md5.length() > 0) {
                            md5Hash = this.md5;
                            if (inputStream != null) {
                                this.copyStream(inputStream, zipOutputStream);
                            }
                        } else if (inputStream != null) {
                            md5Hash = this.copyHashStream(inputStream, zipOutputStream);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot copy email stream", (Throwable)e);
                        ex = e;
                    }
                }
            }
            shouldIgnoreNative = CdsConversationMimeType.CHANNEL.getMimeType().equals(this.fileClass);
            this.writeXml(loadfile, xmlDocument, documentsXmlElement, md5Hash, null, shouldIgnoreNative, false);
        }
        catch (Exception e) {
            try {
                ex = e;
                shouldIgnoreNative = CdsConversationMimeType.CHANNEL.getMimeType().equals(this.fileClass);
                this.writeXml(loadfile, xmlDocument, documentsXmlElement, md5Hash, null, shouldIgnoreNative, false);
            }
            catch (Throwable throwable) {
                boolean shouldIgnoreNative2 = CdsConversationMimeType.CHANNEL.getMimeType().equals(this.fileClass);
                this.writeXml(loadfile, xmlDocument, documentsXmlElement, md5Hash, null, shouldIgnoreNative2, false);
                throw throwable;
            }
        }
        if (ex != null) {
            resultOk = false;
            if (errorListener != null) {
                errorListener.onError(this.docId, "Cannot package native file", ex, false);
            } else {
                LOGGER.warn("Cannot package native file for DocID " + this.docId, (Throwable)ex);
            }
        }
        for (LoadfileItem child : this.children) {
            boolean childResultOk = child.write(loadfile, xmlDocument, documentsXmlElement, zipOutputStream, errorListener);
            resultOk = resultOk && childResultOk;
        }
        return resultOk;
    }

    protected Element createAndPopulateFieldValuesXmlElement(Loadfile loadfile, Document xmlDocument, boolean isDuplicateItem) {
        Element fieldValuesXmlDocument = xmlDocument.createElement("FieldValues");
        Collection<LoadFileField> loadFileFields = loadfile.getLoadFileFields().values();
        for (LoadFileField loadFileField : loadFileFields) {
            String fieldValue = null;
            if (this.fieldValueMap != null) {
                fieldValue = StringEscapeUtils.escapeXml11((String)this.fieldValueMap.get(loadFileField.getName()));
            }
            if (fieldValue == null && this.fieldValues != null) {
                int fieldIndex = loadFileField.getIndex();
                if (fieldIndex >= this.fieldValues.size()) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Item " + this.docId + " does not have field " + loadFileField.getName());
                    continue;
                }
                fieldValue = StringEscapeUtils.escapeXml11((String)this.fieldValues.get(fieldIndex));
            }
            if (fieldValue == null || fieldValue.isEmpty() || isDuplicateItem && loadFileField.isLoadFileField()) continue;
            Element fieldXmlDocument = xmlDocument.createElement(loadFileField.getNormalizedFieldName());
            fieldXmlDocument.setTextContent(fieldValue);
            fieldValuesXmlDocument.appendChild(fieldXmlDocument);
        }
        return fieldValuesXmlDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String copyHashStream(InputStream inputStream, ZipOutputStream outputStream) throws IOException {
        HashingOutputStream hashingOutputStream = null;
        ZipOutputStream zipOutputStream = outputStream;
        synchronized (zipOutputStream) {
            try {
                ZipEntry nativeFileContents = new ZipEntry("Native/" + this.docId);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                hashingOutputStream = new HashingOutputStream(Hashing.md5(), (OutputStream)baos);
                this.crc = this.calculateCrcSize((OutputStream)hashingOutputStream, inputStream);
                this.size = baos.size();
                nativeFileContents.setCrc(this.crc);
                nativeFileContents.setSize(this.size);
                nativeFileContents.setCompressedSize(this.size);
                outputStream.putNextEntry(nativeFileContents);
                outputStream.write(baos.toByteArray());
            }
            finally {
                outputStream.closeEntry();
            }
        }
        return hashingOutputStream.hash().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyStream(InputStream inputStream, ZipOutputStream outputStream) throws IOException {
        ZipOutputStream zipOutputStream = outputStream;
        synchronized (zipOutputStream) {
            try {
                ZipEntry nativeFileContents = new ZipEntry("Native/" + this.docId);
                ByteArrayOutputStream baos = null;
                if (this.getCrc() == null || this.getSize() == null) {
                    baos = new ByteArrayOutputStream();
                    this.crc = this.calculateCrcSize(baos, inputStream);
                    this.size = baos.size();
                    nativeFileContents.setCrc(this.crc);
                    nativeFileContents.setSize(this.size);
                    nativeFileContents.setCompressedSize(this.size);
                } else {
                    nativeFileContents.setCrc(this.getCrc());
                    nativeFileContents.setSize(this.getSize());
                    nativeFileContents.setCompressedSize(this.getSize());
                }
                outputStream.putNextEntry(nativeFileContents);
                if (baos != null) {
                    outputStream.write(baos.toByteArray());
                } else {
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
            }
            finally {
                outputStream.closeEntry();
            }
        }
    }

    protected long calculateCrcSize(OutputStream baos, InputStream is) throws IOException {
        int read;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        while ((read = is.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
            crc.update(buffer, 0, read);
        }
        return crc.getValue();
    }

    public void writePathXml(Document xmlDocument, Element parentFolderXmlElement, String parentFolderName) {
        Element documentXmlElement = xmlDocument.createElement("Document");
        documentXmlElement.setAttribute("DocId", this.docId);
        parentFolderXmlElement.appendChild(documentXmlElement);
        if (this.children.size() > 0) {
            Element folderXmlElement = xmlDocument.createElement("Folder");
            folderXmlElement.setAttribute("FolderParentName", parentFolderName);
            folderXmlElement.setAttribute("FolderName", this.docId);
            parentFolderXmlElement.appendChild(folderXmlElement);
            for (LoadfileItem childItem : this.children) {
                childItem.writePathXml(xmlDocument, folderXmlElement, this.name);
            }
        }
    }

    protected String patchLocation(String location) {
        String[] locationSplits = ((String)location).split("/");
        ArrayList<String> normalizedSplits = new ArrayList<String>();
        for (String locationSplit : locationSplits) {
            try {
                normalizedSplits.add(URLDecoder.decode(locationSplit, "UTF-8"));
            }
            catch (Exception e) {
                normalizedSplits.add(locationSplit);
                LOGGER.debug("Cannot decode URI " + locationSplit, (Throwable)e);
            }
        }
        location = String.join((CharSequence)"/", normalizedSplits);
        location = ((String)location).replace(PERCENTAGE, URI_ENCODED_PERCENTAGE);
        if (((String)(location = ((String)location).replace(INTERNALLY_ENCODED_FS, URI_ENCODED_FS))).startsWith(HTTPS_PREFIX)) {
            location = URI_ENCODED_HTTPS_PREFIX + ((String)location).substring(HTTPS_PREFIX.length());
        }
        return location;
    }

    public String getName() {
        return this.name;
    }

    public abstract InputStream getInputStream() throws IOException;

    public Long getSize() throws IOException {
        return this.size;
    }

    public Long getCrc() throws IOException {
        return this.crc;
    }
}

