/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.loadfile;

import com.nuix.automate.workflow.core.utils.loadfile.LoadfileItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PathItem {
    private String folderName;
    private Map<String, PathItem> subFolders;
    private List<LoadfileItem> loadfileItems;

    public PathItem(String folderName) {
        this.folderName = folderName;
        this.subFolders = new HashMap<String, PathItem>();
        this.loadfileItems = new ArrayList<LoadfileItem>();
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public Map<String, PathItem> getSubFolders() {
        return this.subFolders;
    }

    public void setSubFolders(Map<String, PathItem> subFolders) {
        this.subFolders = subFolders;
    }

    public List<LoadfileItem> getLoadfileItems() {
        return this.loadfileItems;
    }

    public void setLoadfileItems(List<LoadfileItem> loadfileItems) {
        this.loadfileItems = loadfileItems;
    }

    public void writePathXml(Document xmlDocument, Element parentFolderXmlElement, String parentFolderName) {
        Element folderXmlElement = xmlDocument.createElement("Folder");
        folderXmlElement.setAttribute("FolderName", this.folderName);
        folderXmlElement.setAttribute("FolderParentName", parentFolderName);
        parentFolderXmlElement.appendChild(folderXmlElement);
        for (PathItem subFolder : this.subFolders.values()) {
            subFolder.writePathXml(xmlDocument, folderXmlElement, this.folderName);
        }
        for (LoadfileItem loadfileItem : this.loadfileItems) {
            loadfileItem.writePathXml(xmlDocument, folderXmlElement, this.folderName);
        }
    }
}

