/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.memgraph;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.workflow.core.utils.general.ThirdPartyProxyRestClient;
import com.nuix.automate.workflow.core.utils.memgraph.MemgraphJobInfo;
import jakarta.ws.rs.core.GenericType;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;

public class GraphServiceRestClient
extends ThirdPartyProxyRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GraphServiceRestClient.class);

    public GraphServiceRestClient(String thirdPartyServiceId, String schedulerUrl, String bearerToken, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        super(thirdPartyServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
    }

    @Override
    public String getLogFileName() {
        return System.getProperty("automate.graphservice.log");
    }

    @Override
    public String getServiceName() {
        return "Graph Service";
    }

    public Integer requestMemgraphLock(MemgraphJobInfo memgraphJobInfo) throws IOException {
        LOGGER.debug("Calling Memgraph Service on case " + memgraphJobInfo.getCaseId() + " for job " + memgraphJobInfo.getJobId());
        ApiProxyRequest apiProxyRequest = new ApiProxyRequest();
        apiProxyRequest.setBody((Object)memgraphJobInfo);
        Integer response = this.proxyApiRequest(apiProxyRequest, new GenericType<Integer>(){});
        return response;
    }
}

