/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nlp;

import com.google.gson.Gson;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.NlpService;
import com.nuix.automate.utils.models.api.thirdparty.NlpUserCredential;
import com.nuix.automate.workflow.core.utils.nlp.NlpApiToken;
import com.nuix.automate.workflow.core.utils.nlp.NlpSsoResponse;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.MethodNotSupportedException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class NlpRestClient
implements AutoCloseable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NlpRestClient.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private String apiToken;
    private String accessToken;
    private Client client;
    private Gson gson;
    private boolean usingCustomFingerprint = false;
    private LogChannel logChannel;
    private transient LogHandler logHandler;
    private String url;
    private String feedsApiUrl;
    private String jobControlUrl;
    private String clientName;

    public NlpRestClient(String uid, String url, String feedsApiUrl, String jobControlUrl, String apiToken, Set<String> whitelistedCertificateFingerprints, LogChannel logChannel) throws GeneralSecurityException {
        this.logChannel = logChannel;
        this.apiToken = apiToken;
        this.url = url;
        this.feedsApiUrl = feedsApiUrl;
        this.jobControlUrl = jobControlUrl;
        this.clientName = "nlp-api" + uid;
        this.client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)this.clientName, whitelistedCertificateFingerprints, (boolean)false);
        if (whitelistedCertificateFingerprints != null) {
            for (String fingerprint : whitelistedCertificateFingerprints) {
                if (fingerprint == null || fingerprint.trim().length() <= 0) continue;
                this.usingCustomFingerprint = true;
                break;
            }
        }
        this.gson = new Gson();
        this.logHandler = LogHandler.getInstance();
        try {
            this.retrieveAccessToken();
        }
        catch (IOException e) {
            LOGGER.error("Cannot retrieve NLP access token", (Throwable)e);
        }
    }

    public NlpRestClient(String uid, NlpService nlpService, NlpUserCredential userCredential, LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        this(uid, nlpService.getUrl(), nlpService.getEffectiveFeedsApiUrl(), nlpService.getEffectiveJobControlUrl(), userCredential.getToken(), whitelistedCertFingerprints, logChannel);
    }

    @Override
    public void close() {
        block3: {
            try {
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Unable to close client", (Throwable)e);
            }
        }
    }

    public <ResponseType, RequestType> ResponseType callApi(String url, String logUrl, String method, RequestType requestData, GenericType<ResponseType> entityType) throws IOException {
        LOGGER.info(method + " " + logUrl);
        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent(method + " " + logUrl));
        this.logHandler.addLogEvent(this.logChannel.getLogEvent(this.gson.toJson(requestData) + "\n"));
        try (Response response = null;){
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.accessToken));
            String logFileName = System.getProperty("automate.nlp.log");
            File logFile = null;
            if (logFileName != null) {
                logFile = new File(logFileName);
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(method + " " + logUrl + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)this.gson.toJson(requestData), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Nlp log", (Throwable)e);
                }
            }
            switch (method) {
                case "POST": {
                    response = invocationBuilder.post(Entity.entity(requestData, (String)"application/json"));
                    break;
                }
                case "PUT": {
                    response = invocationBuilder.put(Entity.entity(requestData, (String)"application/json"));
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API with body");
                }
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write NLP log", (Throwable)e);
                }
            }
            String stringResponse = (String)response.readEntity(String.class);
            this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent("HTTP/" + response.getStatus()));
            this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
            this.logHandler.addLogEvent(this.logChannel.getSeparator());
            String errorMessage = this.iu.getFormattedString("NlpRestClient.Error.ApiError", new Object[]{"HTTP/" + response.getStatus(), method + " " + logUrl});
            if (response.getStatus() == 401) {
                throw new IOException(errorMessage);
            }
            if (response.getStatus() == 403) {
                throw new IOException(errorMessage);
            }
            if (response.getStatus() == 404) {
                throw new NotFoundException(errorMessage);
            }
            if (response.getStatus() == 405) {
                throw new MethodNotSupportedException(errorMessage);
            }
            if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 202) {
                LOGGER.error(method + ": " + this.gson.toJson(requestData));
                LOGGER.error(url + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                if (logFile != null) {
                    try {
                        FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                        FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write Nlp log", (Throwable)e);
                    }
                }
                throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
            }
            Object responseData = entityType.getType().equals(String.class) ? stringResponse : SerializationUtils.fromJson((String)stringResponse, (Class)entityType.getRawType());
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Nlp log", (Throwable)e);
                }
            }
            Object object = responseData;
            return (ResponseType)object;
        }
    }

    public <ResponseType, RequestType> ResponseType callApiUrlEncoded(String url, String method, Form form, GenericType<ResponseType> entityType) throws IOException {
        LOGGER.info(method + " " + url);
        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent(method + " " + url + "\n"));
        try (Response response = null;){
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/x-www-form-urlencoded"});
            String logFileName = System.getProperty("automate.nlp.log");
            File logFile = null;
            if (logFileName != null) {
                logFile = new File(logFileName);
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(method + " " + url + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Nlp log", (Throwable)e);
                }
            }
            switch (method) {
                case "POST": {
                    response = invocationBuilder.post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
                    break;
                }
                case "PUT": {
                    response = invocationBuilder.put(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API with body");
                }
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write NLP log", (Throwable)e);
                }
            }
            String stringResponse = (String)response.readEntity(String.class);
            this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent("HTTP/" + response.getStatus()));
            String errorMessage = this.iu.getFormattedString("NlpRestClient.Error.ApiError", new Object[]{"HTTP/" + response.getStatus(), method + " " + url});
            if (response.getStatus() == 401) {
                this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                this.logHandler.addLogEvent(this.logChannel.getSeparator());
                throw new IOException(errorMessage);
            }
            if (response.getStatus() == 403) {
                this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                this.logHandler.addLogEvent(this.logChannel.getSeparator());
                throw new IOException(this.iu.getString("NlpRestClient.Error.PermissionDenied"));
            }
            if (response.getStatus() == 404) {
                this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                this.logHandler.addLogEvent(this.logChannel.getSeparator());
                throw new NotFoundException(errorMessage);
            }
            if (response.getStatus() == 405) {
                this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                this.logHandler.addLogEvent(this.logChannel.getSeparator());
                throw new MethodNotSupportedException(errorMessage);
            }
            if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 202) {
                this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                this.logHandler.addLogEvent(this.logChannel.getSeparator());
                if (logFile != null) {
                    try {
                        FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                        FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write Nlp log", (Throwable)e);
                    }
                }
                LOGGER.error(method + ": " + url + "\nBody: " + this.gson.toJson((Object)form));
                LOGGER.error(url + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
            }
            this.logHandler.addLogEvent(this.logChannel.getLogEvent("\n"));
            this.logHandler.addLogEvent(this.logChannel.getSeparator());
            Object responseData = entityType.getType().equals(String.class) ? stringResponse : SerializationUtils.fromJson((String)stringResponse, (Class)entityType.getRawType());
            String string = responseData;
            return (ResponseType)string;
        }
    }

    public <ResponseType, RequestType> ResponseType callApi(String url, String logUrl, String method, GenericType<ResponseType> entityType) throws IOException {
        LOGGER.info(method + " " + logUrl);
        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent(method + " " + logUrl + "\n"));
        try (Response response = null;){
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.accessToken));
            String logFileName = System.getProperty("automate.nlp.log");
            File logFile = null;
            if (logFileName != null) {
                logFile = new File(logFileName);
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(method + " " + logUrl + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Nlp log", (Throwable)e);
                }
            }
            switch (method) {
                case "GET": {
                    response = invocationBuilder.get();
                    break;
                }
                case "DELETE": {
                    response = invocationBuilder.delete();
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API without body");
                }
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write NLP log", (Throwable)e);
                }
            }
            String stringResponse = (String)response.readEntity(String.class);
            this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent("HTTP/" + response.getStatus()));
            this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
            this.logHandler.addLogEvent(this.logChannel.getSeparator());
            String errorMessage = this.iu.getFormattedString("NlpRestClient.Error.ApiError", new Object[]{"HTTP/" + response.getStatus(), method + " " + logUrl});
            if (response.getStatus() == 401) {
                throw new IOException(errorMessage);
            }
            if (response.getStatus() == 403) {
                throw new IOException(this.iu.getString("NlpRestClient.Error.PermissionDenied"));
            }
            if (response.getStatus() == 404) {
                throw new NotFoundException(errorMessage);
            }
            if (response.getStatus() == 405) {
                throw new MethodNotSupportedException(errorMessage);
            }
            if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 202) {
                LOGGER.error(method + ": " + logUrl);
                LOGGER.error(url + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                if (logFile != null) {
                    try {
                        FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                        FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write NLP log", (Throwable)e);
                    }
                }
                throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
            }
            Object responseData = entityType.getType().equals(String.class) ? stringResponse : SerializationUtils.fromJson((String)stringResponse, (Class)entityType.getRawType());
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Nlp log", (Throwable)e);
                }
            }
            Object object = responseData;
            return (ResponseType)object;
        }
    }

    public void retrieveAccessToken() throws IOException {
        NlpApiToken nlpApiToken;
        String decodedApiToken;
        try {
            decodedApiToken = new String(Base64.getDecoder().decode(this.apiToken), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Cannot decode API token", (Throwable)e);
            throw new IOException(this.iu.getString("NlpRestClient.Error.InvalidApiToken"));
        }
        try {
            nlpApiToken = (NlpApiToken)this.gson.fromJson(decodedApiToken, NlpApiToken.class);
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse API token", (Throwable)e);
            throw new IOException(this.iu.getString("NlpRestClient.Error.InvalidApiToken"));
        }
        String tokenHostname = "Unknown";
        HashSet<String> serviceHostnamesLower = new HashSet<String>();
        try {
            tokenHostname = FormattingUtils.getHostnameFromUrl((String)nlpApiToken.getApiUrl());
            if (this.url != null) {
                serviceHostnamesLower.add(FormattingUtils.getHostnameFromUrl((String)this.url).toLowerCase());
            }
            serviceHostnamesLower.add(FormattingUtils.getHostnameFromUrl((String)this.feedsApiUrl).toLowerCase());
            if (this.jobControlUrl != null) {
                serviceHostnamesLower.add(FormattingUtils.getHostnameFromUrl((String)this.jobControlUrl).toLowerCase());
            }
        }
        catch (URISyntaxException e) {
            LOGGER.error("Cannot parse hostname from URL", (Throwable)e);
        }
        if (!serviceHostnamesLower.contains(tokenHostname)) {
            throw new IOException(this.iu.getFormattedString("NlpRestClient.Error.InvalidHostname", new Object[]{tokenHostname, String.join((CharSequence)", ", serviceHostnamesLower)}));
        }
        Form form = new Form();
        form.param("client_id", nlpApiToken.getClientId());
        form.param("grant_type", "client_credentials");
        form.param("client_secret", nlpApiToken.getClientSecret());
        NlpSsoResponse response = this.callApiUrlEncoded(nlpApiToken.getTokenUrl(), "POST", form, new GenericType<NlpSsoResponse>(){});
        if (response == null || response.getAccess_token() == null) {
            throw new IOException(this.iu.getString("NlpRestClient.Error.InvalidApiSsoResponse"));
        }
        this.accessToken = response.getAccess_token();
    }

    public String getUrl() {
        return this.url;
    }

    public String getFeedsApiUrl() {
        return this.feedsApiUrl;
    }
}

