/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.nuix.Folder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CaseFolders {
    public static final String METADATA_FOLDER_NAME_PREFIX = "security_name_";
    public static final String METADATA_FOLDER_GROUPS_PREFIX = "security_list_";
    public static final String METADATA_FOLDER_ITEM_ASSIGNMENT_PREFIX = "folder_security_";
    private final Map<String, Folder> foldersById = new HashMap<String, Folder>();
    private final Map<String, Folder> foldersByName = new HashMap<String, Folder>();
    private final ExecutionContext executionContext;

    public CaseFolders(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        for (Map.Entry entry : executionContext.nuixCase.getCustomMetadata().entrySet()) {
            String folderId;
            if (((String)entry.getKey()).startsWith(METADATA_FOLDER_NAME_PREFIX)) {
                String folderName = entry.getValue().toString();
                folderId = ((String)entry.getKey()).substring(METADATA_FOLDER_NAME_PREFIX.length());
                Folder caseFolder = this.getFolderWithId(folderId);
                if (caseFolder == null) {
                    this.trackExistingFolder(new Folder(folderId, folderName));
                } else {
                    caseFolder.setName(folderName);
                }
            }
            if (!((String)entry.getKey()).startsWith(METADATA_FOLDER_GROUPS_PREFIX)) continue;
            String groupIdsJson = entry.getValue().toString();
            folderId = ((String)entry.getKey()).substring(METADATA_FOLDER_GROUPS_PREFIX.length());
            Integer[] groupIds = (Integer[])SerializationUtils.fromJson((String)groupIdsJson, Integer[].class);
            Folder caseFolder = this.getFolderWithId(folderId);
            if (caseFolder == null) {
                caseFolder = new Folder(folderId, null);
                this.trackExistingFolder(caseFolder);
            }
            caseFolder.getGroupIds().clear();
            caseFolder.getGroupIds().addAll(Arrays.asList(groupIds));
        }
    }

    public Folder getFolderWithId(String id) {
        return this.foldersById.get(id);
    }

    public Folder getFolderWithName(String name) {
        return this.foldersByName.get(name);
    }

    public void trackExistingFolder(Folder folder) {
        this.foldersByName.put(folder.getName(), folder);
        this.foldersByName.put(folder.getId(), folder);
    }

    public Folder createFolder(String folderName) {
        if (this.foldersByName.containsKey(folderName)) {
            throw new IllegalArgumentException("Case folder " + folderName + " already exists");
        }
        Folder folder = new Folder(UidUtils.getRandom(), folderName);
        this.executionContext.nuixCase.getCustomMetadata().put(METADATA_FOLDER_NAME_PREFIX + folder.getId(), (Object)folder.getName(), "text", "api", null);
        this.trackExistingFolder(folder);
        return folder;
    }
}

