/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import java.util.List;
import java.util.Set;
import nuix.Item;
import nuix.MetadataItem;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ComparableMetadataFieldItem
implements Comparable<ComparableMetadataFieldItem> {
    public Item item;
    public List<MetadataItem> metadata;
    public Set<String> rubyFieldNames;
    public Object[] cachedValues;

    public ComparableMetadataFieldItem(Item item, List<MetadataItem> metadata, Set<String> rubyFieldNames) {
        this.item = item;
        this.metadata = metadata;
        this.cachedValues = new Object[metadata.size()];
        this.rubyFieldNames = rubyFieldNames;
    }

    private int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable oc1 = (Comparable)o1;
            Comparable oc2 = (Comparable)o2;
            return ObjectUtils.compare((Comparable)oc1, (Comparable)oc2);
        }
        return 0;
    }

    public Object getEvaluatedMetadataValue(int metadataItemPosition) {
        if (this.cachedValues[metadataItemPosition] == null) {
            try {
                this.cachedValues[metadataItemPosition] = MetadataItemUtils.evaluateUnformatted(this.metadata.get(metadataItemPosition), this.item, this.rubyFieldNames);
            }
            catch (Exception e) {
                this.cachedValues[metadataItemPosition] = null;
            }
        }
        return this.cachedValues[metadataItemPosition];
    }

    @Override
    public int compareTo(@NotNull ComparableMetadataFieldItem o) {
        for (int i = 0; i < this.metadata.size(); ++i) {
            int result = this.compare(this.getEvaluatedMetadataValue(i), o.getEvaluatedMetadataValue(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

