/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.AddToProductionSetOperation;
import com.nuix.automate.workflow.core.execution.options.sorting.SortDirection;
import com.nuix.automate.workflow.core.execution.options.sorting.SortField;
import com.nuix.automate.workflow.core.utils.nuix.ComparableArray;
import java.util.List;
import nuix.Item;
import nuix.ItemExpression;

public class CustomFieldsItemExpression
implements ItemExpression {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddToProductionSetOperation.class);
    SortDirection[] sortDirections;
    SortField[] sortFields;

    public CustomFieldsItemExpression(List<Object[]> sortFieldsList) {
        this.sortDirections = new SortDirection[sortFieldsList.size()];
        this.sortFields = new SortField[sortFieldsList.size()];
        for (int i = 0; i < sortFieldsList.size(); ++i) {
            this.sortFields[i] = (SortField)((Object)sortFieldsList.get(i)[0]);
            this.sortDirections[i] = (SortDirection)((Object)sortFieldsList.get(i)[1]);
        }
    }

    public Object evaluate(Item item) {
        Object[] data = new Object[this.sortFields.length];
        for (int i = 0; i < this.sortFields.length; ++i) {
            Object dataItem = null;
            switch (this.sortFields[i]) {
                case POSITION: {
                    dataItem = item.getPosition();
                    break;
                }
                case TOP_LEVEL_ITEM_DATE: {
                    dataItem = item.getTopLevelItemDate();
                    break;
                }
                case ITEM_DATE: {
                    dataItem = item.getDate();
                    break;
                }
                case TOP_LEVEL_PATH_NAME: {
                    Item topLevelItem1 = item.getTopLevelItem();
                    if (topLevelItem1 != null) {
                        topLevelItem1 = (Item)topLevelItem1.getParent();
                    }
                    if (topLevelItem1 == null) break;
                    dataItem = String.join((CharSequence)"/", topLevelItem1.getPathNames());
                    break;
                }
                case PATH_NAME: {
                    Item scopeItem = (Item)item.getParent();
                    if (scopeItem == null) break;
                    dataItem = String.join((CharSequence)"/", scopeItem.getPathNames());
                    break;
                }
                case TOP_LEVEL_EFFECTIVE_PATH_NAME: {
                    Item scopeItem = item.getTopLevelItem();
                    if (scopeItem != null) {
                        scopeItem = (Item)scopeItem.getParent();
                    }
                    if (scopeItem == null) break;
                    if (scopeItem.getType().getName().equals("application/vnd.ms-outlook-msg")) {
                        scopeItem = (Item)scopeItem.getParent();
                    }
                    dataItem = String.join((CharSequence)"/", scopeItem.getPathNames());
                    break;
                }
                case EFFECTIVE_PATH_NAME: {
                    Item scopeItem = (Item)item.getParent();
                    if (scopeItem == null) break;
                    if (scopeItem.getType().getName().equals("application/vnd.ms-outlook-msg")) {
                        scopeItem = (Item)scopeItem.getParent();
                    }
                    dataItem = String.join((CharSequence)"/", scopeItem.getPathNames());
                }
            }
            data[i] = dataItem;
        }
        return new ComparableArray(data, this.sortDirections);
    }
}

