/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.derbycontrol.DerbyControlCaseInfo;
import com.nuix.automate.workflow.core.utils.derbycontrol.DerbyControlServiceRestClient;
import com.nuix.automate.workflow.core.utils.nuix.CaseType;
import com.nuix.automate.workflow.core.utils.nuix.NuixCaseUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;
import nuix.Case;
import nuix.CaseFactory;

public class DerbyControlUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DerbyControlUtils.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private DerbyControlServiceRestClient derbyControlServiceClient;
    private Operation operation;
    private ExecutionContext executionContext;

    public DerbyControlUtils(ExecutionContext executionContext, Operation operation) {
        this.executionContext = executionContext;
        this.operation = operation;
        this.initializeDerbyControlServiceClient();
    }

    protected void initializeDerbyControlServiceClient() {
        try {
            String derbyControlServiceId = this.executionContext.evalParametersIfSet("{derby_control_service_id}", this.operation);
            String schedulerUrl = this.executionContext.evalParametersIfSet("{scheduler_url}", this.operation).trim();
            String bearerToken = this.executionContext.evalProtectedParameter("{job_bearer_token_protected}").trim();
            HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
            try {
                whitelistedCertFingerprints.add(this.executionContext.evalParametersIfSet("{scheduler_cert_fingerprint}", this.operation).trim());
            }
            catch (ParameterException e) {
                LOGGER.info("Not using custom Scheduler cert fingerprint", (Throwable)e);
            }
            this.derbyControlServiceClient = new DerbyControlServiceRestClient(derbyControlServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
            this.derbyControlServiceClient.setReattemptEnabled(false);
            this.derbyControlServiceClient.setOperation(this.operation);
        }
        catch (ParameterException | GeneralSecurityException e) {
            LOGGER.info("Not using Derby Control Service, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false));
        }
    }

    private boolean callDerbyControlOnSimpleCase(String location) throws IOException {
        LOGGER.info("Handling simple case at " + location);
        String caseGuid = NuixCaseUtils.getNuixCaseGuid(location);
        if (this.executionContext.nuixVersion.compareTo(new Version(100, 0, "")) < 0) {
            this.operation.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Warning.SkipDerbyControlService", (Object)this.executionContext.nuixVersion));
            return false;
        }
        if (caseGuid == null) {
            LOGGER.info("Skipping Derby Control Service because case GUID cannot be extracted");
            throw new IOException("Cannot detect case GUID");
        }
        try {
            DerbyControlCaseInfo derbyControlCaseInfo = new DerbyControlCaseInfo(caseGuid, location);
            this.derbyControlServiceClient.callDerbyControlService(derbyControlCaseInfo);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Cannot warm-up Derby Control Service", (Throwable)e);
            throw new IOException(e);
        }
    }

    public void prepareExistingCase(String location) {
        if (this.derbyControlServiceClient != null) {
            CaseType caseType = NuixCaseUtils.getNuixCaseType(location);
            if (caseType == null) {
                LOGGER.warn("Cannot prepare case because case type cannot be determined");
            } else {
                boolean success = false;
                if (caseType.equals((Object)CaseType.COMPOUND)) {
                    LOGGER.info("Handling compound case");
                    List<Path> subCases = NuixCaseUtils.getNuixSubCasePaths(location);
                    LOGGER.info("Detected " + subCases.size() + " subcases");
                    success = true;
                    for (Path subCase : subCases) {
                        boolean subcaseSuccess = false;
                        try {
                            subcaseSuccess = this.callDerbyControlOnSimpleCase(subCase.toString());
                        }
                        catch (IOException e) {
                            this.operation.addWarning(this.iu.getFormattedString("UseCaseOperation.Warning.CannotUseDerbyControlServiceException", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                        }
                        success = success && subcaseSuccess;
                    }
                } else {
                    try {
                        success = this.callDerbyControlOnSimpleCase(location);
                    }
                    catch (IOException e) {
                        this.operation.addWarning(this.iu.getFormattedString("UseCaseOperation.Warning.CannotUseDerbyControlServiceException", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                    }
                }
                if (success) {
                    this.operation.addExecutionLog(this.iu.getString("UseCaseOperation.Log.CaseEnabledForSimultaneousAccess"));
                }
            }
        }
    }

    public Case reopenCreatedCase(Case nuixCase, CaseFactory caseFactory) throws IOException {
        if (this.derbyControlServiceClient != null) {
            if (this.executionContext.nuixVersion.compareTo(new Version(100, 0, "")) < 0) {
                LOGGER.info("Skipping Derby Control Service because Nuix Version is not Neo");
                this.operation.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Warning.SkipDerbyControlService", (Object)this.executionContext.nuixVersion));
                return nuixCase;
            }
            Version nuixCaseVersion = new Version(NuixCaseUtils.getNuixCaseVersion(nuixCase.getLocation().getAbsolutePath()));
            if (nuixCaseVersion.compareTo(new Version(100, 0, "")) < 0) {
                LOGGER.info("Skipping Derby Control Service because case is not a Neo case");
                this.operation.addExecutionLog(this.iu.getFormattedString("UseCaseOperation.Warning.SkipDerbyControlService", (Object)this.executionContext.nuixVersion));
                return nuixCase;
            }
            Path nuixCasePath = Paths.get(nuixCase.getLocation().getPath(), new String[0]);
            if (nuixCase.isCompound()) {
                LOGGER.info("Skipping Derby Control Service because case is compound");
                return nuixCase;
            }
            LOGGER.info("Closing case ...");
            DerbyControlCaseInfo derbyControlCaseInfo = new DerbyControlCaseInfo(nuixCase.getGuid(), nuixCase.getLocation().toString());
            nuixCase.close();
            try {
                LOGGER.info("Calling Derby Control Service ...");
                this.derbyControlServiceClient.callDerbyControlService(derbyControlCaseInfo);
                this.operation.addExecutionLog(this.iu.getString("UseCaseOperation.Log.CaseEnabledForSimultaneousAccess"));
            }
            catch (Exception e) {
                LOGGER.error("Cannot warm-up Derby Control Service", (Throwable)e);
                this.operation.addWarning(this.iu.getString("UseCaseOperation.Warning.CannotUseDerbyControlService"));
            }
            LOGGER.info("Re-opening case ...");
            nuixCase = caseFactory.open(nuixCasePath.toString());
            return nuixCase;
        }
        return nuixCase;
    }
}

