/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.investigate.Group;
import com.nuix.automate.workflow.core.utils.investigate.InvestigateServiceRestClient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;

public class InvestigateUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(InvestigateUtils.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private InvestigateServiceRestClient investigateServiceClient;
    private Operation operation;
    private ExecutionContext executionContext;

    public InvestigateUtils(ExecutionContext executionContext, Operation operation) throws IOException {
        this.executionContext = executionContext;
        this.operation = operation;
        this.initializeInvestigateServiceClient();
    }

    protected void initializeInvestigateServiceClient() throws IOException {
        String investigateServiceId;
        try {
            investigateServiceId = this.executionContext.evalParametersIfSet("{investigate_service_id}", this.operation);
        }
        catch (ParameterException e) {
            LOGGER.error("Cannot evaluate Investigate parameter", (Throwable)e);
            throw new IOException(this.iu.getString("InvestigateService.Error.MissingInvestigateService"));
        }
        try {
            String schedulerUrl = this.executionContext.evalParametersIfSet("{scheduler_url}", this.operation).trim();
            String bearerToken = this.executionContext.evalProtectedParameter("{job_bearer_token_protected}").trim();
            HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
            try {
                whitelistedCertFingerprints.add(this.executionContext.evalParametersIfSet("{scheduler_cert_fingerprint}", this.operation).trim());
            }
            catch (ParameterException e) {
                LOGGER.info("Not using custom Scheduler cert fingerprint", (Throwable)e);
            }
            this.investigateServiceClient = new InvestigateServiceRestClient(investigateServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
            this.investigateServiceClient.setReattemptEnabled(false);
            this.investigateServiceClient.setOperation(this.operation);
        }
        catch (ParameterException | GeneralSecurityException e) {
            LOGGER.error("Cannot setup Investigate service", e);
            throw new IOException(this.iu.getFormattedString("InvestigateService.Error.GenericError", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false)));
        }
    }

    public List<Group> getGroups() throws IOException {
        try {
            LOGGER.info("Getting Investigate groups");
            return this.investigateServiceClient.getGroups();
        }
        catch (Exception e) {
            LOGGER.error("Error getting Investigate groups", (Throwable)e);
            throw new IOException(this.iu.getFormattedString("InvestigateService.Error.ApiError", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false)));
        }
    }

    public void addGroupToCase(Integer groupId, String caseGuid) throws IOException {
        try {
            LOGGER.info("Adding Investigate group " + groupId + " to " + caseGuid);
            this.investigateServiceClient.addGroupToCase(groupId, caseGuid);
        }
        catch (Exception e) {
            LOGGER.error("Error getting Investigate groups", (Throwable)e);
            throw new IOException(this.iu.getFormattedString("InvestigateService.Error.ApiError", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false)));
        }
    }
}

