/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import java.util.HashMap;
import java.util.HashSet;
import nuix.EvidenceContainer;
import nuix.locations.AwsLocation;
import nuix.locations.EnterpriseVaultLocation;
import nuix.locations.ExchangeWSLocation;
import nuix.locations.Location;
import nuix.locations.LocationFactory;
import nuix.locations.OracleServerLocation;
import nuix.locations.SharePointLocation;
import nuix.locations.SlackLocation;
import nuix.locations.SqlServerLocation;
import nuix.locations.SshLocation;
import nuix.locations.TwitterHistoricalLocation;
import org.joda.time.DateTime;

public class NetworkSourceUtils {
    protected static transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");

    public static void addS3Evidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        String s3_bucket;
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        AwsLocation location = locationFactory.makeAmazonS3Location();
        String s3_access = executionContext.evalStringParameter("{s3_access}", currentOperation);
        if (s3_access != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.S3AccessKey", (Object)s3_access));
            String s3_secret = executionContext.evalProtectedParameter("{s3_secret_protected}");
            if (s3_secret.equals("{s3_secret_protected}") || s3_secret.length() == 0) {
                throw new ParameterException("Parameter {s3_secret_protected} not defined");
            }
            location = location.withAccess(s3_access, s3_secret.toCharArray());
        } else {
            Boolean s3_credential_discovery = executionContext.evalBooleanParameter("{s3_credential_discovery_boolean}", currentOperation);
            if (s3_credential_discovery != null && s3_credential_discovery.booleanValue()) {
                currentOperation.addExecutionLog(iu.getString("AddEvidenceOperation.Log.S3CredentialDiscovery"));
                location = location.withCredentialDiscovery();
            }
        }
        String s3_endpoint = executionContext.evalStringParameter("{s3_endpoint}", currentOperation);
        if (s3_endpoint != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.S3Endpoint", (Object)s3_endpoint));
            location = location.withEndpoint(s3_endpoint);
        }
        if ((s3_bucket = executionContext.evalStringParameter("{s3_bucket}", currentOperation)) != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.S3Bucket", (Object)s3_bucket));
            location = location.withBucket(s3_bucket);
        }
        evidenceContainer.addLocation((Location)location);
    }

    public static void addSharepointEvidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        String sharepoint_uri = executionContext.evalStringParameter("{sharepoint_uri}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SharePointUri", (Object)sharepoint_uri));
        String sharepoint_domain = executionContext.evalStringParameter("{sharepoint_domain}", currentOperation);
        if (sharepoint_domain != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SharePointDomain", (Object)sharepoint_domain));
        }
        String sharepoint_username = executionContext.evalStringParameter("{sharepoint_username}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SharePointUsername", (Object)sharepoint_username));
        String sharepoint_password = executionContext.evalProtectedStringParameter("{sharepoint_password}", currentOperation);
        SharePointLocation location = locationFactory.makeSharePointLocation(sharepoint_uri, sharepoint_domain, sharepoint_username, sharepoint_password.toCharArray());
        evidenceContainer.addLocation((Location)location);
    }

    public static void addExchangeEvidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        String exchange_mailbox_retrieval;
        String exchange_mailbox;
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        String exchange_uri = executionContext.evalStringParameter("{exchange_uri}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.ExchangeUri", (Object)exchange_uri));
        String exchange_domain = executionContext.evalStringParameter("{exchange_domain}", currentOperation);
        if (exchange_domain != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.ExchangeDomain", (Object)exchange_domain));
        }
        String exchange_username = executionContext.evalStringParameter("{exchange_username}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.ExchangeUsername", (Object)exchange_username));
        String exchange_password = executionContext.evalProtectedStringParameter("{exchange_password}", currentOperation);
        ExchangeWSLocation location = locationFactory.makeExchangeServerLocation(exchange_uri, exchange_domain, exchange_username, exchange_password.toCharArray());
        Boolean exchange_impersonation = executionContext.evalBooleanParameter("{exchange_impersonating}", currentOperation);
        if (exchange_impersonation != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.ExchangeImpersonation", (Object)exchange_impersonation));
            if (exchange_impersonation.booleanValue()) {
                location = location.withImpersonation();
            }
        }
        if ((exchange_mailbox = executionContext.evalStringParameter("{exchange_mailbox}", currentOperation)) != null) {
            location = location.withMailbox(exchange_mailbox);
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.ExchangeMailbox", (Object)exchange_mailbox));
        }
        if ((exchange_mailbox_retrieval = executionContext.evalStringParameter("{exchange_mailbox_retrieval}", currentOperation)) != null) {
            String[] retrievalSplits = exchange_mailbox_retrieval.split(",");
            HashSet<String> retrievals = new HashSet<String>();
            for (String retrievalSplit : retrievalSplits) {
                retrievals.add(retrievalSplit.trim());
            }
            location = location.withRetrievals(retrievals);
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.ExchangeRetrievals", (Object)String.join((CharSequence)", ", retrievals)));
        }
        DateTime exchange_from_datetime = executionContext.evalDateTimeParameter("{exchange_from_datetime}", currentOperation);
        DateTime exchange_to_datetime = executionContext.evalDateTimeParameter("{exchange_to_datetime}", currentOperation);
        if (exchange_from_datetime != null && exchange_to_datetime != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.ExchangeDateFrom", (Object)FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)exchange_from_datetime)));
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.ExchangeDateTo", (Object)FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)exchange_to_datetime)));
            location = location.withDateRange(exchange_from_datetime, exchange_to_datetime);
        }
        evidenceContainer.addLocation((Location)location);
    }

    public static void addEnterpriseVaultEvidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        String ev_custodian;
        String ev_archive;
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        String ev_computer = executionContext.evalStringParameter("{ev_computer}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.EVComputer", (Object)ev_computer));
        EnterpriseVaultLocation location = locationFactory.makeEnterpriseVaultLocation(ev_computer);
        String ev_vault = executionContext.evalStringParameter("{ev_vault}", currentOperation);
        if (ev_vault != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.EVVault", (Object)ev_vault));
            location = location.withVault(ev_vault);
        }
        if ((ev_archive = executionContext.evalStringParameter("{ev_archive}", currentOperation)) != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.EVArchive", (Object)ev_archive));
            location = location.withArchive(ev_archive);
        }
        if ((ev_custodian = executionContext.evalStringParameter("{ev_custodian}", currentOperation)) != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.EVCustodian", (Object)ev_custodian));
            location = location.withCustodian(ev_custodian);
        }
        DateTime ev_from_datetime = executionContext.evalDateTimeParameter("{ev_from_datetime}", currentOperation);
        DateTime ev_to_datetime = executionContext.evalDateTimeParameter("{ev_to_datetime}", currentOperation);
        if (ev_from_datetime != null && ev_to_datetime != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.EVDateFrom", (Object)FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)ev_from_datetime)));
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.EVDateTo", (Object)FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)ev_to_datetime)));
            location = location.withDateRange(ev_from_datetime, ev_to_datetime);
        }
        String ev_keywords = executionContext.evalStringParameter("{ev_keywords}", currentOperation);
        String ev_flag = executionContext.evalStringParameter("{ev_flag}", currentOperation);
        if (ev_keywords != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.EVKeywords", (Object)ev_keywords));
            if (ev_flag != null) {
                currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.EVFlag", (Object)ev_flag));
            }
            location = location.withKeywords(ev_keywords, ev_flag);
        }
        evidenceContainer.addLocation((Location)location);
    }

    public static void addDocumentumEvidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        String ev_computer = executionContext.evalStringParameter("{ev_computer}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.EVComputer", (Object)ev_computer));
        HashMap<String, Object> locationProperties = new HashMap<String, Object>();
        locationProperties.put("type", "documentum");
        String documentum_domain = executionContext.evalStringParameter("{documentum_domain}", currentOperation);
        if (documentum_domain != null) {
            locationProperties.put("domain", documentum_domain);
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.DocumentumDomain", (Object)documentum_domain));
        }
        String documentum_username = executionContext.evalStringParameter("{documentum_username}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.DocumentumUsername", (Object)documentum_username));
        locationProperties.put("username", documentum_username);
        String documentum_password = executionContext.evalProtectedStringParameter("{documentum_password}", currentOperation);
        locationProperties.put("password", documentum_password);
        Integer documentum_port_number = executionContext.evalIntParameter("{documentum_port_number}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.DocumentumPort", (Object)documentum_port_number));
        locationProperties.put("port", documentum_port_number);
        String documentum_query = executionContext.evalStringParameter("{documentum_query}", currentOperation);
        if (documentum_query != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.DocumentumQuery", (Object)documentum_query));
            locationProperties.put("query", documentum_query);
        }
        String documentum_server = executionContext.evalStringParameter("{documentum_server}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.DocumentumServer", (Object)documentum_server));
        locationProperties.put("server", documentum_server);
        String documentum_doc_base = executionContext.evalStringParameter("{documentum_doc_base}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.DocumentumDocBase", (Object)documentum_doc_base));
        locationProperties.put("docBase", documentum_doc_base);
        String documentum_property_file = executionContext.evalStringParameter("{documentum_property_file}", currentOperation);
        if (documentum_property_file != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.DocumentumPropertyFile", (Object)documentum_property_file));
            locationProperties.put("propertyFile", documentum_property_file);
        }
        evidenceContainer.addLocation(locationFactory.makeLocation(locationProperties));
    }

    public static void addSqlServerEvidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        String sql_server_query;
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        String sql_server_computer = executionContext.evalStringParameter("{sql_server_computer}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SqlServerComputer", (Object)sql_server_computer));
        String sql_server_instance = executionContext.evalStringParameter("{sql_server_instance}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SqlServerInstance", (Object)sql_server_instance));
        String sql_server_domain = executionContext.evalStringParameter("{sql_server_domain}", currentOperation);
        if (sql_server_domain != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SqlServerDomain", (Object)sql_server_domain));
        }
        String sql_server_username = executionContext.evalStringParameter("{sql_server_username}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SqlServerUsername", (Object)sql_server_username));
        String sql_server_password = executionContext.evalProtectedStringParameter("{sql_server_password}", currentOperation);
        SqlServerLocation location = locationFactory.makeSqlServerLocation(sql_server_computer, sql_server_instance, sql_server_domain, sql_server_username, sql_server_password.toCharArray());
        Integer sql_server_max_rows_per_table_number = executionContext.evalIntParameter("{sql_server_max_rows_per_table_number}", currentOperation);
        if (sql_server_max_rows_per_table_number != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SqlServerMaxRowsPerTable", (Object)sql_server_max_rows_per_table_number));
            location = location.withMaxRows(sql_server_max_rows_per_table_number.intValue());
        }
        if ((sql_server_query = executionContext.evalStringParameter("{sql_server_query}", currentOperation)) != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SqlServerQuery", (Object)sql_server_query));
            location = location.withQuery(sql_server_query);
        }
        evidenceContainer.addLocation((Location)location);
    }

    public static void addOracleEvidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        String oracle_username = executionContext.evalStringParameter("{oracle_username}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.OracleUsername", (Object)oracle_username));
        String oracle_password = executionContext.evalProtectedStringParameter("{oracle_password}", currentOperation);
        String oracle_driverType = executionContext.evalStringParameter("{oracle_driver_type}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.OracleDriverType", (Object)oracle_driverType));
        String oracle_database = executionContext.evalStringParameter("{oracle_database}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.OracleDatabase", (Object)oracle_database));
        String oracle_role = executionContext.evalStringParameter("{oracle_role}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.OracleRole", (Object)oracle_role));
        String oracle_query = executionContext.evalStringParameter("{oracle_query}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.OracleQuery", (Object)oracle_query));
        OracleServerLocation location = locationFactory.makeOracleServerLocation(oracle_driverType, oracle_username, oracle_password.toCharArray(), oracle_role, oracle_database, oracle_query);
        Integer oracle_max_rows_per_table = executionContext.evalIntParameter("{oracle_max_rows_per_table}", currentOperation);
        if (oracle_max_rows_per_table != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.OracleMaxRowsPerTable", (Object)oracle_max_rows_per_table));
            location = location.withMaxRows(oracle_max_rows_per_table.intValue());
        }
        evidenceContainer.addLocation((Location)location);
    }

    public static void addDropboxEvidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        String dropbox_auth_code_protected = executionContext.evalProtectedStringParameter("{dropbox_auth_code_protected}", currentOperation);
        Boolean dropbox_team = executionContext.evalBooleanParameter("{dropbox_team_boolean}", currentOperation);
        String dropbox_access_token_protected = executionContext.evalProtectedStringParameter("{dropbox_access_token_protected}", currentOperation);
        HashMap<String, Object> locationProperties = new HashMap<String, Object>();
        locationProperties.put("type", "dropbox");
        if (!dropbox_auth_code_protected.equals("{dropbox_auth_code_protected}")) {
            currentOperation.addExecutionLog(iu.getString("AddEvidenceOperation.Log.DropboxUsingAuthCode"));
            locationProperties.put("authCode", "dropbox_auth_code_protected");
        }
        if (dropbox_team != null) {
            currentOperation.addExecutionLog(iu.getString("AddEvidenceOperation.Log.DropboxTeam"));
            locationProperties.put("team", dropbox_team);
        }
        if (!dropbox_access_token_protected.equals("{dropbox_access_token_protected}")) {
            currentOperation.addExecutionLog(iu.getString("AddEvidenceOperation.Log.DropboxUsingAccessToken"));
            locationProperties.put("accessToken", dropbox_access_token_protected);
        }
        evidenceContainer.addLocation(locationFactory.makeLocation(locationProperties));
    }

    public static void addSlackEvidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        DateTime slack_end_datetime;
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        String slack_auto_code = executionContext.evalProtectedStringParameter("{slack_auth_code_protected}", currentOperation);
        SlackLocation slackLocation = locationFactory.makeSlackLocation(slack_auto_code.toCharArray());
        try {
            String slack_user_ids = executionContext.evalParametersIfSet("{slack_user_ids}", currentOperation);
            String[] idSplit = slack_user_ids.split(",");
            HashSet<String> ids = new HashSet<String>();
            for (String id : idSplit) {
                ids.add(id.trim());
            }
            slackLocation = slackLocation.withUserIDs(ids);
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Slack.UserIds", (Object)String.join((CharSequence)", ", ids)));
        }
        catch (ParameterException slack_user_ids) {
            // empty catch block
        }
        DateTime slack_start_datetime = executionContext.evalDateTimeParameter("{slack_start_datetime}", currentOperation);
        if (slack_start_datetime != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Slack.StartTime", (Object)slack_start_datetime));
            slackLocation = slackLocation.withStartDate(slack_start_datetime);
        }
        if ((slack_end_datetime = executionContext.evalDateTimeParameter("{slack_end_datetime}", currentOperation)) != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Slack.EndTime", (Object)slack_end_datetime));
            slackLocation = slackLocation.withEndDate(slack_end_datetime);
        }
        evidenceContainer.addLocation((Location)slackLocation);
    }

    public static void addSshEvidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        String ssh_remote_folder;
        Boolean ssh_accessing_remote_disks;
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        String ssh_username = executionContext.evalStringParameter("{ssh_username}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SshUsername", (Object)ssh_username));
        String ssh_computer = executionContext.evalStringParameter("{ssh_computer}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SshComputer", (Object)ssh_computer));
        Integer ssh_port_number = executionContext.evalIntParameter("{ssh_port_number}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SshPort", (Object)ssh_port_number));
        String ssh_host_fingerprint = executionContext.evalStringParameter("{ssh_host_fingerprint}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SshHostFingerprint", (Object)ssh_host_fingerprint));
        SshLocation location = locationFactory.makeSshLocation(ssh_username, ssh_computer, ssh_port_number.intValue(), ssh_host_fingerprint);
        String ssh_password = executionContext.evalProtectedStringParameter("{ssh_password}", currentOperation);
        if (ssh_password != null) {
            currentOperation.addExecutionLog(iu.getString("AddEvidenceOperation.Log.SshUsingPassword"));
            location = location.withPassword(ssh_password.toCharArray());
        }
        String ssh_sudo_password = executionContext.evalProtectedStringParameter("{ssh_sudo_password}", currentOperation);
        String ssh_key_folder = executionContext.evalStringParameter("{ssh_key_folder}", currentOperation);
        if (ssh_sudo_password != null) {
            currentOperation.addExecutionLog(iu.getString("AddEvidenceOperation.Log.SshUsingSudoPassword"));
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SshKeyFolder", (Object)ssh_key_folder));
            location = location.withSshAuthentication(ssh_key_folder, ssh_sudo_password.toCharArray());
        }
        if ((ssh_accessing_remote_disks = executionContext.evalBooleanParameter("{ssh_accessing_remote_disks_boolean}", currentOperation)) != null && ssh_accessing_remote_disks.booleanValue()) {
            currentOperation.addExecutionLog(iu.getString("AddEvidenceOperation.Log.SshRemoteDisks"));
            location = location.withRemoteDisks();
        }
        if ((ssh_remote_folder = executionContext.evalStringParameter("{ssh_remote_folder}", currentOperation)) != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.SshRemoteFolder", (Object)ssh_remote_folder));
            location = location.withInitialLocation(ssh_remote_folder);
        }
        evidenceContainer.addLocation((Location)location);
    }

    public static void addHistoricalTwitterEvidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        String twitter_access_token = executionContext.evalStringParameter("{twitter_access_token}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.TwitterAccessToken", (Object)twitter_access_token));
        String twitter_consumer_key = executionContext.evalStringParameter("{twitter_consumer_key}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.TwitterConsumerKey", (Object)twitter_consumer_key));
        String twitter_consumer_secret_protected = executionContext.evalProtectedStringParameter("{twitter_consumer_secret_protected}", currentOperation);
        String twitter_access_token_secret_protected = executionContext.evalProtectedStringParameter("{twitter_access_token_secret_protected}", currentOperation);
        TwitterHistoricalLocation location = locationFactory.makeTwitterHistoricalLocation(twitter_consumer_key, twitter_consumer_secret_protected.toCharArray(), twitter_access_token, twitter_access_token_secret_protected.toCharArray());
        evidenceContainer.addLocation((Location)location);
    }
}

